#include <string>
#include <iostream>

#include "./canlxx.h"

int main(void) {

  AuthN::Context ctx(AuthN::Context::ClientMinimalContext);
  if((bool)ctx) {
    std::cout<<"Cert: "<<ctx.GetCertPath()<<std::endl;
    std::cout<<"Key: "<<ctx.GetKeyPath()<<std::endl;
    std::cout<<"CA: "<<ctx.GetCAPath()<<std::endl;
    AuthN::Credentials cred(ctx);  
    AuthN::Credentials::Extension ext;
    std::string extname = "basicConstraints";//"1.3.6.1.4.1.8005.100.100.5";//"keyUsage";//"basicConstraints";
    cred.GetExtension(extname,ext);
    std::cout<<"ext oid: "<<ext.oid<<" ext val: "<<ext.value<<std::endl;
    for(int i = 0;; i++) {
      if(!cred.GetExtension(i, ext)) break;
      std::cout<<"ext oid: "<<ext.oid<<" ext val: "<<ext.value<<std::endl;
    }
    std::list<std::string> attrs;
    cred.GetAttributes(extname, attrs);
    std::cout<<"attribute size: "<<attrs.size()<<std::endl;
    std::list<std::string>::iterator it;
    for(it = attrs.begin(); it != attrs.end(); it++) {
      std::cout<<"attribute: "<<*it<<" attr size: "<<(*it).size()<<std::endl;
    }
  }
  else { std::cout<<"Context is not valid"<<std::endl; }
  return 0;
}
