/* This file is part of Atomes.

Atomes is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

Atomes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with Atomes.
If not, see <https://www.gnu.org/licenses/> */

/*
* This file: 'oplsaar.c'
*
*  Contains:
*

  OPLSAAR force field

  This file contains several tables:

    Atoms      : OPLSAAR_atoms[145][4]
    Bonds      : OPLSAAR_bonds[242][5]
    Angles     : OPLSAAR_angles[593][6]
    Dihedrals  : OPLSAAR_dihedrals[2482][8]
    Impropers  : OPLSAAR_impropers[131][[8]
    Non bonded : OPLSAAR_vdw[145][7]

*/

#include "global.h"

/*
 Atoms
  0= Element, 1= Mass, 2= Key, 3= Description, 4= OPLSAAR info
*/
int OPLSAAR_objects[14] = {145, 0, 0, 242, 0, 0, 593, 0, 2482, 0 , 0, 131, 145, 0};
int OPLSAAR_dim[14] = {4, 0, 0, 5, 0, 0, 6, 0, 8, 0, 0, 8, 7, 0};
/*
  Atoms
*/
char * OPLSAAR_atoms[145][4]= {{"C", "12.01100", "C135", "CH3 all-atom C: alkanes ALL-ATOM "},
                              {"C", "12.01100", "C136", "CH2 all-atom C: alkanes PARAMETERS"},
                              {"C", "12.01100", "C137", "CH all-atom C: alkanes FROM HERE ON"},
                              {"C", "12.01100", "C145", "Benzene C - 12 site JACS,112,4768-90"},
                              {"C", "12.01100", "C149", "all-atom C: CH2, ethyl benzene"},
                              {"C", "12.01100", "C157", "all-atom C: CH3 and CH2, alcohols"},
                              {"C", "12.01100", "C158", "all-atom C: CH, alcohols"},
                              {"C", "12.01100", "C166", "C(OH) phenol Use with all"},
                              {"C", "12.01100", "C206", "all-atom C: CH2, thiols"},
                              {"C", "12.01100", "C209", "all-atom C: CH3, sulfides"},
                              {"C", "12.01100", "C210", "all-atom C: CH2, sulfides"},
                              {"C", "12.01100", "C214", "all-atom C: CH2, disulfides"},
                              {"C", "12.01100", "C223", "C in RCH2NH2 and Gly CA (See 900 for amines)"},
                              {"C", "12.01100", "C224", "C in R2CHNH2 and Ala CA"},
                              {"C", "12.01100", "C235", "C: C=O in amide. Acyl R in amides"},
                              {"C", "12.01100", "C242", "C on N: secondary N-Me amide"},
                              {"C", "12.01100", "C245", "C on N: tertiary N-CH2R amide (Pro Cdelta)"},
                              {"C", "12.01100", "C246", "C on N: tertiary N-CHR2 amide (Pro Calpha)"},
                              {"C", "12.01100", "C267", "Co in CCOOH carboxylic acid"},
                              {"C", "12.01100", "C271", "C in COO- carboxylate"},
                              {"C", "12.01100", "C274", "C: CH2, carboxylate ion"},
                              {"C", "12.01100", "C283", "AA C-alpha on C-terminal ALA"},
                              {"C", "12.01100", "C284", "AA C-alpha on C-terminal GLY"},
                              {"C", "12.01100", "C285", "AA C-alpha on C-terminal PRO"},
                              {"C", "12.01100", "C292", "C in RCH2NH3+ and CA in N-term Gly"},
                              {"C", "12.01100", "C293", "C in R2CHNH3+ and CA in N-term Ala, etc."},
                              {"C", "12.01100", "C295", "AA:C-alpha in N-term PRO"},
                              {"C", "12.01100", "C296", "AA:C-delta in N-term PRO"},
                              {"C", "12.01100", "C302", "C: guanidinium C+"},
                              {"C", "12.01100", "C307", "C: CH2(D), ARG, ethylguanidinium"},
                              {"C", "12.01100", "C308", "C: CH2(G), ARG"},
                              {"C", "12.01100", "C500", "CG in TRP"},
                              {"C", "12.01100", "C501", "CD C in TRP"},
                              {"C", "12.01100", "C502", "CE C in TRP"},
                              {"C", "12.01100", "C505", "CB in HIS"},
                              {"C", "12.01100", "C506", "CE1 in HID, HIE"},
                              {"C", "12.01100", "C507", "CD2 in HID, CG in HIE"},
                              {"C", "12.01100", "C508", "CG in HID, CD2 in HIE"},
                              {"C", "12.01100", "C509", "CE1 in HIP"},
                              {"C", "12.01100", "C510", "CG, CD2 in HIP"},
                              {"C", "12.01100", "C514", "CD1 in TRP"},
                              {"C", "12.011000", "C366", " "},
                              {"C", "12.011000", "C320", " "},
                              {"C", "12.011000", "C362", " "},
                              {"C", "12.011000", "C324", " "},
                              {"C", "12.011000", "C323", " "},
                              {"C", "12.011000", "C353", " "},
                              {"C", "12.011000", "C364", " "},
                              {"C", "12.011000", "C365", " "},
                              {"C", "12.011000", "C183", " "},
                              {"C", "12.011000", "C931", " "},
                              {"C", "12.011000", "C174", " "},
                              {"C", "12.011000", "C350", " "},
                              {"C", "12.011000", "C349", " "},
                              {"C", "12.011000", "C351", " "},
                              {"C", "12.011000", "C932", " "},
                              {"C", "12.011000", "C338", " "},
                              {"C", "12.011000", "C337", " "},
                              {"C", "12.011000", "C334", " "},
                              {"C", "12.011000", "C336", " "},
                              {"C", "12.011000", "C322", " "},
                              {"C", "12.011000", "C933", " "},
                              {"H", "1.00800", "H140", "H all-atom H: alkanes"},
                              {"H", "1.00800", "H146", "Benzene H - 12 site"},
                              {"H", "1.00800", "H155", "all-atom H(O): mono alcohols"},
                              {"H", "1.00800", "H168", "H phenol 145 and 146"},
                              {"H", "1.00800", "H204", "all-atom H(S): thiols (mod 11/99)"},
                              {"H", "1.00800", "H240", "H on N: primary amide"},
                              {"H", "1.00800", "H241", "H on N: secondary amide"},
                              {"H", "1.00800", "H270", "H in CCOOH"},
                              {"H", "1.00800", "H290", "H (RNH3+)"},
                              {"H", "1.00800", "H301", "H: guanidinium NH2"},
                              {"H", "1.00800", "H304", "H: guanidinium NHR"},
                              {"H", "1.00800", "H310", "H (R2NH2+)"},
                              {"H", "1.00800", "H504", "H on NE in TRP"},
                              {"H", "1.00800", "H513", "H on N in HIP"},
                              {"H", "1.008000", "H369", " "},
                              {"H", "1.008000", "H367", " "},
                              {"H", "1.008000", "H329", " "},
                              {"H", "1.008000", "H327", " "},
                              {"H", "1.008000", "H330", " "},
                              {"H", "1.008000", "H343", " "},
                              {"H", "1.008000", "H342", " "},
                              {"H", "1.008000", "H344", " "},
                              {"H", "1.008000", "H345", " "},
                              {"H", "1.008000", "H185", " "},
                              {"H", "1.008000", "H196", " "},
                              {"H", "1.008000", "H359", " "},
                              {"H", "1.008000", "H355", " "},
                              {"H", "1.008000", "H357", " "},
                              {"H", "1.008000", "H358", " "},
                              {"H", "1.008000", "H176", " "},
                              {"H", "1.008000", "H170", " "},
                              {"N", "14.00700", "N237", "N: primary amide. alkane parameters."},
                              {"N", "14.00700", "N238", "N: secondary amide 279 for formyl H."},
                              {"N", "14.00700", "N239", "N: tertiary amide"},
                              {"N", "14.00700", "N287", "N (RNH3+)"},
                              {"N", "14.00700", "N300", "N: guanidinium NH2"},
                              {"N", "14.00700", "N303", "N: guanidinium NHR"},
                              {"N", "14.00700", "N309", "N (R2NH2+)"},
                              {"N", "14.00700", "N503", "NE in TRP"},
                              {"N", "14.00700", "N511", "NE in HID, ND in HIE"},
                              {"N", "14.00700", "N512", "N in HIP"},
                              {"N", "14.007000", "N348", " "},
                              {"N", "14.007000", "N368", " "},
                              {"N", "14.007000", "N937", " "},
                              {"N", "14.007000", "N936", " "},
                              {"N", "14.007000", "N321", " "},
                              {"N", "14.007000", "N361", " "},
                              {"N", "14.007000", "N335", " "},
                              {"N", "14.007000", "N346", " "},
                              {"N", "14.007000", "N363", " "},
                              {"N", "14.007000", "N352", " "},
                              {"N", "14.007000", "N356", " "},
                              {"N", "14.007000", "N341", " "},
                              {"N", "14.007000", "N938", " "},
                              {"O", "15.99940", "O154", "all-atom O: mono alcohols"},
                              {"O", "15.99940", "O167", "O phenol atom C, H"},
                              {"O", "15.99940", "O236", "O: C=O in amide. is neutral - use"},
                              {"O", "15.99940", "O268", "Oh in CCOOH R in RCOOH is"},
                              {"O", "15.99940", "O269", "Oc in CCOOH neutral; use 135-140"},
                              {"O", "15.99940", "O272", "O: O in COO- carboxylate"},
                              {"O", "15.999400", "O370", " "},
                              {"O", "15.999400", "O340", " "},
                              {"O", "15.999400", "O441", " "},
                              {"O", "15.999400", "O169", " "},
                              {"O", "15.999400", "O186", " "},
                              {"P", "30.974000", "P440", " "},
                              {"C", "12.011000", "C347", " "},
                              {"O", "15.999400", "O328", " "},
                              {"O", "15.999400", "O326", " "},
                              {"C", "12.011000", "C6448", " "},
                              {"O", "15.999400", "O6934", " "},
                              {"O", "15.999400", "O6452", " "},
                              {"O", "15.999400", "O6442", " "},
                              {"P", "30.974000", "P6450", " "},
                              {"O", "15.999400", "O6441", " "},
                              {"S", "32.06000", "S200", "all-atom S: thiols (mod 11/99)"},
                              {"S", "32.06000", "S202", "all-atom S: sulfides"},
                              {"S", "32.06000", "S203", "all-atom S: disulfides"},
                              {"O", "15.99940", "OT", "TIP3P water"},
                              {"H", "1.00800", "HT", "TIP3P water"},
                              {"Na", "22.98977", "SOD", "Sodium Ion, adm jr."},
                              {"Cl", "35.45000", "CLA", "Chloride Ion, adm jr."},
                              {"Mg", "24.30000", "MG", "Magnesium Ion"}};

/*
 Bonds
*/
char * OPLSAAR_bonds[242][5]= {{"OT", "HT", "450.0", "0.9572", " "},
                                   {"HT", "HT", "0.0", "1.5139", " "},
                                   {"S203", "S203", "166.0", "2.038", " "},
                                   {"C157", "O6934", "320.00", "1.410", " "},
                                   {"O6934", "C174", "320.00", "1.410", " "},
                                   {"C135", "C136", "268.00", "1.529", " "},
                                   {"C135", "C137", "268.00", "1.529", " "},
                                   {"C135", "C158", "268.00", "1.529", " "},
                                   {"C135", "C224", "268.00", "1.529", " "},
                                   {"C135", "C235", "317.00", "1.522", " "},
                                   {"C135", "C283", "268.00", "1.529", " "},
                                   {"C135", "C293", "268.00", "1.529", " "},
                                   {"C135", "H140", "340.00", "1.090", " "},
                                   {"C136", "C136", "268.00", "1.529", " "},
                                   {"C136", "C137", "268.00", "1.529", " "},
                                   {"C136", "C210", "268.00", "1.529", " "},
                                   {"C136", "C224", "268.00", "1.529", " "},
                                   {"C136", "C235", "317.00", "1.522", " "},
                                   {"C136", "C245", "268.00", "1.529", " "},
                                   {"C136", "C246", "268.00", "1.529", " "},
                                   {"C136", "C267", "317.00", "1.522", " "},
                                   {"C136", "C274", "268.00", "1.529", " "},
                                   {"C136", "C283", "268.00", "1.529", " "},
                                   {"C136", "C285", "268.00", "1.529", " "},
                                   {"C136", "C292", "268.00", "1.529", " "},
                                   {"C136", "C293", "268.00", "1.529", " "},
                                   {"C136", "C295", "268.00", "1.529", " "},
                                   {"C136", "C296", "268.00", "1.529", " "},
                                   {"C136", "C308", "268.00", "1.529", " "},
                                   {"C136", "C500", "317.00", "1.495", " "},
                                   {"C136", "H140", "340.00", "1.090", " "},
                                   {"C137", "C224", "268.00", "1.529", " "},
                                   {"C137", "C283", "268.00", "1.529", " "},
                                   {"C137", "C293", "268.00", "1.529", " "},
                                   {"C137", "H140", "340.00", "1.090", " "},
                                   {"C145", "C145", "469.00", "1.400", " "},
                                   {"C145", "C149", "317.00", "1.510", " "},
                                   {"C145", "C166", "469.00", "1.400", " "},
                                   {"C145", "C501", "469.00", "1.404", " "},
                                   {"C145", "C502", "469.00", "1.400", " "},
                                   {"C145", "H146", "367.00", "1.080", " "},
                                   {"C149", "C224", "268.00", "1.529", " "},
                                   {"C149", "C283", "268.00", "1.529", " "},
                                   {"C149", "C293", "268.00", "1.529", " "},
                                   {"C149", "H140", "340.00", "1.090", " "},
                                   {"C157", "C224", "268.00", "1.529", " "},
                                   {"C157", "C283", "268.00", "1.529", " "},
                                   {"C157", "C293", "268.00", "1.529", " "},
                                   {"C157", "H140", "340.00", "1.090", " "},
                                   {"C157", "O154", "320.00", "1.410", " "},
                                   {"C158", "C224", "268.00", "1.529", " "},
                                   {"C158", "C283", "268.00", "1.529", " "},
                                   {"C158", "C293", "268.00", "1.529", " "},
                                   {"C158", "H140", "340.00", "1.090", " "},
                                   {"C158", "O154", "320.00", "1.410", " "},
                                   {"C166", "O167", "450.00", "1.364", " "},
                                   {"C206", "C224", "268.00", "1.529", " "},
                                   {"C206", "C283", "268.00", "1.529", " "},
                                   {"C206", "C293", "268.00", "1.529", " "},
                                   {"C206", "H140", "340.00", "1.090", " "},
                                   {"C206", "S200", "222.00", "1.810", " "},
                                   {"C209", "H140", "340.00", "1.090", " "},
                                   {"C209", "S202", "222.00", "1.810", " "},
                                   {"C210", "H140", "340.00", "1.090", " "},
                                   {"C210", "S202", "222.00", "1.810", " "},
                                   {"C214", "C224", "268.00", "1.529", " "},
                                   {"C214", "C283", "268.00", "1.529", " "},
                                   {"C214", "C293", "268.00", "1.529", " "},
                                   {"C214", "H140", "340.00", "1.090", " "},
                                   {"C214", "S203", "222.00", "1.810", " "},
                                   {"C223", "C235", "317.00", "1.522", " "},
                                   {"C223", "H140", "340.00", "1.090", " "},
                                   {"C223", "N238", "337.00", "1.449", " "},
                                   {"C223", "C267", "317.00", "1.522", "phosphorylated C-terminal Gly, adm jr."},
                                   {"C224", "C235", "317.00", "1.522", " "},
                                   {"C224", "C267", "317.00", "1.522", " "},
                                   {"C224", "C274", "268.00", "1.529", " "},
                                   {"C224", "C505", "268.00", "1.529", " "},
                                   {"C224", "H140", "340.00", "1.090", " "},
                                   {"C224", "N238", "337.00", "1.449", " "},
                                   {"C235", "C246", "317.00", "1.522", " "},
                                   {"C235", "C292", "317.00", "1.522", " "},
                                   {"C235", "C293", "317.00", "1.522", " "},
                                   {"C235", "C295", "317.00", "1.522", " "},
                                   {"C235", "N237", "490.00", "1.335", " "},
                                   {"C235", "N238", "490.00", "1.335", " "},
                                   {"C235", "N239", "490.00", "1.335", " "},
                                   {"C235", "O236", "570.00", "1.229", " "},
                                   {"C242", "H140", "340.00", "1.090", " "},
                                   {"C242", "N238", "337.00", "1.449", " "},
                                   {"C245", "H140", "340.00", "1.090", " "},
                                   {"C245", "N239", "337.00", "1.449", " "},
                                   {"C246", "H140", "340.00", "1.090", " "},
                                   {"C246", "N239", "337.00", "1.449", " "},
                                   {"C267", "O268", "450.00", "1.364", " "},
                                   {"C267", "O269", "570.00", "1.229", " "},
                                   {"C271", "C274", "317.00", "1.522", " "},
                                   {"C271", "C283", "317.00", "1.522", " "},
                                   {"C271", "C284", "317.00", "1.522", " "},
                                   {"C271", "C285", "317.00", "1.522", " "},
                                   {"C271", "O272", "656.00", "1.250", " "},
                                   {"C274", "C283", "268.00", "1.529", " "},
                                   {"C274", "C293", "268.00", "1.529", " "},
                                   {"C274", "H140", "340.00", "1.090", " "},
                                   {"C283", "C505", "268.00", "1.529", " "},
                                   {"C283", "H140", "340.00", "1.090", " "},
                                   {"C283", "N238", "337.00", "1.449", " "},
                                   {"C284", "H140", "340.00", "1.090", " "},
                                   {"C284", "N238", "337.00", "1.449", " "},
                                   {"C285", "H140", "340.00", "1.090", " "},
                                   {"C285", "N239", "337.00", "1.449", " "},
                                   {"C292", "H140", "340.00", "1.090", " "},
                                   {"C292", "N287", "367.00", "1.471", " "},
                                   {"C293", "C505", "268.00", "1.529", " "},
                                   {"C293", "H140", "340.00", "1.090", " "},
                                   {"C293", "N287", "367.00", "1.471", " "},
                                   {"C295", "H140", "340.00", "1.090", " "},
                                   {"C295", "N309", "367.00", "1.471", " "},
                                   {"C296", "H140", "340.00", "1.090", " "},
                                   {"C296", "N309", "367.00", "1.471", " "},
                                   {"C302", "N300", "481.00", "1.340", " "},
                                   {"C302", "N303", "481.00", "1.340", " "},
                                   {"C307", "C308", "268.00", "1.529", " "},
                                   {"C307", "H140", "340.00", "1.090", " "},
                                   {"C307", "N303", "337.00", "1.463", " "},
                                   {"C308", "H140", "340.00", "1.090", " "},
                                   {"C500", "C501", "388.00", "1.459", " "},
                                   {"C500", "C514", "546.00", "1.352", " "},
                                   {"C501", "C502", "447.00", "1.419", " "},
                                   {"C502", "N503", "428.00", "1.380", " "},
                                   {"C505", "C507", "317.00", "1.504", " "},
                                   {"C505", "C508", "317.00", "1.504", " "},
                                   {"C505", "C510", "317.00", "1.504", " "},
                                   {"C505", "H140", "340.00", "1.090", " "},
                                   {"C506", "H146", "367.00", "1.080", " "},
                                   {"C506", "N503", "477.00", "1.343", " "},
                                   {"C506", "N511", "488.00", "1.335", " "},
                                   {"C507", "C508", "520.00", "1.370", " "},
                                   {"C507", "H146", "367.00", "1.080", " "},
                                   {"C507", "N511", "410.00", "1.394", " "},
                                   {"C508", "H146", "367.00", "1.080", " "},
                                   {"C508", "N503", "427.00", "1.381", " "},
                                   {"C509", "H146", "367.00", "1.080", " "},
                                   {"C509", "N512", "477.00", "1.343", " "},
                                   {"C510", "C510", "520.00", "1.370", " "},
                                   {"C510", "H146", "367.00", "1.080", " "},
                                   {"C510", "N512", "427.00", "1.381", " "},
                                   {"C514", "H146", "367.00", "1.080", " "},
                                   {"C514", "N503", "427.00", "1.381", " "},
                                   {"H155", "O154", "553.00", "0.945", " "},
                                   {"H168", "O167", "553.00", "0.945", " "},
                                   {"H204", "S200", "274.00", "1.336", " "},
                                   {"H240", "N237", "434.00", "1.010", " "},
                                   {"H241", "N238", "434.00", "1.010", " "},
                                   {"H270", "O268", "553.00", "0.945", " "},
                                   {"H290", "N287", "434.00", "1.010", " "},
                                   {"H301", "N300", "434.00", "1.010", " "},
                                   {"H304", "N303", "434.00", "1.010", " "},
                                   {"H310", "N309", "434.00", "1.010", " "},
                                   {"H504", "N503", "434.00", "1.010", " "},
                                   {"H513", "N512", "434.00", "1.010", " "},
                                   {"O186", "C933", "320.00", "1.380", " "},
                                   {"C174", "C933", "268.00", "1.529", " "},
                                   {"H196", "C933", "340.00", "1.090", " "},
                                   {"C933", "N938", "337.00", "1.475", " "},
                                   {"C320", "N938", "424.00", "1.383", " "},
                                   {"C324", "N938", "448.00", "1.365", " "},
                                   {"H330", "C324", "340.00", "1.080", " "},
                                   {"C323", "C322", "410.00", "1.444", " "},
                                   {"O328", "C322", "570.00", "1.229", " "},
                                   {"H329", "C323", "340.00", "1.080", " "},
                                   {"C324", "C323", "549.00", "1.340", " "},
                                   {"N321", "C320", "418.00", "1.388", " "},
                                   {"O326", "C320", "570.00", "1.229", " "},
                                   {"C322", "N321", "418.00", "1.388", " "},
                                   {"H327", "N321", "434.00", "1.010", " "},
                                   {"N335", "C336", "483.00", "1.339", " "},
                                   {"O186", "C932", "320.00", "1.380", " "},
                                   {"C932", "N937", "337.00", "1.475", " "},
                                   {"C174", "C932", "268.00", "1.529", " "},
                                   {"H196", "C932", "340.00", "1.090", " "},
                                   {"C334", "N937", "424.00", "1.383", " "},
                                   {"C338", "N937", "448.00", "1.365", " "},
                                   {"H345", "C338", "367.00", "1.080", " "},
                                   {"H344", "C337", "340.00", "1.080", " "},
                                   {"C337", "C338", "549.00", "1.340", " "},
                                   {"N335", "C334", "457.00", "1.358", " "},
                                   {"O340", "C334", "570.00", "1.229", " "},
                                   {"N341", "C336", "481.00", "1.340", " "},
                                   {"C336", "C337", "427.00", "1.433", " "},
                                   {"H342", "N341", "434.00", "1.010", " "},
                                   {"H343", "N341", "434.00", "1.010", " "},
                                   {"O370", "C366", "570.00", "1.229", " "},
                                   {"C364", "N936", "436.00", "1.374", " "},
                                   {"N363", "C364", "461.00", "1.354", " "},
                                   {"C365", "C364", "520.00", "1.370", " "},
                                   {"H369", "N368", "434.00", "1.010", " "},
                                   {"C362", "N363", "483.00", "1.339", " "},
                                   {"N368", "C362", "481.00", "1.340", " "},
                                   {"C362", "N361", "427.00", "1.381", " "},
                                   {"H367", "N361", "434.00", "1.010", " "},
                                   {"N361", "C366", "418.00", "1.388", " "},
                                   {"C366", "C365", "447.00", "1.419", " "},
                                   {"N352", "C365", "414.00", "1.391", " "},
                                   {"C183", "C6448", "286.00", "1.529", " "},
                                   {"C6448", "H140", "340.00", "1.090", " "},
                                   {"C6448", "O6934", "320.00", "1.410", " "},
                                   {"O6934", "P440", "230.00", "1.610", " "},
                                   {"O441", "P440", "553.00", "1.480", " "},
                                   {"O441", "P6450", "553.00", "1.480", " "},
                                   {"O6452", "P440", "230.00", "1.610", " "},
                                   {"O6442", "P440", "230.00", "1.610", " "},
                                   {"O6442", "P6450", "230.00", "1.610", " "},
                                   {"O6452", "P6450", "230.00", "1.610", " "},
                                   {"O6441", "P6450", "553.00", "1.480", " "},
                                   {"C931", "N936", "337.00", "1.475", " "},
                                   {"C349", "N936", "436.00", "1.374", " "},
                                   {"C353", "N936", "440.00", "1.371", " "},
                                   {"C174", "C931", "268.00", "1.529", " "},
                                   {"O186", "C931", "320.00", "1.380", " "},
                                   {"H196", "C931", "340.00", "1.090", " "},
                                   {"C174", "C174", "268.00", "1.529", " "},
                                   {"O169", "C174", "320.00", "1.410", " "},
                                   {"H176", "C174", "340.00", "1.090", " "},
                                   {"C183", "C174", "268.00", "1.529", " "},
                                   {"C157", "C183", "268.00", "1.529", " "},
                                   {"H185", "C183", "340.00", "1.090", " "},
                                   {"H170", "O169", "553.00", "0.945", " "},
                                   {"C350", "C349", "520.00", "1.370", " "},
                                   {"N348", "C349", "461.00", "1.354", " "},
                                   {"C351", "C350", "469.00", "1.404", " "},
                                   {"N352", "C350", "414.00", "1.391", " "},
                                   {"N356", "C351", "481.00", "1.340", " "},
                                   {"N346", "C351", "483.00", "1.339", " "},
                                   {"H357", "N356", "434.00", "1.010", " "},
                                   {"H358", "N356", "434.00", "1.010", " "},
                                   {"C347", "N346", "502.00", "1.324", " "},
                                   {"H355", "C347", "367.00", "1.080", " "},
                                   {"H359", "C353", "367.00", "1.080", " "},
                                   {"C183", "O186", "320.00", "1.410", " "},
                                   {"C353", "N352", "529.00", "1.304", " "},
                                   {"C347", "N348", "502.00", "1.324", " "}};

/*
 Angles
*/
char * OPLSAAR_angles[593][6]= {{"HT", "OT", "HT", "55.0", "104.52", " "},
                                   {"O6934", "P440", "O6934", "45.0", "102.60", "new?"},
                                   {"C183", "C157", "O6934", "50.00", "109.500", " "},
                                   {"H140", "C157", "O6934", "35.00", "109.500", " "},
                                   {"H176", "C174", "O6934", "35.00", "109.500", " "},
                                   {"C183", "C174", "O6934", "50.00", "109.500", " "},
                                   {"C174", "C174", "O6934", "50.0", "109.50", " "},
                                   {"P440", "O6934", "C174", "30.0", "120.50", " "},
                                   {"P440", "O6934", "C157", "100.0", "120.50", " "},
                                   {"H140", "C135", "H140", "33.0", "107.8", " "},
                                   {"H140", "C136", "H140", "33.0", "107.8", " "},
                                   {"H140", "C149", "H140", "33.0", "107.8", " "},
                                   {"H140", "C157", "H140", "33.0", "107.8", " "},
                                   {"H140", "C206", "H140", "33.0", "107.8", " "},
                                   {"H140", "C209", "H140", "33.0", "107.8", " "},
                                   {"H140", "C210", "H140", "33.0", "107.8", " "},
                                   {"H140", "C214", "H140", "33.0", "107.8", " "},
                                   {"H140", "C223", "H140", "33.0", "107.8", " "},
                                   {"H140", "C224", "H140", "33.0", "107.8", " "},
                                   {"H140", "C242", "H140", "33.0", "107.8", " "},
                                   {"H140", "C245", "H140", "33.0", "107.8", " "},
                                   {"H140", "C274", "H140", "33.0", "107.8", " "},
                                   {"H140", "C284", "H140", "33.0", "107.8", " "},
                                   {"H140", "C292", "H140", "33.0", "107.8", " "},
                                   {"H140", "C296", "H140", "33.0", "107.8", " "},
                                   {"H140", "C307", "H140", "33.0", "107.8", " "},
                                   {"H140", "C308", "H140", "33.0", "107.8", " "},
                                   {"H140", "C505", "H140", "33.0", "107.8", " "},
                                   {"H290", "N287", "H290", "35.0", "109.5", " "},
                                   {"H310", "N309", "H310", "35.0", "109.5", " "},
                                   {"C135", "C136", "C137", "58.35", "112.70", " "},
                                   {"C135", "C136", "H140", "37.50", "110.70", " "},
                                   {"C135", "C137", "C135", "58.35", "112.70", " "},
                                   {"C135", "C137", "C136", "58.35", "112.70", " "},
                                   {"C135", "C137", "C224", "58.35", "112.70", " "},
                                   {"C135", "C137", "C283", "58.35", "112.70", " "},
                                   {"C135", "C137", "C293", "58.35", "112.70", " "},
                                   {"C135", "C137", "H140", "37.50", "110.70", " "},
                                   {"C135", "C158", "C224", "58.35", "112.70", " "},
                                   {"C135", "C158", "C283", "58.35", "112.70", " "},
                                   {"C135", "C158", "C293", "58.35", "112.70", " "},
                                   {"C135", "C158", "H140", "37.50", "110.70", " "},
                                   {"C135", "C158", "O154", "50.00", "109.50", " "},
                                   {"C135", "C224", "C235", "63.00", "111.10", " "},
                                   {"C135", "C224", "C267", "63.00", "111.10", " "},
                                   {"C135", "C224", "H140", "37.50", "110.70", " "},
                                   {"C135", "C224", "N238", "80.00", "109.70", " "},
                                   {"C135", "C235", "N238", "70.00", "116.60", " "},
                                   {"C135", "C235", "N239", "70.00", "116.60", " "},
                                   {"C135", "C235", "O236", "80.00", "120.40", " "},
                                   {"C135", "C283", "C271", "63.00", "111.10", " "},
                                   {"C135", "C283", "H140", "37.50", "110.70", " "},
                                   {"C135", "C283", "N238", "80.00", "109.70", " "},
                                   {"C135", "C293", "C235", "63.00", "111.10", " "},
                                   {"C135", "C293", "H140", "37.50", "110.70", " "},
                                   {"C135", "C293", "N287", "80.00", "111.20", " "},
                                   {"C136", "C135", "H140", "37.50", "110.70", " "},
                                   {"C136", "C136", "C136", "58.35", "112.70", " "},
                                   {"C136", "C136", "C224", "58.35", "112.70", " "},
                                   {"C136", "C136", "C235", "63.00", "111.10", " "},
                                   {"C136", "C136", "C245", "58.35", "112.70", " "},
                                   {"C136", "C136", "C246", "58.35", "112.70", " "},
                                   {"C136", "C136", "C267", "63.00", "111.10", " "},
                                   {"C136", "C136", "C283", "58.35", "112.70", " "},
                                   {"C136", "C136", "C285", "58.35", "112.70", " "},
                                   {"C136", "C136", "C292", "58.35", "112.70", " "},
                                   {"C136", "C136", "C293", "58.35", "112.70", " "},
                                   {"C136", "C136", "C295", "58.35", "112.70", " "},
                                   {"C136", "C136", "C296", "58.35", "112.70", " "},
                                   {"C136", "C136", "H140", "37.50", "110.70", " "},
                                   {"C136", "C137", "C224", "58.35", "112.70", " "},
                                   {"C136", "C137", "C283", "58.35", "112.70", " "},
                                   {"C136", "C137", "C293", "58.35", "112.70", " "},
                                   {"C136", "C137", "H140", "37.50", "110.70", " "},
                                   {"C136", "C210", "H140", "37.50", "110.70", " "},
                                   {"C136", "C210", "S202", "50.00", "114.70", " "},
                                   {"C136", "C224", "C235", "63.00", "111.10", " "},
                                   {"C136", "C224", "H140", "37.50", "110.70", " "},
                                   {"C136", "C224", "N238", "80.00", "109.70", " "},
                                   {"C136", "C235", "N237", "70.00", "116.60", " "},
                                   {"C136", "C235", "O236", "80.00", "120.40", " "},
                                   {"C136", "C245", "H140", "37.50", "110.70", " "},
                                   {"C136", "C245", "N239", "80.00", "109.70", " "},
                                   {"C136", "C246", "C235", "63.00", "111.10", " "},
                                   {"C136", "C246", "H140", "37.50", "110.70", " "},
                                   {"C136", "C246", "N239", "80.00", "109.70", " "},
                                   {"C136", "C267", "O268", "70.00", "108.00", " "},
                                   {"C136", "C267", "O269", "80.00", "120.40", " "},
                                   {"C136", "C274", "C271", "63.00", "111.10", " "},
                                   {"C136", "C274", "H140", "37.50", "110.70", " "},
                                   {"C136", "C283", "C271", "63.00", "111.10", " "},
                                   {"C136", "C283", "H140", "37.50", "110.70", " "},
                                   {"C136", "C283", "N238", "80.00", "109.70", " "},
                                   {"C136", "C285", "C271", "63.00", "111.10", " "},
                                   {"C136", "C285", "H140", "37.50", "110.70", " "},
                                   {"C136", "C285", "N239", "80.00", "109.70", " "},
                                   {"C136", "C292", "H140", "37.50", "110.70", " "},
                                   {"C136", "C292", "N287", "80.00", "111.20", " "},
                                   {"C136", "C293", "C235", "63.00", "111.10", " "},
                                   {"C136", "C293", "H140", "37.50", "110.70", " "},
                                   {"C136", "C293", "N287", "80.00", "111.20", " "},
                                   {"C136", "C295", "C235", "63.00", "111.10", " "},
                                   {"C136", "C295", "H140", "37.50", "110.70", " "},
                                   {"C136", "C295", "N309", "80.00", "111.20", " "},
                                   {"C136", "C296", "H140", "37.50", "110.70", " "},
                                   {"C136", "C296", "N309", "80.00", "111.20", " "},
                                   {"C136", "C308", "C307", "58.35", "112.70", " "},
                                   {"C136", "C308", "H140", "37.50", "110.70", " "},
                                   {"C136", "C500", "C501", "70.00", "128.60", " "},
                                   {"C136", "C500", "C514", "70.00", "125.00", " "},
                                   {"C137", "C135", "H140", "37.50", "110.70", " "},
                                   {"C137", "C136", "C224", "58.35", "112.70", " "},
                                   {"C137", "C136", "C283", "58.35", "112.70", " "},
                                   {"C137", "C136", "C293", "58.35", "112.70", " "},
                                   {"C137", "C136", "H140", "37.50", "110.70", " "},
                                   {"C137", "C224", "C235", "63.00", "111.10", " "},
                                   {"C137", "C224", "H140", "37.50", "110.70", " "},
                                   {"C137", "C224", "N238", "80.00", "109.70", " "},
                                   {"C137", "C283", "C271", "63.00", "111.10", " "},
                                   {"C137", "C283", "H140", "37.50", "110.70", " "},
                                   {"C137", "C283", "N238", "80.00", "109.70", " "},
                                   {"C137", "C293", "C235", "63.00", "111.10", " "},
                                   {"C137", "C293", "H140", "37.50", "110.70", " "},
                                   {"C137", "C293", "N287", "80.00", "111.20", " "},
                                   {"C145", "C145", "C145", "63.00", "120.00", " "},
                                   {"C145", "C145", "C149", "70.00", "120.00", " "},
                                   {"C145", "C145", "C166", "63.00", "120.00", " "},
                                   {"C145", "C145", "C501", "63.00", "120.00", " "},
                                   {"C145", "C145", "C502", "85.00", "120.00", " "},
                                   {"C145", "C145", "H146", "35.00", "120.00", " "},
                                   {"C145", "C149", "C224", "63.00", "114.00", " "},
                                   {"C145", "C149", "C283", "63.00", "114.00", " "},
                                   {"C145", "C149", "C293", "63.00", "114.00", " "},
                                   {"C145", "C149", "H140", "35.00", "109.50", " "},
                                   {"C145", "C166", "C145", "63.00", "120.00", " "},
                                   {"C145", "C166", "O167", "70.00", "120.00", " "},
                                   {"C145", "C501", "C500", "85.00", "134.90", " "},
                                   {"C145", "C501", "C502", "85.00", "116.20", " "},
                                   {"C145", "C502", "C501", "85.00", "122.70", " "},
                                   {"C145", "C502", "N503", "70.00", "132.80", " "},
                                   {"C149", "C224", "C235", "63.00", "111.10", " "},
                                   {"C149", "C224", "H140", "37.50", "110.70", " "},
                                   {"C149", "C224", "N238", "80.00", "109.70", " "},
                                   {"C149", "C283", "C271", "63.00", "111.10", " "},
                                   {"C149", "C283", "H140", "37.50", "110.70", " "},
                                   {"C149", "C283", "N238", "80.00", "109.70", " "},
                                   {"C149", "C293", "C235", "63.00", "111.10", " "},
                                   {"C149", "C293", "H140", "37.50", "110.70", " "},
                                   {"C149", "C293", "N287", "80.00", "111.20", " "},
                                   {"C157", "C224", "C235", "63.00", "111.10", " "},
                                   {"C157", "C224", "H140", "37.50", "110.70", " "},
                                   {"C157", "C224", "N238", "80.00", "109.70", " "},
                                   {"C157", "C283", "C271", "63.00", "111.10", " "},
                                   {"C157", "C283", "H140", "37.50", "110.70", " "},
                                   {"C157", "C283", "N238", "80.00", "109.70", " "},
                                   {"C157", "C293", "C235", "63.00", "111.10", " "},
                                   {"C157", "C293", "H140", "37.50", "110.70", " "},
                                   {"C157", "C293", "N287", "80.00", "111.20", " "},
                                   {"C157", "O154", "H155", "55.00", "108.50", " "},
                                   {"C158", "C135", "H140", "37.50", "110.70", " "},
                                   {"C158", "C224", "C235", "63.00", "111.10", " "},
                                   {"C158", "C224", "H140", "37.50", "110.70", " "},
                                   {"C158", "C224", "N238", "80.00", "109.70", " "},
                                   {"C158", "C283", "C271", "63.00", "111.10", " "},
                                   {"C158", "C283", "H140", "37.50", "110.70", " "},
                                   {"C158", "C283", "N238", "80.00", "109.70", " "},
                                   {"C158", "C293", "C235", "63.00", "111.10", " "},
                                   {"C158", "C293", "H140", "37.50", "110.70", " "},
                                   {"C158", "C293", "N287", "80.00", "111.20", " "},
                                   {"C158", "O154", "H155", "55.00", "108.50", " "},
                                   {"C166", "C145", "H146", "35.00", "120.00", " "},
                                   {"C166", "O167", "H168", "35.00", "113.00", " "},
                                   {"C206", "C224", "C235", "63.00", "111.10", " "},
                                   {"C206", "C224", "H140", "37.50", "110.70", " "},
                                   {"C206", "C224", "N238", "80.00", "109.70", " "},
                                   {"C206", "C283", "C271", "63.00", "111.10", " "},
                                   {"C206", "C283", "H140", "37.50", "110.70", " "},
                                   {"C206", "C283", "N238", "80.00", "109.70", " "},
                                   {"C206", "C293", "C235", "63.00", "111.10", " "},
                                   {"C206", "C293", "H140", "37.50", "110.70", " "},
                                   {"C206", "C293", "N287", "80.00", "111.20", " "},
                                   {"C206", "S200", "H204", "44.00", "96.00", " "},
                                   {"C209", "S202", "C210", "62.00", "98.90", " "},
                                   {"C210", "C136", "C224", "58.35", "112.70", " "},
                                   {"C210", "C136", "C283", "58.35", "112.70", " "},
                                   {"C210", "C136", "C293", "58.35", "112.70", " "},
                                   {"C210", "C136", "H140", "37.50", "110.70", " "},
                                   {"C214", "C224", "C235", "63.00", "111.10", " "},
                                   {"C214", "C224", "H140", "37.50", "110.70", " "},
                                   {"C214", "C224", "N238", "80.00", "109.70", " "},
                                   {"C214", "C283", "C271", "63.00", "111.10", " "},
                                   {"C214", "C283", "H140", "37.50", "110.70", " "},
                                   {"C214", "C283", "N238", "80.00", "109.70", " "},
                                   {"C214", "C293", "C235", "63.00", "111.10", " "},
                                   {"C214", "C293", "H140", "37.50", "110.70", " "},
                                   {"C214", "C293", "N287", "80.00", "111.20", " "},
                                   {"C214", "S203", "S203", "68.00", "103.70", " "},
                                   {"C223", "C235", "N238", "70.00", "116.60", " "},
                                   {"C223", "C235", "N239", "70.00", "116.60", " "},
                                   {"C223", "C235", "O236", "80.00", "120.40", " "},
                                   {"C223", "N238", "C235", "50.00", "121.90", " "},
                                   {"C223", "N238", "H241", "38.00", "118.40", " "},
                                   {"C224", "C135", "H140", "37.50", "110.70", " "},
                                   {"C224", "C136", "C235", "63.00", "111.10", " "},
                                   {"C224", "C136", "C267", "63.00", "111.10", " "},
                                   {"C224", "C136", "C274", "58.35", "112.70", " "},
                                   {"C224", "C136", "C308", "58.35", "112.70", " "},
                                   {"C224", "C136", "C500", "63.00", "115.60", " "},
                                   {"C224", "C136", "H140", "37.50", "110.70", " "},
                                   {"C224", "C137", "H140", "37.50", "110.70", " "},
                                   {"C224", "C149", "H140", "37.50", "110.70", " "},
                                   {"C224", "C157", "H140", "37.50", "110.70", " "},
                                   {"C224", "C157", "O154", "50.00", "109.50", " "},
                                   {"C224", "C158", "H140", "37.50", "110.70", " "},
                                   {"C224", "C158", "O154", "50.00", "109.50", " "},
                                   {"C224", "C206", "H140", "37.50", "110.70", " "},
                                   {"C224", "C206", "S200", "50.00", "108.60", " "},
                                   {"C224", "C214", "H140", "37.50", "110.70", " "},
                                   {"C224", "C214", "S203", "50.00", "114.70", " "},
                                   {"C224", "C235", "N238", "70.00", "116.60", " "},
                                   {"C224", "C235", "N239", "70.00", "116.60", " "},
                                   {"C224", "C235", "O236", "80.00", "120.40", " "},
                                   {"C223", "C267", "O268", "70.00", "108.00", "protonated C-terminal Gly, adm jr."},
                                   {"C224", "C267", "O268", "70.00", "108.00", " "},
                                   {"C223", "C267", "O269", "80.00", "120.40", "protonated C-terminal Gly, adm jr."},
                                   {"C224", "C267", "O269", "80.00", "120.40", " "},
                                   {"C224", "C274", "C271", "63.00", "111.10", " "},
                                   {"C224", "C274", "H140", "37.50", "110.70", " "},
                                   {"C224", "C505", "C507", "63.00", "114.00", " "},
                                   {"C224", "C505", "C508", "63.00", "114.00", " "},
                                   {"C224", "C505", "C510", "63.00", "114.00", " "},
                                   {"C224", "C505", "H140", "37.50", "110.70", " "},
                                   {"C224", "N238", "C235", "50.00", "121.90", " "},
                                   {"C224", "N238", "H241", "38.00", "118.40", " "},
                                   {"C235", "C135", "H140", "35.00", "109.50", " "},
                                   {"C235", "C136", "C283", "63.00", "111.10", " "},
                                   {"C235", "C136", "C293", "63.00", "111.10", " "},
                                   {"C235", "C136", "H140", "35.00", "109.50", " "},
                                   {"C235", "C223", "H140", "35.00", "109.50", " "},
                                   {"C235", "C223", "N238", "63.00", "110.10", " "},
                                   {"C235", "C224", "C274", "63.00", "111.10", " "},
                                   {"C235", "C224", "C505", "63.00", "111.10", " "},
                                   {"C235", "C224", "H140", "35.00", "109.50", " "},
                                   {"C235", "C224", "N238", "63.00", "110.10", " "},
                                   {"C235", "C246", "H140", "35.00", "109.50", " "},
                                   {"C235", "C246", "N239", "63.00", "110.10", " "},
                                   {"C235", "C292", "H140", "35.00", "109.50", " "},
                                   {"C235", "C292", "N287", "80.00", "111.20", " "},
                                   {"C235", "C293", "C274", "63.00", "111.10", " "},
                                   {"C235", "C293", "C505", "63.00", "111.10", " "},
                                   {"C235", "C293", "H140", "35.00", "109.50", " "},
                                   {"C235", "C293", "N287", "80.00", "111.20", " "},
                                   {"C235", "C295", "H140", "35.00", "109.50", " "},
                                   {"C235", "C295", "N309", "80.00", "111.20", " "},
                                   {"C235", "N237", "H240", "35.00", "119.80", " "},
                                   {"C235", "N238", "C242", "50.00", "121.90", " "},
                                   {"C235", "N238", "C283", "50.00", "121.90", " "},
                                   {"C235", "N238", "C284", "50.00", "121.90", " "},
                                   {"C235", "N238", "H241", "35.00", "119.80", " "},
                                   {"C235", "N239", "C245", "50.00", "121.90", " "},
                                   {"C235", "N239", "C246", "50.00", "121.90", " "},
                                   {"C235", "N239", "C285", "50.00", "121.90", " "},
                                   {"C242", "N238", "H241", "38.00", "118.40", " "},
                                   {"C245", "C136", "H140", "37.50", "110.70", " "},
                                   {"C245", "N238", "C285", "50.00", "118.00", " "},
                                   {"C245", "N239", "C246", "50.00", "118.00", " "},
                                   {"C245", "N239", "C285", "50.00", "118.00", " "},
                                   {"C246", "C136", "H140", "37.50", "110.70", " "},
                                   {"C246", "C235", "N238", "70.00", "116.60", " "},
                                   {"C246", "C235", "N239", "70.00", "116.60", " "},
                                   {"C246", "C235", "O236", "80.00", "120.40", " "},
                                   {"C267", "C136", "C283", "63.00", "111.10", " "},
                                   {"C267", "C136", "C293", "63.00", "111.10", " "},
                                   {"C267", "C136", "H140", "35.00", "109.50", " "},
                                   {"C267", "C223", "H140", "35.00", "109.50", "protonated C-terminal Gly, adm jr."},
                                   {"C267", "C224", "H140", "35.00", "109.50", " "},
                                   {"C267", "C223", "N238", "63.00", "110.10", "protonated C-terminal Gly, adm jr."},
                                   {"C267", "C224", "N238", "63.00", "110.10", " "},
                                   {"C267", "O268", "H270", "35.00", "113.00", " "},
                                   {"C271", "C274", "C283", "63.00", "111.10", " "},
                                   {"C271", "C274", "C293", "63.00", "111.10", " "},
                                   {"C271", "C274", "H140", "35.00", "109.50", " "},
                                   {"C271", "C283", "C274", "63.00", "111.10", " "},
                                   {"C271", "C283", "C505", "63.00", "111.10", " "},
                                   {"C271", "C283", "H140", "35.00", "109.50", " "},
                                   {"C271", "C283", "N238", "63.00", "110.10", " "},
                                   {"C271", "C284", "H140", "35.00", "109.50", " "},
                                   {"C271", "C284", "N238", "63.00", "110.10", " "},
                                   {"C271", "C285", "H140", "35.00", "109.50", " "},
                                   {"C271", "C285", "N239", "63.00", "110.10", " "},
                                   {"C274", "C136", "C283", "58.35", "112.70", " "},
                                   {"C274", "C136", "C293", "58.35", "112.70", " "},
                                   {"C274", "C136", "H140", "37.50", "110.70", " "},
                                   {"C274", "C224", "H140", "37.50", "110.70", " "},
                                   {"C274", "C224", "N238", "80.00", "109.70", " "},
                                   {"C274", "C271", "O272", "70.00", "117.00", " "},
                                   {"C274", "C283", "H140", "37.50", "110.70", " "},
                                   {"C274", "C283", "N238", "80.00", "109.70", " "},
                                   {"C274", "C293", "H140", "37.50", "110.70", " "},
                                   {"C274", "C293", "N287", "80.00", "111.20", " "},
                                   {"C283", "C135", "H140", "37.50", "110.70", " "},
                                   {"C283", "C136", "C308", "58.35", "112.70", " "},
                                   {"C283", "C136", "C500", "63.00", "115.60", " "},
                                   {"C283", "C136", "H140", "37.50", "110.70", " "},
                                   {"C283", "C137", "H140", "37.50", "110.70", " "},
                                   {"C283", "C149", "H140", "37.50", "110.70", " "},
                                   {"C283", "C157", "H140", "37.50", "110.70", " "},
                                   {"C283", "C157", "O154", "50.00", "109.50", " "},
                                   {"C283", "C158", "H140", "37.50", "110.70", " "},
                                   {"C283", "C158", "O154", "50.00", "109.50", " "},
                                   {"C283", "C206", "H140", "37.50", "110.70", " "},
                                   {"C283", "C206", "S200", "50.00", "108.60", " "},
                                   {"C283", "C214", "H140", "37.50", "110.70", " "},
                                   {"C283", "C214", "S203", "50.00", "114.70", " "},
                                   {"C283", "C271", "O272", "70.00", "117.00", " "},
                                   {"C283", "C274", "H140", "37.50", "110.70", " "},
                                   {"C283", "C505", "C507", "63.00", "114.00", " "},
                                   {"C283", "C505", "C508", "63.00", "114.00", " "},
                                   {"C283", "C505", "C510", "63.00", "114.00", " "},
                                   {"C283", "C505", "H140", "37.50", "110.70", " "},
                                   {"C283", "N238", "H241", "38.00", "118.40", " "},
                                   {"C284", "C271", "O272", "70.00", "117.00", " "},
                                   {"C284", "N238", "H241", "38.00", "118.40", " "},
                                   {"C285", "C136", "H140", "37.50", "110.70", " "},
                                   {"C285", "C271", "O272", "70.00", "117.00", " "},
                                   {"C292", "C136", "H140", "37.50", "110.70", " "},
                                   {"C292", "C235", "N238", "70.00", "116.60", " "},
                                   {"C292", "C235", "N239", "70.00", "116.60", " "},
                                   {"C292", "C235", "O236", "80.00", "120.40", " "},
                                   {"C292", "N287", "H290", "35.00", "109.50", " "},
                                   {"C293", "C135", "H140", "37.50", "110.70", " "},
                                   {"C293", "C136", "C308", "58.35", "112.70", " "},
                                   {"C293", "C136", "C500", "63.00", "115.60", " "},
                                   {"C293", "C136", "H140", "37.50", "110.70", " "},
                                   {"C293", "C137", "H140", "37.50", "110.70", " "},
                                   {"C293", "C149", "H140", "37.50", "110.70", " "},
                                   {"C293", "C157", "H140", "37.50", "110.70", " "},
                                   {"C293", "C157", "O154", "50.00", "109.50", " "},
                                   {"C293", "C158", "H140", "37.50", "110.70", " "},
                                   {"C293", "C158", "O154", "50.00", "109.50", " "},
                                   {"C293", "C206", "H140", "37.50", "110.70", " "},
                                   {"C293", "C206", "S200", "50.00", "108.60", " "},
                                   {"C293", "C214", "H140", "37.50", "110.70", " "},
                                   {"C293", "C214", "S203", "50.00", "114.70", " "},
                                   {"C293", "C235", "N238", "70.00", "116.60", " "},
                                   {"C293", "C235", "N239", "70.00", "116.60", " "},
                                   {"C293", "C235", "O236", "80.00", "120.40", " "},
                                   {"C293", "C274", "H140", "37.50", "110.70", " "},
                                   {"C293", "C505", "C507", "63.00", "114.00", " "},
                                   {"C293", "C505", "C508", "63.00", "114.00", " "},
                                   {"C293", "C505", "C510", "63.00", "114.00", " "},
                                   {"C293", "C505", "H140", "37.50", "110.70", " "},
                                   {"C293", "N287", "H290", "35.00", "109.50", " "},
                                   {"C295", "C136", "H140", "37.50", "110.70", " "},
                                   {"C295", "C235", "N238", "70.00", "116.60", " "},
                                   {"C295", "C235", "N239", "70.00", "116.60", " "},
                                   {"C295", "C235", "O236", "80.00", "120.40", " "},
                                   {"C295", "N309", "C296", "50.00", "113.00", " "},
                                   {"C295", "N309", "H310", "35.00", "109.50", " "},
                                   {"C296", "C136", "H140", "37.50", "110.70", " "},
                                   {"C296", "N309", "H310", "35.00", "109.50", " "},
                                   {"C302", "N300", "H301", "35.00", "120.00", " "},
                                   {"C302", "N303", "C307", "50.00", "123.20", " "},
                                   {"C302", "N303", "H304", "35.00", "120.00", " "},
                                   {"C307", "C308", "H140", "37.50", "110.70", " "},
                                   {"C307", "N303", "H304", "35.00", "118.40", " "},
                                   {"C308", "C136", "H140", "37.50", "110.70", " "},
                                   {"C308", "C307", "H140", "37.50", "110.70", " "},
                                   {"C308", "C307", "N303", "80.00", "111.20", " "},
                                   {"C500", "C136", "H140", "35.00", "109.50", " "},
                                   {"C500", "C501", "C502", "85.00", "108.80", " "},
                                   {"C500", "C514", "H146", "35.00", "120.00", " "},
                                   {"C500", "C514", "N503", "70.00", "108.70", " "},
                                   {"C501", "C145", "H146", "35.00", "120.00", " "},
                                   {"C501", "C500", "C514", "85.00", "106.40", " "},
                                   {"C501", "C502", "N503", "70.00", "104.40", " "},
                                   {"C502", "C145", "H146", "35.00", "120.00", " "},
                                   {"C502", "N503", "C514", "70.00", "111.60", " "},
                                   {"C502", "N503", "H504", "35.00", "123.10", " "},
                                   {"C505", "C224", "H140", "37.50", "110.70", " "},
                                   {"C505", "C224", "N238", "80.00", "109.70", " "},
                                   {"C505", "C283", "H140", "37.50", "110.70", " "},
                                   {"C505", "C283", "N238", "80.00", "109.70", " "},
                                   {"C505", "C293", "H140", "37.50", "110.70", " "},
                                   {"C505", "C293", "N287", "80.00", "111.20", " "},
                                   {"C505", "C507", "C508", "70.00", "130.70", " "},
                                   {"C505", "C507", "N511", "70.00", "124.50", " "},
                                   {"C505", "C508", "C507", "70.00", "130.70", " "},
                                   {"C505", "C508", "N503", "70.00", "121.60", " "},
                                   {"C505", "C510", "C510", "70.00", "130.70", " "},
                                   {"C505", "C510", "N512", "70.00", "121.60", " "},
                                   {"C506", "N503", "C508", "70.00", "109.80", " "},
                                   {"C506", "N503", "H504", "35.00", "124.00", " "},
                                   {"C506", "N511", "C507", "70.00", "110.00", " "},
                                   {"C507", "C505", "H140", "35.00", "109.50", " "},
                                   {"C507", "C508", "H146", "35.00", "130.70", " "},
                                   {"C507", "C508", "N503", "70.00", "106.30", " "},
                                   {"C508", "C505", "H140", "35.00", "109.50", " "},
                                   {"C508", "C507", "H146", "35.00", "128.20", " "},
                                   {"C508", "C507", "N511", "70.00", "111.00", " "},
                                   {"C508", "N503", "H504", "35.00", "124.00", " "},
                                   {"C509", "N512", "C510", "70.00", "109.80", " "},
                                   {"C509", "N512", "H513", "35.00", "124.00", " "},
                                   {"C510", "C505", "H140", "35.00", "109.50", " "},
                                   {"C510", "C510", "H146", "35.00", "130.70", " "},
                                   {"C510", "C510", "N512", "70.00", "106.30", " "},
                                   {"C510", "N512", "H513", "35.00", "124.00", " "},
                                   {"C514", "N503", "H504", "35.00", "124.00", " "},
                                   {"H140", "C157", "O154", "35.00", "109.50", " "},
                                   {"H140", "C158", "O154", "35.00", "109.50", " "},
                                   {"H140", "C206", "S200", "35.00", "109.50", " "},
                                   {"H140", "C209", "S202", "35.00", "109.50", " "},
                                   {"H140", "C210", "S202", "35.00", "109.50", " "},
                                   {"H140", "C214", "S203", "35.00", "109.50", " "},
                                   {"H140", "C223", "N238", "35.00", "109.50", " "},
                                   {"H140", "C224", "N238", "35.00", "109.50", " "},
                                   {"H140", "C242", "N238", "35.00", "109.50", " "},
                                   {"H140", "C245", "N239", "35.00", "109.50", " "},
                                   {"H140", "C246", "N239", "35.00", "109.50", " "},
                                   {"H140", "C283", "N238", "35.00", "109.50", " "},
                                   {"H140", "C284", "N238", "35.00", "109.50", " "},
                                   {"H140", "C285", "N239", "35.00", "109.50", " "},
                                   {"H140", "C292", "N287", "35.00", "109.50", " "},
                                   {"H140", "C293", "N287", "35.00", "109.50", " "},
                                   {"H140", "C295", "N309", "35.00", "109.50", " "},
                                   {"H140", "C296", "N309", "35.00", "109.50", " "},
                                   {"H140", "C307", "N303", "35.00", "109.50", " "},
                                   {"H146", "C506", "N503", "35.00", "120.00", " "},
                                   {"H146", "C506", "N511", "35.00", "120.00", " "},
                                   {"H146", "C507", "N511", "35.00", "120.00", " "},
                                   {"H146", "C508", "N503", "35.00", "121.60", " "},
                                   {"H146", "C509", "N512", "35.00", "120.00", " "},
                                   {"H146", "C510", "N512", "35.00", "120.00", " "},
                                   {"H146", "C514", "N503", "35.00", "121.60", " "},
                                   {"H240", "N237", "H240", "35.00", "120.00", " "},
                                   {"H301", "N300", "H301", "35.00", "120.00", " "},
                                   {"N237", "C235", "O236", "80.00", "122.90", " "},
                                   {"N238", "C235", "O236", "80.00", "122.90", " "},
                                   {"N239", "C235", "O236", "80.00", "122.90", " "},
                                   {"N300", "C302", "N300", "70.00", "120.00", " "},
                                   {"N300", "C302", "N303", "70.00", "120.00", " "},
                                   {"N503", "C506", "N511", "70.00", "120.00", " "},
                                   {"N512", "C509", "N512", "70.00", "120.00", " "},
                                   {"O268", "C267", "O269", "80.00", "121.00", " "},
                                   {"O272", "C271", "O272", "80.00", "126.00", " "},
                                   {"C183", "O186", "C933", "110.00", "115.000", " "},
                                   {"H196", "C933", "O186", "35.00", "109.500", " "},
                                   {"C320", "N321", "C322", "70.00", "126.400", " "},
                                   {"C320", "N321", "H327", "35.00", "116.800", " "},
                                   {"C324", "N938", "C320", "70.00", "121.600", " "},
                                   {"N321", "C322", "O328", "80.00", "120.600", " "},
                                   {"N321", "C322", "C323", "70.00", "114.100", " "},
                                   {"O326", "C320", "N321", "80.00", "120.600", " "},
                                   {"H327", "N321", "C322", "35.00", "116.800", " "},
                                   {"C322", "C323", "C324", "85.00", "120.700", " "},
                                   {"C322", "C323", "H329", "35.00", "119.700", " "},
                                   {"O328", "C322", "C323", "80.00", "125.300", " "},
                                   {"H329", "C323", "C324", "35.00", "120.000", " "},
                                   {"H196", "C933", "C174", "37.50", "110.700", " "},
                                   {"O186", "C933", "C174", "90.00", "106.000", " "},
                                   {"N938", "C933", "O186", "50.00", "109.500", " "},
                                   {"C933", "C174", "H176", "37.50", "110.700", " "},
                                   {"C933", "C174", "O169", "50.00", "109.500", " "},
                                   {"C933", "C174", "C174", "110.00", "96.000", " "},
                                   {"C933", "N938", "C324", "70.00", "121.200", " "},
                                   {"C320", "N938", "C933", "70.00", "117.600", " "},
                                   {"N938", "C320", "O326", "80.00", "120.900", " "},
                                   {"N938", "C320", "N321", "70.00", "115.400", " "},
                                   {"C323", "C324", "N938", "70.00", "121.200", " "},
                                   {"N938", "C324", "H330", "35.00", "119.100", " "},
                                   {"N938", "C933", "H196", "35.00", "109.500", " "},
                                   {"N938", "C933", "C174", "50.00", "109.500", " "},
                                   {"H330", "C324", "C323", "35.00", "120.000", " "},
                                   {"C336", "N335", "C334", "70.00", "120.500", " "},
                                   {"N335", "C336", "N341", "70.00", "119.300", " "},
                                   {"C337", "C336", "N335", "70.00", "121.500", " "},
                                   {"C183", "O186", "C932", "110.00", "115.000", " "},
                                   {"H196", "C932", "O186", "35.00", "109.500", " "},
                                   {"O186", "C932", "C174", "90.00", "106.000", " "},
                                   {"N937", "C932", "O186", "50.00", "109.500", " "},
                                   {"C338", "C337", "H344", "35.00", "120.000", " "},
                                   {"C334", "N937", "C338", "70.00", "121.600", " "},
                                   {"O340", "C334", "N335", "80.00", "122.500", " "},
                                   {"C336", "N341", "H343", "35.00", "120.000", " "},
                                   {"C336", "N341", "H342", "35.00", "120.000", " "},
                                   {"C338", "C337", "C336", "85.00", "117.000", " "},
                                   {"H344", "C337", "C336", "35.00", "123.300", " "},
                                   {"C337", "C336", "N341", "70.00", "120.100", " "},
                                   {"H343", "N341", "H342", "35.00", "113.000", " "},
                                   {"H196", "C932", "C174", "37.50", "110.700", " "},
                                   {"C932", "C174", "H176", "37.50", "110.700", " "},
                                   {"C932", "C174", "O169", "50.00", "109.500", " "},
                                   {"C932", "C174", "C174", "110.00", "96.000", " "},
                                   {"C338", "N937", "C932", "70.00", "121.200", " "},
                                   {"C932", "N937", "C334", "70.00", "117.600", " "},
                                   {"N937", "C334", "O340", "80.00", "120.900", " "},
                                   {"N335", "C334", "N937", "70.00", "118.600", " "},
                                   {"N937", "C338", "C337", "70.00", "121.200", " "},
                                   {"N937", "C338", "H345", "35.00", "119.100", " "},
                                   {"N937", "C932", "H196", "35.00", "109.500", " "},
                                   {"N937", "C932", "C174", "50.00", "109.500", " "},
                                   {"H345", "C338", "C337", "35.00", "119.700", " "},
                                   {"O370", "C366", "N361", "80.00", "120.600", " "},
                                   {"C364", "C365", "C366", "85.00", "119.200", " "},
                                   {"C365", "N352", "C353", "70.00", "103.800", " "},
                                   {"C365", "C366", "O370", "80.00", "128.800", " "},
                                   {"C364", "C365", "N352", "70.00", "111.000", " "},
                                   {"N361", "C362", "N363", "70.00", "123.300", " "},
                                   {"C362", "N368", "H369", "35.00", "120.000", " "},
                                   {"N352", "C365", "C366", "70.00", "130.000", " "},
                                   {"C365", "C366", "N361", "70.00", "111.300", " "},
                                   {"C366", "N361", "H367", "35.00", "116.800", " "},
                                   {"N936", "C364", "C365", "70.00", "106.200", " "},
                                   {"H369", "N368", "H369", "35.00", "113.000", " "},
                                   {"N363", "C364", "C365", "70.00", "127.700", " "},
                                   {"C366", "N361", "C362", "70.00", "125.200", " "},
                                   {"H367", "N361", "C362", "35.00", "118.000", " "},
                                   {"N936", "C364", "N363", "70.00", "126.200", " "},
                                   {"C362", "N363", "C364", "70.00", "112.200", " "},
                                   {"C353", "N936", "C364", "70.00", "105.400", " "},
                                   {"N368", "C362", "N363", "70.00", "119.300", " "},
                                   {"N361", "C362", "N368", "70.00", "116.000", " "},
                                   {"C364", "N936", "C931", "70.00", "125.800", " "},
                                   {"C183", "C6448", "H140", "37.5", "110.700", " "},
                                   {"P440", "O6452", "P6450", "50.00", "150.000", " "},
                                   {"O441", "P6450", "O6452", "100.00", "108.230", " "},
                                   {"O441", "P6450", "O441", "140.00", "119.900", " "},
                                   {"C6448", "O6934", "P440", "100.00", "120.500", " "},
                                   {"C6448", "C183", "H185", "37.50", "110.700", " "},
                                   {"C174", "C183", "C6448", "58.35", "112.700", " "},
                                   {"C6448", "C183", "O186", "50.00", "109.500", " "},
                                   {"H140", "C6448", "H140", "33.0", "107.800", " "},
                                   {"O6452", "P440", "O6934", "45.00", "102.600", " "},
                                   {"O441", "P440", "O6934", "100.00", "108.230", " "},
                                   {"H140", "C6448", "O6934", "35.00", "109.500", " "},
                                   {"C183", "C6448", "O6934", "50.00", "109.500", " "},
                                   {"P440", "O6452", "P440", "50.00", "150.000", " "},
                                   {"O441", "P440", "O6452", "100.00", "108.230", " "},
                                   {"O441", "P440", "O441", "140.00", "119.900", " "},
                                   {"O6442", "P440", "O6452", "45.00", "102.600", " "},
                                   {"P440", "O6442", "P6450", "50.00", "150.000", " "},
                                   {"O441", "P440", "O6442", "100.00", "108.230", " "},
                                   {"O6441", "P6450", "O6442", "100.00", "108.230", " "},
                                   {"O6441", "P6450", "O6441", "140.00", "119.900", " "},
                                   {"C931", "N936", "C353", "70.00", "128.800", " "},
                                   {"N936", "C931", "C174", "50.00", "109.500", " "},
                                   {"N936", "C931", "O186", "50.00", "109.500", " "},
                                   {"N936", "C931", "H196", "35.00", "109.500", " "},
                                   {"C931", "C174", "C174", "110.00", "96.500", " "},
                                   {"C931", "C174", "O169", "50.00", "109.500", " "},
                                   {"C931", "C174", "H176", "37.50", "110.700", " "},
                                   {"C174", "C174", "C183", "60.00", "100.000", " "},
                                   {"C174", "C174", "H176", "37.50", "110.700", " "},
                                   {"C174", "C183", "C157", "58.35", "112.700", " "},
                                   {"C174", "C183", "H185", "37.50", "110.700", " "},
                                   {"C183", "C157", "O154", "50.00", "109.500", " "},
                                   {"C183", "C157", "H140", "37.50", "110.700", " "},
                                   {"C174", "O169", "H170", "55.00", "108.500", " "},
                                   {"N936", "C349", "C350", "70.00", "106.200", " "},
                                   {"N936", "C349", "N348", "70.00", "126.200", " "},
                                   {"C349", "C350", "C351", "85.00", "117.300", " "},
                                   {"C349", "C350", "N352", "70.00", "111.000", " "},
                                   {"C350", "C351", "N356", "70.00", "123.500", " "},
                                   {"C350", "C351", "N346", "70.00", "117.300", " "},
                                   {"C351", "N356", "H357", "35.00", "120.000", " "},
                                   {"C351", "N356", "H358", "35.00", "120.000", " "},
                                   {"C351", "N346", "C347", "70.00", "118.600", " "},
                                   {"N346", "C347", "H355", "35.00", "115.450", " "},
                                   {"N936", "C353", "H359", "35.00", "123.050", " "},
                                   {"C349", "N936", "C931", "70.00", "125.800", " "},
                                   {"C353", "N936", "C349", "70.00", "105.400", " "},
                                   {"O186", "C931", "C174", "90.00", "106.000", " "},
                                   {"H196", "C931", "C174", "37.50", "110.700", " "},
                                   {"H196", "C931", "O186", "35.00", "109.500", " "},
                                   {"N348", "C349", "C350", "70.00", "127.700", " "},
                                   {"N352", "C353", "N936", "70.00", "113.900", " "},
                                   {"H359", "C353", "N352", "35.00", "123.050", " "},
                                   {"O169", "C174", "C174", "50.00", "109.500", " "},
                                   {"H176", "C174", "O169", "35.00", "109.500", " "},
                                   {"C183", "O186", "C931", "110.00", "115.000", " "},
                                   {"O169", "C174", "C183", "50.00", "109.500", " "},
                                   {"H176", "C174", "C183", "37.50", "110.700", " "},
                                   {"C174", "C183", "O186", "100.00", "109.500", " "},
                                   {"C157", "C183", "O186", "50.00", "109.500", " "},
                                   {"H185", "C183", "O186", "35.00", "109.500", " "},
                                   {"H185", "C183", "C157", "37.50", "110.700", " "},
                                   {"N352", "C350", "C351", "70.00", "132.400", " "},
                                   {"C347", "N348", "C349", "70.00", "111.000", " "},
                                   {"N346", "C351", "N356", "70.00", "119.300", " "},
                                   {"C350", "N352", "C353", "70.00", "103.800", " "},
                                   {"H358", "N356", "H357", "35.00", "113.000", " "},
                                   {"N346", "C347", "N348", "70.00", "129.100", " "},
                                   {"H355", "C347", "N348", "35.00", "115.450", " "}};

/*
 Dihedrals
*/
char * OPLSAAR_dihedrals[2482][8]= {{"X", "C145", "C145", "X", "3.6250", "2", "180.0", " "},
                                   {"X", "C145", "C166", "X", "3.6250", "2", "180.0", " "},
                                   {"X", "C145", "C501", "X", "3.5000", "2", "180.0", " "},
                                   {"X", "C145", "C502", "X", "3.6250", "2", "180.0", " "},
                                   {"X", "C302", "N300", "X", "1.9500", "2", "180.0", " "},
                                   {"X", "C500", "C501", "X", "1.6750", "2", "180.0", " "},
                                   {"X", "C500", "C514", "X", "6.5250", "2", "180.0", " "},
                                   {"X", "C501", "C502", "X", "3.0000", "2", "180.0", " "},
                                   {"X", "C502", "N503", "X", "1.5250", "2", "180.0", " "},
                                   {"X", "C506", "N503", "X", "2.3250", "2", "180.0", " "},
                                   {"X", "C506", "N511", "X", "5.0000", "2", "180.0", " "},
                                   {"X", "C507", "C508", "X", "5.3750", "2", "180.0", " "},
                                   {"X", "C507", "N511", "X", "2.4000", "2", "180.0", " "},
                                   {"X", "C509", "N512", "X", "2.3250", "2", "180.0", " "},
                                   {"X", "C510", "C510", "X", "5.3750", "2", "180.0", " "},
                                   {"X", "C514", "N503", "X", "1.5000", "2", "180.0", " "},
                                   {"O6934", "P440", "O6934", "C157", "0.2500", "1", "0.0", "Alpha"},
                                   {"O6934", "P440", "O6934", "C157", "-0.4000", "2", "180.0", " "},
                                   {"O6934", "P440", "O6934", "C157", "0.2000", "3", "0.0", " "},
                                   {"O6934", "P440", "O6934", "C157", "0.0000", "4", "180.0", " "},
                                   {"O441", "P440", "O6934", "C157", "-0.4500", "1", "0.0", "Alpha prime"},
                                   {"O441", "P440", "O6934", "C157", "0.8500", "2", "180.0", " "},
                                   {"O441", "P440", "O6934", "C157", "0.2000", "3", "0.0", " "},
                                   {"O441", "P440", "O6934", "C157", "0.0000", "4", "180.0", " "},
                                   {"C174", "O6934", "P440", "O441", "-0.4000", "1", "0.0", "Zeta prime"},
                                   {"C174", "O6934", "P440", "O441", "-0.2150", "2", "180.0", " "},
                                   {"C174", "O6934", "P440", "O441", "0.7200", "3", "0.0", " "},
                                   {"C174", "O6934", "P440", "O441", "0.0000", "4", "180.0", " "},
                                   {"C174", "O6934", "P440", "O6934", "0.1900", "1", "0.0", "Zeta"},
                                   {"C174", "O6934", "P440", "O6934", "-1.5100", "2", "180.0", " "},
                                   {"C174", "O6934", "P440", "O6934", "-0.1500", "3", "0.0", " "},
                                   {"C174", "O6934", "P440", "O6934", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C174", "O6934", "4.5330", "1", "0.0", "Technically a Sugar"},
                                   {"O169", "C174", "C174", "O6934", "0.0000", "2", "180.0", " "},
                                   {"O169", "C174", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C174", "O6934", "0.0000", "4", "0.0", " "},
                                   {"P440", "O6934", "C157", "C183", "1.7100", "1", "0.0", "Beta"},
                                   {"P440", "O6934", "C157", "C183", "-0.3100", "2", "180.0", " "},
                                   {"P440", "O6934", "C157", "C183", "0.0500", "3", "0.0", " "},
                                   {"P440", "O6934", "C157", "C183", "0.0000", "4", "180.0", " "},
                                   {"C174", "C174", "O6934", "P440", "0.1000", "1", "0.0", "Epsilon"},
                                   {"C174", "C174", "O6934", "P440", "-0.5500", "2", "180.0", " "},
                                   {"C174", "C174", "O6934", "P440", "-0.0500", "3", "0.0", " "},
                                   {"C174", "C174", "O6934", "P440", "0.0000", "4", "180.0", " "},
                                   {"C174", "C183", "C157", "O6934", "-0.8500", "1", "0.0", "Gamma"},
                                   {"C174", "C183", "C157", "O6934", "-0.7000", "2", "180.0", " "},
                                   {"C174", "C183", "C157", "O6934", "1.4000", "3", "0.0", " "},
                                   {"C174", "C183", "C157", "O6934", "0.0000", "4", "180.0", " "},
                                   {"C931", "C174", "C174", "O6934", "-0.2180", "1", "0.0", "Sugar"},
                                   {"C931", "C174", "C174", "O6934", "0.4500", "2", "180.0", " "},
                                   {"C931", "C174", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"C931", "C174", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"C933", "C174", "C174", "O6934", "-0.2180", "1", "0.0", "Sugar"},
                                   {"C933", "C174", "C174", "O6934", "0.4500", "2", "180.0", " "},
                                   {"C933", "C174", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"C933", "C174", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"C932", "C174", "C174", "O6934", "-0.2180", "1", "0.0", "Sugar"},
                                   {"C932", "C174", "C174", "O6934", "0.4500", "2", "180.0", " "},
                                   {"C932", "C174", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"C932", "C174", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"O6934", "C157", "C183", "O186", "1.9595", "1", "0.0", "Gamma Prime"},
                                   {"O6934", "C157", "C183", "O186", "-1.0000", "2", "180.0", " "},
                                   {"O6934", "C157", "C183", "O186", "-0.8500", "3", "0.0", " "},
                                   {"O6934", "C157", "C183", "O186", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C174", "O6934", "2.1595", "1", "0.0", "Sugar"},
                                   {"O186", "C183", "C174", "O6934", "0.0000", "2", "180.0", " "},
                                   {"O186", "C183", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"O186", "C183", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "O6934", "P440", "0.0000", "1", "0.0", "Epsilon Double Prime"},
                                   {"H176", "C174", "O6934", "P440", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "O6934", "P440", "0.1500", "3", "0.0", " "},
                                   {"H176", "C174", "O6934", "P440", "0.0000", "4", "180.0", " "},
                                   {"P440", "O6934", "C157", "H140", "0.0000", "1", "0.0", "Beta Prime"},
                                   {"P440", "O6934", "C157", "H140", "0.0000", "2", "180.0", " "},
                                   {"P440", "O6934", "C157", "H140", "0.1500", "3", "0.0", " "},
                                   {"P440", "O6934", "C157", "H140", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C174", "O6934", "0.0000", "1", "0.0", "Sugar Pucker"},
                                   {"H185", "C183", "C174", "O6934", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C174", "O6934", "0.2340", "3", "0.0", " "},
                                   {"H185", "C183", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C174", "O6934", "0.0000", "1", "0.0", "Sugar"},
                                   {"H176", "C174", "C174", "O6934", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C174", "O6934", "0.2340", "3", "0.0", " "},
                                   {"H176", "C174", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"O6934", "C157", "C183", "H185", "0.0000", "1", "0.0", "Sugar"},
                                   {"O6934", "C157", "C183", "H185", "0.0000", "2", "180.0", " "},
                                   {"O6934", "C157", "C183", "H185", "0.2340", "3", "0.0", " "},
                                   {"O6934", "C157", "C183", "H185", "0.0000", "4", "180.0", " "},
                                   {"C183", "C174", "O6934", "P440", "0.1400", "1", "0.0", "Epsilon Prime"},
                                   {"C183", "C174", "O6934", "P440", "-0.6100", "2", "180.0", " "},
                                   {"C183", "C174", "O6934", "P440", "-0.8000", "3", "0.0", " "},
                                   {"C183", "C174", "O6934", "P440", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "C174", "O6934", "-0.2180", "1", "0.0", "Sugar Pucker"},
                                   {"C157", "C183", "C174", "O6934", "0.4500", "2", "180.0", " "},
                                   {"C157", "C183", "C174", "O6934", "0.0000", "3", "0.0", " "},
                                   {"C157", "C183", "C174", "O6934", "0.0000", "4", "180.0", " "},
                                   {"C135", "C136", "C137", "C135", "0.6500", "1", "0.0", " "},
                                   {"C135", "C136", "C137", "C135", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C136", "C137", "C135", "0.1000", "3", "0.0", " "},
                                   {"C135", "C136", "C137", "C224", "0.6500", "1", "0.0", " "},
                                   {"C135", "C136", "C137", "C224", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C136", "C137", "C224", "0.1000", "3", "0.0", " "},
                                   {"C135", "C136", "C137", "C283", "0.6500", "1", "0.0", " "},
                                   {"C135", "C136", "C137", "C283", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C136", "C137", "C283", "0.1000", "3", "0.0", " "},
                                   {"C135", "C136", "C137", "C293", "0.6500", "1", "0.0", " "},
                                   {"C135", "C136", "C137", "C293", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C136", "C137", "C293", "0.1000", "3", "0.0", " "},
                                   {"C135", "C136", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C136", "C224", "0.6500", "1", "0.0", " "},
                                   {"C135", "C137", "C136", "C224", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C137", "C136", "C224", "0.1000", "3", "0.0", " "},
                                   {"C135", "C137", "C136", "C283", "0.6500", "1", "0.0", " "},
                                   {"C135", "C137", "C136", "C283", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C137", "C136", "C283", "0.1000", "3", "0.0", " "},
                                   {"C135", "C137", "C136", "C293", "0.6500", "1", "0.0", " "},
                                   {"C135", "C137", "C136", "C293", "-0.1000", "2", "180.0", " "},
                                   {"C135", "C137", "C136", "C293", "0.1000", "3", "0.0", " "},
                                   {"C135", "C137", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C224", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C137", "C224", "C235", "0.5340", "2", "180.0", " "},
                                   {"C135", "C137", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C135", "C137", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C224", "N238", "1.4970", "1", "0.0", " "},
                                   {"C135", "C137", "C224", "N238", "0.1260", "2", "180.0", " "},
                                   {"C135", "C137", "C224", "N238", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C283", "C271", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C137", "C283", "C271", "0.5340", "2", "180.0", " "},
                                   {"C135", "C137", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C135", "C137", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C283", "N238", "1.4970", "1", "0.0", " "},
                                   {"C135", "C137", "C283", "N238", "0.1260", "2", "180.0", " "},
                                   {"C135", "C137", "C283", "N238", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C293", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C137", "C293", "C235", "0.5340", "2", "180.0", " "},
                                   {"C135", "C137", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C135", "C137", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C137", "C293", "N287", "1.4970", "1", "0.0", " "},
                                   {"C135", "C137", "C293", "N287", "0.1260", "2", "180.0", " "},
                                   {"C135", "C137", "C293", "N287", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C224", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C158", "C224", "C235", "0.5340", "2", "180.0", " "},
                                   {"C135", "C158", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C135", "C158", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C224", "N238", "1.4970", "1", "0.0", " "},
                                   {"C135", "C158", "C224", "N238", "0.1260", "2", "180.0", " "},
                                   {"C135", "C158", "C224", "N238", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C283", "C271", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C158", "C283", "C271", "0.5340", "2", "180.0", " "},
                                   {"C135", "C158", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C135", "C158", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C283", "N238", "1.4970", "1", "0.0", " "},
                                   {"C135", "C158", "C283", "N238", "0.1260", "2", "180.0", " "},
                                   {"C135", "C158", "C283", "N238", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C293", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C135", "C158", "C293", "C235", "0.5340", "2", "180.0", " "},
                                   {"C135", "C158", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C135", "C158", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "C293", "N287", "1.4970", "1", "0.0", " "},
                                   {"C135", "C158", "C293", "N287", "0.1260", "2", "180.0", " "},
                                   {"C135", "C158", "C293", "N287", "0.1500", "3", "0.0", " "},
                                   {"C135", "C158", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C135", "C158", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C135", "C158", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C135", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C135", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C135", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C135", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C135", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C135", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C135", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C135", "C224", "C267", "O268", "0.5000", "1", "0.0", " "},
                                   {"C135", "C224", "C267", "O268", "0.2730", "2", "180.0", " "},
                                   {"C135", "C224", "C267", "O268", "0.2250", "3", "0.0", " "},
                                   {"C135", "C224", "C267", "O269", "0.2730", "2", "180.0", " "},
                                   {"C135", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C135", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C135", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C135", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C135", "C235", "N238", "C223", "1.1500", "1", "0.0", " "},
                                   {"C135", "C235", "N238", "C223", "3.0445", "2", "180.0", " "},
                                   {"C135", "C235", "N238", "C224", "1.1500", "1", "0.0", " "},
                                   {"C135", "C235", "N238", "C224", "3.0445", "2", "180.0", " "},
                                   {"C135", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C135", "C235", "N239", "C245", "1.1500", "1", "0.0", " "},
                                   {"C135", "C235", "N239", "C245", "3.0445", "2", "180.0", " "},
                                   {"C135", "C235", "N239", "C246", "1.1500", "1", "0.0", " "},
                                   {"C135", "C235", "N239", "C246", "3.0445", "2", "180.0", " "},
                                   {"C135", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C135", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C135", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C135", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C135", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C135", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C135", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C135", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C135", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C135", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C135", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C135", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C135", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C136", "C136", "C136", "C224", "0.6500", "1", "0.0", " "},
                                   {"C136", "C136", "C136", "C224", "-0.1000", "2", "180.0", " "},
                                   {"C136", "C136", "C136", "C224", "0.1000", "3", "0.0", " "},
                                   {"C267", "C136", "C136", "C224", "0.6500", "1", "0.0", "protonated Glu, adm jr."},
                                   {"C267", "C136", "C136", "C224", "-0.1000", "2", "180.0", "protonated Glu, adm jr."},
                                   {"C267", "C136", "C136", "C224", "0.1000", "3", "0.0", "protonated Glu, adm jr."},
                                   {"C136", "C136", "C136", "C283", "0.6500", "1", "0.0", " "},
                                   {"C136", "C136", "C136", "C283", "-0.1000", "2", "180.0", " "},
                                   {"C136", "C136", "C136", "C283", "0.1000", "3", "0.0", " "},
                                   {"C136", "C136", "C136", "C292", "0.6500", "1", "0.0", " "},
                                   {"C136", "C136", "C136", "C292", "-0.1000", "2", "180.0", " "},
                                   {"C136", "C136", "C136", "C292", "0.1000", "3", "0.0", " "},
                                   {"C136", "C136", "C136", "C293", "0.6500", "1", "0.0", " "},
                                   {"C136", "C136", "C136", "C293", "-0.1000", "2", "180.0", " "},
                                   {"C136", "C136", "C136", "C293", "0.1000", "3", "0.0", " "},
                                   {"C136", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C267", "C136", "C136", "H140", "0.1500", "3", "0.0", "protonated Glu, adm jr."},
                                   {"C136", "C136", "C224", "C235", "-1.1790", "1", "0.0", " "},
                                   {"C136", "C136", "C224", "C235", "0.4555", "2", "180.0", " "},
                                   {"C136", "C136", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C224", "N238", "0.4420", "1", "0.0", " "},
                                   {"C136", "C136", "C224", "N238", "0.4485", "2", "180.0", " "},
                                   {"C136", "C136", "C224", "N238", "0.4400", "3", "0.0", " "},
                                   {"C136", "C136", "C235", "N237", "1.4220", "1", "0.0", " "},
                                   {"C136", "C136", "C235", "N237", "-0.1805", "2", "180.0", " "},
                                   {"C136", "C136", "C235", "N237", "-0.1625", "3", "0.0", " "},
                                   {"C136", "C136", "C235", "O236", "0.2030", "1", "0.0", " "},
                                   {"C136", "C136", "C235", "O236", "0.6520", "2", "180.0", " "},
                                   {"C136", "C136", "C235", "O236", "0.0695", "3", "0.0", " "},
                                   {"C136", "C136", "C245", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C245", "N239", "0.4225", "1", "0.0", " "},
                                   {"C136", "C136", "C245", "N239", "-0.4810", "2", "180.0", " "},
                                   {"C136", "C136", "C245", "N239", "0.3565", "3", "0.0", " "},
                                   {"C136", "C136", "C246", "C235", "-0.8755", "1", "0.0", " "},
                                   {"C136", "C136", "C246", "C235", "0.8030", "2", "180.0", " "},
                                   {"C136", "C136", "C246", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C246", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C246", "N239", "0.7860", "1", "0.0", " "},
                                   {"C136", "C136", "C246", "N239", "0.0795", "2", "180.0", " "},
                                   {"C136", "C136", "C246", "N239", "0.1000", "3", "0.0", " "},
                                   {"C136", "C136", "C267", "O268", "0.5000", "1", "0.0", " "},
                                   {"C136", "C136", "C267", "O268", "0.2730", "2", "180.0", " "},
                                   {"C136", "C136", "C267", "O268", "0.2250", "3", "0.0", " "},
                                   {"C136", "C136", "C267", "O269", "0.2730", "2", "180.0", " "},
                                   {"C136", "C136", "C283", "C271", "-1.1790", "1", "0.0", " "},
                                   {"C136", "C136", "C283", "C271", "0.4555", "2", "180.0", " "},
                                   {"C136", "C136", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C283", "N238", "0.4420", "1", "0.0", " "},
                                   {"C136", "C136", "C283", "N238", "0.4485", "2", "180.0", " "},
                                   {"C136", "C136", "C283", "N238", "0.4400", "3", "0.0", " "},
                                   {"C136", "C136", "C285", "C271", "-0.8755", "1", "0.0", " "},
                                   {"C136", "C136", "C285", "C271", "0.8030", "2", "180.0", " "},
                                   {"C136", "C136", "C285", "C271", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C285", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C285", "N239", "0.7860", "1", "0.0", " "},
                                   {"C136", "C136", "C285", "N239", "0.0795", "2", "180.0", " "},
                                   {"C136", "C136", "C285", "N239", "0.1000", "3", "0.0", " "},
                                   {"C136", "C136", "C292", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C292", "N287", "1.3660", "1", "0.0", " "},
                                   {"C136", "C136", "C292", "N287", "-0.1145", "2", "180.0", " "},
                                   {"C136", "C136", "C292", "N287", "0.2425", "3", "0.0", " "},
                                   {"C136", "C136", "C293", "C235", "-1.1790", "1", "0.0", " "},
                                   {"C136", "C136", "C293", "C235", "0.4555", "2", "180.0", " "},
                                   {"C136", "C136", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C293", "N287", "0.4420", "1", "0.0", " "},
                                   {"C136", "C136", "C293", "N287", "0.4485", "2", "180.0", " "},
                                   {"C136", "C136", "C293", "N287", "0.4400", "3", "0.0", " "},
                                   {"C136", "C136", "C295", "C235", "-0.8755", "1", "0.0", " "},
                                   {"C136", "C136", "C295", "C235", "0.8030", "2", "180.0", " "},
                                   {"C136", "C136", "C295", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C136", "C295", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C295", "N309", "1.3660", "1", "0.0", " "},
                                   {"C136", "C136", "C295", "N309", "-0.1145", "2", "180.0", " "},
                                   {"C136", "C136", "C295", "N309", "0.2425", "3", "0.0", " "},
                                   {"C136", "C136", "C296", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C136", "C296", "N309", "1.3660", "1", "0.0", " "},
                                   {"C136", "C136", "C296", "N309", "-0.1145", "2", "180.0", " "},
                                   {"C136", "C136", "C296", "N309", "0.2425", "3", "0.0", " "},
                                   {"C136", "C137", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C224", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C136", "C137", "C224", "C235", "0.5340", "2", "180.0", " "},
                                   {"C136", "C137", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C137", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C224", "N238", "1.4970", "1", "0.0", " "},
                                   {"C136", "C137", "C224", "N238", "0.1260", "2", "180.0", " "},
                                   {"C136", "C137", "C224", "N238", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C283", "C271", "-0.7110", "1", "0.0", " "},
                                   {"C136", "C137", "C283", "C271", "0.5340", "2", "180.0", " "},
                                   {"C136", "C137", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C136", "C137", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C283", "N238", "1.4970", "1", "0.0", " "},
                                   {"C136", "C137", "C283", "N238", "0.1260", "2", "180.0", " "},
                                   {"C136", "C137", "C283", "N238", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C293", "C235", "-0.7110", "1", "0.0", " "},
                                   {"C136", "C137", "C293", "C235", "0.5340", "2", "180.0", " "},
                                   {"C136", "C137", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C136", "C137", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C137", "C293", "N287", "1.4970", "1", "0.0", " "},
                                   {"C136", "C137", "C293", "N287", "0.1260", "2", "180.0", " "},
                                   {"C136", "C137", "C293", "N287", "0.1500", "3", "0.0", " "},
                                   {"C136", "C210", "S202", "C209", "0.4625", "1", "0.0", " "},
                                   {"C136", "C210", "S202", "C209", "-0.2880", "2", "180.0", " "},
                                   {"C136", "C210", "S202", "C209", "0.3385", "3", "0.0", " "},
                                   {"C136", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C136", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C136", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C136", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C136", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C136", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C136", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C136", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C136", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C136", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C136", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C136", "C235", "N237", "H240", "2.4500", "2", "180.0", " "},
                                   {"C136", "C245", "N239", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C136", "C245", "N239", "C235", "0.0650", "2", "180.0", " "},
                                   {"C136", "C245", "N239", "C235", "0.1690", "3", "0.0", " "},
                                   {"C136", "C245", "N239", "C246", "1.4295", "1", "0.0", " "},
                                   {"C136", "C245", "N239", "C246", "1.0290", "2", "180.0", " "},
                                   {"C136", "C245", "N239", "C246", "-5.6330", "3", "0.0", " "},
                                   {"C136", "C245", "N239", "C285", "1.4295", "1", "0.0", " "},
                                   {"C136", "C245", "N239", "C285", "1.0290", "2", "180.0", " "},
                                   {"C136", "C245", "N239", "C285", "-5.6330", "3", "0.0", " "},
                                   {"C136", "C246", "C235", "N238", "2.5145", "1", "0.0", " "},
                                   {"C136", "C246", "C235", "N238", "0.3595", "2", "180.0", " "},
                                   {"C136", "C246", "C235", "N238", "1.1200", "3", "0.0", " "},
                                   {"C136", "C246", "C235", "N239", "2.5145", "1", "0.0", " "},
                                   {"C136", "C246", "C235", "N239", "0.3595", "2", "180.0", " "},
                                   {"C136", "C246", "C235", "N239", "1.1200", "3", "0.0", " "},
                                   {"C136", "C246", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C136", "C246", "N239", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C136", "C246", "N239", "C235", "0.0650", "2", "180.0", " "},
                                   {"C136", "C246", "N239", "C235", "0.1690", "3", "0.0", " "},
                                   {"C136", "C246", "N239", "C245", "2.3765", "1", "0.0", " "},
                                   {"C136", "C246", "N239", "C245", "-0.3670", "2", "180.0", " "},
                                   {"C136", "C267", "O268", "H270", "0.7500", "1", "0.0", " "},
                                   {"C136", "C267", "O268", "H270", "2.7500", "2", "180.0", " "},
                                   {"C136", "C274", "C271", "O272", "0.2730", "2", "180.0", " "},
                                   {"C136", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C136", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C136", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C136", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C136", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C136", "C285", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C136", "C285", "N239", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C136", "C285", "N239", "C235", "0.0650", "2", "180.0", " "},
                                   {"C136", "C285", "N239", "C235", "0.1690", "3", "0.0", " "},
                                   {"C136", "C285", "N239", "C245", "2.3765", "1", "0.0", " "},
                                   {"C136", "C285", "N239", "C245", "-0.3670", "2", "180.0", " "},
                                   {"C136", "C292", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C136", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C136", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C136", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C136", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C136", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C136", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C136", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C136", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C136", "C295", "C235", "N238", "2.5145", "1", "0.0", " "},
                                   {"C136", "C295", "C235", "N238", "0.3595", "2", "180.0", " "},
                                   {"C136", "C295", "C235", "N238", "1.1200", "3", "0.0", " "},
                                   {"C136", "C295", "C235", "N239", "2.5145", "1", "0.0", " "},
                                   {"C136", "C295", "C235", "N239", "0.3595", "2", "180.0", " "},
                                   {"C136", "C295", "C235", "N239", "1.1200", "3", "0.0", " "},
                                   {"C136", "C295", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C136", "C295", "N309", "C296", "0.71895", "1", "0.0", " "},
                                   {"C136", "C295", "N309", "C296", "-0.0619", "2", "180.0", " "},
                                   {"C136", "C295", "N309", "C296", "0.13195", "3", "0.0", " "},
                                   {"C136", "C295", "N309", "H310", "0.1735", "3", "0.0", " "},
                                   {"C136", "C296", "N309", "C295", "0.71895", "1", "0.0", " "},
                                   {"C136", "C296", "N309", "C295", "-0.0619", "2", "180.0", " "},
                                   {"C136", "C296", "N309", "C295", "0.13195", "3", "0.0", " "},
                                   {"C136", "C296", "N309", "H310", "0.1735", "3", "0.0", " "},
                                   {"C136", "C308", "C307", "H140", "0.1500", "3", "0.0", " "},
                                   {"C136", "C308", "C307", "N303", "1.3660", "1", "0.0", " "},
                                   {"C136", "C308", "C307", "N303", "-0.1145", "2", "180.0", " "},
                                   {"C136", "C308", "C307", "N303", "0.2425", "3", "0.0", " "},
                                   {"C137", "C136", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C137", "C136", "C224", "C235", "-0.8755", "1", "0.0", " "},
                                   {"C137", "C136", "C224", "C235", "0.8030", "2", "180.0", " "},
                                   {"C137", "C136", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C137", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C137", "C136", "C224", "N238", "0.7860", "1", "0.0", " "},
                                   {"C137", "C136", "C224", "N238", "0.0795", "2", "180.0", " "},
                                   {"C137", "C136", "C224", "N238", "0.1000", "3", "0.0", " "},
                                   {"C137", "C136", "C283", "C271", "-0.8755", "1", "0.0", " "},
                                   {"C137", "C136", "C283", "C271", "0.8030", "2", "180.0", " "},
                                   {"C137", "C136", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C137", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C137", "C136", "C283", "N238", "0.7860", "1", "0.0", " "},
                                   {"C137", "C136", "C283", "N238", "0.0795", "2", "180.0", " "},
                                   {"C137", "C136", "C283", "N238", "0.1000", "3", "0.0", " "},
                                   {"C137", "C136", "C293", "C235", "-0.8755", "1", "0.0", " "},
                                   {"C137", "C136", "C293", "C235", "0.8030", "2", "180.0", " "},
                                   {"C137", "C136", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C137", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C137", "C136", "C293", "N287", "0.7860", "1", "0.0", " "},
                                   {"C137", "C136", "C293", "N287", "0.0795", "2", "180.0", " "},
                                   {"C137", "C136", "C293", "N287", "0.1000", "3", "0.0", " "},
                                   {"C137", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C137", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C137", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C137", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C137", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C137", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C137", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C137", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C137", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C137", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C137", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C137", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C137", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C137", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C137", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C137", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C137", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C137", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C137", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C137", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C137", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C137", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C137", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C137", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C145", "C145", "C149", "C224", "0.0000", "1", "0.0", " "},
                                   {"C145", "C145", "C149", "C283", "0.0000", "1", "0.0", " "},
                                   {"C145", "C145", "C149", "C293", "0.0000", "1", "0.0", " "},
                                   {"C145", "C145", "C149", "H140", "0.0000", "1", "0.0", " "},
                                   {"C145", "C149", "C224", "C235", "-0.7030", "1", "0.0", " "},
                                   {"C145", "C149", "C224", "C235", "0.8885", "2", "180.0", " "},
                                   {"C145", "C149", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C145", "C149", "C224", "H140", "0.2310", "3", "0.0", " "},
                                   {"C145", "C149", "C224", "N238", "0.8560", "1", "0.0", " "},
                                   {"C145", "C149", "C224", "N238", "0.3625", "2", "180.0", " "},
                                   {"C145", "C149", "C224", "N238", "0.1830", "3", "0.0", " "},
                                   {"C145", "C149", "C283", "C271", "-0.7030", "1", "0.0", " "},
                                   {"C145", "C149", "C283", "C271", "0.8885", "2", "180.0", " "},
                                   {"C145", "C149", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C145", "C149", "C283", "H140", "0.2310", "3", "0.0", " "},
                                   {"C145", "C149", "C283", "N238", "0.8560", "1", "0.0", " "},
                                   {"C145", "C149", "C283", "N238", "0.3625", "2", "180.0", " "},
                                   {"C145", "C149", "C283", "N238", "0.1830", "3", "0.0", " "},
                                   {"C145", "C149", "C293", "C235", "-0.7030", "1", "0.0", " "},
                                   {"C145", "C149", "C293", "C235", "0.8885", "2", "180.0", " "},
                                   {"C145", "C149", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C145", "C149", "C293", "H140", "0.2310", "3", "0.0", " "},
                                   {"C145", "C149", "C293", "N287", "0.8560", "1", "0.0", " "},
                                   {"C145", "C149", "C293", "N287", "0.3625", "2", "180.0", " "},
                                   {"C145", "C149", "C293", "N287", "0.1830", "3", "0.0", " "},
                                   {"C145", "C166", "C145", "H146", "3.6250", "2", "180.0", " "},
                                   {"C145", "C166", "O167", "H168", "0.8410", "2", "180.0", " "},
                                   {"C145", "C501", "C500", "C514", "1.6750", "2", "180.0", " "},
                                   {"C145", "C502", "C501", "C500", "3.0000", "2", "180.0", " "},
                                   {"C149", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C149", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C149", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C149", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C149", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C149", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C149", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C149", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C149", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C149", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C149", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C149", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C149", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C149", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C149", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C149", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C149", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C149", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C149", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C149", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C149", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C149", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C149", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C149", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C157", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C157", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C157", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C157", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C157", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C157", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C157", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C157", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C157", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C157", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C157", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C157", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C157", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C157", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C157", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C157", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C157", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C157", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C157", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C157", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C157", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C158", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C158", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C158", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C158", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C158", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C158", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C158", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C158", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C158", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C158", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C158", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C158", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C158", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C158", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C158", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C158", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C158", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C158", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C158", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C158", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C158", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C158", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C158", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C158", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C206", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C206", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C206", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C206", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C206", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C206", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C206", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C206", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C206", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C206", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C206", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C206", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C206", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C206", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C206", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C206", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C206", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C206", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C206", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C206", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C206", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C206", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C206", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C206", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C209", "S202", "C210", "H140", "0.3235", "3", "0.0", " "},
                                   {"C210", "C136", "C224", "C235", "-0.4555", "1", "0.0", " "},
                                   {"C210", "C136", "C224", "C235", "0.3495", "2", "180.0", " "},
                                   {"C210", "C136", "C224", "C235", "0.0000", "3", "0.0", " "},
                                   {"C210", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C210", "C136", "C224", "N238", "0.1070", "1", "0.0", " "},
                                   {"C210", "C136", "C224", "N238", "0.2705", "2", "180.0", " "},
                                   {"C210", "C136", "C224", "N238", "0.1960", "3", "0.0", " "},
                                   {"C210", "C136", "C283", "C271", "-0.4555", "1", "0.0", " "},
                                   {"C210", "C136", "C283", "C271", "0.3495", "2", "180.0", " "},
                                   {"C210", "C136", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C210", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C210", "C136", "C283", "N238", "0.1070", "1", "0.0", " "},
                                   {"C210", "C136", "C283", "N238", "0.2705", "2", "180.0", " "},
                                   {"C210", "C136", "C283", "N238", "0.1960", "3", "0.0", " "},
                                   {"C210", "C136", "C293", "C235", "-0.4555", "1", "0.0", " "},
                                   {"C210", "C136", "C293", "C235", "0.3495", "2", "180.0", " "},
                                   {"C210", "C136", "C293", "C235", "0.0000", "3", "0.0", " "},
                                   {"C210", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C210", "C136", "C293", "N287", "0.1070", "1", "0.0", " "},
                                   {"C210", "C136", "C293", "N287", "0.2705", "2", "180.0", " "},
                                   {"C210", "C136", "C293", "N287", "0.1960", "3", "0.0", " "},
                                   {"C210", "S202", "C209", "H140", "0.3235", "3", "0.0", " "},
                                   {"C214", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C214", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C214", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C214", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C214", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C214", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C214", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C214", "C224", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C214", "C224", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C214", "C224", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C214", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C214", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C214", "C283", "N238", "C235", "-0.3410", "1", "0.0", " "},
                                   {"C214", "C283", "N238", "C235", "0.0650", "2", "180.0", " "},
                                   {"C214", "C283", "N238", "C235", "0.1690", "3", "0.0", " "},
                                   {"C214", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C214", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C214", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C214", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C214", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C214", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C214", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C214", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C214", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C214", "S203", "S203", "C214", "-3.7070", "2", "180.0", " "},
                                   {"C214", "S203", "S203", "C214", "0.8525", "3", "0.0", " "},
                                   {"C223", "C235", "N238", "C223", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N238", "C223", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N238", "C224", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N238", "C224", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N238", "C242", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N238", "C242", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N238", "C283", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N238", "C283", "3.0445", "2", "180.0", " "},
                                   {"C295", "C235", "N238", "C283", "1.1500", "1", "0.0", "N-terminal Pro (Pres prop), adm jr."},
                                   {"C295", "C235", "N238", "C283", "3.0445", "2", "180.0", "N-terminal Pro (Pres prop), adm jr."},
                                   {"C223", "C235", "N238", "C284", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N238", "C284", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C223", "C235", "N239", "C245", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N239", "C245", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N239", "C246", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N239", "C246", "3.0445", "2", "180.0", " "},
                                   {"C223", "C235", "N239", "C285", "1.1500", "1", "0.0", " "},
                                   {"C223", "C235", "N239", "C285", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "C224", "1.1500", "1", "0.0", " "},
                                   {"C223", "N238", "C235", "C224", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "C246", "1.1500", "1", "0.0", " "},
                                   {"C223", "N238", "C235", "C246", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "C292", "1.1500", "1", "0.0", " "},
                                   {"C223", "N238", "C235", "C292", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "C293", "1.1500", "1", "0.0", " "},
                                   {"C223", "N238", "C235", "C293", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "C295", "1.1500", "1", "0.0", " "},
                                   {"C223", "N238", "C235", "C295", "3.0445", "2", "180.0", " "},
                                   {"C223", "N238", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C224", "C136", "C136", "C235", "-0.6335", "1", "0.0", " "},
                                   {"C224", "C136", "C136", "C235", "0.2395", "2", "180.0", " "},
                                   {"C224", "C136", "C136", "C235", "-0.2430", "3", "0.0", " "},
                                   {"C224", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C136", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C136", "C210", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C136", "C210", "S202", "-0.7825", "1", "0.0", " "},
                                   {"C224", "C136", "C210", "S202", "-0.0045", "2", "180.0", " "},
                                   {"C224", "C136", "C210", "S202", "-0.2250", "3", "0.0", " "},
                                   {"C224", "C136", "C235", "N237", "0.7470", "1", "0.0", " "},
                                   {"C224", "C136", "C235", "N237", "-0.2555", "2", "180.0", " "},
                                   {"C224", "C136", "C235", "N237", "0.0625", "3", "0.0", " "},
                                   {"C224", "C136", "C235", "O236", "0.8280", "1", "0.0", " "},
                                   {"C224", "C136", "C235", "O236", "0.6520", "2", "180.0", " "},
                                   {"C224", "C136", "C235", "O236", "0.2195", "3", "0.0", " "},
                                   {"C224", "C136", "C267", "O268", "0.5000", "1", "0.0", " "},
                                   {"C224", "C136", "C267", "O268", "0.2730", "2", "180.0", " "},
                                   {"C224", "C136", "C267", "O268", "0.2250", "3", "0.0", " "},
                                   {"C224", "C136", "C267", "O269", "0.2730", "2", "180.0", " "},
                                   {"C224", "C136", "C274", "C271", "-0.4425", "1", "0.0", " "},
                                   {"C224", "C136", "C274", "C271", "0.5125", "2", "180.0", " "},
                                   {"C224", "C136", "C274", "C271", "-0.6465", "3", "0.0", " "},
                                   {"C224", "C136", "C274", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C136", "C308", "C307", "0.6500", "1", "0.0", " "},
                                   {"C224", "C136", "C308", "C307", "-0.1000", "2", "180.0", " "},
                                   {"C224", "C136", "C308", "C307", "0.1000", "3", "0.0", " "},
                                   {"C224", "C136", "C308", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C136", "C500", "C501", "0.0000", "1", "0.0", " "},
                                   {"C224", "C136", "C500", "C514", "-0.3570", "1", "0.0", " "},
                                   {"C224", "C137", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C137", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C157", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C224", "C157", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C224", "C157", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C224", "C158", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C224", "C158", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C224", "C158", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C224", "C158", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C224", "C206", "S200", "H204", "-0.3795", "1", "0.0", " "},
                                   {"C224", "C206", "S200", "H204", "-0.1410", "2", "180.0", " "},
                                   {"C224", "C206", "S200", "H204", "0.3400", "3", "0.0", " "},
                                   {"C224", "C214", "S203", "S203", "0.9705", "1", "0.0", " "},
                                   {"C224", "C214", "S203", "S203", "-0.4180", "2", "180.0", " "},
                                   {"C224", "C214", "S203", "S203", "0.4675", "3", "0.0", " "},
                                   {"C224", "C235", "N238", "C224", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N238", "C224", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N238", "C242", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N238", "C242", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N238", "C283", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N238", "C283", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N238", "C284", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N238", "C284", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C224", "C235", "N239", "C245", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N239", "C245", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N239", "C246", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N239", "C246", "3.0445", "2", "180.0", " "},
                                   {"C224", "C235", "N239", "C285", "1.1500", "1", "0.0", " "},
                                   {"C224", "C235", "N239", "C285", "3.0445", "2", "180.0", " "},
                                   {"C223", "C267", "O268", "H270", "0.7500", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"C223", "C267", "O268", "H270", "2.7500", "2", "180.0", "protonated C-terminal Gly, adm jr."},
                                   {"C224", "C267", "O268", "H270", "0.7500", "1", "0.0", " "},
                                   {"C224", "C267", "O268", "H270", "2.7500", "2", "180.0", " "},
                                   {"C224", "C274", "C271", "O272", "1.2500", "1", "0.0", " "},
                                   {"C224", "C274", "C271", "O272", "0.5000", "2", "180.0", " "},
                                   {"C224", "C274", "C271", "O272", "0.6750", "3", "0.0", " "},
                                   {"C224", "C505", "C507", "C508", "0.0000", "1", "0.0", " "},
                                   {"C224", "C505", "C507", "N511", "-0.2800", "1", "0.0", " "},
                                   {"C224", "C505", "C507", "N511", "-0.3700", "2", "180.0", " "},
                                   {"C224", "C505", "C507", "N511", "0.1745", "3", "0.0", " "},
                                   {"C224", "C505", "C508", "C507", "0.0000", "1", "0.0", " "},
                                   {"C224", "C505", "C508", "N503", "-0.2800", "1", "0.0", " "},
                                   {"C224", "C505", "C508", "N503", "-0.3700", "2", "180.0", " "},
                                   {"C224", "C505", "C508", "N503", "0.1745", "3", "0.0", " "},
                                   {"C224", "C505", "C510", "C510", "0.0000", "1", "0.0", " "},
                                   {"C224", "C505", "C510", "N512", "-1.9950", "1", "0.0", " "},
                                   {"C224", "C505", "C510", "N512", "0.8400", "2", "180.0", " "},
                                   {"C224", "C505", "C510", "N512", "0.1450", "3", "0.0", " "},
                                   {"C224", "N238", "C235", "C246", "1.1500", "1", "0.0", " "},
                                   {"C224", "N238", "C235", "C246", "3.0445", "2", "180.0", " "},
                                   {"C224", "N238", "C235", "C292", "1.1500", "1", "0.0", " "},
                                   {"C224", "N238", "C235", "C292", "3.0445", "2", "180.0", " "},
                                   {"C224", "N238", "C235", "C293", "1.1500", "1", "0.0", " "},
                                   {"C224", "N238", "C235", "C293", "3.0445", "2", "180.0", " "},
                                   {"C224", "N238", "C235", "C295", "1.1500", "1", "0.0", " "},
                                   {"C224", "N238", "C235", "C295", "3.0445", "2", "180.0", " "},
                                   {"C224", "N238", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C235", "C136", "C136", "C283", "-0.6335", "1", "0.0", " "},
                                   {"C235", "C136", "C136", "C283", "0.2395", "2", "180.0", " "},
                                   {"C235", "C136", "C136", "C283", "-0.2430", "3", "0.0", " "},
                                   {"C235", "C136", "C136", "C293", "-0.6335", "1", "0.0", " "},
                                   {"C235", "C136", "C136", "C293", "0.2395", "2", "180.0", " "},
                                   {"C235", "C136", "C136", "C293", "-0.2430", "3", "0.0", " "},
                                   {"C235", "C136", "C136", "H140", "-0.0500", "3", "0.0", " "},
                                   {"C235", "C136", "C224", "C235", "0.2990", "1", "0.0", " "},
                                   {"C235", "C136", "C224", "C235", "0.7790", "2", "180.0", " "},
                                   {"C235", "C136", "C224", "C235", "0.1275", "3", "0.0", " "},
                                   {"C235", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C235", "C136", "C224", "N238", "-2.7505", "1", "0.0", " "},
                                   {"C235", "C136", "C224", "N238", "0.7635", "2", "180.0", " "},
                                   {"C235", "C136", "C224", "N238", "0.0000", "3", "0.0", " "},
                                   {"C235", "C136", "C283", "C271", "0.2990", "1", "0.0", " "},
                                   {"C235", "C136", "C283", "C271", "0.7790", "2", "180.0", " "},
                                   {"C235", "C136", "C283", "C271", "0.1275", "3", "0.0", " "},
                                   {"C235", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C235", "C136", "C283", "N238", "-2.7505", "1", "0.0", " "},
                                   {"C235", "C136", "C283", "N238", "0.7635", "2", "180.0", " "},
                                   {"C235", "C136", "C283", "N238", "0.0000", "3", "0.0", " "},
                                   {"C235", "C136", "C293", "C235", "0.2990", "1", "0.0", " "},
                                   {"C235", "C136", "C293", "C235", "0.7790", "2", "180.0", " "},
                                   {"C235", "C136", "C293", "C235", "0.1275", "3", "0.0", " "},
                                   {"C235", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C235", "C136", "C293", "N287", "-2.7505", "1", "0.0", " "},
                                   {"C235", "C136", "C293", "N287", "0.7635", "2", "180.0", " "},
                                   {"C235", "C136", "C293", "N287", "0.0000", "3", "0.0", " "},
                                   {"C235", "C223", "N238", "C235", "-1.2555", "1", "0.0", " "},
                                   {"C235", "C223", "N238", "C235", "0.1050", "2", "180.0", " "},
                                   {"C235", "C223", "N238", "C235", "-0.1000", "3", "0.0", " "},
                                   {"C235", "C223", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C235", "C224", "C135", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C136", "C267", "0.2990", "1", "0.0", " "},
                                   {"C235", "C224", "C136", "C267", "0.7790", "2", "180.0", " "},
                                   {"C235", "C224", "C136", "C267", "0.1275", "3", "0.0", " "},
                                   {"C235", "C224", "C136", "C274", "-0.8820", "1", "0.0", " "},
                                   {"C235", "C224", "C136", "C274", "0.3500", "2", "180.0", " "},
                                   {"C235", "C224", "C136", "C274", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C136", "C308", "-0.9855", "1", "0.0", " "},
                                   {"C235", "C224", "C136", "C308", "0.3850", "2", "180.0", " "},
                                   {"C235", "C224", "C136", "C308", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C136", "C500", "-0.2530", "1", "0.0", " "},
                                   {"C235", "C224", "C136", "C500", "0.4875", "2", "180.0", " "},
                                   {"C235", "C224", "C136", "C500", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C137", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C149", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C157", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C157", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C235", "C224", "C157", "O154", "0.2025", "2", "180.0", " "},
                                   {"C235", "C224", "C157", "O154", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C158", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C158", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C235", "C224", "C158", "O154", "0.2025", "2", "180.0", " "},
                                   {"C235", "C224", "C158", "O154", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C206", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C206", "S200", "-1.6615", "1", "0.0", " "},
                                   {"C235", "C224", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"C235", "C224", "C206", "S200", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C214", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C214", "S203", "-1.6615", "1", "0.0", " "},
                                   {"C235", "C224", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"C235", "C224", "C214", "S203", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C274", "C271", "0.7715", "1", "0.0", " "},
                                   {"C235", "C224", "C274", "C271", "0.3480", "2", "180.0", " "},
                                   {"C235", "C224", "C274", "C271", "0.0000", "3", "0.0", " "},
                                   {"C235", "C224", "C274", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "C505", "C507", "-0.6410", "1", "0.0", " "},
                                   {"C235", "C224", "C505", "C507", "0.8225", "2", "180.0", " "},
                                   {"C235", "C224", "C505", "C507", "-0.0085", "3", "0.0", " "},
                                   {"C235", "C224", "C505", "C508", "-0.6410", "1", "0.0", " "},
                                   {"C235", "C224", "C505", "C508", "0.8225", "2", "180.0", " "},
                                   {"C235", "C224", "C505", "C508", "-0.0085", "3", "0.0", " "},
                                   {"C235", "C224", "C505", "C510", "-0.8540", "1", "0.0", " "},
                                   {"C235", "C224", "C505", "C510", "0.7580", "2", "180.0", " "},
                                   {"C235", "C224", "C505", "C510", "-0.2510", "3", "0.0", " "},
                                   {"C235", "C224", "C505", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C224", "N238", "C235", "-1.2555", "1", "0.0", " "},
                                   {"C235", "C224", "N238", "C235", "0.1050", "2", "180.0", " "},
                                   {"C235", "C224", "N238", "C235", "-0.1000", "3", "0.0", " "},
                                   {"C235", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C235", "N238", "C223", "C267", "-1.2555", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"C235", "N238", "C223", "C267", "0.1050", "2", "180.0", "protonated C-terminal Gly, adm jr."},
                                   {"C235", "N238", "C223", "C267", "-0.1000", "3", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"C235", "N238", "C224", "C267", "-1.2555", "1", "0.0", " "},
                                   {"C235", "N238", "C224", "C267", "0.1050", "2", "180.0", " "},
                                   {"C235", "N238", "C224", "C267", "-0.1000", "3", "0.0", " "},
                                   {"C235", "C246", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C246", "N239", "C235", "-1.2555", "1", "0.0", " "},
                                   {"C235", "C246", "N239", "C235", "0.1050", "2", "180.0", " "},
                                   {"C235", "C246", "N239", "C235", "-0.1000", "3", "0.0", " "},
                                   {"C235", "C246", "N239", "C245", "-0.8685", "1", "0.0", " "},
                                   {"C235", "C246", "N239", "C245", "0.6255", "2", "180.0", " "},
                                   {"C235", "C246", "N239", "C245", "-1.7505", "3", "0.0", " "},
                                   {"C235", "C292", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C235", "C293", "C135", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C136", "C274", "-0.8820", "1", "0.0", " "},
                                   {"C235", "C293", "C136", "C274", "0.3500", "2", "180.0", " "},
                                   {"C235", "C293", "C136", "C274", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C136", "C308", "-0.9855", "1", "0.0", " "},
                                   {"C235", "C293", "C136", "C308", "0.3850", "2", "180.0", " "},
                                   {"C235", "C293", "C136", "C308", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C136", "C500", "-0.2530", "1", "0.0", " "},
                                   {"C235", "C293", "C136", "C500", "0.4875", "2", "180.0", " "},
                                   {"C235", "C293", "C136", "C500", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C137", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C149", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C157", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C157", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C235", "C293", "C157", "O154", "0.2025", "2", "180.0", " "},
                                   {"C235", "C293", "C157", "O154", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C158", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C158", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C235", "C293", "C158", "O154", "0.2025", "2", "180.0", " "},
                                   {"C235", "C293", "C158", "O154", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C206", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C206", "S200", "-1.6615", "1", "0.0", " "},
                                   {"C235", "C293", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"C235", "C293", "C206", "S200", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C214", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C214", "S203", "-1.6615", "1", "0.0", " "},
                                   {"C235", "C293", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"C235", "C293", "C214", "S203", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C274", "C271", "0.7715", "1", "0.0", " "},
                                   {"C235", "C293", "C274", "C271", "0.3480", "2", "180.0", " "},
                                   {"C235", "C293", "C274", "C271", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C274", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "C505", "C507", "-0.6410", "1", "0.0", " "},
                                   {"C235", "C293", "C505", "C507", "0.8225", "2", "180.0", " "},
                                   {"C235", "C293", "C505", "C507", "-0.0085", "3", "0.0", " "},
                                   {"C235", "C293", "C505", "C508", "-0.6410", "1", "0.0", " "},
                                   {"C235", "C293", "C505", "C508", "0.8225", "2", "180.0", " "},
                                   {"C235", "C293", "C505", "C508", "-0.0085", "3", "0.0", " "},
                                   {"C235", "C293", "C505", "C510", "-0.8540", "1", "0.0", " "},
                                   {"C235", "C293", "C505", "C510", "0.7580", "2", "180.0", " "},
                                   {"C235", "C293", "C505", "C510", "-0.2510", "3", "0.0", " "},
                                   {"C235", "C293", "C505", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C235", "C295", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C235", "C295", "N309", "C296", "0.71895", "1", "0.0", " "},
                                   {"C235", "C295", "N309", "C296", "-0.0619", "2", "180.0", " "},
                                   {"C235", "C295", "N309", "C296", "0.13195", "3", "0.0", " "},
                                   {"C235", "C295", "N309", "H310", "0.1735", "3", "0.0", " "},
                                   {"C235", "N238", "C223", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N238", "C224", "C274", "-0.3410", "1", "0.0", " "},
                                   {"C235", "N238", "C224", "C274", "0.0650", "2", "180.0", " "},
                                   {"C235", "N238", "C224", "C274", "0.1690", "3", "0.0", " "},
                                   {"C235", "N238", "C224", "C505", "-0.3410", "1", "0.0", " "},
                                   {"C235", "N238", "C224", "C505", "0.0650", "2", "180.0", " "},
                                   {"C235", "N238", "C224", "C505", "0.1690", "3", "0.0", " "},
                                   {"C235", "N238", "C224", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N238", "C242", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N238", "C283", "C271", "-1.2555", "1", "0.0", " "},
                                   {"C235", "N238", "C283", "C271", "0.1050", "2", "180.0", " "},
                                   {"C235", "N238", "C283", "C271", "-0.1000", "3", "0.0", " "},
                                   {"C235", "N238", "C283", "C274", "-0.3410", "1", "0.0", " "},
                                   {"C235", "N238", "C283", "C274", "0.0650", "2", "180.0", " "},
                                   {"C235", "N238", "C283", "C274", "0.1690", "3", "0.0", " "},
                                   {"C235", "N238", "C283", "C505", "-0.3410", "1", "0.0", " "},
                                   {"C235", "N238", "C283", "C505", "0.0650", "2", "180.0", " "},
                                   {"C235", "N238", "C283", "C505", "0.1690", "3", "0.0", " "},
                                   {"C235", "N238", "C283", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N238", "C284", "C271", "-1.2555", "1", "0.0", " "},
                                   {"C235", "N238", "C284", "C271", "0.1050", "2", "180.0", " "},
                                   {"C235", "N238", "C284", "C271", "-0.1000", "3", "0.0", " "},
                                   {"C235", "N238", "C284", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N239", "C245", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N239", "C246", "H140", "0.0000", "1", "0.0", " "},
                                   {"C235", "N239", "C285", "C271", "-1.2555", "1", "0.0", " "},
                                   {"C235", "N239", "C285", "C271", "0.1050", "2", "180.0", " "},
                                   {"C235", "N239", "C285", "C271", "-0.1000", "3", "0.0", " "},
                                   {"C235", "N239", "C285", "H140", "0.0000", "1", "0.0", " "},
                                   {"C242", "N238", "C235", "C246", "1.1500", "1", "0.0", " "},
                                   {"C242", "N238", "C235", "C246", "3.0445", "2", "180.0", " "},
                                   {"C242", "N238", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C245", "C136", "C136", "C246", "0.6500", "1", "0.0", " "},
                                   {"C245", "C136", "C136", "C246", "-0.1000", "2", "180.0", " "},
                                   {"C245", "C136", "C136", "C246", "0.1000", "3", "0.0", " "},
                                   {"C245", "C136", "C136", "C285", "0.6500", "1", "0.0", " "},
                                   {"C245", "C136", "C136", "C285", "-0.1000", "2", "180.0", " "},
                                   {"C245", "C136", "C136", "C285", "0.1000", "3", "0.0", " "},
                                   {"C245", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C245", "N239", "C235", "C246", "1.1500", "1", "0.0", " "},
                                   {"C245", "N239", "C235", "C246", "3.0445", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "C292", "1.1500", "1", "0.0", " "},
                                   {"C245", "N239", "C235", "C292", "3.0445", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "C293", "1.1500", "1", "0.0", " "},
                                   {"C245", "N239", "C235", "C293", "3.0445", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "C295", "1.1500", "1", "0.0", " "},
                                   {"C245", "N239", "C235", "C295", "3.0445", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C245", "N239", "C246", "H140", "0.0000", "1", "0.0", " "},
                                   {"C245", "N239", "C285", "C271", "-0.8685", "1", "0.0", " "},
                                   {"C245", "N239", "C285", "C271", "0.6255", "2", "180.0", " "},
                                   {"C245", "N239", "C285", "C271", "-1.7505", "3", "0.0", " "},
                                   {"C245", "N239", "C285", "H140", "0.0000", "1", "0.0", " "},
                                   {"C246", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C246", "C235", "N238", "C283", "1.1500", "1", "0.0", " "},
                                   {"C246", "C235", "N238", "C283", "3.0445", "2", "180.0", " "},
                                   {"C246", "C235", "N238", "C284", "1.1500", "1", "0.0", " "},
                                   {"C246", "C235", "N238", "C284", "3.0445", "2", "180.0", " "},
                                   {"C246", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C246", "C235", "N239", "C246", "1.1500", "1", "0.0", " "},
                                   {"C246", "C235", "N239", "C246", "3.0445", "2", "180.0", " "},
                                   {"C246", "C235", "N239", "C285", "1.1500", "1", "0.0", " "},
                                   {"C246", "C235", "N239", "C285", "3.0445", "2", "180.0", " "},
                                   {"C246", "N239", "C235", "C292", "1.1500", "1", "0.0", " "},
                                   {"C246", "N239", "C235", "C292", "3.0445", "2", "180.0", " "},
                                   {"C246", "N239", "C235", "C293", "1.1500", "1", "0.0", " "},
                                   {"C246", "N239", "C235", "C293", "3.0445", "2", "180.0", " "},
                                   {"C246", "N239", "C235", "C295", "1.1500", "1", "0.0", " "},
                                   {"C246", "N239", "C235", "C295", "3.0445", "2", "180.0", " "},
                                   {"C246", "N239", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C246", "N239", "C245", "H140", "0.0000", "1", "0.0", " "},
                                   {"C267", "C136", "C224", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C267", "C136", "C224", "N238", "-2.7505", "1", "0.0", " "},
                                   {"C267", "C136", "C224", "N238", "0.7635", "2", "180.0", " "},
                                   {"C267", "C136", "C224", "N238", "0.0000", "3", "0.0", " "},
                                   {"C267", "C224", "C135", "H140", "0.0370", "3", "0.0", " "},
                                   {"C267", "C223", "N238", "H241", "0.0000", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"C267", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C271", "C274", "C136", "C283", "-0.4425", "1", "0.0", " "},
                                   {"C271", "C274", "C136", "C283", "0.5125", "2", "180.0", " "},
                                   {"C271", "C274", "C136", "C283", "-0.6465", "3", "0.0", " "},
                                   {"C271", "C274", "C136", "C293", "-0.4425", "1", "0.0", " "},
                                   {"C271", "C274", "C136", "C293", "0.5125", "2", "180.0", " "},
                                   {"C271", "C274", "C136", "C293", "-0.6465", "3", "0.0", " "},
                                   {"C271", "C274", "C136", "H140", "-0.1125", "3", "0.0", " "},
                                   {"C271", "C274", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C271", "C274", "C224", "N238", "-3.9450", "1", "0.0", " "},
                                   {"C271", "C274", "C224", "N238", "0.3310", "2", "180.0", " "},
                                   {"C271", "C274", "C224", "N238", "0.4985", "3", "0.0", " "},
                                   {"C271", "C274", "C283", "C271", "0.7715", "1", "0.0", " "},
                                   {"C271", "C274", "C283", "C271", "0.3480", "2", "180.0", " "},
                                   {"C271", "C274", "C283", "C271", "0.0000", "3", "0.0", " "},
                                   {"C271", "C274", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C271", "C274", "C283", "N238", "-3.9450", "1", "0.0", " "},
                                   {"C271", "C274", "C283", "N238", "0.3310", "2", "180.0", " "},
                                   {"C271", "C274", "C283", "N238", "0.4985", "3", "0.0", " "},
                                   {"C271", "C274", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C271", "C274", "C293", "N287", "-3.9450", "1", "0.0", " "},
                                   {"C271", "C274", "C293", "N287", "0.3310", "2", "180.0", " "},
                                   {"C271", "C274", "C293", "N287", "0.4985", "3", "0.0", " "},
                                   {"C271", "C283", "C135", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C136", "C274", "-0.8820", "1", "0.0", " "},
                                   {"C271", "C283", "C136", "C274", "0.3500", "2", "180.0", " "},
                                   {"C271", "C283", "C136", "C274", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C136", "C308", "-0.9855", "1", "0.0", " "},
                                   {"C271", "C283", "C136", "C308", "0.3850", "2", "180.0", " "},
                                   {"C271", "C283", "C136", "C308", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C136", "C500", "-0.2530", "1", "0.0", " "},
                                   {"C271", "C283", "C136", "C500", "0.4875", "2", "180.0", " "},
                                   {"C271", "C283", "C136", "C500", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C137", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C149", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C157", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C157", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C271", "C283", "C157", "O154", "0.2025", "2", "180.0", " "},
                                   {"C271", "C283", "C157", "O154", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C158", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C158", "O154", "-2.8965", "1", "0.0", " "},
                                   {"C271", "C283", "C158", "O154", "0.2025", "2", "180.0", " "},
                                   {"C271", "C283", "C158", "O154", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C206", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C206", "S200", "-1.6615", "1", "0.0", " "},
                                   {"C271", "C283", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"C271", "C283", "C206", "S200", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C214", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C214", "S203", "-1.6615", "1", "0.0", " "},
                                   {"C271", "C283", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"C271", "C283", "C214", "S203", "0.0000", "3", "0.0", " "},
                                   {"C271", "C283", "C274", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "C505", "C507", "-0.6410", "1", "0.0", " "},
                                   {"C271", "C283", "C505", "C507", "0.8225", "2", "180.0", " "},
                                   {"C271", "C283", "C505", "C507", "-0.0085", "3", "0.0", " "},
                                   {"C271", "C283", "C505", "C508", "-0.6410", "1", "0.0", " "},
                                   {"C271", "C283", "C505", "C508", "0.8225", "2", "180.0", " "},
                                   {"C271", "C283", "C505", "C508", "-0.0085", "3", "0.0", " "},
                                   {"C271", "C283", "C505", "C510", "-0.8540", "1", "0.0", " "},
                                   {"C271", "C283", "C505", "C510", "0.7580", "2", "180.0", " "},
                                   {"C271", "C283", "C505", "C510", "-0.2510", "3", "0.0", " "},
                                   {"C271", "C283", "C505", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C271", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C271", "C284", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C271", "C285", "C136", "H140", "-0.0380", "3", "0.0", " "},
                                   {"C274", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C274", "C136", "C224", "N238", "0.9935", "1", "0.0", " "},
                                   {"C274", "C136", "C224", "N238", "0.2285", "2", "180.0", " "},
                                   {"C274", "C136", "C224", "N238", "0.4100", "3", "0.0", " "},
                                   {"C274", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C274", "C136", "C283", "N238", "0.9935", "1", "0.0", " "},
                                   {"C274", "C136", "C283", "N238", "0.2285", "2", "180.0", " "},
                                   {"C274", "C136", "C283", "N238", "0.4100", "3", "0.0", " "},
                                   {"C274", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C274", "C136", "C293", "N287", "0.9935", "1", "0.0", " "},
                                   {"C274", "C136", "C293", "N287", "0.2285", "2", "180.0", " "},
                                   {"C274", "C136", "C293", "N287", "0.4100", "3", "0.0", " "},
                                   {"C274", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C274", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C274", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C274", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C274", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C274", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C274", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C274", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C274", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C274", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C274", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C274", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C274", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C274", "C293", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C274", "C293", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C274", "C293", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C274", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C274", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C283", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C136", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C136", "C210", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C136", "C210", "S202", "-0.7825", "1", "0.0", " "},
                                   {"C283", "C136", "C210", "S202", "-0.0045", "2", "180.0", " "},
                                   {"C283", "C136", "C210", "S202", "-0.2250", "3", "0.0", " "},
                                   {"C283", "C136", "C235", "N237", "0.7470", "1", "0.0", " "},
                                   {"C283", "C136", "C235", "N237", "-0.2555", "2", "180.0", " "},
                                   {"C283", "C136", "C235", "N237", "0.0625", "3", "0.0", " "},
                                   {"C283", "C136", "C235", "O236", "0.8280", "1", "0.0", " "},
                                   {"C283", "C136", "C235", "O236", "0.6520", "2", "180.0", " "},
                                   {"C283", "C136", "C235", "O236", "0.2195", "3", "0.0", " "},
                                   {"C283", "C136", "C267", "O268", "0.5000", "1", "0.0", " "},
                                   {"C283", "C136", "C267", "O268", "0.2730", "2", "180.0", " "},
                                   {"C283", "C136", "C267", "O268", "0.2250", "3", "0.0", " "},
                                   {"C283", "C136", "C267", "O269", "0.2730", "2", "180.0", " "},
                                   {"C283", "C136", "C274", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C136", "C308", "C307", "0.6500", "1", "0.0", " "},
                                   {"C283", "C136", "C308", "C307", "-0.1000", "2", "180.0", " "},
                                   {"C283", "C136", "C308", "C307", "0.1000", "3", "0.0", " "},
                                   {"C283", "C136", "C308", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C136", "C500", "C501", "0.0000", "1", "0.0", " "},
                                   {"C283", "C136", "C500", "C514", "-0.3570", "1", "0.0", " "},
                                   {"C283", "C137", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C137", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C157", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C283", "C157", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C283", "C157", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C283", "C158", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C283", "C158", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C283", "C158", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C283", "C158", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C283", "C206", "S200", "H204", "-0.3795", "1", "0.0", " "},
                                   {"C283", "C206", "S200", "H204", "-0.1410", "2", "180.0", " "},
                                   {"C283", "C206", "S200", "H204", "0.3400", "3", "0.0", " "},
                                   {"C283", "C214", "S203", "S203", "0.9705", "1", "0.0", " "},
                                   {"C283", "C214", "S203", "S203", "-0.4180", "2", "180.0", " "},
                                   {"C283", "C214", "S203", "S203", "0.4675", "3", "0.0", " "},
                                   {"C283", "C274", "C271", "O272", "1.2500", "1", "0.0", " "},
                                   {"C283", "C274", "C271", "O272", "0.5000", "2", "180.0", " "},
                                   {"C283", "C274", "C271", "O272", "0.6750", "3", "0.0", " "},
                                   {"C283", "C505", "C507", "C508", "0.0000", "1", "0.0", " "},
                                   {"C283", "C505", "C507", "N511", "-0.2800", "1", "0.0", " "},
                                   {"C283", "C505", "C507", "N511", "-0.3700", "2", "180.0", " "},
                                   {"C283", "C505", "C507", "N511", "0.1745", "3", "0.0", " "},
                                   {"C283", "C505", "C508", "C507", "0.0000", "1", "0.0", " "},
                                   {"C283", "C505", "C508", "N503", "-0.2800", "1", "0.0", " "},
                                   {"C283", "C505", "C508", "N503", "-0.3700", "2", "180.0", " "},
                                   {"C283", "C505", "C508", "N503", "0.1745", "3", "0.0", " "},
                                   {"C283", "C505", "C510", "C510", "0.0000", "1", "0.0", " "},
                                   {"C283", "C505", "C510", "N512", "-1.9950", "1", "0.0", " "},
                                   {"C283", "C505", "C510", "N512", "0.8400", "2", "180.0", " "},
                                   {"C283", "C505", "C510", "N512", "0.1450", "3", "0.0", " "},
                                   {"C283", "N238", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C284", "N238", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C285", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C285", "N239", "C235", "O236", "3.0445", "2", "180.0", " "},
                                   {"C285", "N239", "C245", "H140", "0.0000", "1", "0.0", " "},
                                   {"C292", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C292", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C293", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C136", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C136", "C210", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C136", "C210", "S202", "-0.7825", "1", "0.0", " "},
                                   {"C293", "C136", "C210", "S202", "-0.0045", "2", "180.0", " "},
                                   {"C293", "C136", "C210", "S202", "-0.2250", "3", "0.0", " "},
                                   {"C293", "C136", "C235", "N237", "0.7470", "1", "0.0", " "},
                                   {"C293", "C136", "C235", "N237", "-0.2555", "2", "180.0", " "},
                                   {"C293", "C136", "C235", "N237", "0.0625", "3", "0.0", " "},
                                   {"C293", "C136", "C235", "O236", "0.8280", "1", "0.0", " "},
                                   {"C293", "C136", "C235", "O236", "0.6520", "2", "180.0", " "},
                                   {"C293", "C136", "C235", "O236", "0.2195", "3", "0.0", " "},
                                   {"C293", "C136", "C267", "O268", "0.5000", "1", "0.0", " "},
                                   {"C293", "C136", "C267", "O268", "0.2730", "2", "180.0", " "},
                                   {"C293", "C136", "C267", "O268", "0.2250", "3", "0.0", " "},
                                   {"C293", "C136", "C267", "O269", "0.2730", "2", "180.0", " "},
                                   {"C293", "C136", "C274", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C136", "C308", "C307", "0.6500", "1", "0.0", " "},
                                   {"C293", "C136", "C308", "C307", "-0.1000", "2", "180.0", " "},
                                   {"C293", "C136", "C308", "C307", "0.1000", "3", "0.0", " "},
                                   {"C293", "C136", "C308", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C136", "C500", "C501", "0.0000", "1", "0.0", " "},
                                   {"C293", "C136", "C500", "C514", "-0.3570", "1", "0.0", " "},
                                   {"C293", "C137", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C137", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C157", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C293", "C157", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C293", "C157", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C293", "C158", "C135", "H140", "0.1500", "3", "0.0", " "},
                                   {"C293", "C158", "O154", "H155", "-0.1780", "1", "0.0", " "},
                                   {"C293", "C158", "O154", "H155", "-0.0870", "2", "180.0", " "},
                                   {"C293", "C158", "O154", "H155", "0.2460", "3", "0.0", " "},
                                   {"C293", "C206", "S200", "H204", "-0.3795", "1", "0.0", " "},
                                   {"C293", "C206", "S200", "H204", "-0.1410", "2", "180.0", " "},
                                   {"C293", "C206", "S200", "H204", "0.3400", "3", "0.0", " "},
                                   {"C293", "C214", "S203", "S203", "0.9705", "1", "0.0", " "},
                                   {"C293", "C214", "S203", "S203", "-0.4180", "2", "180.0", " "},
                                   {"C293", "C214", "S203", "S203", "0.4675", "3", "0.0", " "},
                                   {"C293", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C293", "C274", "C271", "O272", "1.2500", "1", "0.0", " "},
                                   {"C293", "C274", "C271", "O272", "0.5000", "2", "180.0", " "},
                                   {"C293", "C274", "C271", "O272", "0.6750", "3", "0.0", " "},
                                   {"C293", "C505", "C507", "C508", "0.0000", "1", "0.0", " "},
                                   {"C293", "C505", "C507", "N511", "-0.2800", "1", "0.0", " "},
                                   {"C293", "C505", "C507", "N511", "-0.3700", "2", "180.0", " "},
                                   {"C293", "C505", "C507", "N511", "0.1745", "3", "0.0", " "},
                                   {"C293", "C505", "C508", "C507", "0.0000", "1", "0.0", " "},
                                   {"C293", "C505", "C508", "N503", "-0.2800", "1", "0.0", " "},
                                   {"C293", "C505", "C508", "N503", "-0.3700", "2", "180.0", " "},
                                   {"C293", "C505", "C508", "N503", "0.1745", "3", "0.0", " "},
                                   {"C293", "C505", "C510", "C510", "0.0000", "1", "0.0", " "},
                                   {"C293", "C505", "C510", "N512", "-1.9950", "1", "0.0", " "},
                                   {"C293", "C505", "C510", "N512", "0.8400", "2", "180.0", " "},
                                   {"C293", "C505", "C510", "N512", "0.1450", "3", "0.0", " "},
                                   {"C295", "C136", "C136", "C296", "0.6500", "1", "0.0", " "},
                                   {"C295", "C136", "C136", "C296", "-0.1000", "2", "180.0", " "},
                                   {"C295", "C136", "C136", "C296", "0.1000", "3", "0.0", " "},
                                   {"C295", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C295", "C235", "N238", "H241", "2.4500", "2", "180.0", " "},
                                   {"C295", "N309", "C296", "H140", "0.15085", "3", "0.0", " "},
                                   {"C296", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C296", "N309", "C295", "H140", "0.15085", "3", "0.0", " "},
                                   {"C302", "N303", "C307", "C308", "0.9145", "1", "0.0", " "},
                                   {"C302", "N303", "C307", "C308", "0.1215", "2", "180.0", " "},
                                   {"C302", "N303", "C307", "C308", "-0.2490", "3", "0.0", " "},
                                   {"C302", "N303", "C307", "H140", "0.0885", "3", "0.0", " "},
                                   {"C307", "C308", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"C307", "N303", "C302", "N300", "3.9680", "2", "180.0", " "},
                                   {"C308", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"C308", "C136", "C224", "N238", "0.0515", "1", "0.0", " "},
                                   {"C308", "C136", "C224", "N238", "0.3265", "2", "180.0", " "},
                                   {"C308", "C136", "C224", "N238", "0.2815", "3", "0.0", " "},
                                   {"C308", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"C308", "C136", "C283", "N238", "0.0515", "1", "0.0", " "},
                                   {"C308", "C136", "C283", "N238", "0.3265", "2", "180.0", " "},
                                   {"C308", "C136", "C283", "N238", "0.2815", "3", "0.0", " "},
                                   {"C308", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"C308", "C136", "C293", "N287", "0.0515", "1", "0.0", " "},
                                   {"C308", "C136", "C293", "N287", "0.3265", "2", "180.0", " "},
                                   {"C308", "C136", "C293", "N287", "0.2815", "3", "0.0", " "},
                                   {"C308", "C307", "N303", "H304", "-0.0950", "1", "0.0", " "},
                                   {"C308", "C307", "N303", "H304", "-0.2085", "2", "180.0", " "},
                                   {"C308", "C307", "N303", "H304", "0.2090", "3", "0.0", " "},
                                   {"C500", "C136", "C224", "H140", "0.2310", "3", "0.0", " "},
                                   {"C500", "C136", "C224", "N238", "-0.2940", "1", "0.0", " "},
                                   {"C500", "C136", "C224", "N238", "0.5100", "2", "180.0", " "},
                                   {"C500", "C136", "C224", "N238", "0.3325", "3", "0.0", " "},
                                   {"C500", "C136", "C283", "H140", "0.2310", "3", "0.0", " "},
                                   {"C500", "C136", "C283", "N238", "-0.2940", "1", "0.0", " "},
                                   {"C500", "C136", "C283", "N238", "0.5100", "2", "180.0", " "},
                                   {"C500", "C136", "C283", "N238", "0.3325", "3", "0.0", " "},
                                   {"C500", "C136", "C293", "H140", "0.2310", "3", "0.0", " "},
                                   {"C500", "C136", "C293", "N287", "-0.2940", "1", "0.0", " "},
                                   {"C500", "C136", "C293", "N287", "0.5100", "2", "180.0", " "},
                                   {"C500", "C136", "C293", "N287", "0.3325", "3", "0.0", " "},
                                   {"C500", "C501", "C145", "H146", "3.5000", "2", "180.0", " "},
                                   {"C501", "C500", "C136", "H140", "0.0000", "1", "0.0", " "},
                                   {"C501", "C502", "C145", "H146", "3.6250", "2", "180.0", " "},
                                   {"C502", "C501", "C145", "H146", "3.5000", "2", "180.0", " "},
                                   {"C502", "C501", "C500", "C514", "1.6750", "2", "180.0", " "},
                                   {"C502", "N503", "C514", "H146", "1.5000", "2", "180.0", " "},
                                   {"C505", "C224", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C505", "C224", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C505", "C224", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C505", "C224", "C235", "N239", "0.8895", "1", "0.0", " "},
                                   {"C505", "C224", "C235", "N239", "0.2095", "2", "180.0", " "},
                                   {"C505", "C224", "C235", "N239", "-0.0550", "3", "0.0", " "},
                                   {"C505", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C505", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C505", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"C505", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"C505", "C293", "C235", "N238", "0.8895", "1", "0.0", " "},
                                   {"C505", "C293", "C235", "N238", "0.2095", "2", "180.0", " "},
                                   {"C505", "C293", "C235", "N238", "-0.0550", "3", "0.0", " "},
                                   {"C505", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"C505", "C293", "N287", "H290", "0.1735", "3", "0.0", " "},
                                   {"C505", "C508", "C507", "H146", "5.3750", "2", "180.0", " "},
                                   {"C505", "C508", "C507", "N511", "5.3750", "2", "180.0", " "},
                                   {"C505", "C508", "N503", "C506", "1.4000", "2", "180.0", " "},
                                   {"C505", "C508", "N503", "H504", "1.4000", "2", "180.0", " "},
                                   {"C505", "C510", "N512", "C509", "1.4000", "2", "180.0", " "},
                                   {"C505", "C510", "N512", "H513", "1.4000", "2", "180.0", " "},
                                   {"C506", "N503", "C508", "C507", "1.4000", "2", "180.0", " "},
                                   {"C506", "N503", "C508", "H146", "2.5000", "2", "180.0", " "},
                                   {"C506", "N511", "C507", "C508", "2.4000", "2", "180.0", " "},
                                   {"C506", "N511", "C507", "H146", "2.4000", "2", "180.0", " "},
                                   {"C507", "C505", "C224", "H140", "0.2310", "3", "0.0", " "},
                                   {"C507", "C505", "C224", "N238", "-0.2710", "1", "0.0", " "},
                                   {"C507", "C505", "C224", "N238", "0.2175", "2", "180.0", " "},
                                   {"C507", "C505", "C224", "N238", "0.0000", "3", "0.0", " "},
                                   {"C507", "C505", "C283", "H140", "0.2310", "3", "0.0", " "},
                                   {"C507", "C505", "C283", "N238", "-0.2710", "1", "0.0", " "},
                                   {"C507", "C505", "C283", "N238", "0.2175", "2", "180.0", " "},
                                   {"C507", "C505", "C283", "N238", "0.0000", "3", "0.0", " "},
                                   {"C507", "C505", "C293", "H140", "0.2310", "3", "0.0", " "},
                                   {"C507", "C505", "C293", "N287", "-0.2710", "1", "0.0", " "},
                                   {"C507", "C505", "C293", "N287", "0.2175", "2", "180.0", " "},
                                   {"C507", "C505", "C293", "N287", "0.0000", "3", "0.0", " "},
                                   {"C507", "C508", "C505", "H140", "0.0000", "1", "0.0", " "},
                                   {"C507", "C508", "N503", "H504", "1.4000", "2", "180.0", " "},
                                   {"C507", "N511", "C506", "H146", "5.0000", "2", "180.0", " "},
                                   {"C507", "N511", "C506", "N503", "5.0000", "2", "180.0", " "},
                                   {"C508", "C505", "C224", "H140", "0.2310", "3", "0.0", " "},
                                   {"C508", "C505", "C224", "N238", "-0.2710", "1", "0.0", " "},
                                   {"C508", "C505", "C224", "N238", "0.2175", "2", "180.0", " "},
                                   {"C508", "C505", "C224", "N238", "0.0000", "3", "0.0", " "},
                                   {"C508", "C505", "C283", "H140", "0.2310", "3", "0.0", " "},
                                   {"C508", "C505", "C283", "N238", "-0.2710", "1", "0.0", " "},
                                   {"C508", "C505", "C283", "N238", "0.2175", "2", "180.0", " "},
                                   {"C508", "C505", "C283", "N238", "0.0000", "3", "0.0", " "},
                                   {"C508", "C505", "C293", "H140", "0.2310", "3", "0.0", " "},
                                   {"C508", "C505", "C293", "N287", "-0.2710", "1", "0.0", " "},
                                   {"C508", "C505", "C293", "N287", "0.2175", "2", "180.0", " "},
                                   {"C508", "C505", "C293", "N287", "0.0000", "3", "0.0", " "},
                                   {"C508", "C507", "C505", "H140", "0.0000", "1", "0.0", " "},
                                   {"C508", "N503", "C506", "H146", "2.3250", "2", "180.0", " "},
                                   {"C508", "N503", "C506", "N511", "2.3250", "2", "180.0", " "},
                                   {"C509", "N512", "C510", "C510", "1.4000", "2", "180.0", " "},
                                   {"C509", "N512", "C510", "H146", "2.5000", "2", "180.0", " "},
                                   {"C510", "C505", "C224", "H140", "0.2310", "3", "0.0", " "},
                                   {"C510", "C505", "C224", "N238", "-1.5190", "1", "0.0", " "},
                                   {"C510", "C505", "C224", "N238", "0.2095", "2", "180.0", " "},
                                   {"C510", "C505", "C224", "N238", "0.0000", "3", "0.0", " "},
                                   {"C510", "C505", "C283", "H140", "0.2310", "3", "0.0", " "},
                                   {"C510", "C505", "C283", "N238", "-1.5190", "1", "0.0", " "},
                                   {"C510", "C505", "C283", "N238", "0.2095", "2", "180.0", " "},
                                   {"C510", "C505", "C283", "N238", "0.0000", "3", "0.0", " "},
                                   {"C510", "C505", "C293", "H140", "0.2310", "3", "0.0", " "},
                                   {"C510", "C505", "C293", "N287", "-1.5190", "1", "0.0", " "},
                                   {"C510", "C505", "C293", "N287", "0.2095", "2", "180.0", " "},
                                   {"C510", "C505", "C293", "N287", "0.0000", "3", "0.0", " "},
                                   {"C510", "C510", "C505", "H140", "0.0000", "1", "0.0", " "},
                                   {"C510", "C510", "N512", "H513", "1.4000", "2", "180.0", " "},
                                   {"C510", "N512", "C509", "H146", "2.3250", "2", "180.0", " "},
                                   {"C510", "N512", "C509", "N512", "2.3250", "2", "180.0", " "},
                                   {"C514", "C500", "C136", "H140", "-0.2400", "3", "0.0", " "},
                                   {"H140", "C135", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C158", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C158", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C135", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C135", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C135", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C135", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C135", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C135", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C135", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C136", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C137", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C210", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C210", "S202", "0.2260", "3", "0.0", " "},
                                   {"H140", "C136", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C235", "N237", "0.0000", "1", "0.0", " "},
                                   {"H140", "C136", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C136", "C245", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C245", "N239", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C246", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C246", "N239", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C267", "O268", "0.0000", "1", "0.0", " "},
                                   {"H140", "C136", "C267", "O269", "0.0000", "1", "0.0", " "},
                                   {"H140", "C136", "C274", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C285", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C285", "N239", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C292", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C292", "N287", "0.1920", "3", "0.0", " "},
                                   {"H140", "C136", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C136", "C295", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C295", "N309", "0.1920", "3", "0.0", " "},
                                   {"H140", "C136", "C296", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C136", "C296", "N309", "0.1920", "3", "0.0", " "},
                                   {"H140", "C136", "C308", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C137", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C137", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C137", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C137", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C137", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C137", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C149", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C149", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C149", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C149", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C149", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C149", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C157", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C157", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C157", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C157", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C157", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C157", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C157", "O154", "H155", "0.1762", "3", "0.0", " "},
                                   {"H140", "C158", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C158", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C158", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C158", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C158", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C158", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C158", "O154", "H155", "0.1762", "3", "0.0", " "},
                                   {"H140", "C206", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C206", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C206", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C206", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C206", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C206", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C206", "S200", "H204", "0.2400", "3", "0.0", " "},
                                   {"H140", "C214", "C224", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C214", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C214", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C214", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C214", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C214", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C214", "S203", "S203", "0.2790", "3", "0.0", " "},
                                   {"H140", "C223", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C223", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C223", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C223", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"H140", "C224", "C157", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C224", "C158", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C224", "C206", "S200", "0.2260", "3", "0.0", " "},
                                   {"H140", "C224", "C214", "S203", "0.2260", "3", "0.0", " "},
                                   {"H140", "C224", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C224", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C223", "C267", "O268", "0.0000", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"H140", "C223", "C267", "O269", "0.0000", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"H140", "C224", "C267", "O268", "0.0000", "1", "0.0", " "},
                                   {"H140", "C224", "C267", "O269", "0.0000", "1", "0.0", " "},
                                   {"H140", "C224", "C274", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C224", "C505", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C224", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"H140", "C242", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"H140", "C246", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C246", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C246", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C274", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C274", "C271", "O272", "0.0000", "1", "0.0", " "},
                                   {"H140", "C274", "C283", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C274", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C274", "C293", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C274", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C283", "C157", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C283", "C158", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C283", "C206", "S200", "0.2260", "3", "0.0", " "},
                                   {"H140", "C283", "C214", "S203", "0.2260", "3", "0.0", " "},
                                   {"H140", "C283", "C271", "O272", "0.0000", "1", "0.0", " "},
                                   {"H140", "C283", "C505", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C283", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"H140", "C284", "C271", "O272", "0.0000", "1", "0.0", " "},
                                   {"H140", "C284", "N238", "H241", "0.0000", "1", "0.0", " "},
                                   {"H140", "C285", "C271", "O272", "0.0000", "1", "0.0", " "},
                                   {"H140", "C292", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C292", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C292", "N287", "H290", "0.1305", "3", "0.0", " "},
                                   {"H140", "C293", "C157", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C293", "C158", "O154", "0.2340", "3", "0.0", " "},
                                   {"H140", "C293", "C206", "S200", "0.2260", "3", "0.0", " "},
                                   {"H140", "C293", "C214", "S203", "0.2260", "3", "0.0", " "},
                                   {"H140", "C293", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C293", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C293", "C505", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C293", "N287", "H290", "0.1305", "3", "0.0", " "},
                                   {"H140", "C295", "C235", "N238", "0.0000", "1", "0.0", " "},
                                   {"H140", "C295", "C235", "N239", "0.0000", "1", "0.0", " "},
                                   {"H140", "C295", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"H140", "C295", "N309", "H310", "0.1305", "3", "0.0", " "},
                                   {"H140", "C296", "N309", "H310", "0.1920", "3", "0.0", " "},
                                   {"H140", "C307", "C308", "H140", "0.1500", "3", "0.0", " "},
                                   {"H140", "C307", "N303", "H304", "0.0000", "1", "0.0", " "},
                                   {"H140", "C308", "C307", "N303", "-0.2910", "3", "0.0", " "},
                                   {"H140", "C505", "C224", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C505", "C283", "N238", "0.2320", "3", "0.0", " "},
                                   {"H140", "C505", "C293", "N287", "0.2320", "3", "0.0", " "},
                                   {"H140", "C505", "C507", "N511", "0.2095", "3", "0.0", " "},
                                   {"H140", "C505", "C508", "N503", "0.2095", "3", "0.0", " "},
                                   {"H140", "C505", "C510", "N512", "0.2095", "3", "0.0", " "},
                                   {"H146", "C508", "C507", "N511", "5.3750", "2", "180.0", " "},
                                   {"H146", "C508", "N503", "H504", "2.5000", "2", "180.0", " "},
                                   {"H146", "C510", "N512", "H513", "2.5000", "2", "180.0", " "},
                                   {"H240", "N237", "C235", "O236", "2.4500", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "O236", "2.4500", "2", "180.0", " "},
                                   {"H270", "O268", "C267", "O269", "2.7500", "2", "180.0", " "},
                                   {"H301", "N300", "C302", "N300", "1.9500", "2", "180.0", " "},
                                   {"H301", "N300", "C302", "N303", "1.9500", "2", "180.0", " "},
                                   {"H304", "N303", "C302", "N300", "1.9500", "2", "180.0", " "},
                                   {"H504", "N503", "C506", "N511", "2.3250", "2", "180.0", " "},
                                   {"H513", "N512", "C509", "N512", "2.3250", "2", "180.0", " "},
                                   {"N238", "C223", "C235", "N238", "0.9050", "1", "0.0", " "},
                                   {"N238", "C223", "C235", "N238", "1.0775", "2", "180.0", " "},
                                   {"N238", "C223", "C235", "N238", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C223", "C235", "N239", "0.9050", "1", "0.0", " "},
                                   {"N238", "C223", "C235", "N239", "1.0775", "2", "180.0", " "},
                                   {"N238", "C223", "C235", "N239", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C223", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N238", "C224", "C157", "O154", "3.1290", "1", "0.0", " "},
                                   {"N238", "C224", "C157", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N238", "C224", "C157", "O154", "0.6835", "3", "0.0", " "},
                                   {"N238", "C224", "C158", "O154", "3.1290", "1", "0.0", " "},
                                   {"N238", "C224", "C158", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N238", "C224", "C158", "O154", "0.6835", "3", "0.0", " "},
                                   {"N238", "C224", "C206", "S200", "1.0275", "1", "0.0", " "},
                                   {"N238", "C224", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"N238", "C224", "C206", "S200", "0.2720", "3", "0.0", " "},
                                   {"N238", "C224", "C214", "S203", "1.0275", "1", "0.0", " "},
                                   {"N238", "C224", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"N238", "C224", "C214", "S203", "0.2720", "3", "0.0", " "},
                                   {"N238", "C224", "C235", "N238", "0.9050", "1", "0.0", " "},
                                   {"N238", "C224", "C235", "N238", "1.0775", "2", "180.0", " "},
                                   {"N238", "C224", "C235", "N238", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C224", "C235", "N239", "0.9050", "1", "0.0", " "},
                                   {"N238", "C224", "C235", "N239", "1.0775", "2", "180.0", " "},
                                   {"N238", "C224", "C235", "N239", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C224", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N238", "C223", "C267", "O268", "2.6300", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"N238", "C223", "C267", "O268", "0.4100", "2", "180.0", "protonated C-terminal Gly, adm jr."},
                                   {"N238", "C223", "C267", "O268", "0.0000", "3", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"N238", "C224", "C267", "O268", "2.6300", "1", "0.0", " "},
                                   {"N238", "C224", "C267", "O268", "0.4100", "2", "180.0", " "},
                                   {"N238", "C224", "C267", "O268", "0.0000", "3", "0.0", " "},
                                   {"N238", "C223", "C267", "O269", "0.0000", "1", "0.0", "protonated C-terminal Gly, adm jr."},
                                   {"N238", "C224", "C267", "O269", "0.0000", "1", "0.0", " "},
                                   {"N238", "C235", "C246", "N239", "-0.4700", "1", "0.0", " "},
                                   {"N238", "C235", "C246", "N239", "1.3775", "2", "180.0", " "},
                                   {"N238", "C235", "C246", "N239", "-1.3350", "3", "0.0", " "},
                                   {"N238", "C235", "C292", "N287", "0.9050", "1", "0.0", " "},
                                   {"N238", "C235", "C292", "N287", "1.0775", "2", "180.0", " "},
                                   {"N238", "C235", "C292", "N287", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C235", "C293", "N287", "0.9050", "1", "0.0", " "},
                                   {"N238", "C235", "C293", "N287", "1.0775", "2", "180.0", " "},
                                   {"N238", "C235", "C293", "N287", "-0.2350", "3", "0.0", " "},
                                   {"N238", "C235", "C295", "N309", "-0.4700", "1", "0.0", " "},
                                   {"N238", "C235", "C295", "N309", "1.3775", "2", "180.0", " "},
                                   {"N238", "C235", "C295", "N309", "-1.3350", "3", "0.0", " "},
                                   {"N238", "C283", "C157", "O154", "3.1290", "1", "0.0", " "},
                                   {"N238", "C283", "C157", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N238", "C283", "C157", "O154", "0.6835", "3", "0.0", " "},
                                   {"N238", "C283", "C158", "O154", "3.1290", "1", "0.0", " "},
                                   {"N238", "C283", "C158", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N238", "C283", "C158", "O154", "0.6835", "3", "0.0", " "},
                                   {"N238", "C283", "C206", "S200", "1.0275", "1", "0.0", " "},
                                   {"N238", "C283", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"N238", "C283", "C206", "S200", "0.2720", "3", "0.0", " "},
                                   {"N238", "C283", "C214", "S203", "1.0275", "1", "0.0", " "},
                                   {"N238", "C283", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"N238", "C283", "C214", "S203", "0.2720", "3", "0.0", " "},
                                   {"N238", "C283", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"N238", "C284", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"N239", "C235", "C246", "N239", "-0.4700", "1", "0.0", " "},
                                   {"N239", "C235", "C246", "N239", "1.3775", "2", "180.0", " "},
                                   {"N239", "C235", "C246", "N239", "-1.3350", "3", "0.0", " "},
                                   {"N239", "C235", "C293", "N287", "0.9050", "1", "0.0", " "},
                                   {"N239", "C235", "C293", "N287", "1.0775", "2", "180.0", " "},
                                   {"N239", "C235", "C293", "N287", "-0.2350", "3", "0.0", " "},
                                   {"N239", "C235", "C295", "N309", "-0.4700", "1", "0.0", " "},
                                   {"N239", "C235", "C295", "N309", "1.3775", "2", "180.0", " "},
                                   {"N239", "C235", "C295", "N309", "-1.3350", "3", "0.0", " "},
                                   {"N239", "C246", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N239", "C285", "C271", "O272", "0.4100", "2", "180.0", " "},
                                   {"N287", "C292", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N287", "C293", "C157", "O154", "3.1290", "1", "0.0", " "},
                                   {"N287", "C293", "C157", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N287", "C293", "C157", "O154", "0.6835", "3", "0.0", " "},
                                   {"N287", "C293", "C158", "O154", "3.1290", "1", "0.0", " "},
                                   {"N287", "C293", "C158", "O154", "-0.5185", "2", "180.0", " "},
                                   {"N287", "C293", "C158", "O154", "0.6835", "3", "0.0", " "},
                                   {"N287", "C293", "C206", "S200", "1.0275", "1", "0.0", " "},
                                   {"N287", "C293", "C206", "S200", "0.2645", "2", "180.0", " "},
                                   {"N287", "C293", "C206", "S200", "0.2720", "3", "0.0", " "},
                                   {"N287", "C293", "C214", "S203", "1.0275", "1", "0.0", " "},
                                   {"N287", "C293", "C214", "S203", "0.2645", "2", "180.0", " "},
                                   {"N287", "C293", "C214", "S203", "0.2720", "3", "0.0", " "},
                                   {"N287", "C293", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N309", "C295", "C235", "O236", "0.0000", "1", "0.0", " "},
                                   {"N503", "C508", "C507", "N511", "5.3750", "2", "180.0", " "},
                                   {"C267", "C136", "C293", "N287", "-2.7505", "1", "0.0", " "},
                                   {"C267", "C136", "C293", "N287", "0.7635", "2", "180.0", " "},
                                   {"C267", "C136", "C293", "N287", "0.0000", "3", "0.0", " "},
                                   {"C235", "C293", "C136", "C267", "0.2990", "1", "0.0", " "},
                                   {"C235", "C293", "C136", "C267", "0.7790", "2", "180.0", " "},
                                   {"C235", "C293", "C136", "C267", "0.1275", "3", "0.0", " "},
                                   {"C267", "C136", "C283", "N238", "-2.7505", "1", "0.0", " "},
                                   {"C267", "C136", "C283", "N238", "0.7635", "2", "180.0", " "},
                                   {"C267", "C136", "C283", "N238", "0.0000", "3", "0.0", " "},
                                   {"C267", "C136", "C283", "C271", "0.2990", "1", "0.0", " "},
                                   {"C267", "C136", "C283", "C271", "0.7790", "2", "180.0", " "},
                                   {"C267", "C136", "C283", "C271", "0.1275", "3", "0.0", " "},
                                   {"O340", "C334", "N335", "C336", "0.0000", "1", "0.0", " "},
                                   {"O340", "C334", "N335", "C336", "3.6250", "2", "180.0", " "},
                                   {"O340", "C334", "N335", "C336", "0.0000", "3", "0.0", " "},
                                   {"O340", "C334", "N335", "C336", "0.0000", "4", "180.0", " "},
                                   {"C933", "C174", "C174", "O169", "-0.2180", "1", "0.0", " "},
                                   {"C933", "C174", "C174", "O169", "0.4500", "2", "180.0", " "},
                                   {"C933", "C174", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"C933", "C174", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"C933", "N938", "C324", "C323", "0.0000", "1", "0.0", " "},
                                   {"C933", "N938", "C324", "C323", "2.5000", "2", "180.0", " "},
                                   {"C933", "N938", "C324", "C323", "0.0000", "3", "0.0", " "},
                                   {"C933", "N938", "C324", "C323", "0.0000", "4", "180.0", " "},
                                   {"C933", "N938", "C320", "O326", "0.0000", "1", "0.0", " "},
                                   {"C933", "N938", "C320", "O326", "3.6250", "2", "180.0", " "},
                                   {"C933", "N938", "C320", "O326", "0.0000", "3", "0.0", " "},
                                   {"C933", "N938", "C320", "O326", "0.0000", "4", "180.0", " "},
                                   {"C933", "N938", "C324", "H330", "0.0000", "1", "0.0", " "},
                                   {"C933", "N938", "C324", "H330", "2.5000", "2", "180.0", " "},
                                   {"C933", "N938", "C324", "H330", "0.0000", "3", "0.0", " "},
                                   {"C933", "N938", "C324", "H330", "0.0000", "4", "180.0", " "},
                                   {"C933", "C174", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"C933", "C174", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"C933", "C174", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"C933", "C174", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"C933", "C174", "O169", "H170", "1.3370", "1", "0.0", " "},
                                   {"C933", "C174", "O169", "H170", "-1.4415", "2", "180.0", " "},
                                   {"C933", "C174", "O169", "H170", "0.5130", "3", "0.0", " "},
                                   {"C933", "C174", "O169", "H170", "0.0000", "4", "180.0", " "},
                                   {"C933", "N938", "C320", "N321", "0.0000", "1", "0.0", " "},
                                   {"C933", "N938", "C320", "N321", "3.6250", "2", "180.0", " "},
                                   {"C933", "N938", "C320", "N321", "0.0000", "3", "0.0", " "},
                                   {"C933", "N938", "C320", "N321", "0.0000", "4", "180.0", " "},
                                   {"C324", "N938", "C933", "O186", "0.2000", "1", "0.0", " "},
                                   {"C324", "N938", "C933", "O186", "-1.4000", "2", "180.0", " "},
                                   {"C324", "N938", "C933", "O186", "-0.3000", "3", "0.0", " "},
                                   {"C324", "N938", "C933", "O186", "0.0000", "4", "180.0", " "},
                                   {"O186", "C933", "C174", "C174", "-0.2180", "1", "0.0", " "},
                                   {"O186", "C933", "C174", "C174", "0.4500", "2", "180.0", " "},
                                   {"O186", "C933", "C174", "C174", "0.0000", "3", "0.0", " "},
                                   {"O186", "C933", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"O186", "C933", "C174", "O169", "2.1595", "1", "0.0", " "},
                                   {"O186", "C933", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"O186", "C933", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"O186", "C933", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"O186", "C933", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"O186", "C933", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"O186", "C933", "C174", "H176", "0.2340", "3", "0.0", " "},
                                   {"O186", "C933", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"C933", "C174", "C174", "C183", "0.6500", "1", "0.0", " "},
                                   {"C933", "C174", "C174", "C183", "-0.1000", "2", "180.0", " "},
                                   {"C933", "C174", "C174", "C183", "0.1000", "3", "0.0", " "},
                                   {"C933", "C174", "C174", "C183", "0.0000", "4", "180.0", " "},
                                   {"N938", "C933", "O186", "C183", "-0.2500", "1", "0.0", " "},
                                   {"N938", "C933", "O186", "C183", "-0.7500", "2", "180.0", " "},
                                   {"N938", "C933", "O186", "C183", "0.5000", "3", "0.0", " "},
                                   {"N938", "C933", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"C933", "O186", "C183", "H185", "0.0000", "1", "0.0", " "},
                                   {"C933", "O186", "C183", "H185", "0.0000", "2", "180.0", " "},
                                   {"C933", "O186", "C183", "H185", "0.3800", "3", "0.0", " "},
                                   {"C933", "O186", "C183", "H185", "0.0000", "4", "180.0", " "},
                                   {"C320", "N938", "C933", "O186", "-0.1000", "1", "0.0", " "},
                                   {"C320", "N938", "C933", "O186", "-1.2500", "2", "180.0", " "},
                                   {"C320", "N938", "C933", "O186", "0.3500", "3", "0.0", " "},
                                   {"C320", "N938", "C933", "O186", "0.0000", "4", "180.0", " "},
                                   {"C174", "C933", "O186", "C183", "0.3250", "1", "0.0", " "},
                                   {"C174", "C933", "O186", "C183", "-0.1250", "2", "180.0", " "},
                                   {"C174", "C933", "O186", "C183", "-0.2350", "3", "0.0", " "},
                                   {"C174", "C933", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"H196", "C933", "O186", "C183", "0.0000", "1", "0.0", " "},
                                   {"H196", "C933", "O186", "C183", "0.0000", "2", "180.0", " "},
                                   {"H196", "C933", "O186", "C183", "0.3800", "3", "0.0", " "},
                                   {"H196", "C933", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"N335", "C336", "N341", "H342", "0.0000", "1", "0.0", " "},
                                   {"N335", "C336", "N341", "H342", "1.9500", "2", "180.0", " "},
                                   {"N335", "C336", "N341", "H342", "0.0000", "3", "0.0", " "},
                                   {"N335", "C336", "N341", "H342", "0.0000", "4", "180.0", " "},
                                   {"N335", "C336", "N341", "H343", "0.0000", "1", "0.0", " "},
                                   {"N335", "C336", "N341", "H343", "1.9500", "2", "180.0", " "},
                                   {"N335", "C336", "N341", "H343", "0.0000", "3", "0.0", " "},
                                   {"N335", "C336", "N341", "H343", "0.0000", "4", "180.0", " "},
                                   {"N937", "C334", "N335", "C336", "0.0000", "1", "0.0", " "},
                                   {"N937", "C334", "N335", "C336", "3.6250", "2", "180.0", " "},
                                   {"N937", "C334", "N335", "C336", "0.0000", "3", "0.0", " "},
                                   {"N937", "C334", "N335", "C336", "0.0000", "4", "180.0", " "},
                                   {"C338", "C337", "C336", "N335", "0.0000", "1", "0.0", " "},
                                   {"C338", "C337", "C336", "N335", "3.5000", "2", "180.0", " "},
                                   {"C338", "C337", "C336", "N335", "0.0000", "3", "0.0", " "},
                                   {"C338", "C337", "C336", "N335", "0.0000", "4", "180.0", " "},
                                   {"C337", "C336", "N335", "C334", "0.0000", "1", "0.0", " "},
                                   {"C337", "C336", "N335", "C334", "3.6250", "2", "180.0", " "},
                                   {"C337", "C336", "N335", "C334", "0.0000", "3", "0.0", " "},
                                   {"C337", "C336", "N335", "C334", "0.0000", "4", "180.0", " "},
                                   {"H344", "C337", "C336", "N335", "0.0000", "1", "0.0", " "},
                                   {"H344", "C337", "C336", "N335", "3.5000", "2", "180.0", " "},
                                   {"H344", "C337", "C336", "N335", "0.0000", "3", "0.0", " "},
                                   {"H344", "C337", "C336", "N335", "0.0000", "4", "180.0", " "},
                                   {"N341", "C336", "N335", "C334", "0.0000", "1", "0.0", " "},
                                   {"N341", "C336", "N335", "C334", "3.6250", "2", "180.0", " "},
                                   {"N341", "C336", "N335", "C334", "0.0000", "3", "0.0", " "},
                                   {"N341", "C336", "N335", "C334", "0.0000", "4", "180.0", " "},
                                   {"C932", "O186", "C183", "C174", "0.3250", "1", "0.0", " "},
                                   {"C932", "O186", "C183", "C174", "-0.1250", "2", "180.0", " "},
                                   {"C932", "O186", "C183", "C174", "-0.2350", "3", "0.0", " "},
                                   {"C932", "O186", "C183", "C174", "0.0000", "4", "180.0", " "},
                                   {"H344", "C337", "C336", "N341", "0.0000", "1", "0.0", " "},
                                   {"H344", "C337", "C336", "N341", "3.5000", "2", "180.0", " "},
                                   {"H344", "C337", "C336", "N341", "0.0000", "3", "0.0", " "},
                                   {"H344", "C337", "C336", "N341", "0.0000", "4", "180.0", " "},
                                   {"C334", "N937", "C932", "C174", "-0.3500", "1", "0.0", " "},
                                   {"C334", "N937", "C932", "C174", "-0.2000", "2", "180.0", " "},
                                   {"C334", "N937", "C932", "C174", "0.1500", "3", "0.0", " "},
                                   {"C334", "N937", "C932", "C174", "0.0000", "4", "180.0", " "},
                                   {"C338", "N937", "C334", "O340", "0.0000", "1", "0.0", " "},
                                   {"C338", "N937", "C334", "O340", "3.6250", "2", "180.0", " "},
                                   {"C338", "N937", "C334", "O340", "0.0000", "3", "0.0", " "},
                                   {"C338", "N937", "C334", "O340", "0.0000", "4", "180.0", " "},
                                   {"C334", "N937", "C338", "C337", "0.0000", "1", "0.0", " "},
                                   {"C334", "N937", "C338", "C337", "3.6250", "2", "180.0", " "},
                                   {"C334", "N937", "C338", "C337", "0.0000", "3", "0.0", " "},
                                   {"C334", "N937", "C338", "C337", "0.0000", "4", "180.0", " "},
                                   {"C334", "N937", "C338", "H345", "0.0000", "1", "0.0", " "},
                                   {"C334", "N937", "C338", "H345", "3.6250", "2", "180.0", " "},
                                   {"C334", "N937", "C338", "H345", "0.0000", "3", "0.0", " "},
                                   {"C334", "N937", "C338", "H345", "0.0000", "4", "180.0", " "},
                                   {"H345", "C338", "C337", "C336", "0.0000", "1", "0.0", " "},
                                   {"H345", "C338", "C337", "C336", "7.0000", "2", "180.0", " "},
                                   {"H345", "C338", "C337", "C336", "0.0000", "3", "0.0", " "},
                                   {"H345", "C338", "C337", "C336", "0.0000", "4", "180.0", " "},
                                   {"H345", "C338", "C337", "H344", "0.0000", "1", "0.0", " "},
                                   {"H345", "C338", "C337", "H344", "7.0000", "2", "180.0", " "},
                                   {"H345", "C338", "C337", "H344", "0.0000", "3", "0.0", " "},
                                   {"H345", "C338", "C337", "H344", "0.0000", "4", "180.0", " "},
                                   {"C337", "C336", "N341", "H342", "0.0000", "1", "0.0", " "},
                                   {"C337", "C336", "N341", "H342", "1.9500", "2", "180.0", " "},
                                   {"C337", "C336", "N341", "H342", "0.0000", "3", "0.0", " "},
                                   {"C337", "C336", "N341", "H342", "0.0000", "4", "180.0", " "},
                                   {"C337", "C336", "N341", "H343", "0.0000", "1", "0.0", " "},
                                   {"C337", "C336", "N341", "H343", "1.9500", "2", "180.0", " "},
                                   {"C337", "C336", "N341", "H343", "0.0000", "3", "0.0", " "},
                                   {"C337", "C336", "N341", "H343", "0.0000", "4", "180.0", " "},
                                   {"N937", "C932", "C174", "C174", "1.1960", "1", "0.0", " "},
                                   {"N937", "C932", "C174", "C174", "-0.3370", "2", "180.0", " "},
                                   {"N937", "C932", "C174", "C174", "0.2750", "3", "0.0", " "},
                                   {"N937", "C932", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"N937", "C932", "C174", "O169", "4.0000", "1", "0.0", " "},
                                   {"N937", "C932", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"N937", "C932", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"N937", "C932", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"N937", "C932", "C174", "H176", "-0.5065", "1", "0.0", " "},
                                   {"N937", "C932", "C174", "H176", "-0.3545", "2", "180.0", " "},
                                   {"N937", "C932", "C174", "H176", "0.2365", "3", "0.0", " "},
                                   {"N937", "C932", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"C338", "C337", "C336", "N341", "0.0000", "1", "0.0", " "},
                                   {"C338", "C337", "C336", "N341", "3.5000", "2", "180.0", " "},
                                   {"C338", "C337", "C336", "N341", "0.0000", "3", "0.0", " "},
                                   {"C338", "C337", "C336", "N341", "0.0000", "4", "180.0", " "},
                                   {"C338", "N937", "C932", "C174", "0.2000", "1", "0.0", " "},
                                   {"C338", "N937", "C932", "C174", "-0.2500", "2", "180.0", " "},
                                   {"C338", "N937", "C932", "C174", "0.0000", "3", "0.0", " "},
                                   {"C338", "N937", "C932", "C174", "0.0000", "4", "180.0", " "},
                                   {"C324", "N938", "C933", "H196", "0.0000", "1", "0.0", " "},
                                   {"C324", "N938", "C933", "H196", "0.0000", "2", "180.0", " "},
                                   {"C324", "N938", "C933", "H196", "0.0000", "3", "0.0", " "},
                                   {"C324", "N938", "C933", "H196", "0.0000", "4", "180.0", " "},
                                   {"O326", "C320", "N321", "H327", "0.0000", "1", "0.0", " "},
                                   {"O326", "C320", "N321", "H327", "3.6250", "2", "180.0", " "},
                                   {"O326", "C320", "N321", "H327", "0.0000", "3", "0.0", " "},
                                   {"O326", "C320", "N321", "H327", "0.0000", "4", "180.0", " "},
                                   {"O328", "C322", "C323", "H329", "0.0000", "1", "0.0", " "},
                                   {"O328", "C322", "C323", "H329", "3.6250", "2", "180.0", " "},
                                   {"O328", "C322", "C323", "H329", "0.0000", "3", "0.0", " "},
                                   {"O328", "C322", "C323", "H329", "0.0000", "4", "180.0", " "},
                                   {"O326", "C320", "N321", "C322", "0.0000", "1", "0.0", " "},
                                   {"O326", "C320", "N321", "C322", "3.6250", "2", "180.0", " "},
                                   {"O326", "C320", "N321", "C322", "0.0000", "3", "0.0", " "},
                                   {"O326", "C320", "N321", "C322", "0.0000", "4", "180.0", " "},
                                   {"H327", "N321", "C322", "O328", "0.0000", "1", "0.0", " "},
                                   {"H327", "N321", "C322", "O328", "3.6250", "2", "180.0", " "},
                                   {"H327", "N321", "C322", "O328", "0.0000", "3", "0.0", " "},
                                   {"H327", "N321", "C322", "O328", "0.0000", "4", "180.0", " "},
                                   {"H327", "N321", "C322", "C323", "0.0000", "1", "0.0", " "},
                                   {"H327", "N321", "C322", "C323", "3.6250", "2", "180.0", " "},
                                   {"H327", "N321", "C322", "C323", "0.0000", "3", "0.0", " "},
                                   {"H327", "N321", "C322", "C323", "0.0000", "4", "180.0", " "},
                                   {"N321", "C322", "C323", "H329", "0.0000", "1", "0.0", " "},
                                   {"N321", "C322", "C323", "H329", "3.6250", "2", "180.0", " "},
                                   {"N321", "C322", "C323", "H329", "0.0000", "3", "0.0", " "},
                                   {"N321", "C322", "C323", "H329", "0.0000", "4", "180.0", " "},
                                   {"C320", "N938", "C324", "H330", "0.0000", "1", "0.0", " "},
                                   {"C320", "N938", "C324", "H330", "3.6250", "2", "180.0", " "},
                                   {"C320", "N938", "C324", "H330", "0.0000", "3", "0.0", " "},
                                   {"C320", "N938", "C324", "H330", "0.0000", "4", "180.0", " "},
                                   {"H330", "C324", "C323", "C322", "0.0000", "1", "0.0", " "},
                                   {"H330", "C324", "C323", "C322", "7.0000", "2", "180.0", " "},
                                   {"H330", "C324", "C323", "C322", "0.0000", "3", "0.0", " "},
                                   {"H330", "C324", "C323", "C322", "0.0000", "4", "180.0", " "},
                                   {"C320", "N321", "C322", "O328", "0.0000", "1", "0.0", " "},
                                   {"C320", "N321", "C322", "O328", "3.6250", "2", "180.0", " "},
                                   {"C320", "N321", "C322", "O328", "0.0000", "3", "0.0", " "},
                                   {"C320", "N321", "C322", "O328", "0.0000", "4", "180.0", " "},
                                   {"C320", "N938", "C933", "C174", "-0.3500", "1", "0.0", " "},
                                   {"C320", "N938", "C933", "C174", "-0.2000", "2", "180.0", " "},
                                   {"C320", "N938", "C933", "C174", "0.1500", "3", "0.0", " "},
                                   {"C320", "N938", "C933", "C174", "0.0000", "4", "180.0", " "},
                                   {"C320", "N938", "C324", "C323", "0.0000", "1", "0.0", " "},
                                   {"C320", "N938", "C324", "C323", "3.6250", "2", "180.0", " "},
                                   {"C320", "N938", "C324", "C323", "0.0000", "3", "0.0", " "},
                                   {"C320", "N938", "C324", "C323", "0.0000", "4", "180.0", " "},
                                   {"H330", "C324", "C323", "H329", "0.0000", "1", "0.0", " "},
                                   {"H330", "C324", "C323", "H329", "7.0000", "2", "180.0", " "},
                                   {"H330", "C324", "C323", "H329", "0.0000", "3", "0.0", " "},
                                   {"H330", "C324", "C323", "H329", "0.0000", "4", "180.0", " "},
                                   {"C320", "N321", "C322", "C323", "0.0000", "1", "0.0", " "},
                                   {"C320", "N321", "C322", "C323", "3.6250", "2", "180.0", " "},
                                   {"C320", "N321", "C322", "C323", "0.0000", "3", "0.0", " "},
                                   {"C320", "N321", "C322", "C323", "0.0000", "4", "180.0", " "},
                                   {"C324", "N938", "C320", "O326", "0.0000", "1", "0.0", " "},
                                   {"C324", "N938", "C320", "O326", "3.6250", "2", "180.0", " "},
                                   {"C324", "N938", "C320", "O326", "0.0000", "3", "0.0", " "},
                                   {"C324", "N938", "C320", "O326", "0.0000", "4", "180.0", " "},
                                   {"C324", "N938", "C320", "N321", "0.0000", "1", "0.0", " "},
                                   {"C324", "N938", "C320", "N321", "3.6250", "2", "180.0", " "},
                                   {"C324", "N938", "C320", "N321", "0.0000", "3", "0.0", " "},
                                   {"C324", "N938", "C320", "N321", "0.0000", "4", "180.0", " "},
                                   {"C324", "N938", "C933", "C174", "0.2000", "1", "0.0", " "},
                                   {"C324", "N938", "C933", "C174", "-0.2500", "2", "180.0", " "},
                                   {"C324", "N938", "C933", "C174", "0.0000", "3", "0.0", " "},
                                   {"C324", "N938", "C933", "C174", "0.0000", "4", "180.0", " "},
                                   {"O328", "C322", "C323", "C324", "0.0000", "1", "0.0", " "},
                                   {"O328", "C322", "C323", "C324", "3.5000", "2", "180.0", " "},
                                   {"O328", "C322", "C323", "C324", "0.0000", "3", "0.0", " "},
                                   {"O328", "C322", "C323", "C324", "0.0000", "4", "180.0", " "},
                                   {"N321", "C322", "C323", "C324", "0.0000", "1", "0.0", " "},
                                   {"N321", "C322", "C323", "C324", "3.5000", "2", "180.0", " "},
                                   {"N321", "C322", "C323", "C324", "0.0000", "3", "0.0", " "},
                                   {"N321", "C322", "C323", "C324", "0.0000", "4", "180.0", " "},
                                   {"N938", "C933", "C174", "H176", "-0.5065", "1", "0.0", " "},
                                   {"N938", "C933", "C174", "H176", "-0.3545", "2", "180.0", " "},
                                   {"N938", "C933", "C174", "H176", "0.2365", "3", "0.0", " "},
                                   {"N938", "C933", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"N938", "C933", "C174", "O169", "4.0000", "1", "0.0", " "},
                                   {"N938", "C933", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"N938", "C933", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"N938", "C933", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"N938", "C933", "C174", "C174", "1.1960", "1", "0.0", " "},
                                   {"N938", "C933", "C174", "C174", "-0.3370", "2", "180.0", " "},
                                   {"N938", "C933", "C174", "C174", "0.2750", "3", "0.0", " "},
                                   {"N938", "C933", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"N938", "C324", "C323", "C322", "0.0000", "1", "0.0", " "},
                                   {"N938", "C324", "C323", "C322", "7.0000", "2", "180.0", " "},
                                   {"N938", "C324", "C323", "C322", "0.0000", "3", "0.0", " "},
                                   {"N938", "C324", "C323", "C322", "0.0000", "4", "180.0", " "},
                                   {"N938", "C324", "C323", "H329", "0.0000", "1", "0.0", " "},
                                   {"N938", "C324", "C323", "H329", "7.0000", "2", "180.0", " "},
                                   {"N938", "C324", "C323", "H329", "0.0000", "3", "0.0", " "},
                                   {"N938", "C324", "C323", "H329", "0.0000", "4", "180.0", " "},
                                   {"H196", "C933", "C174", "O169", "0.0000", "1", "0.0", " "},
                                   {"H196", "C933", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"H196", "C933", "C174", "O169", "0.2340", "3", "0.0", " "},
                                   {"H196", "C933", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"H196", "C933", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"H196", "C933", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"H196", "C933", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"H196", "C933", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"N938", "C320", "N321", "H327", "0.0000", "1", "0.0", " "},
                                   {"N938", "C320", "N321", "H327", "3.6250", "2", "180.0", " "},
                                   {"N938", "C320", "N321", "H327", "0.0000", "3", "0.0", " "},
                                   {"N938", "C320", "N321", "H327", "0.0000", "4", "180.0", " "},
                                   {"N938", "C320", "N321", "C322", "0.0000", "1", "0.0", " "},
                                   {"N938", "C320", "N321", "C322", "3.6250", "2", "180.0", " "},
                                   {"N938", "C320", "N321", "C322", "0.0000", "3", "0.0", " "},
                                   {"N938", "C320", "N321", "C322", "0.0000", "4", "180.0", " "},
                                   {"H196", "C933", "C174", "C174", "0.0000", "1", "0.0", " "},
                                   {"H196", "C933", "C174", "C174", "0.0000", "2", "180.0", " "},
                                   {"H196", "C933", "C174", "C174", "0.1500", "3", "0.0", " "},
                                   {"H196", "C933", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"C338", "N937", "C334", "N335", "0.0000", "1", "0.0", " "},
                                   {"C338", "N937", "C334", "N335", "3.6250", "2", "180.0", " "},
                                   {"C338", "N937", "C334", "N335", "0.0000", "3", "0.0", " "},
                                   {"C338", "N937", "C334", "N335", "0.0000", "4", "180.0", " "},
                                   {"C334", "N937", "C932", "H196", "0.0000", "1", "0.0", " "},
                                   {"C334", "N937", "C932", "H196", "0.0000", "2", "180.0", " "},
                                   {"C334", "N937", "C932", "H196", "0.0000", "3", "0.0", " "},
                                   {"C334", "N937", "C932", "H196", "0.0000", "4", "180.0", " "},
                                   {"C338", "N937", "C932", "H196", "0.0000", "1", "0.0", " "},
                                   {"C338", "N937", "C932", "H196", "0.0000", "2", "180.0", " "},
                                   {"C338", "N937", "C932", "H196", "0.0000", "3", "0.0", " "},
                                   {"C338", "N937", "C932", "H196", "0.0000", "4", "180.0", " "},
                                   {"H196", "C932", "C174", "C174", "0.0000", "1", "0.0", " "},
                                   {"H196", "C932", "C174", "C174", "0.0000", "2", "180.0", " "},
                                   {"H196", "C932", "C174", "C174", "0.1500", "3", "0.0", " "},
                                   {"H196", "C932", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"H196", "C932", "C174", "O169", "0.0000", "1", "0.0", " "},
                                   {"H196", "C932", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"H196", "C932", "C174", "O169", "0.2340", "3", "0.0", " "},
                                   {"H196", "C932", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"H196", "C932", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"H196", "C932", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"H196", "C932", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"H196", "C932", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"N937", "C338", "C337", "C336", "0.0000", "1", "0.0", " "},
                                   {"N937", "C338", "C337", "C336", "7.0000", "2", "180.0", " "},
                                   {"N937", "C338", "C337", "C336", "0.0000", "3", "0.0", " "},
                                   {"N937", "C338", "C337", "C336", "0.0000", "4", "180.0", " "},
                                   {"N937", "C338", "C337", "H344", "0.0000", "1", "0.0", " "},
                                   {"N937", "C338", "C337", "H344", "7.0000", "2", "180.0", " "},
                                   {"N937", "C338", "C337", "H344", "0.0000", "3", "0.0", " "},
                                   {"N937", "C338", "C337", "H344", "0.0000", "4", "180.0", " "},
                                   {"C338", "N937", "C932", "O186", "0.2000", "1", "0.0", " "},
                                   {"C338", "N937", "C932", "O186", "-1.4000", "2", "180.0", " "},
                                   {"C338", "N937", "C932", "O186", "-0.3000", "3", "0.0", " "},
                                   {"C338", "N937", "C932", "O186", "0.0000", "4", "180.0", " "},
                                   {"C932", "N937", "C334", "N335", "0.0000", "1", "0.0", " "},
                                   {"C932", "N937", "C334", "N335", "3.6250", "2", "180.0", " "},
                                   {"C932", "N937", "C334", "N335", "0.0000", "3", "0.0", " "},
                                   {"C932", "N937", "C334", "N335", "0.0000", "4", "180.0", " "},
                                   {"C932", "N937", "C334", "O340", "0.0000", "1", "0.0", " "},
                                   {"C932", "N937", "C334", "O340", "3.6250", "2", "180.0", " "},
                                   {"C932", "N937", "C334", "O340", "0.0000", "3", "0.0", " "},
                                   {"C932", "N937", "C334", "O340", "0.0000", "4", "180.0", " "},
                                   {"C932", "N937", "C338", "H345", "0.0000", "1", "0.0", " "},
                                   {"C932", "N937", "C338", "H345", "2.5000", "2", "180.0", " "},
                                   {"C932", "N937", "C338", "H345", "0.0000", "3", "0.0", " "},
                                   {"C932", "N937", "C338", "H345", "0.0000", "4", "180.0", " "},
                                   {"C932", "N937", "C338", "C337", "0.0000", "1", "0.0", " "},
                                   {"C932", "N937", "C338", "C337", "2.5000", "2", "180.0", " "},
                                   {"C932", "N937", "C338", "C337", "0.0000", "3", "0.0", " "},
                                   {"C932", "N937", "C338", "C337", "0.0000", "4", "180.0", " "},
                                   {"C932", "C174", "O169", "H170", "1.3370", "1", "0.0", " "},
                                   {"C932", "C174", "O169", "H170", "-1.4415", "2", "180.0", " "},
                                   {"C932", "C174", "O169", "H170", "0.5130", "3", "0.0", " "},
                                   {"C932", "C174", "O169", "H170", "0.0000", "4", "180.0", " "},
                                   {"C932", "C174", "C174", "O169", "-0.2180", "1", "0.0", " "},
                                   {"C932", "C174", "C174", "O169", "0.4500", "2", "180.0", " "},
                                   {"C932", "C174", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"C932", "C174", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"C932", "C174", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"C932", "C174", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"C932", "C174", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"C932", "C174", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"O186", "C932", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"O186", "C932", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"O186", "C932", "C174", "H176", "0.2340", "3", "0.0", " "},
                                   {"O186", "C932", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"O186", "C932", "C174", "O169", "2.1595", "1", "0.0", " "},
                                   {"O186", "C932", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"O186", "C932", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"O186", "C932", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"O186", "C932", "C174", "C174", "-0.2180", "1", "0.0", " "},
                                   {"O186", "C932", "C174", "C174", "0.4500", "2", "180.0", " "},
                                   {"O186", "C932", "C174", "C174", "0.0000", "3", "0.0", " "},
                                   {"O186", "C932", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"N937", "C932", "O186", "C183", "-0.2500", "1", "0.0", " "},
                                   {"N937", "C932", "O186", "C183", "-0.7500", "2", "180.0", " "},
                                   {"N937", "C932", "O186", "C183", "0.5000", "3", "0.0", " "},
                                   {"N937", "C932", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"C932", "O186", "C183", "H185", "0.0000", "1", "0.0", " "},
                                   {"C932", "O186", "C183", "H185", "0.0000", "2", "180.0", " "},
                                   {"C932", "O186", "C183", "H185", "0.3800", "3", "0.0", " "},
                                   {"C932", "O186", "C183", "H185", "0.0000", "4", "180.0", " "},
                                   {"C334", "N937", "C932", "O186", "-0.1000", "1", "0.0", " "},
                                   {"C334", "N937", "C932", "O186", "-1.2580", "2", "180.0", " "},
                                   {"C334", "N937", "C932", "O186", "0.3500", "3", "0.0", " "},
                                   {"C334", "N937", "C932", "O186", "0.0000", "4", "180.0", " "},
                                   {"C174", "C932", "O186", "C183", "0.3250", "1", "0.0", " "},
                                   {"C174", "C932", "O186", "C183", "-0.1250", "2", "180.0", " "},
                                   {"C174", "C932", "O186", "C183", "-0.2350", "3", "0.0", " "},
                                   {"C174", "C932", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"H196", "C932", "O186", "C183", "0.0000", "1", "0.0", " "},
                                   {"H196", "C932", "O186", "C183", "0.0000", "2", "180.0", " "},
                                   {"H196", "C932", "O186", "C183", "0.3800", "3", "0.0", " "},
                                   {"H196", "C932", "O186", "C183", "0.0000", "4", "180.0", " "},
                                   {"C932", "C174", "C174", "C183", "0.6500", "1", "0.0", " "},
                                   {"C932", "C174", "C174", "C183", "-0.1000", "2", "180.0", " "},
                                   {"C932", "C174", "C174", "C183", "0.1000", "3", "0.0", " "},
                                   {"C932", "C174", "C174", "C183", "0.0000", "4", "180.0", " "},
                                   {"C931", "N936", "C364", "C365", "0.0000", "1", "0.0", " "},
                                   {"C931", "N936", "C364", "C365", "2.5000", "2", "180.0", " "},
                                   {"C931", "N936", "C364", "C365", "0.0000", "3", "0.0", " "},
                                   {"C931", "N936", "C364", "C365", "0.0000", "4", "180.0", " "},
                                   {"N936", "C353", "N352", "C365", "0.0000", "1", "0.0", " "},
                                   {"N936", "C353", "N352", "C365", "5.0000", "2", "180.0", " "},
                                   {"N936", "C353", "N352", "C365", "0.0000", "3", "0.0", " "},
                                   {"N936", "C353", "N352", "C365", "0.0000", "4", "180.0", " "},
                                   {"N936", "C364", "N363", "C362", "0.0000", "1", "0.0", " "},
                                   {"N936", "C364", "N363", "C362", "3.6250", "2", "180.0", " "},
                                   {"N936", "C364", "N363", "C362", "0.0000", "3", "0.0", " "},
                                   {"N936", "C364", "N363", "C362", "0.0000", "4", "180.0", " "},
                                   {"N936", "C364", "C365", "C366", "0.0000", "1", "0.0", " "},
                                   {"N936", "C364", "C365", "C366", "3.6250", "2", "180.0", " "},
                                   {"N936", "C364", "C365", "C366", "0.0000", "3", "0.0", " "},
                                   {"N936", "C364", "C365", "C366", "0.0000", "4", "180.0", " "},
                                   {"N936", "C364", "C365", "N352", "0.0000", "1", "0.0", " "},
                                   {"N936", "C364", "C365", "N352", "3.6250", "2", "180.0", " "},
                                   {"N936", "C364", "C365", "N352", "0.0000", "3", "0.0", " "},
                                   {"N936", "C364", "C365", "N352", "0.0000", "4", "180.0", " "},
                                   {"C364", "C365", "C366", "N361", "0.0000", "1", "0.0", " "},
                                   {"C364", "C365", "C366", "N361", "3.5000", "2", "180.0", " "},
                                   {"C364", "C365", "C366", "N361", "0.0000", "3", "0.0", " "},
                                   {"C364", "C365", "C366", "N361", "0.0000", "4", "180.0", " "},
                                   {"C364", "C365", "C366", "O370", "0.0000", "1", "0.0", " "},
                                   {"C364", "C365", "C366", "O370", "3.5000", "2", "180.0", " "},
                                   {"C364", "C365", "C366", "O370", "0.0000", "3", "0.0", " "},
                                   {"C364", "C365", "C366", "O370", "0.0000", "4", "180.0", " "},
                                   {"C364", "C365", "N352", "C353", "0.0000", "1", "0.0", " "},
                                   {"C364", "C365", "N352", "C353", "3.6250", "2", "180.0", " "},
                                   {"C364", "C365", "N352", "C353", "0.0000", "3", "0.0", " "},
                                   {"C364", "C365", "N352", "C353", "0.0000", "4", "180.0", " "},
                                   {"C364", "N363", "C362", "N368", "0.0000", "1", "0.0", " "},
                                   {"C364", "N363", "C362", "N368", "3.6250", "2", "180.0", " "},
                                   {"C364", "N363", "C362", "N368", "0.0000", "3", "0.0", " "},
                                   {"C364", "N363", "C362", "N368", "0.0000", "4", "180.0", " "},
                                   {"C364", "N363", "C362", "N361", "0.0000", "1", "0.0", " "},
                                   {"C364", "N363", "C362", "N361", "3.6250", "2", "180.0", " "},
                                   {"C364", "N363", "C362", "N361", "0.0000", "3", "0.0", " "},
                                   {"C364", "N363", "C362", "N361", "0.0000", "4", "180.0", " "},
                                   {"C364", "N936", "C353", "N352", "0.0000", "1", "0.0", " "},
                                   {"C364", "N936", "C353", "N352", "3.6250", "2", "180.0", " "},
                                   {"C364", "N936", "C353", "N352", "0.0000", "3", "0.0", " "},
                                   {"C364", "N936", "C353", "N352", "0.0000", "4", "180.0", " "},
                                   {"N363", "C362", "N368", "H369", "0.0000", "1", "0.0", " "},
                                   {"N363", "C362", "N368", "H369", "1.9500", "2", "180.0", " "},
                                   {"N363", "C362", "N368", "H369", "0.0000", "3", "0.0", " "},
                                   {"N363", "C362", "N368", "H369", "0.0000", "4", "180.0", " "},
                                   {"H367", "N361", "C362", "N363", "0.0000", "1", "0.0", " "},
                                   {"H367", "N361", "C362", "N363", "3.6250", "2", "180.0", " "},
                                   {"H367", "N361", "C362", "N363", "0.0000", "3", "0.0", " "},
                                   {"H367", "N361", "C362", "N363", "0.0000", "4", "180.0", " "},
                                   {"C366", "N361", "C362", "N363", "0.0000", "1", "0.0", " "},
                                   {"C366", "N361", "C362", "N363", "3.6250", "2", "180.0", " "},
                                   {"C366", "N361", "C362", "N363", "0.0000", "3", "0.0", " "},
                                   {"C366", "N361", "C362", "N363", "0.0000", "4", "180.0", " "},
                                   {"N363", "C364", "C365", "C366", "0.0000", "1", "0.0", " "},
                                   {"N363", "C364", "C365", "C366", "3.6250", "2", "180.0", " "},
                                   {"N363", "C364", "C365", "C366", "0.0000", "3", "0.0", " "},
                                   {"N363", "C364", "C365", "C366", "0.0000", "4", "180.0", " "},
                                   {"N363", "C364", "C365", "N352", "0.0000", "1", "0.0", " "},
                                   {"N363", "C364", "C365", "N352", "3.6250", "2", "180.0", " "},
                                   {"N363", "C364", "C365", "N352", "0.0000", "3", "0.0", " "},
                                   {"N363", "C364", "C365", "N352", "0.0000", "4", "180.0", " "},
                                   {"O370", "C366", "N361", "C362", "0.0000", "1", "0.0", " "},
                                   {"O370", "C366", "N361", "C362", "3.0445", "2", "180.0", " "},
                                   {"O370", "C366", "N361", "C362", "0.0000", "3", "0.0", " "},
                                   {"O370", "C366", "N361", "C362", "0.0000", "4", "180.0", " "},
                                   {"C365", "C364", "N363", "C362", "0.0000", "1", "0.0", " "},
                                   {"C365", "C364", "N363", "C362", "3.6250", "2", "180.0", " "},
                                   {"C365", "C364", "N363", "C362", "0.0000", "3", "0.0", " "},
                                   {"C365", "C364", "N363", "C362", "0.0000", "4", "180.0", " "},
                                   {"O370", "C366", "N361", "H367", "0.0000", "1", "0.0", " "},
                                   {"O370", "C366", "N361", "H367", "2.4500", "2", "180.0", " "},
                                   {"O370", "C366", "N361", "H367", "0.0000", "3", "0.0", " "},
                                   {"O370", "C366", "N361", "H367", "0.0000", "4", "180.0", " "},
                                   {"C366", "C365", "N352", "C353", "0.0000", "1", "0.0", " "},
                                   {"C366", "C365", "N352", "C353", "3.6250", "2", "180.0", " "},
                                   {"C366", "C365", "N352", "C353", "0.0000", "3", "0.0", " "},
                                   {"C366", "C365", "N352", "C353", "0.0000", "4", "180.0", " "},
                                   {"N352", "C365", "C366", "O370", "0.0000", "1", "0.0", " "},
                                   {"N352", "C365", "C366", "O370", "3.5000", "2", "180.0", " "},
                                   {"N352", "C365", "C366", "O370", "0.0000", "3", "0.0", " "},
                                   {"N352", "C365", "C366", "O370", "0.0000", "4", "180.0", " "},
                                   {"H359", "C353", "N352", "C365", "0.0000", "1", "0.0", " "},
                                   {"H359", "C353", "N352", "C365", "5.0000", "2", "180.0", " "},
                                   {"H359", "C353", "N352", "C365", "0.0000", "3", "0.0", " "},
                                   {"H359", "C353", "N352", "C365", "0.0000", "4", "180.0", " "},
                                   {"C353", "N936", "C364", "C365", "0.0000", "1", "0.0", " "},
                                   {"C353", "N936", "C364", "C365", "3.6250", "2", "180.0", " "},
                                   {"C353", "N936", "C364", "C365", "0.0000", "3", "0.0", " "},
                                   {"C353", "N936", "C364", "C365", "0.0000", "4", "180.0", " "},
                                   {"C364", "N936", "C931", "O186", "0.2000", "1", "0.0", " "},
                                   {"C364", "N936", "C931", "O186", "-0.6000", "2", "180.0", " "},
                                   {"C364", "N936", "C931", "O186", "0.6000", "3", "0.0", " "},
                                   {"C364", "N936", "C931", "O186", "0.0000", "4", "180.0", " "},
                                   {"C364", "N936", "C931", "C174", "-0.3500", "1", "0.0", " "},
                                   {"C364", "N936", "C931", "C174", "-0.0500", "2", "180.0", " "},
                                   {"C364", "N936", "C931", "C174", "0.3000", "3", "0.0", " "},
                                   {"C364", "N936", "C931", "C174", "0.0000", "4", "180.0", " "},
                                   {"C364", "N936", "C353", "H359", "0.0000", "1", "0.0", " "},
                                   {"C364", "N936", "C353", "H359", "3.6250", "2", "180.0", " "},
                                   {"C364", "N936", "C353", "H359", "0.0000", "3", "0.0", " "},
                                   {"C364", "N936", "C353", "H359", "0.0000", "4", "180.0", " "},
                                   {"H367", "N361", "C362", "N368", "0.0000", "1", "0.0", " "},
                                   {"H367", "N361", "C362", "N368", "3.6250", "2", "180.0", " "},
                                   {"H367", "N361", "C362", "N368", "0.0000", "3", "0.0", " "},
                                   {"H367", "N361", "C362", "N368", "0.0000", "4", "180.0", " "},
                                   {"C366", "N361", "C362", "N368", "0.0000", "1", "0.0", " "},
                                   {"C366", "N361", "C362", "N368", "3.6250", "2", "180.0", " "},
                                   {"C366", "N361", "C362", "N368", "0.0000", "3", "0.0", " "},
                                   {"C366", "N361", "C362", "N368", "0.0000", "4", "180.0", " "},
                                   {"N361", "C362", "N368", "H369", "0.0000", "1", "0.0", " "},
                                   {"N361", "C362", "N368", "H369", "1.9500", "2", "180.0", " "},
                                   {"N361", "C362", "N368", "H369", "0.0000", "3", "0.0", " "},
                                   {"N361", "C362", "N368", "H369", "0.0000", "4", "180.0", " "},
                                   {"C353", "N936", "C364", "N363", "0.0000", "1", "0.0", " "},
                                   {"C353", "N936", "C364", "N363", "3.6250", "2", "180.0", " "},
                                   {"C353", "N936", "C364", "N363", "0.0000", "3", "0.0", " "},
                                   {"C353", "N936", "C364", "N363", "0.0000", "4", "180.0", " "},
                                   {"C365", "C366", "N361", "C362", "1.1500", "1", "0.0", " "},
                                   {"C365", "C366", "N361", "C362", "3.0445", "2", "180.0", " "},
                                   {"C365", "C366", "N361", "C362", "0.0000", "3", "0.0", " "},
                                   {"C365", "C366", "N361", "C362", "0.0000", "4", "180.0", " "},
                                   {"N352", "C365", "C366", "N361", "0.0000", "1", "0.0", " "},
                                   {"N352", "C365", "C366", "N361", "3.5000", "2", "180.0", " "},
                                   {"N352", "C365", "C366", "N361", "0.0000", "3", "0.0", " "},
                                   {"N352", "C365", "C366", "N361", "0.0000", "4", "180.0", " "},
                                   {"C365", "C366", "N361", "H367", "0.0000", "1", "0.0", " "},
                                   {"C365", "C366", "N361", "H367", "2.4500", "2", "180.0", " "},
                                   {"C365", "C366", "N361", "H367", "0.0000", "3", "0.0", " "},
                                   {"C365", "C366", "N361", "H367", "0.0000", "4", "180.0", " "},
                                   {"C364", "N936", "C931", "H196", "0.0000", "1", "0.0", " "},
                                   {"C364", "N936", "C931", "H196", "0.0000", "2", "180.0", " "},
                                   {"C364", "N936", "C931", "H196", "0.0000", "3", "0.0", " "},
                                   {"C364", "N936", "C931", "H196", "0.0000", "4", "180.0", " "},
                                   {"C931", "N936", "C364", "N363", "0.0000", "1", "0.0", " "},
                                   {"C931", "N936", "C364", "N363", "2.5000", "2", "180.0", " "},
                                   {"C931", "N936", "C364", "N363", "0.0000", "3", "0.0", " "},
                                   {"C931", "N936", "C364", "N363", "0.0000", "4", "180.0", " "},
                                   {"C183", "C6448", "O6934", "P440", "-0.7100", "1", "0.0", " "},
                                   {"C183", "C6448", "O6934", "P440", "-0.3100", "2", "180.0", " "},
                                   {"C183", "C6448", "O6934", "P440", "0.0500", "3", "0.0", " "},
                                   {"C183", "C6448", "O6934", "P440", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C6448", "O6934", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "C6448", "O6934", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C6448", "O6934", "0.2340", "3", "0.0", " "},
                                   {"H185", "C183", "C6448", "O6934", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C6448", "H140", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "C6448", "H140", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C6448", "H140", "0.1500", "3", "0.0", " "},
                                   {"H185", "C183", "C6448", "H140", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C6448", "O6934", "3.7595", "1", "0.0", " "},
                                   {"O186", "C183", "C6448", "O6934", "-0.6000", "2", "180.0", " "},
                                   {"O186", "C183", "C6448", "O6934", "-0.0500", "3", "0.0", " "},
                                   {"O186", "C183", "C6448", "O6934", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C6448", "H140", "0.0000", "1", "0.0", " "},
                                   {"O186", "C183", "C6448", "H140", "0.0000", "2", "180.0", " "},
                                   {"O186", "C183", "C6448", "H140", "0.2340", "3", "0.0", " "},
                                   {"O186", "C183", "C6448", "H140", "0.0000", "4", "180.0", " "},
                                   {"C933", "O186", "C183", "C174", "0.3250", "1", "0.0", " "},
                                   {"C933", "O186", "C183", "C174", "-0.1250", "2", "180.0", " "},
                                   {"C933", "O186", "C183", "C174", "-0.2350", "3", "0.0", " "},
                                   {"C933", "O186", "C183", "C174", "0.0000", "4", "180.0", " "},
                                   {"C320", "N938", "C933", "H196", "0.0000", "1", "0.0", " "},
                                   {"C320", "N938", "C933", "H196", "0.0000", "2", "180.0", " "},
                                   {"C320", "N938", "C933", "H196", "0.0000", "3", "0.0", " "},
                                   {"C320", "N938", "C933", "H196", "0.0000", "4", "180.0", " "},
                                   {"C933", "O186", "C183", "C6448", "0.3250", "1", "0.0", " "},
                                   {"C933", "O186", "C183", "C6448", "-0.1250", "2", "180.0", " "},
                                   {"C933", "O186", "C183", "C6448", "-0.2650", "3", "0.0", " "},
                                   {"C933", "O186", "C183", "C6448", "0.0000", "4", "180.0", " "},
                                   {"C931", "O186", "C183", "C6448", "0.3250", "1", "0.0", " "},
                                   {"C931", "O186", "C183", "C6448", "-0.1250", "2", "180.0", " "},
                                   {"C931", "O186", "C183", "C6448", "-0.2650", "3", "0.0", " "},
                                   {"C931", "O186", "C183", "C6448", "0.0000", "4", "180.0", " "},
                                   {"C932", "O186", "C183", "C6448", "0.3250", "1", "0.0", " "},
                                   {"C932", "O186", "C183", "C6448", "-0.1250", "2", "180.0", " "},
                                   {"C932", "O186", "C183", "C6448", "-0.2650", "3", "0.0", " "},
                                   {"C932", "O186", "C183", "C6448", "0.0000", "4", "180.0", " "},
                                   {"C6448", "C183", "C174", "C174", "0.6500", "1", "0.0", " "},
                                   {"C6448", "C183", "C174", "C174", "-0.1000", "2", "180.0", " "},
                                   {"C6448", "C183", "C174", "C174", "0.1000", "3", "0.0", " "},
                                   {"C6448", "C183", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"C174", "C183", "C6448", "O6934", "0.7000", "1", "0.0", " "},
                                   {"C174", "C183", "C6448", "O6934", "0.2500", "2", "180.0", " "},
                                   {"C174", "C183", "C6448", "O6934", "1.0500", "3", "0.0", " "},
                                   {"C174", "C183", "C6448", "O6934", "0.0000", "4", "180.0", " "},
                                   {"C174", "C183", "C6448", "H140", "0.0000", "1", "0.0", " "},
                                   {"C174", "C183", "C6448", "H140", "0.0000", "2", "180.0", " "},
                                   {"C174", "C183", "C6448", "H140", "0.1500", "3", "0.0", " "},
                                   {"C174", "C183", "C6448", "H140", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C183", "C6448", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C183", "C6448", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C183", "C6448", "0.1500", "3", "0.0", " "},
                                   {"H176", "C174", "C183", "C6448", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C183", "C6448", "-0.2180", "1", "0.0", " "},
                                   {"O169", "C174", "C183", "C6448", "0.4500", "2", "180.0", " "},
                                   {"O169", "C174", "C183", "C6448", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C183", "C6448", "0.0000", "4", "180.0", " "},
                                   {"C6448", "O6934", "P440", "O441", "0.4000", "1", "0.0", " "},
                                   {"C6448", "O6934", "P440", "O441", "0.1500", "2", "180.0", " "},
                                   {"C6448", "O6934", "P440", "O441", "0.0500", "3", "0.0", " "},
                                   {"C6448", "O6934", "P440", "O441", "0.0000", "4", "180.0", " "},
                                   {"C6448", "O6934", "P440", "O6452", "-0.4500", "1", "0.0", " "},
                                   {"C6448", "O6934", "P440", "O6452", "-0.2500", "2", "180.0", " "},
                                   {"C6448", "O6934", "P440", "O6452", "0.1000", "3", "0.0", " "},
                                   {"C6448", "O6934", "P440", "O6452", "0.0000", "4", "180.0", " "},
                                   {"H140", "C6448", "O6934", "P440", "0.0000", "1", "0.0", " "},
                                   {"H140", "C6448", "O6934", "P440", "0.0000", "2", "180.0", " "},
                                   {"H140", "C6448", "O6934", "P440", "0.1500", "3", "0.0", " "},
                                   {"H140", "C6448", "O6934", "P440", "0.0000", "4", "180.0", " "},
                                   {"O6934", "P440", "O6452", "P6450", "-0.0500", "1", "0.0", " "},
                                   {"O6934", "P440", "O6452", "P6450", "-0.2000", "2", "180.0", " "},
                                   {"O6934", "P440", "O6452", "P6450", "0.0500", "3", "0.0", " "},
                                   {"O6934", "P440", "O6452", "P6450", "0.0000", "4", "180.0", " "},
                                   {"O6934", "P440", "O6452", "P440", "-0.0500", "1", "0.0", " "},
                                   {"O6934", "P440", "O6452", "P440", "-0.2000", "2", "180.0", " "},
                                   {"O6934", "P440", "O6452", "P440", "0.0500", "3", "0.0", " "},
                                   {"O6934", "P440", "O6452", "P440", "0.0000", "4", "180.0", " "},
                                   {"P440", "O6452", "P6450", "O441", "0.1500", "1", "0.0", " "},
                                   {"P440", "O6452", "P6450", "O441", "0.1500", "2", "180.0", " "},
                                   {"P440", "O6452", "P6450", "O441", "0.0000", "3", "0.0", " "},
                                   {"P440", "O6452", "P6450", "O441", "0.0000", "4", "180.0", " "},
                                   {"P6450", "O6452", "P440", "O441", "0.1500", "1", "0.0", " "},
                                   {"P6450", "O6452", "P440", "O441", "0.1500", "2", "180.0", " "},
                                   {"P6450", "O6452", "P440", "O441", "0.0000", "3", "0.0", " "},
                                   {"P6450", "O6452", "P440", "O441", "0.0000", "4", "180.0", " "},
                                   {"P440", "O6452", "P440", "O441", "0.1500", "1", "0.0", " "},
                                   {"P440", "O6452", "P440", "O441", "0.1500", "2", "180.0", " "},
                                   {"P440", "O6452", "P440", "O441", "0.0000", "3", "0.0", " "},
                                   {"P440", "O6452", "P440", "O441", "0.0000", "4", "180.0", " "},
                                   {"P440", "O6452", "P440", "O6442", "-0.0500", "1", "0.0", " "},
                                   {"P440", "O6452", "P440", "O6442", "-0.2000", "2", "180.0", " "},
                                   {"P440", "O6452", "P440", "O6442", "0.0500", "3", "0.0", " "},
                                   {"P440", "O6452", "P440", "O6442", "0.0000", "4", "180.0", " "},
                                   {"O6452", "P440", "O6442", "P6450", "-0.0500", "1", "0.0", " "},
                                   {"O6452", "P440", "O6442", "P6450", "-0.2000", "2", "180.0", " "},
                                   {"O6452", "P440", "O6442", "P6450", "0.0500", "3", "0.0", " "},
                                   {"O6452", "P440", "O6442", "P6450", "0.0000", "4", "180.0", " "},
                                   {"P440", "O6442", "P6450", "O6441", "0.0000", "1", "0.0", " "},
                                   {"P440", "O6442", "P6450", "O6441", "0.0000", "2", "180.0", " "},
                                   {"P440", "O6442", "P6450", "O6441", "-0.0500", "3", "0.0", " "},
                                   {"P440", "O6442", "P6450", "O6441", "0.0000", "4", "180.0", " "},
                                   {"O441", "P440", "O6442", "P6450", "0.1500", "1", "0.0", " "},
                                   {"O441", "P440", "O6442", "P6450", "0.1500", "2", "180.0", " "},
                                   {"O441", "P440", "O6442", "P6450", "0.0000", "3", "0.0", " "},
                                   {"O441", "P440", "O6442", "P6450", "0.0000", "4", "180.0", " "},
                                   {"H355", "C347", "N346", "C351", "0.0000", "1", "0.0", " "},
                                   {"H355", "C347", "N346", "C351", "3.6250", "2", "180.0", " "},
                                   {"H355", "C347", "N346", "C351", "0.0000", "3", "0.0", " "},
                                   {"H355", "C347", "N346", "C351", "0.0000", "4", "180.0", " "},
                                   {"H359", "C353", "N936", "C931", "0.0000", "1", "0.0", " "},
                                   {"H359", "C353", "N936", "C931", "5.0000", "2", "180.0", " "},
                                   {"H359", "C353", "N936", "C931", "0.0000", "3", "0.0", " "},
                                   {"H359", "C353", "N936", "C931", "0.0000", "4", "180.0", " "},
                                   {"O186", "C931", "N936", "C349", "0.2000", "1", "0.0", " "},
                                   {"O186", "C931", "N936", "C349", "-0.6000", "2", "180.0", " "},
                                   {"O186", "C931", "N936", "C349", "0.6000", "3", "0.0", " "},
                                   {"O186", "C931", "N936", "C349", "0.0000", "4", "180.0", " "},
                                   {"H196", "C931", "N936", "C349", "0.0000", "1", "0.0", " "},
                                   {"H196", "C931", "N936", "C349", "0.0000", "2", "180.0", " "},
                                   {"H196", "C931", "N936", "C349", "0.0000", "3", "0.0", " "},
                                   {"H196", "C931", "N936", "C349", "0.0000", "4", "180.0", " "},
                                   {"C174", "C931", "N936", "C353", "0.0500", "1", "0.0", " "},
                                   {"C174", "C931", "N936", "C353", "-0.3500", "2", "180.0", " "},
                                   {"C174", "C931", "N936", "C353", "-0.1500", "3", "0.0", " "},
                                   {"C174", "C931", "N936", "C353", "0.0000", "4", "180.0", " "},
                                   {"O186", "C931", "N936", "C353", "1.8000", "1", "0.0", " "},
                                   {"O186", "C931", "N936", "C353", "-1.8000", "2", "180.0", " "},
                                   {"O186", "C931", "N936", "C353", "0.6000", "3", "0.0", " "},
                                   {"O186", "C931", "N936", "C353", "0.0000", "4", "180.0", " "},
                                   {"H196", "C931", "N936", "C353", "0.0000", "1", "0.0", " "},
                                   {"H196", "C931", "N936", "C353", "0.0000", "2", "180.0", " "},
                                   {"H196", "C931", "N936", "C353", "0.0000", "3", "0.0", " "},
                                   {"H196", "C931", "N936", "C353", "0.0000", "4", "180.0", " "},
                                   {"N348", "C349", "N936", "C931", "0.0000", "1", "0.0", " "},
                                   {"N348", "C349", "N936", "C931", "2.5000", "2", "180.0", " "},
                                   {"N348", "C349", "N936", "C931", "0.0000", "3", "0.0", " "},
                                   {"N348", "C349", "N936", "C931", "0.0000", "4", "180.0", " "},
                                   {"C350", "C349", "N936", "C353", "0.0000", "1", "0.0", " "},
                                   {"C350", "C349", "N936", "C353", "3.6250", "2", "180.0", " "},
                                   {"C350", "C349", "N936", "C353", "0.0000", "3", "0.0", " "},
                                   {"C350", "C349", "N936", "C353", "0.0000", "4", "180.0", " "},
                                   {"N348", "C349", "N936", "C353", "0.0000", "1", "0.0", " "},
                                   {"N348", "C349", "N936", "C353", "3.6250", "2", "180.0", " "},
                                   {"N348", "C349", "N936", "C353", "0.0000", "3", "0.0", " "},
                                   {"N348", "C349", "N936", "C353", "0.0000", "4", "180.0", " "},
                                   {"N352", "C353", "N936", "C931", "0.0000", "1", "0.0", " "},
                                   {"N352", "C353", "N936", "C931", "5.0000", "2", "180.0", " "},
                                   {"N352", "C353", "N936", "C931", "0.0000", "3", "0.0", " "},
                                   {"N352", "C353", "N936", "C931", "0.0000", "4", "180.0", " "},
                                   {"N352", "C353", "N936", "C349", "0.0000", "1", "0.0", " "},
                                   {"N352", "C353", "N936", "C349", "3.6250", "2", "180.0", " "},
                                   {"N352", "C353", "N936", "C349", "0.0000", "3", "0.0", " "},
                                   {"N352", "C353", "N936", "C349", "0.0000", "4", "180.0", " "},
                                   {"H359", "C353", "N936", "C349", "0.0000", "1", "0.0", " "},
                                   {"H359", "C353", "N936", "C349", "3.6250", "2", "180.0", " "},
                                   {"H359", "C353", "N936", "C349", "0.0000", "3", "0.0", " "},
                                   {"H359", "C353", "N936", "C349", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C931", "N936", "4.0000", "1", "0.0", " "},
                                   {"O169", "C174", "C931", "N936", "0.0000", "2", "180.0", " "},
                                   {"O169", "C174", "C931", "N936", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C931", "N936", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C931", "N936", "-0.5065", "1", "0.0", " "},
                                   {"H176", "C174", "C931", "N936", "-0.3545", "2", "180.0", " "},
                                   {"H176", "C174", "C931", "N936", "0.2365", "3", "0.0", " "},
                                   {"H176", "C174", "C931", "N936", "0.0000", "4", "180.0", " "},
                                   {"C174", "C174", "C931", "O186", "-0.2180", "1", "0.0", " "},
                                   {"C174", "C174", "C931", "O186", "0.4500", "2", "180.0", " "},
                                   {"C174", "C174", "C931", "O186", "0.0000", "3", "0.0", " "},
                                   {"C174", "C174", "C931", "O186", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C931", "O186", "2.1595", "1", "0.0", " "},
                                   {"O169", "C174", "C931", "O186", "0.0000", "2", "180.0", " "},
                                   {"O169", "C174", "C931", "O186", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C931", "O186", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C931", "O186", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C931", "O186", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C931", "O186", "0.2340", "3", "0.0", " "},
                                   {"H176", "C174", "C931", "O186", "0.0000", "4", "180.0", " "},
                                   {"C174", "C174", "C931", "H196", "0.0000", "1", "0.0", " "},
                                   {"C174", "C174", "C931", "H196", "0.0000", "2", "180.0", " "},
                                   {"C174", "C174", "C931", "H196", "0.1500", "3", "0.0", " "},
                                   {"C174", "C174", "C931", "H196", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C931", "H196", "0.0000", "1", "0.0", " "},
                                   {"O169", "C174", "C931", "H196", "0.0000", "2", "180.0", " "},
                                   {"O169", "C174", "C931", "H196", "0.2340", "3", "0.0", " "},
                                   {"O169", "C174", "C931", "H196", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C931", "H196", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C931", "H196", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C931", "H196", "0.1500", "3", "0.0", " "},
                                   {"H176", "C174", "C931", "H196", "0.0000", "4", "180.0", " "},
                                   {"C183", "O186", "C931", "N936", "-0.2500", "1", "0.0", " "},
                                   {"C183", "O186", "C931", "N936", "-0.7500", "2", "180.0", " "},
                                   {"C183", "O186", "C931", "N936", "0.5000", "3", "0.0", " "},
                                   {"C183", "O186", "C931", "N936", "0.0000", "4", "180.0", " "},
                                   {"C183", "O186", "C931", "C174", "0.3250", "1", "0.0", " "},
                                   {"C183", "O186", "C931", "C174", "-0.1250", "2", "180.0", " "},
                                   {"C183", "O186", "C931", "C174", "-0.2650", "3", "0.0", " "},
                                   {"C183", "O186", "C931", "C174", "0.0000", "4", "180.0", " "},
                                   {"C183", "O186", "C931", "H196", "0.0000", "1", "0.0", " "},
                                   {"C183", "O186", "C931", "H196", "0.0000", "2", "180.0", " "},
                                   {"C183", "O186", "C931", "H196", "0.3800", "3", "0.0", " "},
                                   {"C183", "O186", "C931", "H196", "0.0000", "4", "180.0", " "},
                                   {"N352", "C350", "C349", "N936", "0.0000", "1", "0.0", " "},
                                   {"N352", "C350", "C349", "N936", "3.6250", "2", "180.0", " "},
                                   {"N352", "C350", "C349", "N936", "0.0000", "3", "0.0", " "},
                                   {"N352", "C350", "C349", "N936", "0.0000", "4", "180.0", " "},
                                   {"C351", "C350", "C349", "N348", "0.0000", "1", "0.0", " "},
                                   {"C351", "C350", "C349", "N348", "3.6250", "2", "180.0", " "},
                                   {"C351", "C350", "C349", "N348", "0.0000", "3", "0.0", " "},
                                   {"C351", "C350", "C349", "N348", "0.0000", "4", "180.0", " "},
                                   {"N352", "C350", "C349", "N348", "0.0000", "1", "0.0", " "},
                                   {"N352", "C350", "C349", "N348", "3.6250", "2", "180.0", " "},
                                   {"N352", "C350", "C349", "N348", "0.0000", "3", "0.0", " "},
                                   {"N352", "C350", "C349", "N348", "0.0000", "4", "180.0", " "},
                                   {"C347", "N348", "C349", "N936", "0.0000", "1", "0.0", " "},
                                   {"C347", "N348", "C349", "N936", "3.6250", "2", "180.0", " "},
                                   {"C347", "N348", "C349", "N936", "0.0000", "3", "0.0", " "},
                                   {"C347", "N348", "C349", "N936", "0.0000", "4", "180.0", " "},
                                   {"C347", "N348", "C349", "C350", "0.0000", "1", "0.0", " "},
                                   {"C347", "N348", "C349", "C350", "3.6250", "2", "180.0", " "},
                                   {"C347", "N348", "C349", "C350", "0.0000", "3", "0.0", " "},
                                   {"C347", "N348", "C349", "C350", "0.0000", "4", "180.0", " "},
                                   {"C350", "N352", "C353", "N936", "0.0000", "1", "0.0", " "},
                                   {"C350", "N352", "C353", "N936", "5.0000", "2", "180.0", " "},
                                   {"C350", "N352", "C353", "N936", "0.0000", "3", "0.0", " "},
                                   {"C350", "N352", "C353", "N936", "0.0000", "4", "180.0", " "},
                                   {"C350", "N352", "C353", "H359", "0.0000", "1", "0.0", " "},
                                   {"C350", "N352", "C353", "H359", "5.0000", "2", "180.0", " "},
                                   {"C350", "N352", "C353", "H359", "0.0000", "3", "0.0", " "},
                                   {"C350", "N352", "C353", "H359", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C174", "C931", "-0.2180", "1", "0.0", " "},
                                   {"O169", "C174", "C174", "C931", "0.4500", "2", "180.0", " "},
                                   {"O169", "C174", "C174", "C931", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C174", "C931", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C174", "C931", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C174", "C931", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C174", "C931", "0.1500", "3", "0.0", " "},
                                   {"H176", "C174", "C174", "C931", "0.0000", "4", "180.0", " "},
                                   {"C183", "C174", "C174", "O169", "-0.2180", "1", "0.0", " "},
                                   {"C183", "C174", "C174", "O169", "0.4500", "2", "180.0", " "},
                                   {"C183", "C174", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"C183", "C174", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"O169", "C174", "C174", "O169", "4.5330", "1", "0.0", " "},
                                   {"O169", "C174", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"O169", "C174", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"O169", "C174", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C174", "O169", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C174", "O169", "0.2340", "3", "0.0", " "},
                                   {"H176", "C174", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"C183", "C174", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"C183", "C174", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"C183", "C174", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"C183", "C174", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"H176", "C174", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"H176", "C174", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"H176", "C174", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"H176", "C174", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"C174", "C183", "O186", "C931", "0.3250", "1", "0.0", " "},
                                   {"C174", "C183", "O186", "C931", "-0.1250", "2", "180.0", " "},
                                   {"C174", "C183", "O186", "C931", "-0.2650", "3", "0.0", " "},
                                   {"C174", "C183", "O186", "C931", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "O186", "C931", "0.3250", "1", "0.0", " "},
                                   {"C157", "C183", "O186", "C931", "-0.1250", "2", "180.0", " "},
                                   {"C157", "C183", "O186", "C931", "-0.2650", "3", "0.0", " "},
                                   {"C157", "C183", "O186", "C931", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "O186", "C932", "0.3250", "1", "0.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C932", "-0.1250", "2", "180.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C932", "-0.2650", "3", "0.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C932", "0.0000", "4", "180.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C933", "0.3250", "1", "0.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C933", "-0.1250", "2", "180.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C933", "-0.2650", "3", "0.0", "adm jr., from C157 C183 O186 C931"},
                                   {"C157", "C183", "O186", "C933", "0.0000", "4", "180.0", "adm jr., from C157 C183 O186 C931"},
                                   {"H185", "C183", "O186", "C931", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "O186", "C931", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "O186", "C931", "0.3800", "3", "0.0", " "},
                                   {"H185", "C183", "O186", "C931", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C174", "C174", "-0.2180", "1", "0.0", " "},
                                   {"O186", "C183", "C174", "C174", "0.4500", "2", "180.0", " "},
                                   {"O186", "C183", "C174", "C174", "0.0000", "3", "0.0", " "},
                                   {"O186", "C183", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C174", "C174", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "C174", "C174", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C174", "C174", "0.1500", "3", "0.0", " "},
                                   {"H185", "C183", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C174", "O169", "2.1595", "1", "0.0", " "},
                                   {"O186", "C183", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"O186", "C183", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"O186", "C183", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "C174", "O169", "-0.2180", "1", "0.0", " "},
                                   {"C157", "C183", "C174", "O169", "0.4500", "2", "180.0", " "},
                                   {"C157", "C183", "C174", "O169", "0.0000", "3", "0.0", " "},
                                   {"C157", "C183", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C174", "O169", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "C174", "O169", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C174", "O169", "0.2340", "3", "0.0", " "},
                                   {"H185", "C183", "C174", "O169", "0.0000", "4", "180.0", " "},
                                   {"O186", "C183", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"O186", "C183", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"O186", "C183", "C174", "H176", "0.2340", "3", "0.0", " "},
                                   {"O186", "C183", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"C157", "C183", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"C157", "C183", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"C157", "C183", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"H185", "C183", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"H185", "C183", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"H185", "C183", "C174", "H176", "0.1500", "3", "0.0", " "},
                                   {"H185", "C183", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"H170", "O169", "C174", "C183", "-0.1780", "1", "0.0", " "},
                                   {"H170", "O169", "C174", "C183", "-0.0870", "2", "180.0", " "},
                                   {"H170", "O169", "C174", "C183", "0.2460", "3", "0.0", " "},
                                   {"H170", "O169", "C174", "C183", "0.0000", "4", "180.0", " "},
                                   {"H170", "O169", "C174", "H176", "0.0000", "1", "0.0", " "},
                                   {"H170", "O169", "C174", "H176", "0.0000", "2", "180.0", " "},
                                   {"H170", "O169", "C174", "H176", "0.1760", "3", "0.0", " "},
                                   {"H170", "O169", "C174", "H176", "0.0000", "4", "180.0", " "},
                                   {"O154", "C157", "C183", "O186", "3.4095", "1", "0.0", " "},
                                   {"O154", "C157", "C183", "O186", "-1.2500", "2", "180.0", " "},
                                   {"O154", "C157", "C183", "O186", "0.5000", "3", "0.0", " "},
                                   {"O154", "C157", "C183", "O186", "0.0000", "4", "180.0", " "},
                                   {"H140", "C157", "C183", "O186", "0.0000", "1", "0.0", " "},
                                   {"H140", "C157", "C183", "O186", "0.0000", "2", "180.0", " "},
                                   {"H140", "C157", "C183", "O186", "0.2340", "3", "0.0", " "},
                                   {"H140", "C157", "C183", "O186", "0.0000", "4", "180.0", " "},
                                   {"H140", "C157", "C183", "C174", "0.0000", "1", "0.0", " "},
                                   {"H140", "C157", "C183", "C174", "0.0000", "2", "180.0", " "},
                                   {"H140", "C157", "C183", "C174", "0.1500", "3", "0.0", " "},
                                   {"H140", "C157", "C183", "C174", "0.0000", "4", "180.0", " "},
                                   {"O154", "C157", "C183", "H185", "0.0000", "1", "0.0", " "},
                                   {"O154", "C157", "C183", "H185", "0.0000", "2", "180.0", " "},
                                   {"O154", "C157", "C183", "H185", "0.2340", "3", "0.0", " "},
                                   {"O154", "C157", "C183", "H185", "0.0000", "4", "180.0", " "},
                                   {"H140", "C157", "C183", "H185", "0.0000", "1", "0.0", " "},
                                   {"H140", "C157", "C183", "H185", "0.0000", "2", "180.0", " "},
                                   {"H140", "C157", "C183", "H185", "0.1500", "3", "0.0", " "},
                                   {"H140", "C157", "C183", "H185", "0.0000", "4", "180.0", " "},
                                   {"N346", "C351", "C350", "C349", "0.0000", "1", "0.0", " "},
                                   {"N346", "C351", "C350", "C349", "3.5000", "2", "180.0", " "},
                                   {"N346", "C351", "C350", "C349", "0.0000", "3", "0.0", " "},
                                   {"N346", "C351", "C350", "C349", "0.0000", "4", "180.0", " "},
                                   {"N356", "C351", "C350", "N352", "0.0000", "1", "0.0", " "},
                                   {"N356", "C351", "C350", "N352", "3.5000", "2", "180.0", " "},
                                   {"N356", "C351", "C350", "N352", "0.0000", "3", "0.0", " "},
                                   {"N356", "C351", "C350", "N352", "0.0000", "4", "180.0", " "},
                                   {"N346", "C351", "C350", "N352", "0.0000", "1", "0.0", " "},
                                   {"N346", "C351", "C350", "N352", "3.5000", "2", "180.0", " "},
                                   {"N346", "C351", "C350", "N352", "0.0000", "3", "0.0", " "},
                                   {"N346", "C351", "C350", "N352", "0.0000", "4", "180.0", " "},
                                   {"C353", "N352", "C350", "C349", "0.0000", "1", "0.0", " "},
                                   {"C353", "N352", "C350", "C349", "3.6250", "2", "180.0", " "},
                                   {"C353", "N352", "C350", "C349", "0.0000", "3", "0.0", " "},
                                   {"C353", "N352", "C350", "C349", "0.0000", "4", "180.0", " "},
                                   {"C353", "N352", "C350", "C351", "0.0000", "1", "0.0", " "},
                                   {"C353", "N352", "C350", "C351", "3.6250", "2", "180.0", " "},
                                   {"C353", "N352", "C350", "C351", "0.0000", "3", "0.0", " "},
                                   {"C353", "N352", "C350", "C351", "0.0000", "4", "180.0", " "},
                                   {"N346", "C347", "N348", "C349", "0.0000", "1", "0.0", " "},
                                   {"N346", "C347", "N348", "C349", "3.6250", "2", "180.0", " "},
                                   {"N346", "C347", "N348", "C349", "0.0000", "3", "0.0", " "},
                                   {"N346", "C347", "N348", "C349", "0.0000", "4", "180.0", " "},
                                   {"H355", "C347", "N348", "C349", "0.0000", "1", "0.0", " "},
                                   {"H355", "C347", "N348", "C349", "3.6250", "2", "180.0", " "},
                                   {"H355", "C347", "N348", "C349", "0.0000", "3", "0.0", " "},
                                   {"H355", "C347", "N348", "C349", "0.0000", "4", "180.0", " "},
                                   {"H358", "N356", "C351", "C350", "0.0000", "1", "0.0", " "},
                                   {"H358", "N356", "C351", "C350", "1.9500", "2", "180.0", " "},
                                   {"H358", "N356", "C351", "C350", "0.0000", "3", "0.0", " "},
                                   {"H358", "N356", "C351", "C350", "0.0000", "4", "180.0", " "},
                                   {"H357", "N356", "C351", "N346", "0.0000", "1", "0.0", " "},
                                   {"H357", "N356", "C351", "N346", "1.9500", "2", "180.0", " "},
                                   {"H357", "N356", "C351", "N346", "0.0000", "3", "0.0", " "},
                                   {"H357", "N356", "C351", "N346", "0.0000", "4", "180.0", " "},
                                   {"H358", "N356", "C351", "N346", "0.0000", "1", "0.0", " "},
                                   {"H358", "N356", "C351", "N346", "1.9500", "2", "180.0", " "},
                                   {"H358", "N356", "C351", "N346", "0.0000", "3", "0.0", " "},
                                   {"H358", "N356", "C351", "N346", "0.0000", "4", "180.0", " "},
                                   {"C347", "N346", "C351", "N356", "0.0000", "1", "0.0", " "},
                                   {"C347", "N346", "C351", "N356", "3.6250", "2", "180.0", " "},
                                   {"C347", "N346", "C351", "N356", "0.0000", "3", "0.0", " "},
                                   {"C347", "N346", "C351", "N356", "0.0000", "4", "180.0", " "},
                                   {"N348", "C347", "N346", "C351", "0.0000", "1", "0.0", " "},
                                   {"N348", "C347", "N346", "C351", "3.6250", "2", "180.0", " "},
                                   {"N348", "C347", "N346", "C351", "0.0000", "3", "0.0", " "},
                                   {"N348", "C347", "N346", "C351", "0.0000", "4", "180.0", " "},
                                   {"C174", "C931", "N936", "C349", "-0.3500", "1", "0.0", " "},
                                   {"C174", "C931", "N936", "C349", "-0.0500", "2", "180.0", " "},
                                   {"C174", "C931", "N936", "C349", "0.3000", "3", "0.0", " "},
                                   {"C174", "C931", "N936", "C349", "0.0000", "4", "180.0", " "},
                                   {"C174", "C174", "C931", "N936", "1.1960", "1", "0.0", " "},
                                   {"C174", "C174", "C931", "N936", "-0.3370", "2", "180.0", " "},
                                   {"C174", "C174", "C931", "N936", "0.2750", "3", "0.0", " "},
                                   {"C174", "C174", "C931", "N936", "0.0000", "4", "180.0", " "},
                                   {"C183", "C174", "C174", "C931", "0.6500", "1", "0.0", " "},
                                   {"C183", "C174", "C174", "C931", "-0.1000", "2", "180.0", " "},
                                   {"C183", "C174", "C174", "C931", "0.1000", "3", "0.0", " "},
                                   {"C183", "C174", "C174", "C931", "0.0000", "4", "180.0", " "},
                                   {"C157", "C183", "C174", "C174", "0.6500", "1", "0.0", " "},
                                   {"C157", "C183", "C174", "C174", "-0.1000", "2", "180.0", " "},
                                   {"C157", "C183", "C174", "C174", "0.1000", "3", "0.0", " "},
                                   {"C157", "C183", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"O154", "C157", "C183", "C174", "-1.0000", "1", "0.0", " "},
                                   {"O154", "C157", "C183", "C174", "-0.1000", "2", "180.0", " "},
                                   {"O154", "C157", "C183", "C174", "-0.2500", "3", "0.0", " "},
                                   {"O154", "C157", "C183", "C174", "0.0000", "4", "180.0", " "},
                                   {"H155", "O154", "C157", "C183", "1.3370", "1", "0.0", " "},
                                   {"H155", "O154", "C157", "C183", "-1.4415", "2", "180.0", " "},
                                   {"H155", "O154", "C157", "C183", "0.5130", "3", "0.0", " "},
                                   {"H155", "O154", "C157", "C183", "0.0000", "4", "180.0", " "},
                                   {"H170", "O169", "C174", "C174", "1.3370", "1", "0.0", " "},
                                   {"H170", "O169", "C174", "C174", "-1.4415", "2", "180.0", " "},
                                   {"H170", "O169", "C174", "C174", "0.5130", "3", "0.0", " "},
                                   {"H170", "O169", "C174", "C174", "0.0000", "4", "180.0", " "},
                                   {"H170", "O169", "C174", "C931", "1.3370", "1", "0.0", " "},
                                   {"H170", "O169", "C174", "C931", "-1.4415", "2", "180.0", " "},
                                   {"H170", "O169", "C174", "C931", "0.5130", "3", "0.0", " "},
                                   {"H170", "O169", "C174", "C931", "0.0000", "4", "180.0", " "},
                                   {"C350", "C349", "N936", "C931", "0.0000", "1", "0.0", " "},
                                   {"C350", "C349", "N936", "C931", "2.5000", "2", "180.0", " "},
                                   {"C350", "C349", "N936", "C931", "0.0000", "3", "0.0", " "},
                                   {"C350", "C349", "N936", "C931", "0.0000", "4", "180.0", " "},
                                   {"C351", "C350", "C349", "N936", "0.0000", "1", "0.0", " "},
                                   {"C351", "C350", "C349", "N936", "3.6250", "2", "180.0", " "},
                                   {"C351", "C350", "C349", "N936", "0.0000", "3", "0.0", " "},
                                   {"C351", "C350", "C349", "N936", "0.0000", "4", "180.0", " "},
                                   {"N356", "C351", "C350", "C349", "0.0000", "1", "0.0", " "},
                                   {"N356", "C351", "C350", "C349", "3.5000", "2", "180.0", " "},
                                   {"N356", "C351", "C350", "C349", "0.0000", "3", "0.0", " "},
                                   {"N356", "C351", "C350", "C349", "0.0000", "4", "180.0", " "},
                                   {"H357", "N356", "C351", "C350", "0.0000", "1", "0.0", " "},
                                   {"H357", "N356", "C351", "C350", "1.9500", "2", "180.0", " "},
                                   {"H357", "N356", "C351", "C350", "0.0000", "3", "0.0", " "},
                                   {"H357", "N356", "C351", "C350", "0.0000", "4", "180.0", " "},
                                   {"C347", "N346", "C351", "C350", "0.0000", "1", "0.0", " "},
                                   {"C347", "N346", "C351", "C350", "3.6250", "2", "180.0", " "},
                                   {"C347", "N346", "C351", "C350", "0.0000", "3", "0.0", " "},
                                   {"C347", "N346", "C351", "C350", "0.0000", "4", "180.0", " "}};

/*
 Impropers
*/
char * OPLSAAR_impropers[131][8]= {{"C136", "C500", "C501", "C514", "1.1000", "2", "180.0", " "},
                                   {"C136", "C500", "C514", "C501", "1.1000", "2", "180.0", " "},
                                   {"C145", "C502", "C501", "N503", "1.1000", "2", "180.0", " "},
                                   {"C145", "C502", "N503", "C501", "1.1000", "2", "180.0", " "},
                                   {"C149", "C145", "C145", "C145", "1.1000", "2", "180.0", " "},
                                   {"C245", "N238", "C235", "C285", "2.5000", "2", "180.0", " "},
                                   {"C245", "N238", "C285", "C235", "2.5000", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "C246", "2.5000", "2", "180.0", " "},
                                   {"C245", "N239", "C235", "C285", "2.5000", "2", "180.0", " "},
                                   {"C245", "N239", "C246", "C235", "2.5000", "2", "180.0", " "},
                                   {"C245", "N239", "C285", "C235", "2.5000", "2", "180.0", " "},
                                   {"C502", "C501", "C145", "C500", "1.1000", "2", "180.0", " "},
                                   {"C502", "C501", "C500", "C145", "1.1000", "2", "180.0", " "},
                                   {"C505", "C507", "C508", "N511", "1.1000", "2", "180.0", " "},
                                   {"C505", "C507", "N511", "C508", "1.1000", "2", "180.0", " "},
                                   {"C505", "C508", "C507", "N503", "1.1000", "2", "180.0", " "},
                                   {"C505", "C508", "N503", "C507", "1.1000", "2", "180.0", " "},
                                   {"C505", "C510", "C510", "N512", "1.1000", "2", "180.0", " "},
                                   {"C505", "C510", "N512", "C510", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C145", "C145", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C166", "C145", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C145", "C166", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C145", "C501", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C501", "C145", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C145", "C502", "1.1000", "2", "180.0", " "},
                                   {"H146", "C145", "C502", "C145", "1.1000", "2", "180.0", " "},
                                   {"H146", "C506", "N503", "N511", "1.1000", "2", "180.0", " "},
                                   {"H146", "C506", "N511", "N503", "1.1000", "2", "180.0", " "},
                                   {"H146", "C507", "C508", "N511", "1.1000", "2", "180.0", " "},
                                   {"H146", "C507", "N511", "C508", "1.1000", "2", "180.0", " "},
                                   {"H146", "C508", "C507", "N503", "1.1000", "2", "180.0", " "},
                                   {"H146", "C508", "N503", "C507", "1.1000", "2", "180.0", " "},
                                   {"H146", "C509", "N512", "N512", "1.1000", "2", "180.0", " "},
                                   {"H146", "C510", "C510", "N512", "1.1000", "2", "180.0", " "},
                                   {"H146", "C510", "N512", "C510", "1.1000", "2", "180.0", " "},
                                   {"H146", "C514", "C500", "N503", "1.1000", "2", "180.0", " "},
                                   {"H146", "C514", "N503", "C500", "1.1000", "2", "180.0", " "},
                                   {"H240", "N237", "C235", "H240", "2.5000", "2", "180.0", " "},
                                   {"H240", "N237", "H240", "C235", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C223", "C235", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C224", "C235", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "C223", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "C224", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "C242", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "C283", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C235", "C284", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C242", "C235", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C283", "C235", "2.5000", "2", "180.0", " "},
                                   {"H241", "N238", "C284", "C235", "2.5000", "2", "180.0", " "},
                                   {"H301", "N300", "C302", "H301", "2.5000", "2", "180.0", " "},
                                   {"H301", "N300", "H301", "C302", "2.5000", "2", "180.0", " "},
                                   {"H304", "N303", "C302", "C307", "2.5000", "2", "180.0", " "},
                                   {"H304", "N303", "C307", "C302", "2.5000", "2", "180.0", " "},
                                   {"H504", "N503", "C502", "C514", "2.5000", "2", "180.0", " "},
                                   {"H504", "N503", "C506", "C508", "2.5000", "2", "180.0", " "},
                                   {"H504", "N503", "C508", "C506", "2.5000", "2", "180.0", " "},
                                   {"H504", "N503", "C514", "C502", "2.5000", "2", "180.0", " "},
                                   {"H513", "N512", "C509", "C510", "2.5000", "2", "180.0", " "},
                                   {"H513", "N512", "C510", "C509", "2.5000", "2", "180.0", " "},
                                   {"N300", "C302", "N300", "N303", "10.5000", "2", "180.0", " "},
                                   {"N300", "C302", "N303", "N300", "10.5000", "2", "180.0", " "},
                                   {"O167", "C166", "C145", "C145", "1.1000", "2", "180.0", " "},
                                   {"O236", "C235", "C135", "N239", "10.5", "2", "180.0", " "},
                                   {"O236", "C235", "C135", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C136", "N237", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C223", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C223", "N239", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C224", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C224", "N239", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C246", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C246", "N239", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C292", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C293", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C293", "N239", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C295", "N238", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "C295", "N239", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N237", "C136", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C135", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C223", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C224", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C246", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C292", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C293", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N238", "C295", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C135", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C223", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C224", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C246", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C293", "10.5000", "2", "180.0", " "},
                                   {"O236", "C235", "N239", "C295", "10.5000", "2", "180.0", " "},
                                   {"O269", "C267", "C136", "O268", "10.5000", "2", "180.0", " "},
                                   {"O269", "C267", "O268", "C136", "10.5000", "2", "180.0", " "},
                                   {"O269", "C267", "C224", "O268", "10.5000", "2", "180.0", " "},
                                   {"O269", "C267", "O268", "C224", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "C274", "O272", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "C283", "O272", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "C284", "O272", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "C285", "O272", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "O272", "C274", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "O272", "C283", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "O272", "C284", "10.5000", "2", "180.0", " "},
                                   {"O272", "C271", "O272", "C285", "10.5000", "2", "180.0", " "},
                                   {"O268", "C267", "C136", "O269", "10.5", "2", "180.0", " "},
                                   {"O268", "C267", "C223", "O269", "10.5", "2", "180.0", "Gly"},
                                   {"O268", "C267", "C224", "O269", "10.5", "2", "180.0", " "},
                                   {"C320", "C933", "N938", "C324", "2.5000", "2", "180.0", " "},
                                   {"C320", "N938", "N321", "O326", "2.5000", "2", "180.0", " "},
                                   {"C322", "C320", "N321", "H327", "2.5000", "2", "180.0", " "},
                                   {"C322", "N321", "C323", "O328", "2.5000", "2", "180.0", " "},
                                   {"C324", "C322", "C323", "H329", "2.5000", "2", "180.0", " "},
                                   {"C323", "N938", "C324", "H330", "2.5000", "2", "180.0", " "},
                                   {"C338", "N937", "C932", "C334", "2.5000", "2", "180.0", " "},
                                   {"N335", "N937", "C334", "O340", "2.5000", "2", "180.0", " "},
                                   {"N341", "N335", "C336", "C337", "2.5000", "2", "180.0", " "},
                                   {"H342", "C336", "N341", "H343", "2.5000", "2", "180.0", " "},
                                   {"C338", "C336", "C337", "H344", "2.5000", "2", "180.0", " "},
                                   {"C337", "N937", "C338", "H345", "2.5000", "2", "180.0", " "},
                                   {"C364", "C365", "C366", "N352", "2.5000", "2", "180.0", " "},
                                   {"N361", "N363", "C362", "N368", "2.5000", "2", "180.0", " "},
                                   {"H369", "C362", "N368", "H369", "2.5000", "2", "180.0", " "},
                                   {"C362", "H367", "N361", "C366", "2.5000", "2", "180.0", " "},
                                   {"O370", "C365", "C366", "N361", "2.5000", "2", "180.0", " "},
                                   {"N936", "N363", "C364", "C365", "2.5000", "2", "180.0", " "},
                                   {"C353", "C931", "N936", "C364", "2.5000", "2", "180.0", " "},
                                   {"H358", "N356", "C351", "H357", "2.5000", "2", "180.0", " "},
                                   {"H355", "C347", "N346", "N348", "2.5000", "2", "180.0", " "},
                                   {"N356", "C351", "C350", "N346", "2.5000", "2", "180.0", " "},
                                   {"C351", "C350", "C349", "N352", "2.5000", "2", "180.0", " "},
                                   {"N352", "N936", "C353", "H359", "2.5000", "2", "180.0", " "},
                                   {"N348", "C349", "C350", "N936", "2.5000", "2", "180.0", " "},
                                   {"C349", "N936", "C931", "C353", "2.5000", "2", "180.0", " "}};

/*
 Non-bonded
*/
char * OPLSAAR_vdw[145][7]= {{"C135", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C136", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C137", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C145", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C149", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C157", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C158", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C166", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C206", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C209", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C210", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C214", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C223", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C224", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C235", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C242", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C245", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C246", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C267", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C271", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C274", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C283", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C284", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C285", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C292", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C293", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C295", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C296", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C302", "0.00", "-0.050000", "1.2627698", "0.00", "-0.025000", "1.2627698"},
                                   {"C307", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C308", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C500", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C501", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C502", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C505", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C506", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C507", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C508", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C509", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C510", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C514", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"H140", "0.00", "-0.030000", "1.4030776", "0.00", "-0.015000", "1.4030776"},
                                   {"H146", "0.00", "-0.030000", "1.3581791", "0.00", "-0.015000", "1.3581791"},
                                   {"H155", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H168", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H204", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H240", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H241", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H270", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H290", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H301", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H304", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H310", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H504", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H513", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"N237", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N238", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N239", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N287", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N300", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N303", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N309", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N503", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N511", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N512", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"O154", "0.00", "-0.170000", "1.7510408", "0.00", "-0.085000", "1.7510408"},
                                   {"O167", "0.00", "-0.170000", "1.7229792", "0.00", "-0.085000", "1.7229792"},
                                   {"O236", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"O268", "0.00", "-0.170000", "1.6836931", "0.00", "-0.085000", "1.6836931"},
                                   {"O269", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"O272", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"S200", "0.00", "-0.425000", "2.0204317", "0.00", "-0.212500", "2.0204317"},
                                   {"S202", "0.00", "-0.355000", "2.0204317", "0.00", "-0.177500", "2.0204317"},
                                   {"S203", "0.00", "-0.355000", "2.0204317", "0.00", "-0.177500", "2.0204317"},
                                   {"OT", "0.00", "-0.152100", "1.768200", "0.00", "-0.152100", "1.768200"},
                                   {"HT", "0.00", "-0.046000", "0.224500", "0.00", "-0.046000", "0.22450"},
                                   {"SOD", "0.00", "-0.000500", "2.9969737", "0.00", "-0.000500", "2.9969737"},
                                   {"CLA", "0.00", "-0.710000", "2.2561487", "0.00", "-0.710000", "2.2561487"},
                                   {"MG", "0.00", "-0.857044", "0.9229261", "0.00", "-0.857044", "0.9229261"},
                                   {"H329", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"C933", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"N938", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"C324", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"H330", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"C320", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"O326", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"N321", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"H327", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"C322", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"O328", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"C323", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"C932", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"N937", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N936", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"C338", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"H345", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"C337", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"H344", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"C334", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"O340", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"N335", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"C336", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"N341", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"H342", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"H343", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"C931", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C349", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"C353", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"C174", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"O186", "0.00", "-0.140000", "1.6275699", "0.00", "-0.070000", "1.6275699"},
                                   {"H196", "0.00", "-0.030000", "1.4030775", "0.00", "-0.015000", "1.4030775"},
                                   {"O169", "0.00", "-0.170000", "1.7229792", "0.00", "-0.085000", "1.7229792"},
                                   {"H176", "0.00", "-0.030000", "1.4030775", "0.00", "-0.015000", "1.4030775"},
                                   {"C183", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"H185", "0.00", "-0.030000", "1.4030775", "0.00", "-0.015000", "1.4030775"},
                                   {"H170", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"C350", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"N348", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"C351", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"N352", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N356", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N346", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"H357", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"H358", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"C347", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"H355", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"H359", "0.00", "-0.050000", "1.4030775", "0.00", "-0.025000", "1.4030775"},
                                   {"C6448", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"O6934", "0.00", "-0.140000", "1.6275700", "0.00", "-0.070000", "1.6275700"},
                                   {"P440", "0.00", "-0.200000", "2.0990040", "0.00", "-0.100000", "2.0990040"},
                                   {"O441", "0.00", "-0.200000", "1.7678777", "0.00", "-0.100000", "1.7678777"},
                                   {"O6452", "0.00", "-0.140000", "1.6275700", "0.00", "-0.070000", "1.6275700"},
                                   {"O6442", "0.00", "-0.140000", "1.6275700", "0.00", "-0.070000", "1.6275700"},
                                   {"P6450", "0.00", "-0.200000", "2.0990040", "0.00", "-0.100000", "2.0990040"},
                                   {"O6441", "0.00", "-0.200000", "1.7678777", "0.00", "-0.100000", "1.7678777"},
                                   {"C364", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"N368", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"H369", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"N363", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"C362", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"},
                                   {"N361", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"H367", "0.00", "-0.000000", "0.0000000", "0.00", "-0.000000", "0.0000000"},
                                   {"C366", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"O370", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"C365", "0.00", "-0.080000", "1.9643086", "0.00", "-0.040000", "1.9643086"}};
