/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgSchema;

public class PgExtension {
    private final String name;
    private PgSchema schema;
    private String version;
    private String from;

    public PgExtension(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public PgSchema getSchema() {
        return this.schema;
    }

    public void setSchema(PgSchema pgSchema) {
        this.schema = pgSchema;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE EXTENSION ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        if (this.schema != null) {
            stringBuilder.append(" SCHEMA ");
            stringBuilder.append(this.schema.getName());
        }
        if (this.version != null && !this.version.isEmpty()) {
            stringBuilder.append(" VERSION ");
            stringBuilder.append(this.version);
        }
        if (this.from != null && !this.from.isEmpty()) {
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.from);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PgExtension) {
            PgExtension pgExtension = (PgExtension)object;
            bl = this.name.equals(pgExtension.getName()) && this.from.equals(pgExtension.getFrom()) && this.version.equals(pgExtension.getVersion());
        }
        return bl;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.name + "|" + this.version + "|" + this.from).hashCode();
    }
}

