/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgColumnUtils;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgType;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class PgDiffTypes {
    public static void alterTypes(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgType pgType : pgSchema2.getTypes()) {
            if (pgSchema == null || !pgSchema.containsType(pgType.getName())) continue;
            PgType pgType2 = pgSchema.getType(pgType.getName());
            PgDiffTypes.updateTypeColumns(printWriter, pgDiffArguments, pgType2, pgType, searchPathHelper);
        }
    }

    private static void addCreateTypeColumns(List<String> list, PgDiffArguments pgDiffArguments, PgType pgType, PgType pgType2, List<PgColumn> list2) {
        for (PgColumn pgColumn : pgType2.getColumns()) {
            if (pgType.containsColumn(pgColumn.getName())) continue;
            list.add("\tADD ATTRIBUTE " + pgColumn.getFullDefinition(pgDiffArguments.isAddDefaults()));
            if (!pgDiffArguments.isAddDefaults() || pgColumn.getNullValue() || pgColumn.getDefaultValue() != null && !pgColumn.getDefaultValue().isEmpty()) continue;
            list2.add(pgColumn);
        }
    }

    private static void addDropTypeColumns(List<String> list, PgType pgType, PgType pgType2) {
        for (PgColumn pgColumn : pgType.getColumns()) {
            if (pgType2.containsColumn(pgColumn.getName())) continue;
            list.add("\tDROP ATTRIBUTE " + PgDiffUtils.getQuotedName(pgColumn.getName()));
        }
    }

    private static void addModifyTypeColumns(List<String> list, PgDiffArguments pgDiffArguments, PgType pgType, PgType pgType2, List<PgColumn> list2) {
        for (PgColumn pgColumn : pgType2.getColumns()) {
            String string;
            String string2;
            if (!pgType.containsColumn(pgColumn.getName())) continue;
            PgColumn pgColumn2 = pgType.getColumn(pgColumn.getName());
            String string3 = PgDiffUtils.getQuotedName(pgColumn.getName());
            if (!pgColumn2.getType().equals(pgColumn.getType())) {
                list.add("\tALTER ATTRIBUTE " + string3 + " TYPE " + pgColumn.getType() + " /* " + MessageFormat.format(Resources.getString("TypeParameterChange"), pgType2.getName(), pgColumn2.getType(), pgColumn.getType()) + " */");
            }
            String string4 = pgColumn2.getDefaultValue() == null ? "" : pgColumn2.getDefaultValue();
            String string5 = string2 = pgColumn.getDefaultValue() == null ? "" : pgColumn.getDefaultValue();
            if (!string4.equals(string2)) {
                if (string2.length() == 0) {
                    list.add("\tALTER ATTRIBUTE " + string3 + " DROP DEFAULT");
                } else {
                    list.add("\tALTER ATTRIBUTE " + string3 + " SET DEFAULT " + string2);
                }
            }
            if (pgColumn2.getNullValue() == pgColumn.getNullValue()) continue;
            if (pgColumn.getNullValue()) {
                list.add("\tALTER ATTRIBUTE " + string3 + " DROP NOT NULL");
                continue;
            }
            if (pgDiffArguments.isAddDefaults() && (string = PgColumnUtils.getDefaultValue(pgColumn.getType())) != null) {
                list.add("\tALTER ATTRIBUTE " + string3 + " SET DEFAULT " + string);
                list2.add(pgColumn);
            }
            list.add("\tALTER ATTRIBUTE " + string3 + " SET NOT NULL");
        }
    }

    public static void createTypes(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgType pgType : pgSchema2.getTypes()) {
            if (pgSchema != null && pgSchema.containsType(pgType.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgType.getCreationSQL());
        }
    }

    public static void dropTypes(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgType pgType : pgSchema.getTypes()) {
            if (pgSchema2.containsType(pgType.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgType.getDropSQL());
        }
    }

    private static void updateTypeColumns(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgType pgType, PgType pgType2, SearchPathHelper searchPathHelper) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<PgColumn> arrayList2 = new ArrayList<PgColumn>();
        PgDiffTypes.addDropTypeColumns(arrayList, pgType, pgType2);
        PgDiffTypes.addCreateTypeColumns(arrayList, pgDiffArguments, pgType, pgType2, arrayList2);
        PgDiffTypes.addModifyTypeColumns(arrayList, pgDiffArguments, pgType, pgType2, arrayList2);
        if (!arrayList.isEmpty()) {
            int n;
            String string = PgDiffUtils.getQuotedName(pgType2.getName());
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println("ALTER TYPE " + string);
            for (n = 0; n < arrayList.size(); ++n) {
                printWriter.print((String)arrayList.get(n));
                printWriter.println(n + 1 < arrayList.size() ? "," : ";");
            }
            if (!arrayList2.isEmpty()) {
                printWriter.println();
                printWriter.println("ALTER TYPE " + string);
                for (n = 0; n < arrayList2.size(); ++n) {
                    printWriter.print("\tALTER ATTRIBUTE ");
                    printWriter.print(PgDiffUtils.getQuotedName(((PgColumn)arrayList2.get(n)).getName()));
                    printWriter.print(" DROP DEFAULT");
                    printWriter.println(n + 1 < arrayList2.size() ? "," : ";");
                }
            }
        }
    }

    private PgDiffTypes() {
    }
}

