/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class TextChunk
extends Chunk {
    protected String propName;

    public TextChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        String string = this.readText();
        aiffModule.addAiffProperty(new Property(this.propName, PropertyType.STRING, string));
        return true;
    }

    protected String readText() throws IOException {
        byte[] byArray = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf(this._dstream, byArray, this._module);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 32 && byArray[i] <= 127) continue;
            byArray[i] = 32;
        }
        return new String(byArray, "ASCII");
    }
}

