/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TextMDMetadata {
    public static final String NAMESPACE = "info:lc/xmlns/textMD-v3";
    public static final String DEFAULT_LOCATION = "http://www.loc.gov/standards/textMD/textMD-v3.01a.xsd";
    public static final String VERSION = "3.0";
    public static final String[] BYTE_ORDER = new String[]{"big", "little", "middle"};
    public static final int BYTE_ORDER_BIG = 0;
    public static final int BYTE_ORDER_LITTLE = 1;
    public static final int BYTE_ORDER_MIDDLE = 2;
    public static final String[] LINEBREAK = new String[]{"CR", "LF", "CR/LF"};
    public static final int LINEBREAK_CR = 0;
    public static final int LINEBREAK_LF = 1;
    public static final int LINEBREAK_CRLF = 2;
    protected static final String[] UNKNOWN_JAVA_CHARSET = new String[]{"ISO-10646-UTF-1", "ISO_646.basic:1983", "INVARIANT", "BS_4730", "NATS-SEFI", "NATS-SEFI-ADD", "NATS-DANO", "NATS-DANO-ADD", "SEN_850200_B", "SEN_850200_C", "ISO-2022-CN-EXT", "JIS_C6220-1969-jp", "JIS_C6220-1969-ro", "IT", "PT", "ES", "greek7-old", "latin-greek", "DIN_66003", "NF_Z_62-010_(1973)", "latin-greek-1", "ISO_5427", "JIS_C6226-1978", "BS_viewdata", "INIS", "INIS-8", "INIS-cyrillic", "ISO_5427:1981", "ISO_5428:1980", "GB_1988-80", "GB_2312-80", "NS_4551-1", "NS_4551-2", "NF_Z_62-010", "videotex-suppl", "PT2", "ES2", "MSZ_7795.3", "greek7", "ASMO_449", "iso-ir-90", "JIS_C6229-1984-a", "JIS_C6229-1984-b", "JIS_C6229-1984-b-add", "JIS_C6229-1984-hand", "JIS_C6229-1984-hand-add", "JIS_C6229-1984-kana", "ISO_2033-1983", "ANSI_X3.110-1983", "T.61-7bit", "ECMA-cyrillic", "CSA_Z243.4-1985-1", "CSA_Z243.4-1985-2", "CSA_Z243.4-1985-gr", "ISO_8859-6-E", "ISO_8859-6-I", "T.101-G2", "ISO_8859-8-E", "ISO_8859-8-I", "CSN_369103", "JUS_I.B1.002", "ISO_6937-2-add", "IEC_P27-1", "JUS_I.B1.003-serb", "JUS_I.B1.003-mac", "greek-ccitt", "NC_NC00-10:81", "ISO_6937-2-25", "GOST_19768-74", "ISO_8859-supp", "ISO_10367-box", "ISO-8859-10", "latin-lap", "DS_2089", "us-dk", "dk-us", "KSC5636", "ISO-10646-UCS-4", "DEC-MCS", "hp-roman8", "macintosh", "IBM038", "IBM274", "IBM275", "IBM281", "IBM290", "IBM423", "IBM851", "IBM880", "IBM891", "IBM903", "IBM904", "IBM905", "EBCDIC-AT-DE", "EBCDIC-AT-DE-A", "EBCDIC-CA-FR", "EBCDIC-DK-NO", "EBCDIC-DK-NO-A", "EBCDIC-FI-SE", "EBCDIC-FI-SE-A", "EBCDIC-FR", "EBCDIC-IT", "EBCDIC-PT", "EBCDIC-ES", "EBCDIC-ES-A", "EBCDIC-ES-S", "EBCDIC-UK", "EBCDIC-US", "UNKNOWN-8BIT", "MNEMONIC", "MNEM", "VISCII", "VIQR", "IBM00924", "UNICODE-1-1", "SCSU", "UTF-7", "CESU-8", "UNICODE-1-1-UTF-7", "ISO-8859-14", "ISO-8859-16", "Extended_UNIX_Code_Fixed_Width_for_Japanese", "ISO-10646-UCS-Basic", "ISO-10646-Unicode-Latin1", "ISO-10646-J-1", "ISO-Unicode-IBM-1268", "ISO-Unicode-IBM-1276", "ISO-Unicode-IBM-1264", "ISO-Unicode-IBM-1265", "ISO-8859-1-Windows-3.0-Latin-1", "ISO-8859-1-Windows-3.1-Latin-1", "ISO-8859-2-Windows-Latin-2", "ISO-8859-9-Windows-Latin-5", "Adobe-Standard-Encoding", "Ventura-US", "Ventura-International", "PC8-Danish-Norwegian", "PC8-Turkish", "IBM-Symbols", "HP-Legal", "HP-Pi-font", "HP-Math8", "Adobe-Symbol-Encoding", "HP-DeskTop", "Ventura-Math", "Microsoft-Publishing", "HZ-GB-2312"};
    protected static Set setOfUnknownJavaCharset = new HashSet<String>(Arrays.asList(UNKNOWN_JAVA_CHARSET));
    protected static Map fromISO_639_2_T2B = new HashMap();
    public static final String CHARSET_ASCII = "US-ASCII";
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_ISO8859_1 = "ISO-8859-1";
    public static final int NILL = -1;
    private String charset;
    private int byte_order = -1;
    private String byte_size;
    private String character_size;
    private int linebreak = -1;
    private String language;
    private String markup_basis;
    private String markup_basis_version;
    private String markup_language;
    private String markup_language_version;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = TextMDMetadata.toTextMDCharset(string);
    }

    public int getByte_order() {
        return this.byte_order;
    }

    public String getByte_orderString() {
        if (this.byte_order == -1) {
            return BYTE_ORDER[0];
        }
        return BYTE_ORDER[this.byte_order];
    }

    public void setByte_order(int n) {
        this.byte_order = n;
    }

    public String getByte_size() {
        return this.byte_size;
    }

    public void setByte_size(String string) {
        this.byte_size = string;
    }

    public String getCharacter_size() {
        return this.character_size;
    }

    public void setCharacter_size(String string) {
        this.character_size = string;
    }

    public int getLinebreak() {
        return this.linebreak;
    }

    public String getLinebreakString() {
        if (this.linebreak == -1) {
            return LINEBREAK[2];
        }
        return LINEBREAK[this.linebreak];
    }

    public void setLinebreak(int n) {
        this.linebreak = n;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = TextMDMetadata.toISO_639_2(string);
    }

    public String getMarkup_basis() {
        return this.markup_basis;
    }

    public void setMarkup_basis(String string) {
        this.markup_basis = string;
    }

    public String getMarkup_basis_version() {
        return this.markup_basis_version;
    }

    public void setMarkup_basis_version(String string) {
        this.markup_basis_version = string;
    }

    public String getMarkup_language() {
        return this.markup_language;
    }

    public void setMarkup_language(String string) {
        this.markup_language = string;
    }

    public String getMarkup_language_version() {
        return this.markup_language_version;
    }

    public void setMarkup_language_version(String string) {
        this.markup_language_version = string;
    }

    public static String toTextMDCharset(String string) {
        if (string == null) {
            return null;
        }
        Charset charset = null;
        String string2 = null;
        try {
            charset = Charset.forName(string);
            string2 = charset.name();
        }
        catch (Exception exception) {
            string2 = setOfUnknownJavaCharset.contains(string) ? string : CHARSET_ISO8859_1;
        }
        if (string2 != null) {
            return string2;
        }
        return CHARSET_ISO8859_1;
    }

    public static String toISO_639_2(String string) {
        if (string == null) {
            return null;
        }
        if ("qaa-qtz".equals(string)) {
            return string;
        }
        String string2 = null;
        if (string.length() == 3) {
            string2 = string;
        } else if (string.length() == 2) {
            try {
                Locale locale = new Locale(string);
                string2 = locale.getISO3Language();
            }
            catch (Exception exception) {}
        } else if (string.length() > 3) {
            try {
                Locale locale = new Locale(string.substring(0, 2));
                string = locale.getISO3Language();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null && string2.length() == 3) {
            if (fromISO_639_2_T2B.containsKey(string2)) {
                string2 = (String)fromISO_639_2_T2B.get(string2);
            }
            return string2;
        }
        return null;
    }

    static {
        fromISO_639_2_T2B.put("sqi", "alb");
        fromISO_639_2_T2B.put("hye", "arm");
        fromISO_639_2_T2B.put("eus", "baq");
        fromISO_639_2_T2B.put("mya", "bur");
        fromISO_639_2_T2B.put("zho", "chi");
        fromISO_639_2_T2B.put("ces", "cze");
        fromISO_639_2_T2B.put("nld", "dut");
        fromISO_639_2_T2B.put("fra", "fre");
        fromISO_639_2_T2B.put("kat", "geo");
        fromISO_639_2_T2B.put("deu", "ger");
        fromISO_639_2_T2B.put("ell", "gre");
        fromISO_639_2_T2B.put("isl", "ice");
        fromISO_639_2_T2B.put("mkd", "mac");
        fromISO_639_2_T2B.put("mri", "mao");
        fromISO_639_2_T2B.put("msa", "may");
        fromISO_639_2_T2B.put("fas", "per");
        fromISO_639_2_T2B.put("ron", "rum");
        fromISO_639_2_T2B.put("slk", "slo");
        fromISO_639_2_T2B.put("bod", "tib");
        fromISO_639_2_T2B.put("cym", "wel");
    }
}

