/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui.skins;

import java.awt.Color;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkinUtils {
    private static final Log log = LogFactory.getLog(SkinUtils.class);

    public Color loadColor(Properties skinProperties, String colorPropertyName) {
        Color color = null;
        String colorValue = skinProperties.getProperty(colorPropertyName, null);
        log.debug((Object)("Loading skin color with property '" + colorPropertyName + "', value: " + colorValue));
        if (colorValue != null) {
            color = Color.decode(colorValue);
        } else {
            log.warn((Object)("Color is not available for property '" + colorPropertyName + "'"));
        }
        return color;
    }

    public ImageIcon loadIcon(Properties skinProperties, String iconPathPropertyName) {
        ImageIcon imageIcon = null;
        String imageIconPath = skinProperties.getProperty(iconPathPropertyName, null);
        log.debug((Object)("Loading image icon with property '" + iconPathPropertyName + "', value: " + imageIconPath));
        if (imageIconPath != null && imageIconPath.length() > 0) {
            URL iconURL = this.getClass().getResource(imageIconPath);
            if (iconURL != null) {
                imageIcon = new ImageIcon(iconURL);
            } else {
                log.warn((Object)("Image icon resources is not available in classpath for path '" + imageIconPath + "'"));
            }
        } else {
            log.warn((Object)("Image icon path is not available for property '" + iconPathPropertyName + "'"));
        }
        return imageIcon;
    }
}

