/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ResponseXml/ManifestXml.h"

#include "Doc/ResponseDoc/CManifestCollectionDoc.h"
#include "Doc/ResponseDoc/CManifestDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ResponseXml/ManifestCollectionXml.h"

using namespace Caf;

void ManifestCollectionXml::add(
	const SmartPtrCManifestCollectionDoc manifestCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ManifestCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(manifestCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCManifestDoc> manifestVal =
			manifestCollectionDoc->getManifest();
		CAF_CM_VALIDATE_STL(manifestVal);

		if (! manifestVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCManifestDoc> > manifestIter(manifestVal);
				manifestIter; manifestIter++) {
				const SmartPtrCXmlElement manifestXml =
					thisXml->createAndAddElement("manifest");
				ManifestXml::add(*manifestIter, manifestXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCManifestCollectionDoc ManifestCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ManifestCollectionXml", "parse");

	SmartPtrCManifestCollectionDoc manifestCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection manifestChildrenXml =
			thisXml->findRequiredChildren("manifest");

		std::deque<SmartPtrCManifestDoc> manifestVal;
		if (! manifestChildrenXml.IsNull() && ! manifestChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> manifestXmlIter(*manifestChildrenXml);
				manifestXmlIter; manifestXmlIter++) {
				const SmartPtrCXmlElement manifestXml = manifestXmlIter->second;
				const SmartPtrCManifestDoc manifestDoc =
					ManifestXml::parse(manifestXml);
				manifestVal.push_back(manifestDoc);
			}
		}

		manifestCollectionDoc.CreateInstance();
		manifestCollectionDoc->initialize(
			manifestVal);
	}
	CAF_CM_EXIT;

	return manifestCollectionDoc;
}

