#!/bin/sh

set -e

APT_LOGS=$(mktemp ${AUTOPKGTEST_TMP}/apt_XXXX.log)

# Create a dummy service with a nested proc hierarchy that ends up with a
# needrestart call after an APT transaction that should make pretty much all
# daemons outdated.
systemd-run -q --wait -u nested-service bash -c "$PWD/debian/tests/restart-libc6-once.sh $APT_LOGS"

cat $APT_LOGS

if awk '/Service restarts being deferred:/,/END/' $APT_LOGS | grep -q 'systemctl restart nested-service'; then
    echo OK
else
    echo nested-service not found in deferred restarts!
    exit 1
fi
