/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.TesterAnnotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public enum MapFeature implements Feature<Map>
{
    ALLOWS_NULL_QUERIES(new Feature[0]),
    ALLOWS_NULL_KEYS(ALLOWS_NULL_QUERIES),
    ALLOWS_NULL_VALUES(new Feature[0]),
    RESTRICTS_KEYS(new Feature[0]),
    RESTRICTS_VALUES(new Feature[0]),
    SUPPORTS_PUT(new Feature[0]),
    SUPPORTS_REMOVE(new Feature[0]),
    FAILS_FAST_ON_CONCURRENT_MODIFICATION(new Feature[0]),
    REJECTS_DUPLICATES_AT_CREATION(new Feature[0]),
    GENERAL_PURPOSE(SUPPORTS_PUT, SUPPORTS_REMOVE);

    private final Set<Feature<? super Map>> implied;

    private MapFeature(Feature<? super Map> ... implied) {
        this.implied = Helpers.copyToSet(implied);
    }

    @Override
    public Set<Feature<? super Map>> getImpliedFeatures() {
        return this.implied;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @TesterAnnotation
    public static @interface Require {
        public MapFeature[] value() default {};

        public MapFeature[] absent() default {};
    }
}

