package mediaservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// OperationsClient is the media Services resource management APIs.
type OperationsClient struct {
	ManagementClient
}

// NewOperationsClient creates an instance of the OperationsClient client.
func NewOperationsClient(subscriptionID string) OperationsClient {
	return NewOperationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewOperationsClientWithBaseURI creates an instance of the OperationsClient
// client.
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return OperationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailabilty sends the check name availabilty request.
//
// checkNameAvailabilityInput is properties needed to check the availability
// of a name.
func (client OperationsClient) CheckNameAvailabilty(checkNameAvailabilityInput CheckNameAvailabilityInput) (result CheckNameAvailabilityOutput, err error) {
	req, err := client.CheckNameAvailabiltyPreparer(checkNameAvailabilityInput)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "CheckNameAvailabilty", nil, "Failure preparing request")
	}

	resp, err := client.CheckNameAvailabiltySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "CheckNameAvailabilty", resp, "Failure sending request")
	}

	result, err = client.CheckNameAvailabiltyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "CheckNameAvailabilty", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabiltyPreparer prepares the CheckNameAvailabilty request.
func (client OperationsClient) CheckNameAvailabiltyPreparer(checkNameAvailabilityInput CheckNameAvailabilityInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Media/CheckNameAvailability", pathParameters),
		autorest.WithJSON(checkNameAvailabilityInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CheckNameAvailabiltySender sends the CheckNameAvailabilty request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) CheckNameAvailabiltySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CheckNameAvailabiltyResponder handles the response to the CheckNameAvailabilty request. The method always
// closes the http.Response Body.
func (client OperationsClient) CheckNameAvailabiltyResponder(resp *http.Response) (result CheckNameAvailabilityOutput, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Create sends the create request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service. mediaService
// is media Service properties needed for creation.
func (client OperationsClient) Create(resourceGroupName string, mediaServiceName string, mediaService MediaService) (result MediaService, err error) {
	req, err := client.CreatePreparer(resourceGroupName, mediaServiceName, mediaService)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Create", nil, "Failure preparing request")
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Create", resp, "Failure sending request")
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client OperationsClient) CreatePreparer(resourceGroupName string, mediaServiceName string, mediaService MediaService) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", pathParameters),
		autorest.WithJSON(mediaService),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client OperationsClient) CreateResponder(resp *http.Response) (result MediaService, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete sends the delete request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service.
func (client OperationsClient) Delete(resourceGroupName string, mediaServiceName string) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(resourceGroupName, mediaServiceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Delete", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Delete", resp, "Failure sending request")
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client OperationsClient) DeletePreparer(resourceGroupName string, mediaServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client OperationsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service.
func (client OperationsClient) Get(resourceGroupName string, mediaServiceName string) (result MediaService, err error) {
	req, err := client.GetPreparer(resourceGroupName, mediaServiceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client OperationsClient) GetPreparer(resourceGroupName string, mediaServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client OperationsClient) GetResponder(resp *http.Response) (result MediaService, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup sends the list by resource group request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription.
func (client OperationsClient) ListByResourceGroup(resourceGroupName string) (result MediaServiceCollection, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListByResourceGroup", nil, "Failure preparing request")
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListByResourceGroup", resp, "Failure sending request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client OperationsClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client OperationsClient) ListByResourceGroupResponder(resp *http.Response) (result MediaServiceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListKeys sends the list keys request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service.
func (client OperationsClient) ListKeys(resourceGroupName string, mediaServiceName string) (result ServiceKeys, err error) {
	req, err := client.ListKeysPreparer(resourceGroupName, mediaServiceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListKeys", nil, "Failure preparing request")
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListKeys", resp, "Failure sending request")
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client OperationsClient) ListKeysPreparer(resourceGroupName string, mediaServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client OperationsClient) ListKeysResponder(resp *http.Response) (result ServiceKeys, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RegenerateKey sends the regenerate key request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service.
// regenerateKeyInput is properties needed to regenerate the Media Service
// key.
func (client OperationsClient) RegenerateKey(resourceGroupName string, mediaServiceName string, regenerateKeyInput RegenerateKeyInput) (result RegenerateKeyOutput, err error) {
	req, err := client.RegenerateKeyPreparer(resourceGroupName, mediaServiceName, regenerateKeyInput)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "RegenerateKey", nil, "Failure preparing request")
	}

	resp, err := client.RegenerateKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "RegenerateKey", resp, "Failure sending request")
	}

	result, err = client.RegenerateKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "RegenerateKey", resp, "Failure responding to request")
	}

	return
}

// RegenerateKeyPreparer prepares the RegenerateKey request.
func (client OperationsClient) RegenerateKeyPreparer(resourceGroupName string, mediaServiceName string, regenerateKeyInput RegenerateKeyInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/regenerateKey", pathParameters),
		autorest.WithJSON(regenerateKeyInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RegenerateKeySender sends the RegenerateKey request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) RegenerateKeySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RegenerateKeyResponder handles the response to the RegenerateKey request. The method always
// closes the http.Response Body.
func (client OperationsClient) RegenerateKeyResponder(resp *http.Response) (result RegenerateKeyOutput, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SyncStorageKeys sends the sync storage keys request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service.
// syncStorageKeysInput is properties needed to sycnronize the keys for a
// storage account to the Media Service.
func (client OperationsClient) SyncStorageKeys(resourceGroupName string, mediaServiceName string, syncStorageKeysInput SyncStorageKeysInput) (result MediaService, err error) {
	req, err := client.SyncStorageKeysPreparer(resourceGroupName, mediaServiceName, syncStorageKeysInput)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "SyncStorageKeys", nil, "Failure preparing request")
	}

	resp, err := client.SyncStorageKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "SyncStorageKeys", resp, "Failure sending request")
	}

	result, err = client.SyncStorageKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "SyncStorageKeys", resp, "Failure responding to request")
	}

	return
}

// SyncStorageKeysPreparer prepares the SyncStorageKeys request.
func (client OperationsClient) SyncStorageKeysPreparer(resourceGroupName string, mediaServiceName string, syncStorageKeysInput SyncStorageKeysInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/syncStorageKeys", pathParameters),
		autorest.WithJSON(syncStorageKeysInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncStorageKeysSender sends the SyncStorageKeys request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) SyncStorageKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncStorageKeysResponder handles the response to the SyncStorageKeys request. The method always
// closes the http.Response Body.
func (client OperationsClient) SyncStorageKeysResponder(resp *http.Response) (result MediaService, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update sends the update request.
//
// resourceGroupName is name of the resource group within the Azure
// subscription. mediaServiceName is name of the Media Service. mediaService
// is media Service properties needed for update.
func (client OperationsClient) Update(resourceGroupName string, mediaServiceName string, mediaService MediaService) (result MediaService, err error) {
	req, err := client.UpdatePreparer(resourceGroupName, mediaServiceName, mediaService)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Update", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Update", resp, "Failure sending request")
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mediaservices.OperationsClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client OperationsClient) UpdatePreparer(resourceGroupName string, mediaServiceName string, mediaService MediaService) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"mediaServiceName":  autorest.Encode("path", mediaServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", pathParameters),
		autorest.WithJSON(mediaService),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client OperationsClient) UpdateResponder(resp *http.Response) (result MediaService, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
