/* cheese-window.c generated by valac 0.39.7.25-e3fff, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cheese-camera-device.h>
#include <cairo.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <float.h>
#include <math.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
enum  {
	CHEESE_MAIN_WINDOW_0_PROPERTY,
	CHEESE_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* cheese_main_window_properties[CHEESE_MAIN_WINDOW_NUM_PROPERTIES];

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	ClutterScript* clutter_builder;
	GtkBuilder* header_bar_ui;
	GtkHeaderBar* header_bar;
	GSettings* settings;
	GtkClutterEmbed* viewport_widget;
	GtkWidget* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkBox* thumbnails_right;
	GtkBox* thumbnails_bottom;
	GtkWidget* leave_fullscreen_button_box;
	GtkButton* take_action_button;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkWidget* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterActor* viewport_layout;
	ClutterActor* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterActor* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterActor* current_effects_grid;
	guint current_effects_page;
	GList* effects_grids;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean action_cancelled;
	gboolean was_maximized;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE ((guint) 9)
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void cheese_main_window_on_file_open (CheeseMainWindow* self);
static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self);
static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void cheese_main_window_on_file_trash (CheeseMainWindow* self);
static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void cheese_main_window_on_file_delete (CheeseMainWindow* self);
static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void cheese_main_window_on_effects_next (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type,
                                                GtkApplication* application);
static void cheese_main_window_set_window_title (CheeseMainWindow* self,
                                          const gchar* title);
static gboolean cheese_main_window_on_window_state_change_event (CheeseMainWindow* self,
                                                          GtkWidget* widget,
                                                          GdkEventWindowState* event);
static gboolean _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                         GdkEventWindowState* event,
                                                                                         gpointer self);
static void cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self,
                                                  GtkWidget* widget,
                                                  guint button,
                                                  guint time);
static gboolean cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self,
                                                      GtkWidget* thumbview);
gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self,
                                                             GtkWidget* iconview,
                                                             GdkEventButton* event);
static void _vala_GtkTreePath_free (GtkTreePath* self);
void cheese_main_window_set_fullscreen (CheeseMainWindow* self,
                                        gboolean fullscreen);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self,
                                             gboolean fullscreen);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self,
                                        CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda4_ (CheeseMainWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self,
                                                               GtkWidget* viewport,
                                                               GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                               GdkEventMotion* event,
                                                                                               gpointer self);
void cheese_main_window_set_wide_mode (CheeseMainWindow* self,
                                       gboolean wide_mode);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self,
                                         ClutterActor* actor,
                                         ClutterActorBox* box,
                                         ClutterAllocationFlags flags);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type,
                                             ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self,
                             CheeseCountdownCountdownCallback completed_callback,
                             void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self,
                                               gboolean is_start);
static gboolean cheese_main_window_cancel_running_action (CheeseMainWindow* self);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self,
                                                gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self,
                                            GdkEventKey* event);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_show_error (CheeseMainWindow* self,
                                    const gchar* _error_);
void cheese_main_window_set_effects (CheeseMainWindow* self,
                                     gboolean effects);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self,
                                                 gboolean active);
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self,
                                                   ClutterTapAction* tap,
                                                   ClutterActor* source);
static gboolean cheese_main_window_is_previous_effects_page (CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self,
                                               gint number);
static gboolean cheese_main_window_is_next_effects_page (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_update_header_bar_title (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                                           ClutterActor* actor,
                                                                           gpointer self);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self,
                                                 const gchar* name);
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                                           ClutterActorBox* box,
                                                                           ClutterAllocationFlags flags,
                                                                           gpointer self);
static gboolean _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                             gpointer self);
static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                            GdkEventButton* event,
                                                                                            gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self);
ClutterActor* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_current_mode (CheeseMainWindow* self,
                                          CheeseMediaMode mode);
void cheese_main_window_set_camera (CheeseMainWindow* self,
                                    CheeseCamera* camera);
static void cheese_main_window_finalize (GObject * obj);

static const GActionEntry CHEESE_MAIN_WINDOW_actions[6] = {{"file-open", _cheese_main_window_on_file_open_gsimple_action_activate_callback}, {"file-saveas", _cheese_main_window_on_file_saveas_gsimple_action_activate_callback}, {"file-trash", _cheese_main_window_on_file_trash_gsimple_action_activate_callback}, {"file-delete", _cheese_main_window_on_file_delete_gsimple_action_activate_callback}, {"effects-next", _cheese_main_window_on_effects_next_gsimple_action_activate_callback}, {"effects-previous", _cheese_main_window_on_effects_previous_gsimple_action_activate_callback}};

/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType
cheese_main_window_delete_response_get_type (void)
{
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void
_cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	cheese_main_window_on_file_open ((CheeseMainWindow*) self);
}


static void
_cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	cheese_main_window_on_file_saveas ((CheeseMainWindow*) self);
}


static void
_cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	cheese_main_window_on_file_trash ((CheeseMainWindow*) self);
}


static void
_cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	cheese_main_window_on_file_delete ((CheeseMainWindow*) self);
}


static void
_cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	cheese_main_window_on_effects_next ((CheeseMainWindow*) self);
}


static void
_cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	cheese_main_window_on_effects_previous ((CheeseMainWindow*) self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


CheeseMainWindow*
cheese_main_window_construct (GType object_type,
                              GtkApplication* application)
{
	CheeseMainWindow * self = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkSettings* settings = NULL;
	GtkSettings* _tmp3_;
	GtkSettings* _tmp4_;
	GtkSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (CheeseMainWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->header_bar_ui;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "header_bar");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp1_) : NULL);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp2_;
	_tmp3_ = gtk_settings_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	settings = _tmp4_;
	_tmp5_ = settings;
	g_object_get (_tmp5_, "gtk-dialogs-use-header", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkHeaderBar* _tmp8_;
		GtkHeaderBar* _tmp9_;
		_tmp8_ = self->priv->header_bar;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
		_tmp9_ = self->priv->header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp9_);
	}
	_g_object_unref0 (settings);
	return self;
}


CheeseMainWindow*
cheese_main_window_new (GtkApplication* application)
{
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}


static void
cheese_main_window_set_window_title (CheeseMainWindow* self,
                                     const gchar* title)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->header_bar;
	gtk_header_bar_set_title (_tmp0_, title);
	gtk_window_set_title ((GtkWindow*) self, title);
}


static gboolean
_cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                GdkEventWindowState* event,
                                                                                gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_window_state_change_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static gboolean
cheese_main_window_on_window_state_change_event (CheeseMainWindow* self,
                                                 GtkWidget* widget,
                                                 GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->new_window_state;
	_tmp1_ = event->changed_mask;
	self->priv->was_maximized = ((_tmp0_ - _tmp1_) & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	g_signal_parse_name ("window-state-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self);
	result = FALSE;
	return result;
}


static void
cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self,
                                             GtkWidget* widget,
                                             guint button,
                                             guint time)
{
	GtkMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->thumbnail_popup;
	gtk_menu_popup (_tmp0_, NULL, widget, NULL, NULL, button, (guint32) time);
}


static gboolean
cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self,
                                             GtkWidget* thumbview)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (thumbview != NULL, FALSE);
	cheese_main_window_do_thumb_view_popup_menu (self, thumbview, (guint) 0, (guint) 0);
	result = TRUE;
	return result;
}


/**
    * Popup a context menu when right-clicking on a thumbnail.
    *
    * @param iconview the thumbnail view that emitted the signal
    * @param event the event
    * @return false to allow further processing of the event, true to indicate
    * that the event was handled completely
    */
static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}


gboolean
cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self,
                                                    GtkWidget* iconview,
                                                    GdkEventButton* event)
{
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	CheeseThumbView* _tmp5_;
	GtkTreePath* _tmp6_;
	GdkEventType _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = event->x;
	_tmp2_ = event->y;
	_tmp3_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp1_, (gint) _tmp2_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	_tmp5_ = self->priv->thumb_view;
	_tmp6_ = path;
	if (!gtk_icon_view_path_is_selected ((GtkIconView*) _tmp5_, _tmp6_)) {
		CheeseThumbView* _tmp7_;
		CheeseThumbView* _tmp8_;
		GtkTreePath* _tmp9_;
		CheeseThumbView* _tmp10_;
		GtkTreePath* _tmp11_;
		_tmp7_ = self->priv->thumb_view;
		gtk_icon_view_unselect_all ((GtkIconView*) _tmp7_);
		_tmp8_ = self->priv->thumb_view;
		_tmp9_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp8_, _tmp9_);
		_tmp10_ = self->priv->thumb_view;
		_tmp11_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp10_, _tmp11_, NULL, FALSE);
	}
	_tmp12_ = event->type;
	if (_tmp12_ == GDK_BUTTON_PRESS) {
		GdkEvent* button_press = NULL;
		GdkEvent* _tmp13_;
		button_press = (GdkEvent*) event;
		_tmp13_ = button_press;
		if (gdk_event_triggers_context_menu (_tmp13_)) {
			CheeseThumbView* _tmp14_;
			guint _tmp15_;
			guint32 _tmp16_;
			_tmp14_ = self->priv->thumb_view;
			_tmp15_ = event->button;
			_tmp16_ = event->time;
			cheese_main_window_do_thumb_view_popup_menu (self, (GtkWidget*) _tmp14_, _tmp15_, (guint) _tmp16_);
			result = TRUE;
			__vala_GtkTreePath_free0 (path);
			return result;
		}
	} else {
		GdkEventType _tmp17_;
		_tmp17_ = event->type;
		if (_tmp17_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (self);
			result = TRUE;
			__vala_GtkTreePath_free0 (path);
			return result;
		}
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   */
static void
cheese_main_window_on_file_open (CheeseMainWindow* self)
{
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GdkScreen* _tmp7_;
		GdkScreen* _tmp8_;
		GdkScreen* _tmp9_;
		const gchar* _tmp10_;
		_tmp4_ = filename;
		_tmp5_ = g_filename_to_uri (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (uri);
		uri = _tmp6_;
		_tmp7_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (screen);
		screen = _tmp8_;
		_tmp9_ = screen;
		_tmp10_ = uri;
		gtk_show_uri (_tmp9_, _tmp10_, gtk_get_current_event_time (), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp3_);
			goto __catch4_g_error;
		}
		_g_free0 (_tmp3_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GtkMessageDialog* error_dialog = NULL;
		const gchar* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = filename;
		_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not open %s"), _tmp11_);
		g_object_ref_sink (_tmp12_);
		error_dialog = _tmp12_;
		_tmp13_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp13_);
		_tmp14_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp14_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   */
static void
cheese_main_window_on_file_delete (CheeseMainWindow* self)
{
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors = FALSE;
	GList* files = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_;
	guint files_length = 0U;
	GList* _tmp2_;
	GtkMessageDialog* confirmation_dialog = NULL;
	guint _tmp3_;
	guint _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp8_;
	guint _tmp9_;
	GtkMessageDialog* _tmp10_;
	gint _tmp11_;
	GtkMessageDialog* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	files_length = g_list_length (_tmp2_);
	_tmp3_ = files_length;
	_tmp4_ = files_length;
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp3_), _tmp4_);
	g_object_ref_sink (_tmp5_);
	confirmation_dialog = _tmp5_;
	_tmp6_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp6_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp7_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _ ("_Delete"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp8_ = confirmation_dialog;
	_tmp9_ = files_length;
	gtk_message_dialog_format_secondary_text (_tmp8_, "%s", ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp9_));
	_tmp10_ = confirmation_dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp10_);
	_tmp11_ = response;
	if (_tmp11_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp12_;
		_tmp12_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp12_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp13_;
				GFile* file = NULL;
				_tmp13_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp13_;
				{
					GFile* _tmp14_;
					_tmp14_ = file;
					if (_tmp14_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp15_;
						_tmp15_ = file;
						g_file_delete (_tmp15_, NULL, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch5_g_error;
						}
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* err = NULL;
						GError* _tmp16_;
						const gchar* _tmp17_;
						gboolean _tmp18_;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp16_ = err;
						_tmp17_ = _tmp16_->message;
						g_warning ("cheese-window.vala:285: Unable to delete file: %s", _tmp17_);
						_tmp18_ = skip_all_errors;
						if (!_tmp18_) {
							GtkMessageDialog* error_dialog = NULL;
							GFile* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							GtkMessageDialog* _tmp22_;
							GtkMessageDialog* _tmp23_;
							GtkMessageDialog* _tmp24_;
							GtkMessageDialog* _tmp25_;
							GtkMessageDialog* _tmp26_;
							GtkMessageDialog* _tmp27_;
							gint _tmp28_;
							GtkMessageDialog* _tmp30_;
							_tmp19_ = file;
							_tmp20_ = g_file_get_path (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _ ("Could not delete %s"), _tmp21_);
							g_object_ref_sink (_tmp22_);
							_tmp23_ = _tmp22_;
							_g_free0 (_tmp21_);
							error_dialog = _tmp23_;
							_tmp24_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp24_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
							_tmp25_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp25_, _ ("Skip"), (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp26_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp26_, _ ("Skip all"), (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp27_ = error_dialog;
							error_response = gtk_dialog_run ((GtkDialog*) _tmp27_);
							_tmp28_ = error_response;
							if (_tmp28_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp29_;
								_tmp29_ = error_response;
								if (_tmp29_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp30_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp30_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally5:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp31_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp31_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   */
static void
cheese_main_window_on_file_trash (CheeseMainWindow* self)
{
	GFile* file = NULL;
	GList* files = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				GList* _tmp5_;
				GList* _tmp6_;
				gint _tmp7_;
				GList* _tmp8_;
				gconstpointer _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = files;
				if (!(((guint) _tmp4_) < g_list_length (_tmp5_))) {
					break;
				}
				_tmp6_ = files;
				_tmp7_ = i;
				_tmp8_ = g_list_nth (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _tmp8_->data;
				_tmp10_ = _g_object_ref0 ((GFile*) _tmp9_);
				_g_object_unref0 (file);
				file = _tmp10_;
				_tmp11_ = file;
				if (_tmp11_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp12_;
					_tmp12_ = file;
					g_file_trash (_tmp12_, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* err = NULL;
					GtkMessageDialog* error_dialog = NULL;
					GFile* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					GtkMessageDialog* _tmp16_;
					GtkMessageDialog* _tmp17_;
					GtkMessageDialog* _tmp18_;
					GtkMessageDialog* _tmp19_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp13_ = file;
					_tmp14_ = g_file_get_path (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not move %s to trash"), _tmp15_);
					g_object_ref_sink (_tmp16_);
					_tmp17_ = _tmp16_;
					_g_free0 (_tmp15_);
					error_dialog = _tmp17_;
					_tmp18_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp18_);
					_tmp19_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp19_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   */
static void
cheese_main_window_on_file_saveas (CheeseMainWindow* self)
{
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	const gchar* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	const gchar* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	gint _tmp13_;
	GtkFileChooserDialog* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("Save"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp3_;
	_tmp4_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp4_, TRUE);
	_tmp5_ = filename;
	_tmp6_ = g_filename_display_basename (_tmp5_);
	_g_free0 (basename);
	basename = _tmp6_;
	_tmp7_ = save_as_dialog;
	_tmp8_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp7_, _tmp8_);
	_tmp9_ = save_as_dialog;
	_tmp10_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp9_, _tmp10_);
	_tmp11_ = save_as_dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp11_);
	_tmp12_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	_tmp13_ = response;
	if (_tmp13_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp14_;
		gchar* _tmp15_;
		GFile* src = NULL;
		const gchar* _tmp16_;
		GFile* _tmp17_;
		GFile* dest = NULL;
		const gchar* _tmp18_;
		GFile* _tmp19_;
		_tmp14_ = save_as_dialog;
		_tmp15_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp14_);
		_g_free0 (target_filename);
		target_filename = _tmp15_;
		_tmp16_ = filename;
		_tmp17_ = g_file_new_for_path (_tmp16_);
		src = _tmp17_;
		_tmp18_ = target_filename;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		dest = _tmp19_;
		{
			GFile* _tmp20_;
			GFile* _tmp21_;
			_tmp20_ = src;
			_tmp21_ = dest;
			g_file_copy (_tmp20_, _tmp21_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* err = NULL;
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp22_;
			GtkMessageDialog* _tmp23_;
			GtkMessageDialog* _tmp24_;
			GtkMessageDialog* _tmp25_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = target_filename;
			_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not save %s"), _tmp22_);
			g_object_ref_sink (_tmp23_);
			error_dialog = _tmp23_;
			_tmp24_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp24_);
			_tmp25_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp25_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp26_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp26_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
     * Toggle fullscreen mode.
     *
     * @param fullscreen whether the window should be fullscreen
     */
void
cheese_main_window_set_fullscreen (CheeseMainWindow* self,
                                   gboolean fullscreen)
{
	g_return_if_fail (self != NULL);
	cheese_main_window_set_fullscreen_mode (self, fullscreen);
}


/**
     * Make the media capture mode actions sensitive.
     */
static void
cheese_main_window_enable_mode_change (CheeseMainWindow* self)
{
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_;
	GtkApplication* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, TRUE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, TRUE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, TRUE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
     * Make the media capture mode actions insensitive.
     */
static void
cheese_main_window_disable_mode_change (CheeseMainWindow* self)
{
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_;
	GtkApplication* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, FALSE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, FALSE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, FALSE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void
cheese_main_window_set_resolution (CheeseMainWindow* self,
                                   CheeseMediaMode mode)
{
	CheeseCamera* _tmp0_;
	GList* formats = NULL;
	CheeseCamera* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	CheeseVideoFormat* format = NULL;
	gint width = 0;
	gint height = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		_g_list_free0 (formats);
		return;
	}
	width = 0;
	height = 0;
	switch (mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp4_;
			GSettings* _tmp5_;
			_tmp4_ = self->priv->settings;
			width = g_settings_get_int (_tmp4_, "photo-x-resolution");
			_tmp5_ = self->priv->settings;
			height = g_settings_get_int (_tmp5_, "photo-y-resolution");
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp6_;
			GSettings* _tmp7_;
			_tmp6_ = self->priv->settings;
			width = g_settings_get_int (_tmp6_, "video-x-resolution");
			_tmp7_ = self->priv->settings;
			height = g_settings_get_int (_tmp7_, "video-y-resolution");
			break;
		}
		default:
		break;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				GList* _tmp11_;
				GList* _tmp12_;
				gint _tmp13_;
				GList* _tmp14_;
				gconstpointer _tmp15_;
				gboolean _tmp16_ = FALSE;
				gint _tmp17_;
				CheeseVideoFormat* _tmp18_;
				gint _tmp19_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = formats;
				if (!(((guint) _tmp10_) < g_list_length (_tmp11_))) {
					break;
				}
				_tmp12_ = formats;
				_tmp13_ = i;
				_tmp14_ = g_list_nth (_tmp12_, (guint) _tmp13_);
				_tmp15_ = _tmp14_->data;
				format = (CheeseVideoFormat*) _tmp15_;
				_tmp17_ = width;
				_tmp18_ = format;
				_tmp19_ = _tmp18_->width;
				if (_tmp17_ == _tmp19_) {
					gint _tmp20_;
					CheeseVideoFormat* _tmp21_;
					gint _tmp22_;
					_tmp20_ = height;
					_tmp21_ = format;
					_tmp22_ = _tmp21_->height;
					_tmp16_ = _tmp20_ == _tmp22_;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					CheeseCamera* _tmp23_;
					CheeseVideoFormat* _tmp24_;
					_tmp23_ = self->priv->camera;
					_tmp24_ = format;
					cheese_camera_set_video_format (_tmp23_, _tmp24_);
					break;
				}
			}
		}
	}
	_g_list_free0 (formats);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void
cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self)
{
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean
__lambda4_ (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide (_tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_fullscreen ((GtkWindow*) self);
	result = TRUE;
	return result;
}


static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((CheeseMainWindow*) self);
	return result;
}


static void
cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self)
{
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


/**
     * Show the UI in fullscreen if there is any mouse activity.
     *
     * Start a new timeout at the end of every mouse pointer movement. All
     * timeouts will be cancelled, except one created during the last movement
     * event. Show() is called even if the button is not hidden.
     *
     * @param viewport the widget to check for mouse activity on
     * @param e the (unused) event
     */
static gboolean
cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self,
                                                      GtkWidget* viewport,
                                                      GdkEventMotion* e)
{
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_unfullscreen ((GtkWindow*) self);
	gtk_window_maximize ((GtkWindow*) self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show (_tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean
_cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                      GdkEventMotion* event,
                                                                                      gpointer self)
{
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static void
cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self,
                                        gboolean fullscreen)
{
	g_return_if_fail (self != NULL);
	self->priv->is_fullscreen = fullscreen;
	if (fullscreen) {
		gboolean _tmp0_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkClutterEmbed* _tmp5_;
		g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self, 0);
		_tmp0_ = self->priv->is_wide_mode;
		if (_tmp0_) {
			GtkBox* _tmp1_;
			_tmp1_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp1_);
		} else {
			GtkBox* _tmp2_;
			_tmp2_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp2_);
		}
		_tmp3_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_set_no_show_all (_tmp3_, FALSE);
		_tmp4_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_show_all (_tmp4_);
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp5_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp5_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp6_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkClutterEmbed* _tmp11_;
		guint _tmp12_;
		gboolean _tmp13_;
		_tmp6_ = self->priv->is_wide_mode;
		if (_tmp6_) {
			GtkBox* _tmp7_;
			_tmp7_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp7_);
		} else {
			GtkBox* _tmp8_;
			_tmp8_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp8_);
		}
		_tmp9_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_hide (_tmp9_);
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp10_ = self->priv->buttons_area;
		gtk_widget_show (_tmp10_);
		_tmp11_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
		_tmp13_ = self->priv->was_maximized;
		if (_tmp13_) {
			gtk_window_maximize ((GtkWindow*) self);
		} else {
			gtk_window_unmaximize ((GtkWindow*) self);
		}
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
void
cheese_main_window_set_wide_mode (CheeseMainWindow* self,
                                  gboolean wide_mode)
{
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkClutterEmbed* _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	GtkRequisition req = {0};
	GtkRequisition _tmp34_ = {0};
	GtkRequisition _tmp35_ = {0};
	GtkRequisition _tmp36_;
	gint _tmp37_;
	GtkRequisition _tmp38_;
	gint _tmp39_;
	GtkClutterEmbed* _tmp40_;
	g_return_if_fail (self != NULL);
	self->priv->is_wide_mode = wide_mode;
	_tmp0_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = self->priv->viewport_widget;
	_tmp3_ = alloc;
	_tmp4_ = _tmp3_.width;
	_tmp5_ = alloc;
	_tmp6_ = _tmp5_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, _tmp4_, _tmp6_);
	_tmp7_ = self->priv->is_wide_mode;
	if (_tmp7_) {
		CheeseThumbView* _tmp8_;
		EogThumbNav* _tmp9_;
		GtkBox* _tmp10_;
		GList* _tmp11_;
		GList* _tmp12_;
		gboolean _tmp13_;
		GtkBox* _tmp16_;
		EogThumbNav* _tmp17_;
		gboolean _tmp18_;
		_tmp8_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp8_, TRUE);
		_tmp9_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp9_, TRUE);
		_tmp10_ = self->priv->thumbnails_bottom;
		_tmp11_ = gtk_container_get_children ((GtkContainer*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_g_list_free0 (_tmp12_);
		if (_tmp13_) {
			GtkBox* _tmp14_;
			EogThumbNav* _tmp15_;
			_tmp14_ = self->priv->thumbnails_bottom;
			_tmp15_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
		}
		_tmp16_ = self->priv->thumbnails_right;
		_tmp17_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->is_fullscreen;
		if (!_tmp18_) {
			GtkBox* _tmp19_;
			GtkBox* _tmp20_;
			_tmp19_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp19_);
			_tmp20_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp20_);
		}
	} else {
		CheeseThumbView* _tmp21_;
		EogThumbNav* _tmp22_;
		GtkBox* _tmp23_;
		GList* _tmp24_;
		GList* _tmp25_;
		gboolean _tmp26_;
		GtkBox* _tmp29_;
		EogThumbNav* _tmp30_;
		gboolean _tmp31_;
		_tmp21_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp22_, FALSE);
		_tmp23_ = self->priv->thumbnails_right;
		_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_ != NULL;
		_g_list_free0 (_tmp25_);
		if (_tmp26_) {
			GtkBox* _tmp27_;
			EogThumbNav* _tmp28_;
			_tmp27_ = self->priv->thumbnails_right;
			_tmp28_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
		}
		_tmp29_ = self->priv->thumbnails_bottom;
		_tmp30_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
		_tmp31_ = self->priv->is_fullscreen;
		if (!_tmp31_) {
			GtkBox* _tmp32_;
			GtkBox* _tmp33_;
			_tmp32_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp32_);
			_tmp33_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp33_);
		}
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp34_, &_tmp35_);
	req = _tmp34_;
	req = _tmp35_;
	_tmp36_ = req;
	_tmp37_ = _tmp36_.width;
	_tmp38_ = req;
	_tmp39_ = _tmp38_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp37_, _tmp39_);
	_tmp40_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp40_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void
cheese_main_window_on_stage_resize (CheeseMainWindow* self,
                                    ClutterActor* actor,
                                    ClutterActorBox* box,
                                    ClutterAllocationFlags flags)
{
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterStage* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterActor* _tmp7_;
	ClutterStage* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterStage* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterText* _tmp14_;
	ClutterActor* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	ClutterStage* _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size (_tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}


/**
   * The method to call when the countdown is finished.
   */
static void
cheese_main_window_finish_countdown_callback (CheeseMainWindow* self)
{
	gboolean _tmp0_;
	CheeseMediaMode _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		gchar* file_name = NULL;
		CheeseFileUtil* _tmp1_;
		CheeseMediaMode _tmp2_;
		gchar* _tmp3_;
		GSettings* _tmp4_;
		GtkWidget* _tmp6_;
		CheeseCamera* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		file_name = _tmp3_;
		_tmp4_ = self->priv->settings;
		if (g_settings_get_boolean (_tmp4_, "flash")) {
			CheeseFlash* _tmp5_;
			_tmp5_ = self->priv->flash;
			cheese_flash_fire (_tmp5_);
		}
		_tmp6_ = self->priv->main_vbox;
		ca_gtk_play_for_widget (_tmp6_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _ ("Shutter sound"), NULL, NULL);
		_tmp7_ = self->priv->camera;
		_tmp8_ = file_name;
		cheese_camera_take_photo (_tmp7_, _tmp8_);
		_g_free0 (file_name);
	}
	_tmp9_ = self->priv->current_mode;
	if (_tmp9_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void
_cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self)
{
	cheese_main_window_finish_countdown_callback ((CheeseMainWindow*) self);
}


void
cheese_main_window_take_photo (CheeseMainWindow* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "countdown")) {
		CheeseMediaMode _tmp1_;
		ClutterText* _tmp2_;
		CheeseCountdown* _tmp3_;
		CheeseCountdown* _tmp4_;
		_tmp1_ = self->priv->current_mode;
		if (_tmp1_ == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp2_ = self->priv->countdown_layer;
		_tmp3_ = cheese_countdown_new (_tmp2_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp3_;
		_tmp4_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp4_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean
cheese_main_window_burst_take_photo (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_;
		GSettings* _tmp3_;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp0_ = _tmp2_ < g_settings_get_int (_tmp3_, "burst-repeat");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp4_;
		cheese_main_window_take_photo (self);
		_tmp4_ = self->priv->burst_count;
		self->priv->burst_count = _tmp4_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
     * Cancel the current action (if any)
     */
static gboolean
cheese_main_window_cancel_running_action (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CheeseCountdown* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current_countdown;
	if (_tmp3_ != NULL) {
		CheeseCountdown* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = self->priv->current_countdown;
		_tmp5_ = _tmp4_->running;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->priv->is_bursting;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_;
		_tmp7_ = self->priv->is_recording;
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		CheeseMediaMode _tmp8_;
		self->priv->action_cancelled = TRUE;
		_tmp8_ = self->priv->current_mode;
		switch (_tmp8_) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				CheeseCountdown* _tmp9_;
				_tmp9_ = self->priv->current_countdown;
				cheese_countdown_stop (_tmp9_);
				cheese_main_window_finish_countdown_callback (self);
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				cheese_main_window_toggle_photo_bursting (self, FALSE);
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				cheese_main_window_toggle_video_recording (self, FALSE);
				break;
			}
			default:
			break;
		}
		self->priv->action_cancelled = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean
cheese_main_window_on_key_release (CheeseMainWindow* self,
                                   GdkEventKey* event)
{
	gboolean result = FALSE;
	gchar* key = NULL;
	guint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->keyval;
	_tmp1_ = gdk_keyval_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (key);
	key = _tmp2_;
	_tmp3_ = g_strcmp0;
	_tmp4_ = key;
	if (_tmp3_ (_tmp4_, "Escape") == 0) {
		if (cheese_main_window_cancel_running_action (self)) {
			result = FALSE;
			_g_free0 (key);
			return result;
		} else {
			gboolean _tmp5_;
			_tmp5_ = self->priv->is_effects_selector_active;
			if (_tmp5_) {
				GtkToggleButton* _tmp6_;
				_tmp6_ = self->priv->effects_toggle_button;
				gtk_toggle_button_set_active (_tmp6_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean
_cheese_main_window_update_timeout_layer_gsource_func (gpointer self)
{
	gboolean result;
	result = cheese_main_window_update_timeout_layer ((CheeseMainWindow*) self);
	return result;
}


void
cheese_main_window_toggle_video_recording (CheeseMainWindow* self,
                                           gboolean is_start)
{
	g_return_if_fail (self != NULL);
	if (is_start) {
		CheeseCamera* _tmp0_;
		CheeseFileUtil* _tmp1_;
		CheeseMediaMode _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkButton* _tmp5_;
		GtkImage* _tmp6_;
		_tmp0_ = self->priv->camera;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = _tmp3_;
		cheese_camera_start_video_recording (_tmp0_, _tmp4_);
		_g_free0 (_tmp4_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Stop recording"));
		_tmp6_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp6_, "media-playback-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp7_;
		ClutterText* _tmp8_;
		GtkButton* _tmp9_;
		GtkImage* _tmp10_;
		_tmp7_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp7_);
		_tmp8_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp8_, "00:00:00");
		_tmp9_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _ ("Record a video"));
		_tmp10_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp10_, "camera-web-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean
cheese_main_window_update_timeout_layer (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_recording;
	if (_tmp0_) {
		ClutterText* _tmp1_;
		CheeseCamera* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->timeout_layer;
		_tmp2_ = self->priv->camera;
		_tmp3_ = cheese_camera_get_recorded_time (_tmp2_);
		_tmp4_ = _tmp3_;
		clutter_text_set_text (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean
_cheese_main_window_burst_take_photo_gsource_func (gpointer self)
{
	gboolean result;
	result = cheese_main_window_burst_take_photo ((CheeseMainWindow*) self);
	return result;
}


void
cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self,
                                          gboolean is_start)
{
	g_return_if_fail (self != NULL);
	if (is_start) {
		GtkButton* _tmp0_;
		gint burst_delay = 0;
		GSettings* _tmp1_;
		gint countdown_duration = 0;
		GSettings* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		gint _tmp5_;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp0_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _ ("Stop taking pictures"));
		cheese_main_window_burst_take_photo (self);
		_tmp1_ = self->priv->settings;
		burst_delay = g_settings_get_int (_tmp1_, "burst-delay");
		_tmp2_ = self->priv->settings;
		countdown_duration = 500 + (g_settings_get_int (_tmp2_, "countdown-duration") * 1000);
		_tmp4_ = burst_delay;
		_tmp5_ = countdown_duration;
		if ((_tmp4_ - _tmp5_) < 1000) {
			GSettings* _tmp6_;
			_tmp6_ = self->priv->settings;
			_tmp3_ = g_settings_get_boolean (_tmp6_, "countdown");
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp7_;
			_tmp7_ = countdown_duration;
			self->priv->burst_callback_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp7_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
		} else {
			gint _tmp8_;
			_tmp8_ = burst_delay;
			self->priv->burst_callback_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
		}
	} else {
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_;
		GtkButton* _tmp14_;
		CheeseFileUtil* _tmp15_;
		guint _tmp16_;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			CheeseCountdown* _tmp13_;
			_tmp13_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp13_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp14_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _ ("Take multiple photos"));
		self->priv->burst_count = 0;
		_tmp15_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp15_);
		_tmp16_ = self->priv->burst_callback_id;
		g_source_remove (_tmp16_);
	}
}


/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void
cheese_main_window_shoot (CheeseMainWindow* self)
{
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_mode;
	switch (_tmp0_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gboolean _tmp1_;
			_tmp1_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp1_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gboolean _tmp2_;
			_tmp2_ = self->priv->is_bursting;
			cheese_main_window_toggle_photo_bursting (self, !_tmp2_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


/**
     * Show an error.
     *
     * @param error the error to display, or null to hide the error layer
     */
void
cheese_main_window_show_error (CheeseMainWindow* self,
                               const gchar* _error_)
{
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		ClutterActor* _tmp0_;
		ClutterActor* _tmp1_;
		ClutterText* _tmp2_;
		ClutterText* _tmp3_;
		_tmp0_ = self->priv->current_effects_grid;
		clutter_actor_hide (_tmp0_);
		_tmp1_ = self->priv->video_preview;
		clutter_actor_hide (_tmp1_);
		_tmp2_ = self->priv->error_layer;
		clutter_text_set_text (_tmp2_, _error_);
		_tmp3_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp3_);
	} else {
		ClutterText* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = self->priv->error_layer;
		clutter_actor_hide ((ClutterActor*) _tmp4_);
		_tmp5_ = self->priv->is_effects_selector_active;
		if (_tmp5_) {
			ClutterActor* _tmp6_;
			_tmp6_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp6_);
		} else {
			ClutterActor* _tmp7_;
			_tmp7_ = self->priv->video_preview;
			clutter_actor_show (_tmp7_);
		}
	}
}


/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void
cheese_main_window_set_effects (CheeseMainWindow* self,
                                gboolean effects)
{
	g_return_if_fail (self != NULL);
	cheese_main_window_toggle_effects_selector (self, effects);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param tap unused
   * @param source the actor (with associated effect) that was selected
   */
void
cheese_main_window_on_selected_effect_change (CheeseMainWindow* self,
                                              ClutterTapAction* tap,
                                              ClutterActor* source)
{
	GtkToggleButton* _tmp0_;
	gconstpointer _tmp1_;
	CheeseEffect* _tmp2_;
	CheeseCamera* _tmp3_;
	CheeseEffect* _tmp4_;
	GSettings* _tmp5_;
	CheeseEffect* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->effects_toggle_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_tmp1_ = g_object_get_data ((GObject*) source, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	_tmp7_ = cheese_effect_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp8_);
}


/**
     * Navigate back one page of effects.
     */
static void
cheese_main_window_on_effects_previous (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (cheese_main_window_is_previous_effects_page (self)) {
		guint _tmp0_;
		_tmp0_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp0_) - 1);
	}
}


/**
     * Navigate forward one page of effects.
     */
static void
cheese_main_window_on_effects_next (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (cheese_main_window_is_next_effects_page (self)) {
		guint _tmp0_;
		_tmp0_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp0_) + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void
cheese_main_window_activate_effects_page (CheeseMainWindow* self,
                                          gint number)
{
	gboolean _tmp0_;
	ClutterActor* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	ClutterActor* _tmp4_;
	gboolean _tmp5_;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	guint i = 0U;
	CheeseEffectsManager* _tmp19_;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	self->priv->current_effects_page = (guint) number;
	_tmp1_ = self->priv->viewport_layout;
	_tmp2_ = clutter_actor_get_children (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->current_effects_grid;
	_tmp5_ = g_list_index (_tmp3_, _tmp4_) != -1;
	_g_list_free0 (_tmp3_);
	if (_tmp5_) {
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		_tmp6_ = self->priv->viewport_layout;
		_tmp7_ = self->priv->current_effects_grid;
		clutter_actor_remove_child (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->effects_grids;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) number);
	_tmp10_ = _g_object_ref0 ((ClutterActor*) _tmp9_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp10_;
	_tmp11_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp11_, (guint) 0);
	_tmp12_ = self->priv->viewport_layout;
	_tmp13_ = self->priv->current_effects_grid;
	clutter_actor_add_child (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->current_effects_grid;
	clutter_actor_save_easing_state (_tmp14_);
	_tmp15_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_mode (_tmp15_, CLUTTER_LINEAR);
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_duration (_tmp16_, (guint) 500);
	_tmp17_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp17_, (guint) 255);
	_tmp18_ = self->priv->current_effects_grid;
	clutter_actor_restore_easing_state (_tmp18_);
	i = (guint) 0;
	_tmp19_ = self->priv->effects_manager;
	_tmp20_ = _tmp19_->effects;
	{
		GList* effect_collection = NULL;
		GList* effect_it = NULL;
		effect_collection = _tmp20_;
		for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
			CheeseEffect* _tmp21_;
			CheeseEffect* effect = NULL;
			_tmp21_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
			effect = _tmp21_;
			{
				guint page_nr = 0U;
				guint _tmp22_;
				guint _tmp23_;
				guint _tmp34_;
				_tmp22_ = i;
				page_nr = _tmp22_ / EFFECTS_PER_PAGE;
				_tmp23_ = page_nr;
				if (_tmp23_ == ((guint) number)) {
					CheeseEffect* _tmp24_;
					CheeseEffect* _tmp31_;
					_tmp24_ = effect;
					if (!cheese_effect_is_preview_connected (_tmp24_)) {
						ClutterActor* texture = NULL;
						CheeseEffect* _tmp25_;
						gconstpointer _tmp26_;
						ClutterActor* _tmp27_;
						CheeseCamera* _tmp28_;
						CheeseEffect* _tmp29_;
						ClutterActor* _tmp30_;
						_tmp25_ = effect;
						_tmp26_ = g_object_get_data ((GObject*) _tmp25_, "texture");
						_tmp27_ = _g_object_ref0 ((ClutterActor*) _tmp26_);
						texture = _tmp27_;
						_tmp28_ = self->priv->camera;
						_tmp29_ = effect;
						_tmp30_ = texture;
						cheese_camera_connect_effect_texture (_tmp28_, _tmp29_, _tmp30_);
						_g_object_unref0 (texture);
					}
					_tmp31_ = effect;
					cheese_effect_enable_preview (_tmp31_);
				} else {
					CheeseEffect* _tmp32_;
					_tmp32_ = effect;
					if (cheese_effect_is_preview_connected (_tmp32_)) {
						CheeseEffect* _tmp33_;
						_tmp33_ = effect;
						cheese_effect_disable_preview (_tmp33_);
					}
				}
				_tmp34_ = i;
				i = _tmp34_ + 1;
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
     * Control the sensitivity of the effects page navigation buttons.
     */
static void
cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self)
{
	GSimpleAction* effects_next = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* effects_previous = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GSimpleAction* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GSimpleAction* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects-next");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects_next = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "effects-previous");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	effects_previous = _tmp3_;
	_tmp5_ = self->priv->is_effects_selector_active;
	if (_tmp5_) {
		_tmp4_ = cheese_main_window_is_next_effects_page (self);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp6_ = effects_next;
	g_simple_action_set_enabled (_tmp6_, _tmp4_);
	_tmp8_ = self->priv->is_effects_selector_active;
	if (_tmp8_) {
		_tmp7_ = cheese_main_window_is_previous_effects_page (self);
	} else {
		_tmp7_ = FALSE;
	}
	_tmp9_ = effects_previous;
	g_simple_action_set_enabled (_tmp9_, _tmp7_);
	_g_object_unref0 (effects_previous);
	_g_object_unref0 (effects_next);
}


static gboolean
cheese_main_window_is_next_effects_page (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
	CheeseEffectsManager* _tmp1_;
	GList* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	result = ((_tmp0_ + 1) * EFFECTS_PER_PAGE) < g_list_length (_tmp2_);
	return result;
}


static gboolean
cheese_main_window_is_previous_effects_page (CheeseMainWindow* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_effects_page;
	result = _tmp0_ != ((guint) 0);
	return result;
}


/**
     * Toggle the visibility of the effects selector.
     *
     * @param active whether the selector should be active
     */
static void
cheese_main_window_toggle_effects_selector (CheeseMainWindow* self,
                                            gboolean active)
{
	GList* _tmp0_;
	CheeseCamera* _tmp7_;
	g_return_if_fail (self != NULL);
	self->priv->is_effects_selector_active = active;
	_tmp0_ = self->priv->effects_grids;
	if (g_list_length (_tmp0_) == ((guint) 0)) {
		const gchar* _tmp1_ = NULL;
		if (active) {
			_tmp1_ = _ ("No effects found");
		} else {
			_tmp1_ = NULL;
		}
		cheese_main_window_show_error (self, _tmp1_);
	} else {
		if (active) {
			ClutterActor* _tmp2_;
			ClutterActor* _tmp3_;
			guint _tmp4_;
			_tmp2_ = self->priv->video_preview;
			clutter_actor_hide (_tmp2_);
			_tmp3_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp3_);
			_tmp4_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, (gint) _tmp4_);
		} else {
			ClutterActor* _tmp5_;
			ClutterActor* _tmp6_;
			_tmp5_ = self->priv->current_effects_grid;
			clutter_actor_hide (_tmp5_);
			_tmp6_ = self->priv->video_preview;
			clutter_actor_show (_tmp6_);
		}
	}
	_tmp7_ = self->priv->camera;
	cheese_camera_toggle_effects_pipeline (_tmp7_, active);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
	cheese_main_window_update_header_bar_title (self);
}


/**
   * Create the effects selector.
   */
static void
_cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                                      ClutterActor* actor,
                                                                      gpointer self)
{
	cheese_main_window_on_selected_effect_change ((CheeseMainWindow*) self, _sender, actor);
}


static void
cheese_main_window_setup_effects_selector (CheeseMainWindow* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_;
		CheeseEffectsManager* _tmp2_;
		CheeseEffectsManager* _tmp3_;
		GList* _tmp4_;
		CheeseEffectsManager* _tmp5_;
		GList* _tmp6_;
		guint i = 0U;
		CheeseEffectsManager* _tmp16_;
		GList* _tmp17_;
		GList* _tmp78_;
		gconstpointer _tmp79_;
		ClutterActor* _tmp80_;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
		self->priv->effects_grids = NULL;
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		if (g_list_length (_tmp4_) == ((guint) 0)) {
			g_warning ("cheese-window.vala:1121: gnome-video-effects is not installed.");
			return;
		}
		_tmp5_ = self->priv->effects_manager;
		_tmp6_ = _tmp5_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp6_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp7_;
				CheeseEffect* effect = NULL;
				_tmp7_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp7_;
				{
					ClutterGridLayout* grid_layout = NULL;
					ClutterGridLayout* _tmp8_;
					ClutterActor* grid = NULL;
					ClutterActor* _tmp9_;
					ClutterActor* _tmp10_;
					ClutterGridLayout* _tmp11_;
					ClutterActor* _tmp12_;
					ClutterActor* _tmp13_;
					ClutterGridLayout* _tmp14_;
					ClutterGridLayout* _tmp15_;
					_tmp8_ = (ClutterGridLayout*) clutter_grid_layout_new ();
					g_object_ref_sink (_tmp8_);
					grid_layout = _tmp8_;
					_tmp9_ = clutter_actor_new ();
					g_object_ref_sink (_tmp9_);
					grid = _tmp9_;
					_tmp10_ = grid;
					_tmp11_ = grid_layout;
					clutter_actor_set_layout_manager (_tmp10_, (ClutterLayoutManager*) _tmp11_);
					_tmp12_ = grid;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					self->priv->effects_grids = g_list_append (self->priv->effects_grids, _tmp13_);
					_tmp14_ = grid_layout;
					clutter_grid_layout_set_column_spacing (_tmp14_, (guint) 10);
					_tmp15_ = grid_layout;
					clutter_grid_layout_set_row_spacing (_tmp15_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (effect);
				}
			}
		}
		i = (guint) 0;
		_tmp16_ = self->priv->effects_manager;
		_tmp17_ = _tmp16_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp17_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp18_;
				CheeseEffect* effect = NULL;
				_tmp18_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp18_;
				{
					ClutterActor* texture = NULL;
					ClutterActor* _tmp19_;
					ClutterBinLayout* layout = NULL;
					ClutterBinLayout* _tmp20_;
					ClutterActor* box = NULL;
					ClutterActor* _tmp21_;
					ClutterActor* _tmp22_;
					ClutterBinLayout* _tmp23_;
					ClutterText* text = NULL;
					ClutterText* _tmp24_;
					ClutterActor* rect = NULL;
					ClutterActor* _tmp25_;
					ClutterActor* _tmp26_;
					ClutterActor* _tmp27_;
					ClutterColor _tmp28_ = {0};
					ClutterActor* _tmp29_;
					ClutterActor* _tmp30_;
					ClutterActor* _tmp31_;
					ClutterActor* _tmp32_;
					ClutterActor* _tmp33_;
					ClutterActor* _tmp34_;
					ClutterTapAction* tap = NULL;
					ClutterTapAction* _tmp35_;
					ClutterActor* _tmp36_;
					ClutterTapAction* _tmp37_;
					ClutterTapAction* _tmp38_;
					ClutterActor* _tmp39_;
					CheeseEffect* _tmp40_;
					CheeseEffect* _tmp41_;
					CheeseEffect* _tmp42_;
					ClutterActor* _tmp43_;
					ClutterActor* _tmp44_;
					ClutterText* _tmp45_;
					CheeseEffect* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					ClutterText* _tmp49_;
					ClutterColor _tmp50_ = {0};
					ClutterActor* _tmp51_;
					ClutterText* _tmp52_;
					gfloat _tmp53_;
					gfloat _tmp54_;
					ClutterActor* _tmp55_;
					ClutterActor* _tmp56_;
					ClutterActor* _tmp57_;
					ClutterActor* _tmp58_;
					ClutterActor* _tmp59_;
					ClutterActor* _tmp60_;
					ClutterText* _tmp61_;
					ClutterText* _tmp62_;
					ClutterText* _tmp63_;
					ClutterText* _tmp64_;
					ClutterActor* _tmp65_;
					ClutterText* _tmp66_;
					ClutterGridLayout* grid_layout = NULL;
					GList* _tmp67_;
					guint _tmp68_;
					gconstpointer _tmp69_;
					ClutterLayoutManager* _tmp70_;
					ClutterLayoutManager* _tmp71_;
					ClutterGridLayout* _tmp72_;
					ClutterGridLayout* _tmp73_;
					ClutterActor* _tmp74_;
					guint _tmp75_;
					guint _tmp76_;
					guint _tmp77_;
					_tmp19_ = clutter_actor_new ();
					g_object_ref_sink (_tmp19_);
					texture = _tmp19_;
					_tmp20_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp20_);
					layout = _tmp20_;
					_tmp21_ = clutter_actor_new ();
					g_object_ref_sink (_tmp21_);
					box = _tmp21_;
					_tmp22_ = box;
					_tmp23_ = layout;
					clutter_actor_set_layout_manager (_tmp22_, (ClutterLayoutManager*) _tmp23_);
					_tmp24_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp24_);
					text = _tmp24_;
					_tmp25_ = clutter_actor_new ();
					g_object_ref_sink (_tmp25_);
					rect = _tmp25_;
					_tmp26_ = rect;
					clutter_actor_set_opacity (_tmp26_, (guint) 128);
					_tmp27_ = rect;
					clutter_color_from_string (&_tmp28_, "black");
					clutter_actor_set_background_color (_tmp27_, &_tmp28_);
					_tmp29_ = texture;
					clutter_actor_set_content_gravity (_tmp29_, CLUTTER_CONTENT_GRAVITY_RESIZE_ASPECT);
					_tmp30_ = box;
					_tmp31_ = texture;
					clutter_actor_add_child (_tmp30_, _tmp31_);
					_tmp32_ = box;
					clutter_actor_set_reactive (_tmp32_, TRUE);
					_tmp33_ = box;
					g_object_set (_tmp33_, "min-height", (gfloat) 40, NULL);
					_tmp34_ = box;
					g_object_set (_tmp34_, "min-width", (gfloat) 50, NULL);
					_tmp35_ = (ClutterTapAction*) clutter_tap_action_new ();
					g_object_ref_sink (_tmp35_);
					tap = _tmp35_;
					_tmp36_ = box;
					_tmp37_ = tap;
					clutter_actor_add_action (_tmp36_, (ClutterAction*) _tmp37_);
					_tmp38_ = tap;
					g_signal_connect_object (_tmp38_, "tap", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap, self, 0);
					_tmp39_ = box;
					_tmp40_ = effect;
					_tmp41_ = _g_object_ref0 (_tmp40_);
					g_object_set_data_full ((GObject*) _tmp39_, "effect", _tmp41_, g_object_unref);
					_tmp42_ = effect;
					_tmp43_ = texture;
					_tmp44_ = _g_object_ref0 (_tmp43_);
					g_object_set_data_full ((GObject*) _tmp42_, "texture", _tmp44_, g_object_unref);
					_tmp45_ = text;
					_tmp46_ = effect;
					_tmp47_ = cheese_effect_get_name (_tmp46_);
					_tmp48_ = _tmp47_;
					clutter_text_set_text (_tmp45_, _tmp48_);
					_tmp49_ = text;
					clutter_color_from_string (&_tmp50_, "white");
					clutter_text_set_color (_tmp49_, &_tmp50_);
					_tmp51_ = rect;
					_tmp52_ = text;
					_tmp53_ = clutter_actor_get_height ((ClutterActor*) _tmp52_);
					_tmp54_ = _tmp53_;
					clutter_actor_set_height (_tmp51_, _tmp54_ + 5);
					_tmp55_ = rect;
					clutter_actor_set_x_align (_tmp55_, CLUTTER_ACTOR_ALIGN_FILL);
					_tmp56_ = rect;
					clutter_actor_set_y_align (_tmp56_, CLUTTER_ACTOR_ALIGN_END);
					_tmp57_ = rect;
					clutter_actor_set_x_expand (_tmp57_, TRUE);
					_tmp58_ = rect;
					clutter_actor_set_y_expand (_tmp58_, TRUE);
					_tmp59_ = box;
					_tmp60_ = rect;
					clutter_actor_add_child (_tmp59_, _tmp60_);
					_tmp61_ = text;
					clutter_actor_set_x_align ((ClutterActor*) _tmp61_, CLUTTER_ACTOR_ALIGN_CENTER);
					_tmp62_ = text;
					clutter_actor_set_y_align ((ClutterActor*) _tmp62_, CLUTTER_ACTOR_ALIGN_END);
					_tmp63_ = text;
					clutter_actor_set_x_expand ((ClutterActor*) _tmp63_, TRUE);
					_tmp64_ = text;
					clutter_actor_set_y_expand ((ClutterActor*) _tmp64_, TRUE);
					_tmp65_ = box;
					_tmp66_ = text;
					clutter_actor_add_child (_tmp65_, (ClutterActor*) _tmp66_);
					_tmp67_ = self->priv->effects_grids;
					_tmp68_ = i;
					_tmp69_ = g_list_nth_data (_tmp67_, _tmp68_ / EFFECTS_PER_PAGE);
					_tmp70_ = clutter_actor_get_layout_manager ((ClutterActor*) _tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, clutter_grid_layout_get_type ()) ? ((ClutterGridLayout*) _tmp71_) : NULL);
					grid_layout = _tmp72_;
					_tmp73_ = grid_layout;
					_tmp74_ = box;
					_tmp75_ = i;
					_tmp76_ = i;
					clutter_grid_layout_attach (_tmp73_, _tmp74_, ((gint) (_tmp75_ % EFFECTS_PER_PAGE)) % 3, ((gint) (_tmp76_ % EFFECTS_PER_PAGE)) / 3, 1, 1);
					_tmp77_ = i;
					i = _tmp77_ + 1;
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (tap);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp78_ = self->priv->effects_grids;
		_tmp79_ = g_list_nth_data (_tmp78_, (guint) 0);
		_tmp80_ = _g_object_ref0 ((ClutterActor*) _tmp79_);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp80_;
	}
}


/**
     * Update the UI when the camera starts playing.
     */
void
cheese_main_window_camera_state_change_playing (CheeseMainWindow* self)
{
	CheeseEffect* effect = NULL;
	CheeseEffectsManager* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	CheeseEffect* _tmp4_;
	CheeseEffect* _tmp5_;
	CheeseEffect* _tmp6_;
	g_return_if_fail (self != NULL);
	cheese_main_window_show_error (self, NULL);
	_tmp0_ = self->priv->effects_manager;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "selected-effect");
	_tmp3_ = _tmp2_;
	_tmp4_ = cheese_effects_manager_get_effect (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	effect = _tmp5_;
	_tmp6_ = effect;
	if (_tmp6_ != NULL) {
		CheeseCamera* _tmp7_;
		CheeseEffect* _tmp8_;
		_tmp7_ = self->priv->camera;
		_tmp8_ = effect;
		cheese_camera_set_effect (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (effect);
}


/**
     * Report an error as the camerabin switched to the NULL state.
     */
void
cheese_main_window_camera_state_change_null (CheeseMainWindow* self)
{
	ClutterText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	cheese_main_window_cancel_running_action (self);
	_tmp0_ = self->priv->error_layer;
	g_object_get ((ClutterActor*) _tmp0_, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		cheese_main_window_show_error (self, _ ("There was an error playing video from the webcam"));
	}
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void
_cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                                      ClutterActorBox* box,
                                                                      ClutterAllocationFlags flags,
                                                                      gpointer self)
{
	cheese_main_window_on_stage_resize ((CheeseMainWindow*) self, _sender, box, flags);
}


static gboolean
_cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                    gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_thumb_view_popup_menu ((CheeseMainWindow*) self, _sender);
	return result;
}


static gboolean
_cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_thumbnail_button_press_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static gboolean
_cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_key_release ((CheeseMainWindow*) self, event);
	return result;
}


void
cheese_main_window_setup_ui (CheeseMainWindow* self)
{
	ClutterScript* _tmp0_;
	CheeseFileUtil* _tmp1_;
	CheeseFlash* _tmp2_;
	GSettings* _tmp3_;
	GMenu* menu = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GtkMenu* _tmp8_;
	GtkClutterEmbed* _tmp11_;
	ClutterActor* _tmp12_;
	ClutterStage* _tmp13_;
	ClutterScript* _tmp14_;
	GObject* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterScript* _tmp17_;
	GObject* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterScript* _tmp20_;
	GObject* _tmp21_;
	ClutterBinLayout* _tmp22_;
	ClutterScript* _tmp23_;
	GObject* _tmp24_;
	ClutterText* _tmp25_;
	ClutterScript* _tmp26_;
	GObject* _tmp27_;
	ClutterActor* _tmp28_;
	ClutterScript* _tmp29_;
	GObject* _tmp30_;
	ClutterText* _tmp31_;
	ClutterScript* _tmp32_;
	GObject* _tmp33_;
	ClutterText* _tmp34_;
	ClutterActor* _tmp35_;
	ClutterStage* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterBinLayout* _tmp39_;
	ClutterStage* _tmp40_;
	ClutterActor* _tmp41_;
	ClutterStage* _tmp42_;
	ClutterText* _tmp43_;
	ClutterStage* _tmp44_;
	CheeseThumbView* _tmp45_;
	CheeseThumbView* _tmp46_;
	EogThumbNav* _tmp47_;
	GtkMenu* _tmp48_;
	CheeseThumbView* _tmp49_;
	CheeseThumbView* _tmp50_;
	GtkCssProvider* css = NULL;
	GdkScreen* _tmp54_;
	GdkScreen* _tmp55_;
	CheeseThumbView* _tmp56_;
	GtkClutterEmbed* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp0_;
	_tmp1_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp1_;
	_tmp2_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_application_get_menu_by_id (_tmp5_, "thumbview-menu");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	menu = _tmp7_;
	_tmp8_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) menu);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp8_;
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_MAIN_WINDOW_actions, G_N_ELEMENTS (CHEESE_MAIN_WINDOW_actions), self);
	{
		ClutterScript* _tmp9_;
		_tmp9_ = self->priv->clutter_builder;
		clutter_script_load_from_resource (_tmp9_, "/org/gnome/Cheese/cheese-viewport.json", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp10_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = err->message;
		g_error ("cheese-window.vala:1236: Error: %s", _tmp10_);
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = self->priv->viewport_widget;
	_tmp12_ = gtk_clutter_embed_get_stage (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp13_;
	_tmp14_ = self->priv->clutter_builder;
	_tmp15_ = clutter_script_get_object (_tmp14_, "video_preview");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp16_;
	_tmp17_ = self->priv->clutter_builder;
	_tmp18_ = clutter_script_get_object (_tmp17_, "viewport_layout");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp19_;
	_tmp20_ = self->priv->clutter_builder;
	_tmp21_ = clutter_script_get_object (_tmp20_, "viewport_layout_manager");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp22_;
	_tmp23_ = self->priv->clutter_builder;
	_tmp24_ = clutter_script_get_object (_tmp23_, "countdown_layer");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, clutter_text_get_type ()) ? ((ClutterText*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp25_;
	_tmp26_ = self->priv->clutter_builder;
	_tmp27_ = clutter_script_get_object (_tmp26_, "background");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp28_;
	_tmp29_ = self->priv->clutter_builder;
	_tmp30_ = clutter_script_get_object (_tmp29_, "error_layer");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, clutter_text_get_type ()) ? ((ClutterText*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp31_;
	_tmp32_ = self->priv->clutter_builder;
	_tmp33_ = clutter_script_get_object (_tmp32_, "timeout_layer");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, clutter_text_get_type ()) ? ((ClutterText*) _tmp33_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp34_;
	_tmp35_ = self->priv->video_preview;
	clutter_actor_set_request_mode (_tmp35_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp36_ = self->priv->viewport;
	_tmp37_ = self->priv->background_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp36_, _tmp37_);
	_tmp38_ = self->priv->viewport_layout;
	_tmp39_ = self->priv->viewport_layout_manager;
	clutter_actor_set_layout_manager (_tmp38_, (ClutterLayoutManager*) _tmp39_);
	_tmp40_ = self->priv->viewport;
	_tmp41_ = self->priv->viewport_layout;
	clutter_actor_add_child ((ClutterActor*) _tmp40_, _tmp41_);
	_tmp42_ = self->priv->viewport;
	_tmp43_ = self->priv->timeout_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp42_, (ClutterActor*) _tmp43_);
	_tmp44_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp44_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp45_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp45_;
	_tmp46_ = self->priv->thumb_view;
	_tmp47_ = eog_thumb_nav_new ((GtkWidget*) _tmp46_, FALSE);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp47_;
	_tmp48_ = self->priv->thumbnail_popup;
	_tmp49_ = self->priv->thumb_view;
	gtk_menu_attach_to_widget (_tmp48_, (GtkWidget*) _tmp49_, NULL);
	_tmp50_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "popup-menu", (GCallback) _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu, self, 0);
	{
		GFile* file = NULL;
		GFile* _tmp51_;
		GtkCssProvider* _tmp52_;
		_tmp51_ = g_file_new_for_uri ("resource:///org/gnome/Cheese/cheese.css");
		file = _tmp51_;
		_tmp52_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp52_;
		gtk_css_provider_load_from_file (css, file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch9_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp53_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp53_ = e->message;
		g_error ("cheese-window.vala:1273: Error parsing CSS: %s\n", _tmp53_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css);
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp54_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp55_ = _tmp54_;
	gtk_style_context_add_provider_for_screen (_tmp55_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp56_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp56_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp57_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp57_);
	cheese_main_window_set_wide_mode (self, FALSE);
	cheese_main_window_setup_effects_selector (self);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (css);
	_g_object_unref0 (menu);
}


ClutterActor*
cheese_main_window_get_video_preview (CheeseMainWindow* self)
{
	ClutterActor* result = NULL;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void
cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self)
{
	CheeseThumbView* _tmp0_;
	CheeseFileUtil* _tmp1_;
	const gchar* _tmp2_;
	CheeseThumbView* _tmp3_;
	CheeseFileUtil* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void
cheese_main_window_set_current_mode (CheeseMainWindow* self,
                                     CheeseMediaMode mode)
{
	CheeseMediaMode _tmp0_;
	ClutterText* _tmp1_;
	CheeseMediaMode _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
	_tmp0_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp0_);
	cheese_main_window_update_header_bar_title (self);
	_tmp1_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp1_);
	_tmp2_ = self->priv->current_mode;
	switch (_tmp2_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkButton* _tmp3_;
			_tmp3_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Take a photo using a webcam"));
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkButton* _tmp4_;
			ClutterText* _tmp5_;
			ClutterText* _tmp6_;
			_tmp4_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Record a video using a webcam"));
			_tmp5_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp5_, "00:00:00");
			_tmp6_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp6_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkButton* _tmp7_;
			_tmp7_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _ ("Take multiple photos using a webcam"));
			break;
		}
		default:
		break;
	}
}


/**
     * Set the header bar title.
     */
static void
cheese_main_window_update_header_bar_title (CheeseMainWindow* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (_tmp0_) {
		cheese_main_window_set_window_title (self, _ ("Choose an Effect"));
	} else {
		CheeseMediaMode _tmp1_;
		_tmp1_ = self->priv->current_mode;
		switch (_tmp1_) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				cheese_main_window_set_window_title (self, _ ("Take a Photo"));
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				cheese_main_window_set_window_title (self, _ ("Record a Video"));
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				cheese_main_window_set_window_title (self, _ ("Take Multiple Photos"));
				break;
			}
			default:
			break;
		}
	}
}


/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void
cheese_main_window_set_camera (CheeseMainWindow* self,
                               CheeseCamera* camera)
{
	CheeseCamera* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = _g_object_ref0 (camera);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp0_;
}


static void
cheese_main_window_class_init (CheeseMainWindowClass * klass)
{
	gint CheeseMainWindow_private_offset;
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
	CheeseMainWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Cheese/cheese-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "viewport_widget", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, viewport_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, main_vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_right", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_bottom", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_bottom));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "leave_fullscreen_button_box", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, leave_fullscreen_button_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button_image", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "effects_toggle_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, effects_toggle_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "buttons_area", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, buttons_area));
}


static void
cheese_main_window_instance_init (CheeseMainWindow * self)
{
	GtkBuilder* _tmp0_;
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Cheese/headerbar.ui");
	self->priv->header_bar_ui = _tmp0_;
	self->priv->current_effects_page = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
cheese_main_window_finalize (GObject * obj)
{
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->header_bar_ui);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->leave_fullscreen_button_box);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType
cheese_main_window_get_type (void)
{
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}



