/*
 * general defines
 *
 * Copyright (c) 2001        Nico Schottelius <nico@schottelius.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GPMDEF_INCLUDED
#define _GPMDEF_INCLUDED

/*** devfs ****/

/* Devfs stuff: Which console to take ?  Either tty0 or vc/0 */
#define GPM_IS_DEVFS         0
#define GPM_IS_NOT_DEVFS     1
#define GPM_IS_NOTHING       2

#define GPM_DEVFS_VC         "/dev/vc/"     /* DEVFS_VC"%d" can make all vcs */
#define GPM_NO_DEVFS_VC      "/dev/tty"     /* the old solution */

/* current console */
#define GPM_DEVFS_CVC    GPM_DEVFS_VC"0"      /* new: /dev/vc/0 :) */
#define GPM_NO_DEVFS_CVC GPM_NO_DEVFS_VC"0"   /* old: /dev/tty0    */

#define GPM_NO_DEVFS_MOUSE   "/dev/mouse"    /* the old pseudo link*/
#define GPM_NULL_DEV         "/dev/null"

/* ret_devfs type */
#define GPM_TYPE_CON 1
#define GPM_TYPE_VCN 2

/*** mouse commands ***/ 

#define GPM_AUX_SEND_ID    0xF2
#define GPM_AUX_ID_ERROR   -1
#define GPM_AUX_ID_PS2     0
#define GPM_AUX_ID_IMPS2   3

/* these are shameless stolen from /usr/src/linux/include/linux/pc_keyb.h    */

#define GPM_AUX_SET_RES        0xE8  /* Set resolution */
#define GPM_AUX_SET_SCALE11    0xE6  /* Set 1:1 scaling */ 
#define GPM_AUX_SET_SCALE21    0xE7  /* Set 2:1 scaling */
#define GPM_AUX_GET_SCALE      0xE9  /* Get scaling factor */
#define GPM_AUX_SET_STREAM     0xEA  /* Set stream mode */
#define GPM_AUX_SET_SAMPLE     0xF3  /* Set sample rate */ 
#define GPM_AUX_ENABLE_DEV     0xF4  /* Enable aux device */
#define GPM_AUX_DISABLE_DEV    0xF5  /* Disable aux device */
#define GPM_AUX_RESET          0xFF  /* Reset aux device */
#define GPM_AUX_ACK            0xFA  /* Command byte ACK. */ 

#define GPM_AUX_BUF_SIZE    2048  /* This might be better divisible by
                                 three to make overruns stay in sync
                                 but then the read function would need
                                 a lock etc - ick */
                                                      
/*** logging ***/

#define GPM_LOG_STRING __LINE__,__FILE__, 

#define GPM_LOG_INFO  GPM_LOG_STRING 0
#define GPM_LOG_WARN  GPM_LOG_STRING 1
#define GPM_LOG_ERR   GPM_LOG_STRING 2
#define GPM_LOG_DEBUG GPM_LOG_STRING 3

#endif /* if not included */
