#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <gtk/gtk.h>
#include <xs.h>

#include "xs_store.h"
#include "xenviews.h"

/* ------------------------------------------------------------------ */

GtkWidget            *xs_toplevel;

static GtkWidget     *status;
static XenStore      *store;
static GtkWidget     *view;

/* ------------------------------------------------------------------ */

static void menu_cb_close(void)
{
    gtk_widget_destroy(xs_toplevel);
}

static void menu_cb_expand_subtree(void)
{
    GtkTreeSelection *sel;
    GtkTreeModel *model;
    GtkTreeIter iter;

    sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
    if (!gtk_tree_selection_get_selected(sel, &model, &iter))
	return;
    gtk_tree_view_expand_row(GTK_TREE_VIEW(view),
			     gtk_tree_model_get_path(model, &iter),
			     true);
}

static void menu_cb_expand_all(void)
{
    gtk_tree_view_expand_all(GTK_TREE_VIEW(view));
}

static void menu_cb_about(void)
{
    static char *comments = "xenstore browser";
    static char *copyright = "(c) 2005-2007 Gerd Hoffmann";
    static char *authors[] = { "Gerd Hoffmann <kraxel@redhat.com>", NULL };

    gtk_show_about_dialog(GTK_WINDOW(xs_toplevel),
			  "authors",         authors,
			  "comments",        comments,
			  "copyright",       copyright,
			  "logo-icon-name",  GTK_STOCK_ABOUT,
			  "version",         VERSION,
			  NULL);
}

static void destroy(GtkWidget *widget,
                    gpointer   data)
{
    g_object_unref(store);
    xs_toplevel = NULL;

    gtk_main_quit();
}

/* ------------------------------------------------------------------ */

static const GtkActionEntry entries[] = {
    {
	.name        = "FileMenu",
	.label       = "_File",
    },{
	.name        = "Quit",
	.stock_id    = GTK_STOCK_QUIT,
	.label       = "_Quit",
	.callback    = menu_cb_close,
    },{

	.name        = "ViewMenu",
	.label       = "_View",
    },{
	.name        = "ExpandSubTree",
	.label       = "_Expand subtree",
	.accelerator = "<control>E",
	.callback    = menu_cb_expand_subtree,
    },{
	.name        = "ExpandAll",
	.label       = "Expand _all",
	.accelerator = "<control>A",
	.callback    = menu_cb_expand_all,
    },{

	.name        = "HelpMenu",
	.label       = "_Help",
    },{
	.name        = "About",
	.stock_id    = GTK_STOCK_ABOUT,
	.label       = "_About ...",
	.callback    = menu_cb_about,
    },
};

static char ui_xml[] =
"<ui>"
"  <menubar name='MainMenu'>"
"    <menu action='FileMenu'>"
"      <menuitem action='Quit'/>"
"    </menu>"
"    <menu action='ViewMenu'>"
"      <menuitem action='ExpandSubTree'/>"
"      <menuitem action='ExpandAll'/>"
"    </menu>"
"    <menu action='HelpMenu'>"
"      <menuitem action='About'/>"
"    </menu>"
"  </menubar>"
"  <toolbar action='ToolBar'>"
"    <toolitem action='Quit'/>"
"  </toolbar>"
"</ui>";

/* ------------------------------------------------------------------ */

static GtkWidget *xenstore_create_view(XenStore *store)
{
    GtkCellRenderer *renderer;
    GtkWidget *view;

    view  = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(view),
			    GTK_TREE_MODEL(store));
    gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(view)),
				GTK_SELECTION_SINGLE);

    renderer = gtk_cell_renderer_text_new();
    g_object_set(renderer,
                 "font", "monospace",
                 NULL);
    gtk_tree_view_insert_column_with_attributes
	(GTK_TREE_VIEW(view), -1, _("Name"), renderer,
	 "text", XENSTORE_COL_NAME,
	 NULL);

    renderer = gtk_cell_renderer_text_new();
    g_object_set(renderer,
                 "font", "monospace",
                 NULL);
    gtk_tree_view_insert_column_with_attributes
	(GTK_TREE_VIEW(view), -1, _("Value"), renderer,
	 "text", XENSTORE_COL_VALUE,
	 NULL);

    return view;
}

void xenstore_create_window(void)
{
    GtkWidget *vbox, *menubar, *toolbar, *scroll, *frame;
    GtkAccelGroup *accel;
    GtkActionGroup *ag;
    GtkUIManager *ui;
    GError *err;

    xs_toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(xs_toplevel), _("xenstore"));
    gtk_widget_set_size_request(GTK_WIDGET(xs_toplevel), 480, 320);
    g_signal_connect(G_OBJECT(xs_toplevel), "destroy",
		     G_CALLBACK(destroy), NULL);
    
    /* menu + toolbar */
    ui = gtk_ui_manager_new();
    ag = gtk_action_group_new("MenuActions");
    gtk_action_group_add_actions(ag, entries, G_N_ELEMENTS(entries), xs_toplevel);
    gtk_ui_manager_insert_action_group(ui, ag, 0);
    accel = gtk_ui_manager_get_accel_group(ui);
    gtk_window_add_accel_group(GTK_WINDOW(xs_toplevel), accel);

    err = NULL;
    if (!gtk_ui_manager_add_ui_from_string(ui, ui_xml, -1, &err)) {
	g_message("building menus failed: %s", err->message);
	g_error_free(err);
	exit(1);
    }

    /* list */
    store = xenstore_new();
    view  = xenstore_create_view(store);
    scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
				   GTK_POLICY_NEVER,
				   GTK_POLICY_AUTOMATIC);
    
    /* other widgets */
    status = gtk_label_new("status line");
    gtk_misc_set_alignment(GTK_MISC(status), 0, 0.5);
    gtk_misc_set_padding(GTK_MISC(status), 3, 1);

    /* Make a vbox and put stuff in */
    vbox = gtk_vbox_new(FALSE, 1);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 1);
    gtk_container_add(GTK_CONTAINER(xs_toplevel), vbox);
    menubar = gtk_ui_manager_get_widget(ui, "/MainMenu");
    gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, FALSE, 0);
    if (0) {
	toolbar = gtk_ui_manager_get_widget(ui, "/ToolBar");
	gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);
    }
    gtk_box_pack_start(GTK_BOX(vbox), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), view);

    frame = gtk_frame_new(NULL);
    gtk_box_pack_end(GTK_BOX(vbox), frame, FALSE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(frame), status);
    return;
}
