/**
	@license GNU GPLv2
	PROJECT "trovacap"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file dlg_help.cxx
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#include "dlg_help.h"

/*----------------------------------------------------------------------------*/

WinHelp::WinHelp()
{
	dlg_help = new Fl_Window((Fl::w() - winW)/2, (Fl::h() - winH)/2, winW, winH,
		"trovacap: Help");
	dlg_help->user_data((void*)(this));
	dlg_help->begin();
	{
		hlp_html = new Fl_Help_View(0, 0, winW, winH - 35);
		hlp_html->textfont(4);
		hlp_html->textsize(16);
		hlp_html->load("./docs/trovacap.html");

		btn_annulla = new Fl_Button((winW - 100)/2, winH -30, 100, 25, "&Chiudi");
		btn_annulla->callback((Fl_Callback*)cb_btn_annulla, (void*)(this));
	}
	dlg_help->end();
	dlg_help->set_modal();
}

/*----------------------------------------------------------------------------*/

WinHelp::~WinHelp()
{
	delete dlg_help;
}

/*----------------------------------------------------------------------------*/

void
WinHelp::show()
{
	dlg_help->show();
}

/*----------------------------------------------------------------------------*/

void
WinHelp::hide()
{
	dlg_help->hide();
}

/*----------------------------------------------------------------------------*/

int
WinHelp::visible()
{
	return dlg_help->visible();
}

/*----------------------------------------------------------------------------*/

int
WinHelp::standby()
{
	show();
	while (visible()) Fl::wait();

	return 0;
}

/*----------------------------------------------------------------------------*/

void
WinHelp::cb_btn_annulla(Fl_Button*, void* obj)
{
	static_cast<WinHelp *>(obj)->ex_annulla();
}

/*----------------------------------------------------------------------------*/

inline void
WinHelp::ex_annulla()
{
	hide();
}
