// @HEADER
// ***********************************************************************
// 
// Moocho: Multi-functional Object-Oriented arCHitecture for Optimization
//                  Copyright (2003) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Roscoe A. Bartlett (rabartl@sandia.gov) 
// 
// ***********************************************************************
// @HEADER
//

#if !defined CHECK_CONVERGENCE_STD_STRATEGY_H
#define CHECK_CONVERGENCE_STD_STRATEGY_H

#include "MoochoPack_CheckConvergence_Strategy.hpp"

namespace MoochoPack {

/** \brief Implementation of CheckConvergence_Strategy interface
 *
 * This object can not change the flow of control or do anything fancy.  It just
 *  checks convergence by calculating norm errors and comparing with tolerance
 *  It can update iteration quantities if desired.
 *
 * See the printed documentation generated by \c this->print_step().
 */
class CheckConvergenceStd_Strategy :
    public CheckConvergence_Strategy
  {
  public:
    CheckConvergenceStd_Strategy(
      EOptErrorCheck opt_error_check = OPT_ERROR_REDUCED_GRADIENT_LAGR,
      EScaleKKTErrorBy scale_opt_error_by = SCALE_BY_ONE,
      EScaleKKTErrorBy scale_feas_error_by = SCALE_BY_ONE,
      EScaleKKTErrorBy scale_comp_error_by = SCALE_BY_ONE,
      bool scale_opt_error_by_Gf = true
      );
    
    /** @name Overridden from CheckConvergence_Strategy */
    //@{
    /** \brief . */
    virtual bool Converged( Algorithm& _algo);

    /** \brief . */
    virtual void print_step( const Algorithm& _algo, std::ostream& out, const std::string& L ) const;

    //@}

  protected:

    value_type CalculateScalingFactor( NLPAlgoState& state, EScaleKKTErrorBy scale_by ) const;

  }; // end class CheckConvergenceStd_Strategy

} // end namespace MoochoPack

#endif // CHECK_CONVERGENCE_STD_STRATEGY_H

