#include <iostream>
#include <fstream>
using namespace std;

#include <tools.h>
#include <ginac_tools.h>
using namespace GiNaC;
using SyFi::initSyFi;
using SyFi::compare_archives;


int main(int argc, char **argv)
{
  // symbols from symbol factory
	initSyFi(3);
	using SyFi::x;
	using SyFi::y;
	using SyFi::z;
	
	// some different symbols with same names
	ex xl = symbol("x");
	ex yl = symbol("y");
	ex zl = symbol("z");
	
	ex e1 = xl*xl + yl*yl*yl + sin(zl);
	ex e2 = x *x  + y *y *y  + sin(z );
	
	string exname1 = "testexpression1";
	string exname2 = "testexpression2";
	string exname3 = "testexpression3";
	
	archive a1;
	a1.archive_ex(e1,    exname1.c_str());
	a1.archive_ex(e1*e1, exname2.c_str());
	
	archive a2;
	a2.archive_ex(e2,    exname1.c_str());
	a2.archive_ex(e2*e2, exname2.c_str());
	
	string filename1 = "compare_archives1.gar";
	string filename2 = "compare_archives2.gar";
	
	ofstream ofile1(filename1.c_str());
	ofile1 << a1;
	ofile1.close();
	
	ofstream ofile2(filename2.c_str());
	ofile2 << a2;
	ofile2.close();
	
	bool success;
	success = compare_archives(filename1, filename2);
	if(!success)
	{
		cout << "Failure!" << endl;
		return -1;
	}
	
	// now test that we get failure when we should
	a1.archive_ex(e1,    exname3.c_str());
	a2.archive_ex(e2+1,  exname3.c_str());
	
	ofstream fofile1(filename1.c_str());
	fofile1 << a1;
	fofile1.close();
	
	ofstream fofile2(filename2.c_str());
	fofile2 << a2;
	fofile2.close();
	
	success = compare_archives(filename1, filename2);
	if(success)
	{
		cout << "Failure! Different expressions compare as equal." << endl;
		return -1;
	}

	return 0;
}
