// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#include "Ptv.h"
#include <iostream>
#include <math.h>

using std::ostream;
using std::endl;

double Ptv::tol = 1.0e-9;
double Ptv_match::tol = 1.0e-9;
//double Ptv::tol = .0;
//double Ptv_match::tol = .0;

Ptv::Ptv() : dim(0)
{
	v = new double[0];
}


Ptv::Ptv(double x, double y)
{
	dim = 2;
	v = new double[2];
	v[0] = x;
	v[1] = y;
}


Ptv::Ptv(double x, double y, double z)
{
	dim = 3;
	v = new double[3];
	v[0] = x;
	v[1] = y;
	v[2] = z;
}


Ptv::Ptv(unsigned int size_)
{
	dim = size_;
	v = new double[dim];
	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = 0.0;
	}
}


// FIXME:
// The constructor which takes int, double* could/should work
// on the double* provided instead of creating a copy.
// This however affects the destructor. Since Ptv should
// not delete memory.
// We could introduce a bool external_storage in Ptv which
// is used as a test in the destructor.

Ptv::Ptv(unsigned int size_, double* v_)
{
	dim = size_;
	v = new double[dim];
	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = v_[i];
	}
}


Ptv::Ptv(const Ptv& p)
{
	dim = p.size();
	v = new double[dim];
	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = p[i];
	}

}


Ptv::~Ptv()
{
	delete [] v;
}


void Ptv::redim(unsigned int size_, double* v_)
{
	if (dim != size_ )
	{
		delete [] v;
		dim = size_;
		v = new double[dim];
	}

	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = v_[i];
	}
}


void Ptv::redim(unsigned int size_)
{
	if (dim != size_ )
	{
		delete [] v;
		dim = size_;
		v = new double[dim];
	}
	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = 0.0;
	}
}


void Ptv::fill(double* v_)
{
	for (unsigned int i=0; i< dim; i++)
	{
		v[i] = v_[i];
	}
}


const unsigned int Ptv::size() const { return dim;}

const double& Ptv::operator [] (unsigned int i) const
{
	return v[i];
}


double& Ptv::operator [] (unsigned int i)
{
	return v[i];
}


Ptv& Ptv::operator = (const Ptv& p)
{
	if ( this != &p)
	{
		if ( dim != p.size())
		{
			delete [] v;
			dim = p.size();
			v = new double[dim];
		}
		for (unsigned int i=0; i< dim; i++)
		{
			v[i] = p[i];
		}
	}
	return *this;
}


bool Ptv::less(const Ptv& p) const
{

	if ( dim <  p.size() ) return true ;
	if ( dim >  p.size() ) return false;

	/* 
	for (int i=dim-1; i>= 0; i--) {
	  if ( fabs(v[i] - p[i]) > tol ) {
		if (v[i] < p[i])
		  return true;
		else
	return false;
	}
	}
	*/

	for (int i=dim-1; i>= 0; i--)
	{
		if ( v[i] + tol >= p[i] - tol &&  v[i] - tol <= p[i] + tol )
		{
		}
		else if (v[i] + tol  < p[i] - tol  )
		{
			return true;
		}
		else if ( v[i] - tol > p[i] + tol  )
		{
			return false;
		}
	}

	return false;
}


ostream & operator<< ( ostream& os, const Ptv& p)
{
	if (p.size() >= 1)
	{
		os <<"[";
		for (unsigned int i=0; i< p.size()-1; i++)
		{
			os <<p[i]<<",";
		}
		os <<p[p.size()-1]<<"]";
	}
	else
	{
		os <<"Ptv not created properly"<<endl;
	}
	return os;
}


Ptv_match::Ptv_match()
{
	d = 0 ; v = 0.0;
}


Ptv_match::Ptv_match(unsigned int d_, double v_)
{
	d = d_ ; v = v_;
}


bool Ptv_match:: operator () (const Ptv &p)
{
	if ( v + tol >= p[d] && v - tol <= p[d] ) return true;
	else return false;
}
