# - Try to find CLN
# Once done this will define
#
#   CLN_FOUND        - System has CLN
#   CLN_INCLUDE_DIRS - The CLN include directories
#   CLN_LIBRARIES    - The libraries needed to use CLN
#   CLN_VERSION      - CLN version string (MAJOR.MINOR.MICRO)

include(FindPkgConfig)
pkg_check_modules(PC_CLN cln)

set(CLN_VERSION ${PC_CLN_VERSION})

find_path(CLN_INCLUDE_DIR cln/cln.h
  HINTS ${PC_CLN_INCLUDEDIR} ${CLN_DIR}/include $ENV{CLN_DIR}/include)

find_library(CLN_LIBRARY cln
  HINTS ${PC_CLN_LIBDIR} ${CLN_DIR}/lib $ENV{CLN_DIR}/lib)

set(CLN_LIBRARIES ${CLN_LIBRARY})
set(CLN_INCLUDE_DIRS ${CLN_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(CLN DEFAULT_MSG
  CLN_LIBRARY CLN_INCLUDE_DIR)

mark_as_advanced(CLN_INCLUDE_DIR CLN_LIBRARY)
