/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_POSTCMDRESULT_H
#define _SC_POSTCMDRESULT_H

// sc
#include "commands/CmdResultCallback.h"
#include "util/Id.h"
class ScParam;
namespace sc {
  class Error;
}

// qt
class QObject;


/**
 * CmdResultCallback implementation that transfers the result back 
 * to the gui thread by post'ing it to the given target.
 */
class PostCmdResult : public CmdResultCallback
{
public:
  PostCmdResult( ID tid );
  PostCmdResult( QObject* );

  void handleResult( ScParam*, const sc::Error* );

private:
  ID _tid;
};

#endif // _SC_POSTCMDRESULT_H
