-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;
with Error_Types;

--# inherit Dictionary,
--#         Error_Types,
--#         E_Strings,
--#         LexTokenManager,
--#         SPARK_IO;

package Error_IO is
   ----------------------------------------------------------------
   -- This package provides simple primitives for the storage of
   -- Error Entries in a temporary file.
   --
   -- A file of error entries behaves like any other standard
   -- file - it may be created, written to, reset, read from and
   -- closed in the standard way.
   --
   -- The implementation of this package _may_ choose to store
   -- these files on disk, using the facilities of SPARK_IO, or
   -- may choose to store the file entirely in-memory on some
   -- hosts.
   ----------------------------------------------------------------

   type File_Type is private;

   Null_File : constant File_Type;

   procedure Create (File   : in out File_Type;
                     Status :    out SPARK_IO.File_Status);
   --# global in out SPARK_IO.File_Sys;
   --# derives File,
   --#         SPARK_IO.File_Sys,
   --#         Status            from File,
   --#                                SPARK_IO.File_Sys;

   procedure Close (File   : in out File_Type;
                    Status :    out SPARK_IO.File_Status);
   --# global in out SPARK_IO.File_Sys;
   --# derives File,
   --#         SPARK_IO.File_Sys from *,
   --#                                File &
   --#         Status            from File,
   --#                                SPARK_IO.File_Sys;

   procedure Reset (File         : in out File_Type;
                    Mode_Of_File : in     SPARK_IO.File_Mode;
                    Status       :    out SPARK_IO.File_Status);
   --# global in out SPARK_IO.File_Sys;
   --# derives File,
   --#         SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Mode_Of_File &
   --#         Status            from File,
   --#                                Mode_Of_File,
   --#                                SPARK_IO.File_Sys;

   procedure Put_Numeric_Error (File : in File_Type;
                                Item : in Error_Types.NumericError);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Item;

   procedure Get_Numeric_Error (File : in     File_Type;
                                Item :    out Error_Types.NumericError);
   --# global in out SPARK_IO.File_Sys;
   --# derives Item              from SPARK_IO.File_Sys &
   --#         SPARK_IO.File_Sys from *,
   --#                                File;

private
   --# hide Error_IO;
   type File_Descriptor;
   type File_Type is access File_Descriptor;
   Null_File : constant File_Type := null;
end Error_IO;
