/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class ComponentMover
extends MouseAdapter {
    private Class destinationClass;
    private Component destinationComponent;
    private Component destination;
    private Component source;
    private boolean changeCursor = true;
    private Point pressed;
    private Point location;
    private Cursor originalCursor;
    private boolean autoscrolls;
    private Insets dragInsets = new Insets(0, 0, 0, 0);
    private Dimension snapSize = new Dimension(1, 1);

    public ComponentMover() {
    }

    public ComponentMover(Class clazz, Component ... componentArray) {
        this.destinationClass = clazz;
        this.registerComponent(componentArray);
    }

    public ComponentMover(Component component, Component ... componentArray) {
        this.destinationComponent = component;
        this.registerComponent(componentArray);
    }

    public boolean isChangeCursor() {
        return this.changeCursor;
    }

    public void setChangeCursor(boolean bl) {
        this.changeCursor = bl;
    }

    public Insets getDragInsets() {
        return this.dragInsets;
    }

    public void setDragInsets(Insets insets) {
        this.dragInsets = insets;
    }

    public void deregisterComponent(Component ... componentArray) {
        for (Component component : componentArray) {
            component.removeMouseListener(this);
        }
    }

    public void registerComponent(Component ... componentArray) {
        for (Component component : componentArray) {
            component.addMouseListener(this);
        }
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension dimension) {
        this.snapSize = dimension;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.source = mouseEvent.getComponent();
        int n = this.source.getSize().width - this.dragInsets.left - this.dragInsets.right;
        int n2 = this.source.getSize().height - this.dragInsets.top - this.dragInsets.bottom;
        Rectangle rectangle = new Rectangle(this.dragInsets.left, this.dragInsets.top, n, n2);
        if (rectangle.contains(mouseEvent.getPoint())) {
            this.setupForDragging(mouseEvent);
        }
    }

    private void setupForDragging(MouseEvent mouseEvent) {
        this.source.addMouseMotionListener(this);
        this.destination = this.destinationComponent != null ? this.destinationComponent : (this.destinationClass == null ? this.source : SwingUtilities.getAncestorOfClass(this.destinationClass, this.source));
        this.pressed = mouseEvent.getLocationOnScreen();
        this.location = this.destination.getLocation();
        if (this.changeCursor) {
            this.originalCursor = this.source.getCursor();
            this.source.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.destination instanceof JComponent) {
            JComponent jComponent = (JComponent)this.destination;
            this.autoscrolls = jComponent.getAutoscrolls();
            jComponent.setAutoscrolls(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        int n = this.getDragDistance(point.x, this.pressed.x, this.snapSize.width);
        int n2 = this.getDragDistance(point.y, this.pressed.y, this.snapSize.height);
        this.destination.setLocation(this.location.x + n, this.location.y + n2);
    }

    private int getDragDistance(int n, int n2, int n3) {
        int n4;
        int n5 = n3 / 2;
        n4 += (n4 = n - n2) < 0 ? -n5 : n5;
        n4 = n4 / n3 * n3;
        return n4;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.source.removeMouseMotionListener(this);
        if (this.changeCursor) {
            this.source.setCursor(this.originalCursor);
        }
        if (this.destination instanceof JComponent) {
            ((JComponent)this.destination).setAutoscrolls(this.autoscrolls);
        }
    }
}

