## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# Author: Juergen Nickelsen (Juergen.Nickelsen@cs.tu-berlin.de)
#
# $Header: vp.sh[3.0] Tue Jun 29 16:42:03 1993 andy@cs.tu-berlin.de frozen $

pager=${PAGER-more}
options=

while : ; do
    case $1 in
        -*) options="$options $1" # only options without argument supported
	    shift ;;
         *) break ;;
    esac
done

if [ $# -lt 1 ] ; then
    echo Usage: `basename $0` '[vcat-options]' version ...
    exit 1
fi

trap 'rm -f $tmpnames ; exit' 0 1 2 3 15

count=0
tmpnames=
for i in "$@" ; do
    count=`expr $count + 1`
    tmpnm=/tmp/`basename $i`.$$$count
    tmpnames="$tmpnames $tmpnm"
    vcat $options $i > $tmpnm
done
$pager $tmpnames
