// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::FlapFoldPolicy;
use crate::FlapTransitionType;
use crate::Swipeable;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdyFlap")]
    pub struct Flap(Object<ffi::HdyFlap, ffi::HdyFlapClass>) @extends gtk::Container, gtk::Widget, @implements gtk::Buildable, gtk::Orientable, Swipeable;

    match fn {
        type_ => || ffi::hdy_flap_get_type(),
    }
}

impl Flap {
    #[doc(alias = "hdy_flap_new")]
    pub fn new() -> Flap {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::hdy_flap_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Flap`] objects.
    ///
    /// This method returns an instance of [`FlapBuilder`] which can be used to create [`Flap`] objects.
    pub fn builder() -> FlapBuilder {
        FlapBuilder::default()
    }

    #[doc(alias = "hdy_flap_get_content")]
    #[doc(alias = "get_content")]
    pub fn content(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::hdy_flap_get_content(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_flap")]
    #[doc(alias = "get_flap")]
    pub fn flap(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::hdy_flap_get_flap(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_flap_position")]
    #[doc(alias = "get_flap_position")]
    pub fn flap_position(&self) -> gtk::PackType {
        unsafe { from_glib(ffi::hdy_flap_get_flap_position(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_fold_duration")]
    #[doc(alias = "get_fold_duration")]
    pub fn fold_duration(&self) -> u32 {
        unsafe { ffi::hdy_flap_get_fold_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_flap_get_fold_policy")]
    #[doc(alias = "get_fold_policy")]
    pub fn fold_policy(&self) -> FlapFoldPolicy {
        unsafe { from_glib(ffi::hdy_flap_get_fold_policy(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_folded")]
    #[doc(alias = "get_folded")]
    pub fn is_folded(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_folded(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_locked")]
    #[doc(alias = "get_locked")]
    pub fn is_locked(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_locked(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_modal")]
    #[doc(alias = "get_modal")]
    pub fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_modal(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_reveal_duration")]
    #[doc(alias = "get_reveal_duration")]
    pub fn reveal_duration(&self) -> u32 {
        unsafe { ffi::hdy_flap_get_reveal_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_flap_get_reveal_flap")]
    #[doc(alias = "get_reveal_flap")]
    pub fn reveals_flap(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_reveal_flap(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_reveal_progress")]
    #[doc(alias = "get_reveal_progress")]
    pub fn reveal_progress(&self) -> f64 {
        unsafe { ffi::hdy_flap_get_reveal_progress(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_flap_get_separator")]
    #[doc(alias = "get_separator")]
    pub fn separator(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::hdy_flap_get_separator(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_swipe_to_close")]
    #[doc(alias = "get_swipe_to_close")]
    pub fn is_swipe_to_close(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_swipe_to_close(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_swipe_to_open")]
    #[doc(alias = "get_swipe_to_open")]
    pub fn is_swipe_to_open(&self) -> bool {
        unsafe { from_glib(ffi::hdy_flap_get_swipe_to_open(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_get_transition_type")]
    #[doc(alias = "get_transition_type")]
    pub fn transition_type(&self) -> FlapTransitionType {
        unsafe { from_glib(ffi::hdy_flap_get_transition_type(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_flap_set_content")]
    pub fn set_content<P: IsA<gtk::Widget>>(&self, content: Option<&P>) {
        unsafe {
            ffi::hdy_flap_set_content(
                self.to_glib_none().0,
                content.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_flap_set_flap")]
    pub fn set_flap<P: IsA<gtk::Widget>>(&self, flap: Option<&P>) {
        unsafe {
            ffi::hdy_flap_set_flap(
                self.to_glib_none().0,
                flap.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_flap_set_flap_position")]
    pub fn set_flap_position(&self, position: gtk::PackType) {
        unsafe {
            ffi::hdy_flap_set_flap_position(self.to_glib_none().0, position.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_fold_duration")]
    pub fn set_fold_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_flap_set_fold_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "hdy_flap_set_fold_policy")]
    pub fn set_fold_policy(&self, policy: FlapFoldPolicy) {
        unsafe {
            ffi::hdy_flap_set_fold_policy(self.to_glib_none().0, policy.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_locked")]
    pub fn set_locked(&self, locked: bool) {
        unsafe {
            ffi::hdy_flap_set_locked(self.to_glib_none().0, locked.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_modal")]
    pub fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::hdy_flap_set_modal(self.to_glib_none().0, modal.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_reveal_duration")]
    pub fn set_reveal_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_flap_set_reveal_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "hdy_flap_set_reveal_flap")]
    pub fn set_reveal_flap(&self, reveal_flap: bool) {
        unsafe {
            ffi::hdy_flap_set_reveal_flap(self.to_glib_none().0, reveal_flap.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_separator")]
    pub fn set_separator<P: IsA<gtk::Widget>>(&self, separator: Option<&P>) {
        unsafe {
            ffi::hdy_flap_set_separator(
                self.to_glib_none().0,
                separator.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_flap_set_swipe_to_close")]
    pub fn set_swipe_to_close(&self, swipe_to_close: bool) {
        unsafe {
            ffi::hdy_flap_set_swipe_to_close(self.to_glib_none().0, swipe_to_close.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_swipe_to_open")]
    pub fn set_swipe_to_open(&self, swipe_to_open: bool) {
        unsafe {
            ffi::hdy_flap_set_swipe_to_open(self.to_glib_none().0, swipe_to_open.into_glib());
        }
    }

    #[doc(alias = "hdy_flap_set_transition_type")]
    pub fn set_transition_type(&self, transition_type: FlapTransitionType) {
        unsafe {
            ffi::hdy_flap_set_transition_type(self.to_glib_none().0, transition_type.into_glib());
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "content")]
    pub fn connect_content_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_content_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::content\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_content_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "flap")]
    pub fn connect_flap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flap_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::flap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_flap_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "flap-position")]
    pub fn connect_flap_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flap_position_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::flap-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_flap_position_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "fold-duration")]
    pub fn connect_fold_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fold_duration_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fold-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fold_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "fold-policy")]
    pub fn connect_fold_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fold_policy_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fold-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fold_policy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "folded")]
    pub fn connect_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_folded_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_folded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "locked")]
    pub fn connect_locked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_locked_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::locked\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_locked_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "modal")]
    pub fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modal_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "reveal-duration")]
    pub fn connect_reveal_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reveal_duration_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reveal-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reveal_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "reveal-flap")]
    pub fn connect_reveal_flap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reveal_flap_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reveal-flap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reveal_flap_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "reveal-progress")]
    pub fn connect_reveal_progress_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reveal_progress_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reveal-progress\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reveal_progress_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "separator")]
    pub fn connect_separator_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_separator_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::separator\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_separator_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "swipe-to-close")]
    pub fn connect_swipe_to_close_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_swipe_to_close_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::swipe-to-close\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_swipe_to_close_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "swipe-to-open")]
    pub fn connect_swipe_to_open_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_swipe_to_open_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::swipe-to-open\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_swipe_to_open_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "transition-type")]
    pub fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_type_trampoline<F: Fn(&Flap) + 'static>(
            this: *mut ffi::HdyFlap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(any(feature = "v1_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
impl Default for Flap {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Flap`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct FlapBuilder {
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    content: Option<gtk::Widget>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    flap: Option<gtk::Widget>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    flap_position: Option<gtk::PackType>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    fold_duration: Option<u32>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    fold_policy: Option<FlapFoldPolicy>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    locked: Option<bool>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    modal: Option<bool>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    reveal_duration: Option<u32>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    reveal_flap: Option<bool>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    separator: Option<gtk::Widget>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    swipe_to_close: Option<bool>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    swipe_to_open: Option<bool>,
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    transition_type: Option<FlapTransitionType>,
    border_width: Option<u32>,
    child: Option<gtk::Widget>,
    resize_mode: Option<gtk::ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    double_buffered: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    focus_on_click: Option<bool>,
    halign: Option<gtk::Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_left: Option<i32>,
    margin_right: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<gtk::Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    //style: /*Unknown type*/,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    orientation: Option<gtk::Orientation>,
}

impl FlapBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`FlapBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Flap`].
    pub fn build(self) -> Flap {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref content) = self.content {
            properties.push(("content", content));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref flap) = self.flap {
            properties.push(("flap", flap));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref flap_position) = self.flap_position {
            properties.push(("flap-position", flap_position));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref fold_duration) = self.fold_duration {
            properties.push(("fold-duration", fold_duration));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref fold_policy) = self.fold_policy {
            properties.push(("fold-policy", fold_policy));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref locked) = self.locked {
            properties.push(("locked", locked));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref modal) = self.modal {
            properties.push(("modal", modal));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref reveal_duration) = self.reveal_duration {
            properties.push(("reveal-duration", reveal_duration));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref reveal_flap) = self.reveal_flap {
            properties.push(("reveal-flap", reveal_flap));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref separator) = self.separator {
            properties.push(("separator", separator));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref swipe_to_close) = self.swipe_to_close {
            properties.push(("swipe-to-close", swipe_to_close));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref swipe_to_open) = self.swipe_to_open {
            properties.push(("swipe-to-open", swipe_to_open));
        }
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref transition_type) = self.transition_type {
            properties.push(("transition-type", transition_type));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref double_buffered) = self.double_buffered {
            properties.push(("double-buffered", double_buffered));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_left) = self.margin_left {
            properties.push(("margin-left", margin_left));
        }
        if let Some(ref margin_right) = self.margin_right {
            properties.push(("margin-right", margin_right));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<Flap>(&properties).expect("Failed to create an instance of Flap")
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn content<P: IsA<gtk::Widget>>(mut self, content: &P) -> Self {
        self.content = Some(content.clone().upcast());
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn flap<P: IsA<gtk::Widget>>(mut self, flap: &P) -> Self {
        self.flap = Some(flap.clone().upcast());
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn flap_position(mut self, flap_position: gtk::PackType) -> Self {
        self.flap_position = Some(flap_position);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn fold_duration(mut self, fold_duration: u32) -> Self {
        self.fold_duration = Some(fold_duration);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn fold_policy(mut self, fold_policy: FlapFoldPolicy) -> Self {
        self.fold_policy = Some(fold_policy);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn locked(mut self, locked: bool) -> Self {
        self.locked = Some(locked);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn modal(mut self, modal: bool) -> Self {
        self.modal = Some(modal);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn reveal_duration(mut self, reveal_duration: u32) -> Self {
        self.reveal_duration = Some(reveal_duration);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn reveal_flap(mut self, reveal_flap: bool) -> Self {
        self.reveal_flap = Some(reveal_flap);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn separator<P: IsA<gtk::Widget>>(mut self, separator: &P) -> Self {
        self.separator = Some(separator.clone().upcast());
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn swipe_to_close(mut self, swipe_to_close: bool) -> Self {
        self.swipe_to_close = Some(swipe_to_close);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn swipe_to_open(mut self, swipe_to_open: bool) -> Self {
        self.swipe_to_open = Some(swipe_to_open);
        self
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn transition_type(mut self, transition_type: FlapTransitionType) -> Self {
        self.transition_type = Some(transition_type);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<gtk::Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: gtk::ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn double_buffered(mut self, double_buffered: bool) -> Self {
        self.double_buffered = Some(double_buffered);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_left(mut self, margin_left: i32) -> Self {
        self.margin_left = Some(margin_left);
        self
    }

    pub fn margin_right(mut self, margin_right: i32) -> Self {
        self.margin_right = Some(margin_right);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<gtk::Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

impl fmt::Display for Flap {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Flap")
    }
}
