#ifndef _SKIT_BLAS3_H
#define _SKIT_BLAS3_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

namespace rheolef {

// ============================[ CHECK SIZE ]====================================
template <class D, class B>
static inline
void
check_diag_mat_length (const D& d, const B& b)
{
    check_macro (d.n() == b.nrow(), "incompatible diag("
        << d.n()    << "," << d.n()   <<  ")*mat("
        << b.nrow() << "," << b.ncol()<<  ")");
}
template <class A, class D>
static inline
void
check_mat_diag_length (const A& a, const D& d)
{
    check_macro (a.ncol() == d.n(),          "incompatible mat("
        << a.nrow() << "," << a.ncol() << ")*diag("
        << d.n()    << "," << d.n()    << ")");
}
template <class A, class B>
static inline
void
check_mat_length (const A& a, const B& b)
{
    check_macro (a.nrow() == b.nrow() && a.ncol() == b.ncol(),
        "incompatible mat("
        << a.nrow() << "," << a.ncol() << ") +- mat("
        << b.nrow() << "," << b.ncol() << ") combination.");
}
template <class A, class B>
static inline
void
check_mat_mul_length (const A& a, const B& b)
{
    check_macro (a.ncol() == b.nrow(),
        "incompatible mat("
        << a.nrow() << "," << a.ncol() << ") * mat("
        << b.nrow() << "," << b.ncol() << ")");
}
// =========================[ MAT AND Float ]===================================
template <class T>
csr<T>
operator * (const csr<T>& a, const Float& lambda);

template <class T>
csr<T>
operator * (const Float& lambda, const csr<T>& a);

template <class T>
csr<T>
operator / (const csr<T>& a, const Float& lambda);

}// namespace rheolef
// ==============================[ others ]======================================

#ifdef _RHEOLEF_HAVE_EXPRESSION_TEMPLATE
#include "blas3-tmpl.h"
#else
#include "blas3-no-tmpl.h"
#endif

#endif // _SKIT_BLAS3_H
