% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{viridis_pal}
\alias{viridis_pal}
\title{Viridis Color Palettes}
\usage{
viridis_pal(alpha = 1, begin = 0, end = 1, direction = 1, option = "D")
}
\arguments{
\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the color map begins.}

\item{end}{The (corrected) hue in [0,1] at which the color map ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Eight options are available:
\itemize{
 \item "magma" (or "A")
 \item "inferno" (or "B")
 \item "plasma" (or "C")
 \item "viridis" (or "D")
 \item "cividis" (or "E")
 \item "rocket" (or "F")
 \item "mako" (or "G")
 \item "turbo" (or "H")
}}
}
\description{
A wrapper function around \code{\link[viridisLite]{viridis}} to
 turn it into a palette function compatible with
 \code{\link[ggplot2]{discrete_scale}}.
}
\details{
See \code{\link[viridisLite]{viridis}} and
 \code{\link[viridisLite]{viridis.map}} for more information on the color
 palettes.
}
\examples{
library(scales)
show_col(viridis_pal()(12))

}
\author{
Bob Rudis: \email{bob@rud.is}

Simon Garnier: \email{garnier@njit.edu}
}
