% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate.R
\name{iterate}
\alias{iterate}
\alias{iterate_n}
\alias{iterate_while}
\title{Repeatedly modify a graph by a function}
\usage{
iterate_n(.data, n, .f, ...)

iterate_while(.data, cnd, .f, ..., max_n = NULL)
}
\arguments{
\item{.data}{A \code{tbl_graph} object}

\item{n}{The number of times to iterate}

\item{.f}{A function taking in a \code{tbl_graph} as the first argument and
returning a \code{tbl_graph} object}

\item{...}{Further arguments passed on to \code{.f}}

\item{cnd}{A condition that must evaluate to \code{TRUE} or \code{FALSE} determining if
iteration should continue}

\item{max_n}{The maximum number of iterations in case \code{cnd} never evaluates
to \code{FALSE}}
}
\value{
A \code{tbl_graph} object
}
\description{
The iterate family of functions allow you to call the same modification
function on a graph until some condition is met. This can be used to create
simple simulations in a tidygraph friendly API
}
\examples{
# Gradually remove edges from the least connected nodes while avoiding
# isolates
create_notable('zachary') |>
  iterate_n(20, function(gr) {
    gr |>
      activate(nodes) |>
      mutate(deg = centrality_degree(), rank = order(deg)) |>
      activate(edges) |>
      slice(
        -which(edge_is_incident(.N()$rank == sum(.N()$deg == 1) + 1))[1]
      )
  })

# Remove a random edge until the graph is split in two
create_notable('zachary') |>
  iterate_while(graph_component_count() == 1, function(gr) {
    gr |>
      activate(edges) |>
      slice(-sample(graph_size(), 1))
  })

}
