% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie_utils.R
\name{susie_get_objective}
\alias{susie_get_objective}
\alias{susie_get_posterior_mean}
\alias{susie_get_posterior_sd}
\alias{susie_get_niter}
\alias{susie_get_prior_variance}
\alias{susie_get_residual_variance}
\alias{susie_get_lfsr}
\alias{susie_get_posterior_samples}
\alias{susie_get_cs}
\alias{susie_get_pip}
\title{Inferences From Fitted SuSiE Model}
\usage{
susie_get_objective(res, last_only = TRUE, warning_tol = 1e-06)

susie_get_posterior_mean(res, prior_tol = 1e-09)

susie_get_posterior_sd(res, prior_tol = 1e-09)

susie_get_niter(res)

susie_get_prior_variance(res)

susie_get_residual_variance(res)

susie_get_lfsr(res)

susie_get_posterior_samples(susie_fit, num_samples)

susie_get_cs(
  res,
  X = NULL,
  Xcorr = NULL,
  coverage = 0.95,
  min_abs_corr = 0.5,
  dedup = TRUE,
  squared = FALSE,
  check_symmetric = TRUE,
  n_purity = 100,
  use_rfast
)

susie_get_pip(res, prune_by_cs = FALSE, prior_tol = 1e-09)
}
\arguments{
\item{res}{A susie fit, typically an output from
\code{\link{susie}} or one of its variants. For
\code{susie_get_pip} and \code{susie_get_cs}, this may instead be
the posterior inclusion probability matrix, \code{alpha}.}

\item{last_only}{If \code{last_only = FALSE}, return the ELBO from
all iterations; otherwise return the ELBO from the last iteration
only.}

\item{warning_tol}{Warn if ELBO is decreasing by this
tolerance level.}

\item{prior_tol}{Filter out effects having estimated prior variance
smaller than this threshold.}

\item{susie_fit}{A susie fit, an output from \code{\link{susie}}.}

\item{num_samples}{The number of draws from the posterior
distribution.}

\item{X}{n by p matrix of values of the p variables (covariates) in
n samples. When provided, correlation between variables will be
computed and used to remove CSs whose minimum correlation among
variables is smaller than \code{min_abs_corr}.}

\item{Xcorr}{p by p matrix of correlations between variables
(covariates). When provided, it will be used to remove CSs whose
minimum correlation among variables is smaller than
\code{min_abs_corr}.}

\item{coverage}{A number between 0 and 1 specifying desired
coverage of each CS.}

\item{min_abs_corr}{A "purity" threshold for the CS. Any CS that
contains a pair of variables with correlation less than this
threshold will be filtered out and not reported.}

\item{dedup}{If \code{dedup = TRUE}, remove duplicate CSs.}

\item{squared}{If \code{squared = TRUE}, report min, mean and
median of squared correlation instead of the absolute correlation.}

\item{check_symmetric}{If \code{check_symmetric = TRUE}, perform a
check for symmetry of matrix \code{Xcorr} when \code{Xcorr} is
provided (not \code{NULL}).}

\item{n_purity}{The maximum number of credible set (CS) variables
used in calculating the correlation (\dQuote{purity})
statistics. When the number of variables included in the CS is
greater than this number, the CS variables are randomly subsampled.}

\item{use_rfast}{Use the Rfast package for the purity calculations.
By default \code{use_rfast = TRUE} if the Rfast package is
installed.}

\item{prune_by_cs}{Whether or not to ignore single effects not in
a reported CS when calculating PIP.}
}
\value{
\code{susie_get_objective} returns the evidence lower bound
(ELBO) achieved by the fitted susie model and, optionally, at each
iteration of the IBSS fitting procedure.

\code{susie_get_residual_variance} returns the (estimated or
fixed) residual variance parameter.

\code{susie_get_prior_variance} returns the (estimated or fixed)
prior variance parameters.

\code{susie_get_posterior_mean} returns the posterior mean for the
regression coefficients of the fitted susie model.

\code{susie_get_posterior_sd} returns the posterior standard
deviation for coefficients of the fitted susie model.

\code{susie_get_niter} returns the number of model fitting
iterations performed.

\code{susie_get_pip} returns a vector containing the posterior
inclusion probabilities (PIPs) for all variables.

\code{susie_get_lfsr} returns a vector containing the average lfsr
across variables for each single-effect, weighted by the posterior
inclusion probability (alpha).

\code{susie_get_posterior_samples} returns a list containing the
effect sizes samples and causal status with two components: \code{b},
an \code{num_variables} x \code{num_samples} matrix of effect
sizes; \code{gamma}, an \code{num_variables} x \code{num_samples}
matrix of causal status random draws.

\code{susie_get_cs} returns credible sets (CSs) from a susie fit,
as well as summaries of correlation among the variables included in
each CS. If desired, one can filter out CSs that do not meet a
specified \dQuote{purity} threshold; to do this, either \code{X} or
\code{Xcorr} must be supplied. It returns a list with the following
elements:

\item{cs}{A list in which each list element is a vector containing
  the indices of the variables in the CS.}

\item{coverage}{The nominal coverage specified for each CS.}

\item{purity}{If \code{X} or \code{Xcorr} iis provided), the
  purity of each CS.}

\item{cs_index}{If \code{X} or \code{Xcorr} is provided) the index
  (number between 1 and L) of each reported CS in the supplied susie
  fit.}
}
\description{
These functions access basic properties or draw
  inferences from a fitted susie model.
}
\examples{
set.seed(1)
n = 1000
p = 1000
beta = rep(0,p)
beta[1:4] = 1
X = matrix(rnorm(n*p),nrow = n,ncol = p)
X = scale(X,center = TRUE,scale = TRUE)
y = drop(X \%*\% beta + rnorm(n))
s = susie(X,y,L = 10)
susie_get_objective(s)
susie_get_objective(s, last_only=FALSE)
susie_get_residual_variance(s)
susie_get_prior_variance(s)
susie_get_posterior_mean(s)
susie_get_posterior_sd(s)
susie_get_niter(s)
susie_get_pip(s)
susie_get_lfsr(s)

}
