% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-auth-code.R
\name{req_oauth_auth_code}
\alias{req_oauth_auth_code}
\alias{oauth_flow_auth_code}
\title{OAuth with authorization code}
\usage{
req_oauth_auth_code(
  req,
  client,
  auth_url,
  scope = NULL,
  pkce = TRUE,
  auth_params = list(),
  token_params = list(),
  redirect_uri = oauth_redirect_uri(),
  cache_disk = FALSE,
  cache_key = NULL,
  host_name = deprecated(),
  host_ip = deprecated(),
  port = deprecated()
)

oauth_flow_auth_code(
  client,
  auth_url,
  scope = NULL,
  pkce = TRUE,
  auth_params = list(),
  token_params = list(),
  redirect_uri = oauth_redirect_uri(),
  host_name = deprecated(),
  host_ip = deprecated(),
  port = deprecated()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{pkce}{Use "Proof Key for Code Exchange"? This adds an extra layer of
security and should always be used if supported by the server.}

\item{auth_params}{A list containing additional parameters passed to
\code{\link[=oauth_flow_auth_code_url]{oauth_flow_auth_code_url()}}.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}

\item{redirect_uri}{URL to redirect back to after authorization is complete.
Often this must be registered with the API in advance.

httr2 supports three forms of redirect. Firstly, you can use a \code{localhost}
url (the default), where httr2 will set up a temporary webserver to listen
for the OAuth redirect. In this case, httr2 will automatically append a
random port. If you need to set it to a fixed port because the API requires
it, then specify it with (e.g.) \code{"http://localhost:1011"}. This technique
works well when you are working on your own computer.

Secondly, you can provide a URL to a website that uses Javascript to
give the user a code to copy and paste back into the R session (see
\url{https://www.tidyverse.org/google-callback/} and
\url{https://github.com/r-lib/gargle/blob/main/inst/pseudo-oob/google-callback/index.html}
for examples). This is less convenient (because it requires more
user interaction) but also works in hosted environments like RStudio
Server.

Finally, hosted platforms might set the \code{HTTR2_OAUTH_REDIRECT_URL} and
\code{HTTR2_OAUTH_CODE_SOURCE_URL} environment variables. In this case, httr2
will use \code{HTTR2_OAUTH_REDIRECT_URL} for redirects by default, and poll the
\code{HTTR2_OAUTH_CODE_SOURCE_URL} endpoint with the state parameter until it
receives a code in the response (or encounters an error). This delegates
completion of the authorization flow to the hosted platform.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk.

Learn more in \code{vignette("oauth")}}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}

\item{host_name, host_ip, port}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Now use \code{redirect_uri} instead.}
}
\value{
\code{req_oauth_auth_code()} returns a modified HTTP \link{request} that will
use OAuth; \code{oauth_flow_auth_code()} returns an \link{oauth_token}.
}
\description{
Authenticate using the OAuth \strong{authorization code flow}, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.1}{Section 4.1 of RFC 6749}.

This flow is the most commonly used OAuth flow where the user
opens a page in their browser, approves the access, and then returns to R.
When possible, it redirects the browser back to a temporary local webserver
to capture the authorization code. When this is not possible (e.g. when
running on a hosted platform like RStudio Server), provide a custom
\code{redirect_uri} and httr2 will prompt the user to enter the code manually.

Learn more about the overall OAuth authentication flow in \code{vignette("oauth")}.
}
\section{Security considerations}{
The authorization code flow is used for both web applications and native
applications (which are equivalent to R packages). \href{https://datatracker.ietf.org/doc/html/rfc8252}{RFC 8252} spells out
important considerations for native apps. Most importantly there's no way
for native apps to keep secrets from their users. This means that the
server should either not require a \code{client_secret} (i.e. a public client
not an confidential client) or ensure that possession of the \code{client_secret}
doesn't bestow any meaningful rights.

Only modern APIs from the bigger players (Azure, Google, etc) explicitly
native apps. However, in most cases, even for older APIs, possessing the
\code{client_secret} gives you no ability to do anything harmful, so our
general principle is that it's fine to include it in an R package, as long
as it's mildly obfuscated to protect it from credential scraping. There's
no incentive to steal your client credentials if it takes less time to
create a new client than find your client secret.
}

\examples{
req_auth_github <- function(req) {
  req_oauth_auth_code(
    req,
    client = example_github_client(),
    auth_url = "https://github.com/login/oauth/authorize"
  )
}

request("https://api.github.com/user") |>
  req_auth_github()
}
\seealso{
\code{\link[=oauth_flow_auth_code_url]{oauth_flow_auth_code_url()}} for the components necessary to
write your own auth code flow, if the API you are wrapping does not adhere
closely to the standard.

Other OAuth flows: 
\code{\link{req_oauth_bearer_jwt}()},
\code{\link{req_oauth_client_credentials}()},
\code{\link{req_oauth_password}()},
\code{\link{req_oauth_refresh}()}
}
\concept{OAuth flows}
