% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R, R/mstl.R
\name{autoplot.decomposed.ts}
\alias{autoplot.decomposed.ts}
\alias{autoplot.stl}
\alias{autoplot.StructTS}
\alias{autoplot.seas}
\alias{autoplot.mstl}
\title{Plot time series decomposition components using ggplot}
\usage{
\method{autoplot}{decomposed.ts}(object, labels = NULL, range.bars = NULL, ...)

\method{autoplot}{stl}(object, labels = NULL, range.bars = TRUE, ...)

\method{autoplot}{StructTS}(object, labels = NULL, range.bars = TRUE, ...)

\method{autoplot}{seas}(object, labels = NULL, range.bars = NULL, ...)

\method{autoplot}{mstl}(object, ...)
}
\arguments{
\item{object}{Object of class \code{seas}, \code{stl}, or \code{decomposed.ts}.}

\item{labels}{Labels to replace "seasonal", "trend", and "remainder".}

\item{range.bars}{Logical indicating if each plot should have a bar at its
right side representing relative size. If \code{NULL}, automatic selection
takes place.}

\item{...}{Other plotting parameters to affect the plot.}
}
\value{
Returns an object of class \code{ggplot}.
}
\description{
Produces a ggplot object of seasonally decomposed time series for objects of
class \code{stl} (created with \code{\link[stats:stl]{stats::stl()}}, class \code{seas} (created with
\code{\link[seasonal:seas]{seasonal::seas()}}), or class \code{decomposed.ts} (created with
\code{\link[stats:decompose]{stats::decompose()}}).
}
\examples{

library(ggplot2)
co2 |>
  decompose() |>
  autoplot()
nottem |>
  stl(s.window = "periodic") |>
  autoplot()
\dontrun{
library(seasonal)
seas(USAccDeaths) |> autoplot()
}

}
\seealso{
\code{\link[seasonal:seas]{seasonal::seas()}}, \code{\link[stats:stl]{stats::stl()}}, \code{\link[stats:decompose]{stats::decompose()}},
\code{\link[stats:StructTS]{stats::StructTS()}}, \code{\link[stats:stlmethods]{stats::plot.stl()}}.
}
\author{
Mitchell O'Hara-Wild
}
