% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colCounts,xgCMatrix-method}
\alias{colCounts,xgCMatrix-method}
\alias{rowCounts,xgCMatrix-method}
\title{Count how often an element in a row (column) of a matrix-like object is
equal to a value}
\usage{
\S4method{colCounts}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  useNames = TRUE
)

\S4method{rowCounts}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  useNames = TRUE
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{integer}} \code{\link{vector}} of length N (K).
}
\description{
Count how often an element in a row (column) of a matrix-like object is
equal to a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowCounts}} /
\code{matrixStats::\link[matrixStats]{colCounts}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowCounts(mat)
colCounts(mat)
  rowCounts(mat, value = 0)
  colCounts(mat, value = Inf, na.rm = TRUE)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowCounts}()} and
\code{matrixStats::\link[matrixStats:rowCounts]{colCounts}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}. To check if all elements are equal, see
\code{\link[MatrixGenerics]{rowAlls}()}.
}
}
