# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.numbers.v2.regulatory_compliance import RegulatoryComplianceList


class V2(Version):

    def __init__(self, domain):
        """
        Initialize the V2 version of Numbers

        :returns: V2 version of Numbers
        :rtype: twilio.rest.numbers.v2.V2.V2
        """
        super(V2, self).__init__(domain)
        self.version = 'v2'
        self._regulatory_compliance = None

    @property
    def regulatory_compliance(self):
        """
        :rtype: twilio.rest.numbers.v2.regulatory_compliance.RegulatoryComplianceList
        """
        if self._regulatory_compliance is None:
            self._regulatory_compliance = RegulatoryComplianceList(self)
        return self._regulatory_compliance

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Numbers.V2>'
