# kubernetes.client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1.6.3
- Package version: 2.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/kubernetes-incubator/client-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/kubernetes-incubator/client-python.git`)

Then import the package:
```python
import kubernetes.client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kubernetes.client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import kubernetes.client
from kubernetes.client.rest import ApiException
from pprint import pprint

# Configure API key authorization: BearerToken
kubernetes.client.configuration.api_key['authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# kubernetes.client.configuration.api_key_prefix['authorization'] = 'Bearer'
# create an instance of the API class
api_instance = kubernetes.client.ApisApi()

try:
    api_response = api_instance.get_api_versions()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ApisApi->get_api_versions: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApisApi* | [**get_api_versions**](docs/ApisApi.md#get_api_versions) | **GET** /apis/ | 
*AppsApi* | [**get_api_group**](docs/AppsApi.md#get_api_group) | **GET** /apis/apps/ | 
*AppsV1beta1Api* | [**create_namespaced_deployment**](docs/AppsV1beta1Api.md#create_namespaced_deployment) | **POST** /apis/apps/v1beta1/namespaces/{namespace}/deployments | 
*AppsV1beta1Api* | [**create_namespaced_deployment_rollback_rollback**](docs/AppsV1beta1Api.md#create_namespaced_deployment_rollback_rollback) | **POST** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/rollback | 
*AppsV1beta1Api* | [**create_namespaced_stateful_set**](docs/AppsV1beta1Api.md#create_namespaced_stateful_set) | **POST** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets | 
*AppsV1beta1Api* | [**delete_collection_namespaced_deployment**](docs/AppsV1beta1Api.md#delete_collection_namespaced_deployment) | **DELETE** /apis/apps/v1beta1/namespaces/{namespace}/deployments | 
*AppsV1beta1Api* | [**delete_collection_namespaced_stateful_set**](docs/AppsV1beta1Api.md#delete_collection_namespaced_stateful_set) | **DELETE** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets | 
*AppsV1beta1Api* | [**delete_namespaced_deployment**](docs/AppsV1beta1Api.md#delete_namespaced_deployment) | **DELETE** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name} | 
*AppsV1beta1Api* | [**delete_namespaced_stateful_set**](docs/AppsV1beta1Api.md#delete_namespaced_stateful_set) | **DELETE** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1beta1Api* | [**get_api_resources**](docs/AppsV1beta1Api.md#get_api_resources) | **GET** /apis/apps/v1beta1/ | 
*AppsV1beta1Api* | [**list_deployment_for_all_namespaces**](docs/AppsV1beta1Api.md#list_deployment_for_all_namespaces) | **GET** /apis/apps/v1beta1/deployments | 
*AppsV1beta1Api* | [**list_namespaced_deployment**](docs/AppsV1beta1Api.md#list_namespaced_deployment) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/deployments | 
*AppsV1beta1Api* | [**list_namespaced_stateful_set**](docs/AppsV1beta1Api.md#list_namespaced_stateful_set) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets | 
*AppsV1beta1Api* | [**list_stateful_set_for_all_namespaces**](docs/AppsV1beta1Api.md#list_stateful_set_for_all_namespaces) | **GET** /apis/apps/v1beta1/statefulsets | 
*AppsV1beta1Api* | [**patch_namespaced_deployment**](docs/AppsV1beta1Api.md#patch_namespaced_deployment) | **PATCH** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name} | 
*AppsV1beta1Api* | [**patch_namespaced_deployment_status**](docs/AppsV1beta1Api.md#patch_namespaced_deployment_status) | **PATCH** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1beta1Api* | [**patch_namespaced_scale_scale**](docs/AppsV1beta1Api.md#patch_namespaced_scale_scale) | **PATCH** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1beta1Api* | [**patch_namespaced_stateful_set**](docs/AppsV1beta1Api.md#patch_namespaced_stateful_set) | **PATCH** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1beta1Api* | [**patch_namespaced_stateful_set_status**](docs/AppsV1beta1Api.md#patch_namespaced_stateful_set_status) | **PATCH** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name}/status | 
*AppsV1beta1Api* | [**read_namespaced_deployment**](docs/AppsV1beta1Api.md#read_namespaced_deployment) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name} | 
*AppsV1beta1Api* | [**read_namespaced_deployment_status**](docs/AppsV1beta1Api.md#read_namespaced_deployment_status) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1beta1Api* | [**read_namespaced_scale_scale**](docs/AppsV1beta1Api.md#read_namespaced_scale_scale) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1beta1Api* | [**read_namespaced_stateful_set**](docs/AppsV1beta1Api.md#read_namespaced_stateful_set) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1beta1Api* | [**read_namespaced_stateful_set_status**](docs/AppsV1beta1Api.md#read_namespaced_stateful_set_status) | **GET** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name}/status | 
*AppsV1beta1Api* | [**replace_namespaced_deployment**](docs/AppsV1beta1Api.md#replace_namespaced_deployment) | **PUT** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name} | 
*AppsV1beta1Api* | [**replace_namespaced_deployment_status**](docs/AppsV1beta1Api.md#replace_namespaced_deployment_status) | **PUT** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1beta1Api* | [**replace_namespaced_scale_scale**](docs/AppsV1beta1Api.md#replace_namespaced_scale_scale) | **PUT** /apis/apps/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1beta1Api* | [**replace_namespaced_stateful_set**](docs/AppsV1beta1Api.md#replace_namespaced_stateful_set) | **PUT** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1beta1Api* | [**replace_namespaced_stateful_set_status**](docs/AppsV1beta1Api.md#replace_namespaced_stateful_set_status) | **PUT** /apis/apps/v1beta1/namespaces/{namespace}/statefulsets/{name}/status | 
*AuthenticationApi* | [**get_api_group**](docs/AuthenticationApi.md#get_api_group) | **GET** /apis/authentication.k8s.io/ | 
*AuthenticationV1Api* | [**create_token_review**](docs/AuthenticationV1Api.md#create_token_review) | **POST** /apis/authentication.k8s.io/v1/tokenreviews | 
*AuthenticationV1Api* | [**get_api_resources**](docs/AuthenticationV1Api.md#get_api_resources) | **GET** /apis/authentication.k8s.io/v1/ | 
*AuthenticationV1beta1Api* | [**create_token_review**](docs/AuthenticationV1beta1Api.md#create_token_review) | **POST** /apis/authentication.k8s.io/v1beta1/tokenreviews | 
*AuthenticationV1beta1Api* | [**get_api_resources**](docs/AuthenticationV1beta1Api.md#get_api_resources) | **GET** /apis/authentication.k8s.io/v1beta1/ | 
*AuthorizationApi* | [**get_api_group**](docs/AuthorizationApi.md#get_api_group) | **GET** /apis/authorization.k8s.io/ | 
*AuthorizationV1Api* | [**create_namespaced_local_subject_access_review**](docs/AuthorizationV1Api.md#create_namespaced_local_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/namespaces/{namespace}/localsubjectaccessreviews | 
*AuthorizationV1Api* | [**create_self_subject_access_review**](docs/AuthorizationV1Api.md#create_self_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/selfsubjectaccessreviews | 
*AuthorizationV1Api* | [**create_subject_access_review**](docs/AuthorizationV1Api.md#create_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/subjectaccessreviews | 
*AuthorizationV1Api* | [**get_api_resources**](docs/AuthorizationV1Api.md#get_api_resources) | **GET** /apis/authorization.k8s.io/v1/ | 
*AuthorizationV1beta1Api* | [**create_namespaced_local_subject_access_review**](docs/AuthorizationV1beta1Api.md#create_namespaced_local_subject_access_review) | **POST** /apis/authorization.k8s.io/v1beta1/namespaces/{namespace}/localsubjectaccessreviews | 
*AuthorizationV1beta1Api* | [**create_self_subject_access_review**](docs/AuthorizationV1beta1Api.md#create_self_subject_access_review) | **POST** /apis/authorization.k8s.io/v1beta1/selfsubjectaccessreviews | 
*AuthorizationV1beta1Api* | [**create_subject_access_review**](docs/AuthorizationV1beta1Api.md#create_subject_access_review) | **POST** /apis/authorization.k8s.io/v1beta1/subjectaccessreviews | 
*AuthorizationV1beta1Api* | [**get_api_resources**](docs/AuthorizationV1beta1Api.md#get_api_resources) | **GET** /apis/authorization.k8s.io/v1beta1/ | 
*AutoscalingApi* | [**get_api_group**](docs/AutoscalingApi.md#get_api_group) | **GET** /apis/autoscaling/ | 
*AutoscalingV1Api* | [**create_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#create_namespaced_horizontal_pod_autoscaler) | **POST** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**delete_collection_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#delete_collection_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**delete_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#delete_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**get_api_resources**](docs/AutoscalingV1Api.md#get_api_resources) | **GET** /apis/autoscaling/v1/ | 
*AutoscalingV1Api* | [**list_horizontal_pod_autoscaler_for_all_namespaces**](docs/AutoscalingV1Api.md#list_horizontal_pod_autoscaler_for_all_namespaces) | **GET** /apis/autoscaling/v1/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**list_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#list_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**patch_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#patch_namespaced_horizontal_pod_autoscaler) | **PATCH** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**patch_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#patch_namespaced_horizontal_pod_autoscaler_status) | **PATCH** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV1Api* | [**read_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#read_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**read_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#read_namespaced_horizontal_pod_autoscaler_status) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV1Api* | [**replace_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#replace_namespaced_horizontal_pod_autoscaler) | **PUT** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**replace_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#replace_namespaced_horizontal_pod_autoscaler_status) | **PUT** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2alpha1Api* | [**create_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#create_namespaced_horizontal_pod_autoscaler) | **POST** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2alpha1Api* | [**delete_collection_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#delete_collection_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2alpha1Api* | [**delete_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#delete_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2alpha1Api* | [**get_api_resources**](docs/AutoscalingV2alpha1Api.md#get_api_resources) | **GET** /apis/autoscaling/v2alpha1/ | 
*AutoscalingV2alpha1Api* | [**list_horizontal_pod_autoscaler_for_all_namespaces**](docs/AutoscalingV2alpha1Api.md#list_horizontal_pod_autoscaler_for_all_namespaces) | **GET** /apis/autoscaling/v2alpha1/horizontalpodautoscalers | 
*AutoscalingV2alpha1Api* | [**list_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#list_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2alpha1Api* | [**patch_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#patch_namespaced_horizontal_pod_autoscaler) | **PATCH** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2alpha1Api* | [**patch_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2alpha1Api.md#patch_namespaced_horizontal_pod_autoscaler_status) | **PATCH** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2alpha1Api* | [**read_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#read_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2alpha1Api* | [**read_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2alpha1Api.md#read_namespaced_horizontal_pod_autoscaler_status) | **GET** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2alpha1Api* | [**replace_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2alpha1Api.md#replace_namespaced_horizontal_pod_autoscaler) | **PUT** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2alpha1Api* | [**replace_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2alpha1Api.md#replace_namespaced_horizontal_pod_autoscaler_status) | **PUT** /apis/autoscaling/v2alpha1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*BatchApi* | [**get_api_group**](docs/BatchApi.md#get_api_group) | **GET** /apis/batch/ | 
*BatchV1Api* | [**create_namespaced_job**](docs/BatchV1Api.md#create_namespaced_job) | **POST** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**delete_collection_namespaced_job**](docs/BatchV1Api.md#delete_collection_namespaced_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**delete_namespaced_job**](docs/BatchV1Api.md#delete_namespaced_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**get_api_resources**](docs/BatchV1Api.md#get_api_resources) | **GET** /apis/batch/v1/ | 
*BatchV1Api* | [**list_job_for_all_namespaces**](docs/BatchV1Api.md#list_job_for_all_namespaces) | **GET** /apis/batch/v1/jobs | 
*BatchV1Api* | [**list_namespaced_job**](docs/BatchV1Api.md#list_namespaced_job) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**patch_namespaced_job**](docs/BatchV1Api.md#patch_namespaced_job) | **PATCH** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**patch_namespaced_job_status**](docs/BatchV1Api.md#patch_namespaced_job_status) | **PATCH** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV1Api* | [**read_namespaced_job**](docs/BatchV1Api.md#read_namespaced_job) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**read_namespaced_job_status**](docs/BatchV1Api.md#read_namespaced_job_status) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV1Api* | [**replace_namespaced_job**](docs/BatchV1Api.md#replace_namespaced_job) | **PUT** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**replace_namespaced_job_status**](docs/BatchV1Api.md#replace_namespaced_job_status) | **PUT** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV2alpha1Api* | [**create_namespaced_cron_job**](docs/BatchV2alpha1Api.md#create_namespaced_cron_job) | **POST** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs | 
*BatchV2alpha1Api* | [**create_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#create_namespaced_scheduled_job) | **POST** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs | 
*BatchV2alpha1Api* | [**delete_collection_namespaced_cron_job**](docs/BatchV2alpha1Api.md#delete_collection_namespaced_cron_job) | **DELETE** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs | 
*BatchV2alpha1Api* | [**delete_collection_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#delete_collection_namespaced_scheduled_job) | **DELETE** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs | 
*BatchV2alpha1Api* | [**delete_namespaced_cron_job**](docs/BatchV2alpha1Api.md#delete_namespaced_cron_job) | **DELETE** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV2alpha1Api* | [**delete_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#delete_namespaced_scheduled_job) | **DELETE** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name} | 
*BatchV2alpha1Api* | [**get_api_resources**](docs/BatchV2alpha1Api.md#get_api_resources) | **GET** /apis/batch/v2alpha1/ | 
*BatchV2alpha1Api* | [**list_cron_job_for_all_namespaces**](docs/BatchV2alpha1Api.md#list_cron_job_for_all_namespaces) | **GET** /apis/batch/v2alpha1/cronjobs | 
*BatchV2alpha1Api* | [**list_namespaced_cron_job**](docs/BatchV2alpha1Api.md#list_namespaced_cron_job) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs | 
*BatchV2alpha1Api* | [**list_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#list_namespaced_scheduled_job) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs | 
*BatchV2alpha1Api* | [**list_scheduled_job_for_all_namespaces**](docs/BatchV2alpha1Api.md#list_scheduled_job_for_all_namespaces) | **GET** /apis/batch/v2alpha1/scheduledjobs | 
*BatchV2alpha1Api* | [**patch_namespaced_cron_job**](docs/BatchV2alpha1Api.md#patch_namespaced_cron_job) | **PATCH** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV2alpha1Api* | [**patch_namespaced_cron_job_status**](docs/BatchV2alpha1Api.md#patch_namespaced_cron_job_status) | **PATCH** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV2alpha1Api* | [**patch_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#patch_namespaced_scheduled_job) | **PATCH** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name} | 
*BatchV2alpha1Api* | [**patch_namespaced_scheduled_job_status**](docs/BatchV2alpha1Api.md#patch_namespaced_scheduled_job_status) | **PATCH** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status | 
*BatchV2alpha1Api* | [**read_namespaced_cron_job**](docs/BatchV2alpha1Api.md#read_namespaced_cron_job) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV2alpha1Api* | [**read_namespaced_cron_job_status**](docs/BatchV2alpha1Api.md#read_namespaced_cron_job_status) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV2alpha1Api* | [**read_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#read_namespaced_scheduled_job) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name} | 
*BatchV2alpha1Api* | [**read_namespaced_scheduled_job_status**](docs/BatchV2alpha1Api.md#read_namespaced_scheduled_job_status) | **GET** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status | 
*BatchV2alpha1Api* | [**replace_namespaced_cron_job**](docs/BatchV2alpha1Api.md#replace_namespaced_cron_job) | **PUT** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV2alpha1Api* | [**replace_namespaced_cron_job_status**](docs/BatchV2alpha1Api.md#replace_namespaced_cron_job_status) | **PUT** /apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV2alpha1Api* | [**replace_namespaced_scheduled_job**](docs/BatchV2alpha1Api.md#replace_namespaced_scheduled_job) | **PUT** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name} | 
*BatchV2alpha1Api* | [**replace_namespaced_scheduled_job_status**](docs/BatchV2alpha1Api.md#replace_namespaced_scheduled_job_status) | **PUT** /apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status | 
*CertificatesApi* | [**get_api_group**](docs/CertificatesApi.md#get_api_group) | **GET** /apis/certificates.k8s.io/ | 
*CertificatesV1beta1Api* | [**create_certificate_signing_request**](docs/CertificatesV1beta1Api.md#create_certificate_signing_request) | **POST** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests | 
*CertificatesV1beta1Api* | [**delete_certificate_signing_request**](docs/CertificatesV1beta1Api.md#delete_certificate_signing_request) | **DELETE** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name} | 
*CertificatesV1beta1Api* | [**delete_collection_certificate_signing_request**](docs/CertificatesV1beta1Api.md#delete_collection_certificate_signing_request) | **DELETE** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests | 
*CertificatesV1beta1Api* | [**get_api_resources**](docs/CertificatesV1beta1Api.md#get_api_resources) | **GET** /apis/certificates.k8s.io/v1beta1/ | 
*CertificatesV1beta1Api* | [**list_certificate_signing_request**](docs/CertificatesV1beta1Api.md#list_certificate_signing_request) | **GET** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests | 
*CertificatesV1beta1Api* | [**patch_certificate_signing_request**](docs/CertificatesV1beta1Api.md#patch_certificate_signing_request) | **PATCH** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name} | 
*CertificatesV1beta1Api* | [**read_certificate_signing_request**](docs/CertificatesV1beta1Api.md#read_certificate_signing_request) | **GET** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name} | 
*CertificatesV1beta1Api* | [**replace_certificate_signing_request**](docs/CertificatesV1beta1Api.md#replace_certificate_signing_request) | **PUT** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name} | 
*CertificatesV1beta1Api* | [**replace_certificate_signing_request_approval**](docs/CertificatesV1beta1Api.md#replace_certificate_signing_request_approval) | **PUT** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name}/approval | 
*CertificatesV1beta1Api* | [**replace_certificate_signing_request_status**](docs/CertificatesV1beta1Api.md#replace_certificate_signing_request_status) | **PUT** /apis/certificates.k8s.io/v1beta1/certificatesigningrequests/{name}/status | 
*CoreApi* | [**get_api_versions**](docs/CoreApi.md#get_api_versions) | **GET** /api/ | 
*CoreV1Api* | [**connect_delete_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_delete_namespaced_pod_proxy) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_delete_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_delete_namespaced_pod_proxy_with_path) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_delete_namespaced_service_proxy**](docs/CoreV1Api.md#connect_delete_namespaced_service_proxy) | **DELETE** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_delete_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_delete_namespaced_service_proxy_with_path) | **DELETE** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_delete_node_proxy**](docs/CoreV1Api.md#connect_delete_node_proxy) | **DELETE** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_delete_node_proxy_with_path**](docs/CoreV1Api.md#connect_delete_node_proxy_with_path) | **DELETE** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_namespaced_pod_attach**](docs/CoreV1Api.md#connect_get_namespaced_pod_attach) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/attach | 
*CoreV1Api* | [**connect_get_namespaced_pod_exec**](docs/CoreV1Api.md#connect_get_namespaced_pod_exec) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/exec | 
*CoreV1Api* | [**connect_get_namespaced_pod_portforward**](docs/CoreV1Api.md#connect_get_namespaced_pod_portforward) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/portforward | 
*CoreV1Api* | [**connect_get_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_get_namespaced_pod_proxy) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_get_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_get_namespaced_pod_proxy_with_path) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_namespaced_service_proxy**](docs/CoreV1Api.md#connect_get_namespaced_service_proxy) | **GET** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_get_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_get_namespaced_service_proxy_with_path) | **GET** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_node_proxy**](docs/CoreV1Api.md#connect_get_node_proxy) | **GET** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_get_node_proxy_with_path**](docs/CoreV1Api.md#connect_get_node_proxy_with_path) | **GET** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_head_namespaced_pod_proxy) | **HEAD** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_head_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_head_namespaced_pod_proxy_with_path) | **HEAD** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_namespaced_service_proxy**](docs/CoreV1Api.md#connect_head_namespaced_service_proxy) | **HEAD** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_head_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_head_namespaced_service_proxy_with_path) | **HEAD** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_node_proxy**](docs/CoreV1Api.md#connect_head_node_proxy) | **HEAD** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_head_node_proxy_with_path**](docs/CoreV1Api.md#connect_head_node_proxy_with_path) | **HEAD** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_options_namespaced_pod_proxy) | **OPTIONS** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_options_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_options_namespaced_pod_proxy_with_path) | **OPTIONS** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_namespaced_service_proxy**](docs/CoreV1Api.md#connect_options_namespaced_service_proxy) | **OPTIONS** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_options_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_options_namespaced_service_proxy_with_path) | **OPTIONS** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_node_proxy**](docs/CoreV1Api.md#connect_options_node_proxy) | **OPTIONS** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_options_node_proxy_with_path**](docs/CoreV1Api.md#connect_options_node_proxy_with_path) | **OPTIONS** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_namespaced_pod_attach**](docs/CoreV1Api.md#connect_post_namespaced_pod_attach) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/attach | 
*CoreV1Api* | [**connect_post_namespaced_pod_exec**](docs/CoreV1Api.md#connect_post_namespaced_pod_exec) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/exec | 
*CoreV1Api* | [**connect_post_namespaced_pod_portforward**](docs/CoreV1Api.md#connect_post_namespaced_pod_portforward) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/portforward | 
*CoreV1Api* | [**connect_post_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_post_namespaced_pod_proxy) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_post_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_post_namespaced_pod_proxy_with_path) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_namespaced_service_proxy**](docs/CoreV1Api.md#connect_post_namespaced_service_proxy) | **POST** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_post_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_post_namespaced_service_proxy_with_path) | **POST** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_node_proxy**](docs/CoreV1Api.md#connect_post_node_proxy) | **POST** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_post_node_proxy_with_path**](docs/CoreV1Api.md#connect_post_node_proxy_with_path) | **POST** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_put_namespaced_pod_proxy) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_put_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_put_namespaced_pod_proxy_with_path) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_namespaced_service_proxy**](docs/CoreV1Api.md#connect_put_namespaced_service_proxy) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_put_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_put_namespaced_service_proxy_with_path) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_node_proxy**](docs/CoreV1Api.md#connect_put_node_proxy) | **PUT** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_put_node_proxy_with_path**](docs/CoreV1Api.md#connect_put_node_proxy_with_path) | **PUT** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**create_namespace**](docs/CoreV1Api.md#create_namespace) | **POST** /api/v1/namespaces | 
*CoreV1Api* | [**create_namespaced_binding**](docs/CoreV1Api.md#create_namespaced_binding) | **POST** /api/v1/namespaces/{namespace}/bindings | 
*CoreV1Api* | [**create_namespaced_binding_binding**](docs/CoreV1Api.md#create_namespaced_binding_binding) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/binding | 
*CoreV1Api* | [**create_namespaced_config_map**](docs/CoreV1Api.md#create_namespaced_config_map) | **POST** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**create_namespaced_endpoints**](docs/CoreV1Api.md#create_namespaced_endpoints) | **POST** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**create_namespaced_event**](docs/CoreV1Api.md#create_namespaced_event) | **POST** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**create_namespaced_eviction_eviction**](docs/CoreV1Api.md#create_namespaced_eviction_eviction) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/eviction | 
*CoreV1Api* | [**create_namespaced_limit_range**](docs/CoreV1Api.md#create_namespaced_limit_range) | **POST** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**create_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#create_namespaced_persistent_volume_claim) | **POST** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**create_namespaced_pod**](docs/CoreV1Api.md#create_namespaced_pod) | **POST** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**create_namespaced_pod_template**](docs/CoreV1Api.md#create_namespaced_pod_template) | **POST** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**create_namespaced_replication_controller**](docs/CoreV1Api.md#create_namespaced_replication_controller) | **POST** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**create_namespaced_resource_quota**](docs/CoreV1Api.md#create_namespaced_resource_quota) | **POST** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**create_namespaced_secret**](docs/CoreV1Api.md#create_namespaced_secret) | **POST** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**create_namespaced_service**](docs/CoreV1Api.md#create_namespaced_service) | **POST** /api/v1/namespaces/{namespace}/services | 
*CoreV1Api* | [**create_namespaced_service_account**](docs/CoreV1Api.md#create_namespaced_service_account) | **POST** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**create_node**](docs/CoreV1Api.md#create_node) | **POST** /api/v1/nodes | 
*CoreV1Api* | [**create_persistent_volume**](docs/CoreV1Api.md#create_persistent_volume) | **POST** /api/v1/persistentvolumes | 
*CoreV1Api* | [**delete_collection_namespace**](docs/CoreV1Api.md#delete_collection_namespace) | **DELETE** /api/v1/namespaces | 
*CoreV1Api* | [**delete_collection_namespaced_config_map**](docs/CoreV1Api.md#delete_collection_namespaced_config_map) | **DELETE** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**delete_collection_namespaced_endpoints**](docs/CoreV1Api.md#delete_collection_namespaced_endpoints) | **DELETE** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**delete_collection_namespaced_event**](docs/CoreV1Api.md#delete_collection_namespaced_event) | **DELETE** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**delete_collection_namespaced_limit_range**](docs/CoreV1Api.md#delete_collection_namespaced_limit_range) | **DELETE** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**delete_collection_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#delete_collection_namespaced_persistent_volume_claim) | **DELETE** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**delete_collection_namespaced_pod**](docs/CoreV1Api.md#delete_collection_namespaced_pod) | **DELETE** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**delete_collection_namespaced_pod_template**](docs/CoreV1Api.md#delete_collection_namespaced_pod_template) | **DELETE** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**delete_collection_namespaced_replication_controller**](docs/CoreV1Api.md#delete_collection_namespaced_replication_controller) | **DELETE** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**delete_collection_namespaced_resource_quota**](docs/CoreV1Api.md#delete_collection_namespaced_resource_quota) | **DELETE** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**delete_collection_namespaced_secret**](docs/CoreV1Api.md#delete_collection_namespaced_secret) | **DELETE** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**delete_collection_namespaced_service_account**](docs/CoreV1Api.md#delete_collection_namespaced_service_account) | **DELETE** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**delete_collection_node**](docs/CoreV1Api.md#delete_collection_node) | **DELETE** /api/v1/nodes | 
*CoreV1Api* | [**delete_collection_persistent_volume**](docs/CoreV1Api.md#delete_collection_persistent_volume) | **DELETE** /api/v1/persistentvolumes | 
*CoreV1Api* | [**delete_namespace**](docs/CoreV1Api.md#delete_namespace) | **DELETE** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**delete_namespaced_config_map**](docs/CoreV1Api.md#delete_namespaced_config_map) | **DELETE** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**delete_namespaced_endpoints**](docs/CoreV1Api.md#delete_namespaced_endpoints) | **DELETE** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**delete_namespaced_event**](docs/CoreV1Api.md#delete_namespaced_event) | **DELETE** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**delete_namespaced_limit_range**](docs/CoreV1Api.md#delete_namespaced_limit_range) | **DELETE** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**delete_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#delete_namespaced_persistent_volume_claim) | **DELETE** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**delete_namespaced_pod**](docs/CoreV1Api.md#delete_namespaced_pod) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**delete_namespaced_pod_template**](docs/CoreV1Api.md#delete_namespaced_pod_template) | **DELETE** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**delete_namespaced_replication_controller**](docs/CoreV1Api.md#delete_namespaced_replication_controller) | **DELETE** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**delete_namespaced_resource_quota**](docs/CoreV1Api.md#delete_namespaced_resource_quota) | **DELETE** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**delete_namespaced_secret**](docs/CoreV1Api.md#delete_namespaced_secret) | **DELETE** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**delete_namespaced_service**](docs/CoreV1Api.md#delete_namespaced_service) | **DELETE** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**delete_namespaced_service_account**](docs/CoreV1Api.md#delete_namespaced_service_account) | **DELETE** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**delete_node**](docs/CoreV1Api.md#delete_node) | **DELETE** /api/v1/nodes/{name} | 
*CoreV1Api* | [**delete_persistent_volume**](docs/CoreV1Api.md#delete_persistent_volume) | **DELETE** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**get_api_resources**](docs/CoreV1Api.md#get_api_resources) | **GET** /api/v1/ | 
*CoreV1Api* | [**list_component_status**](docs/CoreV1Api.md#list_component_status) | **GET** /api/v1/componentstatuses | 
*CoreV1Api* | [**list_config_map_for_all_namespaces**](docs/CoreV1Api.md#list_config_map_for_all_namespaces) | **GET** /api/v1/configmaps | 
*CoreV1Api* | [**list_endpoints_for_all_namespaces**](docs/CoreV1Api.md#list_endpoints_for_all_namespaces) | **GET** /api/v1/endpoints | 
*CoreV1Api* | [**list_event_for_all_namespaces**](docs/CoreV1Api.md#list_event_for_all_namespaces) | **GET** /api/v1/events | 
*CoreV1Api* | [**list_limit_range_for_all_namespaces**](docs/CoreV1Api.md#list_limit_range_for_all_namespaces) | **GET** /api/v1/limitranges | 
*CoreV1Api* | [**list_namespace**](docs/CoreV1Api.md#list_namespace) | **GET** /api/v1/namespaces | 
*CoreV1Api* | [**list_namespaced_config_map**](docs/CoreV1Api.md#list_namespaced_config_map) | **GET** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**list_namespaced_endpoints**](docs/CoreV1Api.md#list_namespaced_endpoints) | **GET** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**list_namespaced_event**](docs/CoreV1Api.md#list_namespaced_event) | **GET** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**list_namespaced_limit_range**](docs/CoreV1Api.md#list_namespaced_limit_range) | **GET** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**list_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#list_namespaced_persistent_volume_claim) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**list_namespaced_pod**](docs/CoreV1Api.md#list_namespaced_pod) | **GET** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**list_namespaced_pod_template**](docs/CoreV1Api.md#list_namespaced_pod_template) | **GET** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**list_namespaced_replication_controller**](docs/CoreV1Api.md#list_namespaced_replication_controller) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**list_namespaced_resource_quota**](docs/CoreV1Api.md#list_namespaced_resource_quota) | **GET** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**list_namespaced_secret**](docs/CoreV1Api.md#list_namespaced_secret) | **GET** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**list_namespaced_service**](docs/CoreV1Api.md#list_namespaced_service) | **GET** /api/v1/namespaces/{namespace}/services | 
*CoreV1Api* | [**list_namespaced_service_account**](docs/CoreV1Api.md#list_namespaced_service_account) | **GET** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**list_node**](docs/CoreV1Api.md#list_node) | **GET** /api/v1/nodes | 
*CoreV1Api* | [**list_persistent_volume**](docs/CoreV1Api.md#list_persistent_volume) | **GET** /api/v1/persistentvolumes | 
*CoreV1Api* | [**list_persistent_volume_claim_for_all_namespaces**](docs/CoreV1Api.md#list_persistent_volume_claim_for_all_namespaces) | **GET** /api/v1/persistentvolumeclaims | 
*CoreV1Api* | [**list_pod_for_all_namespaces**](docs/CoreV1Api.md#list_pod_for_all_namespaces) | **GET** /api/v1/pods | 
*CoreV1Api* | [**list_pod_template_for_all_namespaces**](docs/CoreV1Api.md#list_pod_template_for_all_namespaces) | **GET** /api/v1/podtemplates | 
*CoreV1Api* | [**list_replication_controller_for_all_namespaces**](docs/CoreV1Api.md#list_replication_controller_for_all_namespaces) | **GET** /api/v1/replicationcontrollers | 
*CoreV1Api* | [**list_resource_quota_for_all_namespaces**](docs/CoreV1Api.md#list_resource_quota_for_all_namespaces) | **GET** /api/v1/resourcequotas | 
*CoreV1Api* | [**list_secret_for_all_namespaces**](docs/CoreV1Api.md#list_secret_for_all_namespaces) | **GET** /api/v1/secrets | 
*CoreV1Api* | [**list_service_account_for_all_namespaces**](docs/CoreV1Api.md#list_service_account_for_all_namespaces) | **GET** /api/v1/serviceaccounts | 
*CoreV1Api* | [**list_service_for_all_namespaces**](docs/CoreV1Api.md#list_service_for_all_namespaces) | **GET** /api/v1/services | 
*CoreV1Api* | [**patch_namespace**](docs/CoreV1Api.md#patch_namespace) | **PATCH** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**patch_namespace_status**](docs/CoreV1Api.md#patch_namespace_status) | **PATCH** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**patch_namespaced_config_map**](docs/CoreV1Api.md#patch_namespaced_config_map) | **PATCH** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**patch_namespaced_endpoints**](docs/CoreV1Api.md#patch_namespaced_endpoints) | **PATCH** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**patch_namespaced_event**](docs/CoreV1Api.md#patch_namespaced_event) | **PATCH** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**patch_namespaced_limit_range**](docs/CoreV1Api.md#patch_namespaced_limit_range) | **PATCH** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**patch_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#patch_namespaced_persistent_volume_claim) | **PATCH** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**patch_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#patch_namespaced_persistent_volume_claim_status) | **PATCH** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**patch_namespaced_pod**](docs/CoreV1Api.md#patch_namespaced_pod) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**patch_namespaced_pod_status**](docs/CoreV1Api.md#patch_namespaced_pod_status) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**patch_namespaced_pod_template**](docs/CoreV1Api.md#patch_namespaced_pod_template) | **PATCH** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**patch_namespaced_replication_controller**](docs/CoreV1Api.md#patch_namespaced_replication_controller) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**patch_namespaced_replication_controller_status**](docs/CoreV1Api.md#patch_namespaced_replication_controller_status) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**patch_namespaced_resource_quota**](docs/CoreV1Api.md#patch_namespaced_resource_quota) | **PATCH** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**patch_namespaced_resource_quota_status**](docs/CoreV1Api.md#patch_namespaced_resource_quota_status) | **PATCH** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**patch_namespaced_scale_scale**](docs/CoreV1Api.md#patch_namespaced_scale_scale) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**patch_namespaced_secret**](docs/CoreV1Api.md#patch_namespaced_secret) | **PATCH** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**patch_namespaced_service**](docs/CoreV1Api.md#patch_namespaced_service) | **PATCH** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**patch_namespaced_service_account**](docs/CoreV1Api.md#patch_namespaced_service_account) | **PATCH** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**patch_namespaced_service_status**](docs/CoreV1Api.md#patch_namespaced_service_status) | **PATCH** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**patch_node**](docs/CoreV1Api.md#patch_node) | **PATCH** /api/v1/nodes/{name} | 
*CoreV1Api* | [**patch_node_status**](docs/CoreV1Api.md#patch_node_status) | **PATCH** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**patch_persistent_volume**](docs/CoreV1Api.md#patch_persistent_volume) | **PATCH** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**patch_persistent_volume_status**](docs/CoreV1Api.md#patch_persistent_volume_status) | **PATCH** /api/v1/persistentvolumes/{name}/status | 
*CoreV1Api* | [**proxy_delete_namespaced_pod**](docs/CoreV1Api.md#proxy_delete_namespaced_pod) | **DELETE** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_delete_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_delete_namespaced_pod_with_path) | **DELETE** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_delete_namespaced_service**](docs/CoreV1Api.md#proxy_delete_namespaced_service) | **DELETE** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_delete_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_delete_namespaced_service_with_path) | **DELETE** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_delete_node**](docs/CoreV1Api.md#proxy_delete_node) | **DELETE** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_delete_node_with_path**](docs/CoreV1Api.md#proxy_delete_node_with_path) | **DELETE** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_get_namespaced_pod**](docs/CoreV1Api.md#proxy_get_namespaced_pod) | **GET** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_get_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_get_namespaced_pod_with_path) | **GET** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_get_namespaced_service**](docs/CoreV1Api.md#proxy_get_namespaced_service) | **GET** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_get_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_get_namespaced_service_with_path) | **GET** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_get_node**](docs/CoreV1Api.md#proxy_get_node) | **GET** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_get_node_with_path**](docs/CoreV1Api.md#proxy_get_node_with_path) | **GET** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_head_namespaced_pod**](docs/CoreV1Api.md#proxy_head_namespaced_pod) | **HEAD** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_head_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_head_namespaced_pod_with_path) | **HEAD** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_head_namespaced_service**](docs/CoreV1Api.md#proxy_head_namespaced_service) | **HEAD** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_head_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_head_namespaced_service_with_path) | **HEAD** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_head_node**](docs/CoreV1Api.md#proxy_head_node) | **HEAD** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_head_node_with_path**](docs/CoreV1Api.md#proxy_head_node_with_path) | **HEAD** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_options_namespaced_pod**](docs/CoreV1Api.md#proxy_options_namespaced_pod) | **OPTIONS** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_options_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_options_namespaced_pod_with_path) | **OPTIONS** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_options_namespaced_service**](docs/CoreV1Api.md#proxy_options_namespaced_service) | **OPTIONS** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_options_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_options_namespaced_service_with_path) | **OPTIONS** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_options_node**](docs/CoreV1Api.md#proxy_options_node) | **OPTIONS** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_options_node_with_path**](docs/CoreV1Api.md#proxy_options_node_with_path) | **OPTIONS** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_patch_namespaced_pod**](docs/CoreV1Api.md#proxy_patch_namespaced_pod) | **PATCH** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_patch_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_patch_namespaced_pod_with_path) | **PATCH** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_patch_namespaced_service**](docs/CoreV1Api.md#proxy_patch_namespaced_service) | **PATCH** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_patch_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_patch_namespaced_service_with_path) | **PATCH** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_patch_node**](docs/CoreV1Api.md#proxy_patch_node) | **PATCH** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_patch_node_with_path**](docs/CoreV1Api.md#proxy_patch_node_with_path) | **PATCH** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_post_namespaced_pod**](docs/CoreV1Api.md#proxy_post_namespaced_pod) | **POST** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_post_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_post_namespaced_pod_with_path) | **POST** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_post_namespaced_service**](docs/CoreV1Api.md#proxy_post_namespaced_service) | **POST** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_post_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_post_namespaced_service_with_path) | **POST** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_post_node**](docs/CoreV1Api.md#proxy_post_node) | **POST** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_post_node_with_path**](docs/CoreV1Api.md#proxy_post_node_with_path) | **POST** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**proxy_put_namespaced_pod**](docs/CoreV1Api.md#proxy_put_namespaced_pod) | **PUT** /api/v1/proxy/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**proxy_put_namespaced_pod_with_path**](docs/CoreV1Api.md#proxy_put_namespaced_pod_with_path) | **PUT** /api/v1/proxy/namespaces/{namespace}/pods/{name}/{path} | 
*CoreV1Api* | [**proxy_put_namespaced_service**](docs/CoreV1Api.md#proxy_put_namespaced_service) | **PUT** /api/v1/proxy/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**proxy_put_namespaced_service_with_path**](docs/CoreV1Api.md#proxy_put_namespaced_service_with_path) | **PUT** /api/v1/proxy/namespaces/{namespace}/services/{name}/{path} | 
*CoreV1Api* | [**proxy_put_node**](docs/CoreV1Api.md#proxy_put_node) | **PUT** /api/v1/proxy/nodes/{name} | 
*CoreV1Api* | [**proxy_put_node_with_path**](docs/CoreV1Api.md#proxy_put_node_with_path) | **PUT** /api/v1/proxy/nodes/{name}/{path} | 
*CoreV1Api* | [**read_component_status**](docs/CoreV1Api.md#read_component_status) | **GET** /api/v1/componentstatuses/{name} | 
*CoreV1Api* | [**read_namespace**](docs/CoreV1Api.md#read_namespace) | **GET** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**read_namespace_status**](docs/CoreV1Api.md#read_namespace_status) | **GET** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**read_namespaced_config_map**](docs/CoreV1Api.md#read_namespaced_config_map) | **GET** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**read_namespaced_endpoints**](docs/CoreV1Api.md#read_namespaced_endpoints) | **GET** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**read_namespaced_event**](docs/CoreV1Api.md#read_namespaced_event) | **GET** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**read_namespaced_limit_range**](docs/CoreV1Api.md#read_namespaced_limit_range) | **GET** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**read_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#read_namespaced_persistent_volume_claim) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**read_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#read_namespaced_persistent_volume_claim_status) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**read_namespaced_pod**](docs/CoreV1Api.md#read_namespaced_pod) | **GET** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**read_namespaced_pod_log**](docs/CoreV1Api.md#read_namespaced_pod_log) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/log | 
*CoreV1Api* | [**read_namespaced_pod_status**](docs/CoreV1Api.md#read_namespaced_pod_status) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**read_namespaced_pod_template**](docs/CoreV1Api.md#read_namespaced_pod_template) | **GET** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**read_namespaced_replication_controller**](docs/CoreV1Api.md#read_namespaced_replication_controller) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**read_namespaced_replication_controller_status**](docs/CoreV1Api.md#read_namespaced_replication_controller_status) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**read_namespaced_resource_quota**](docs/CoreV1Api.md#read_namespaced_resource_quota) | **GET** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**read_namespaced_resource_quota_status**](docs/CoreV1Api.md#read_namespaced_resource_quota_status) | **GET** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**read_namespaced_scale_scale**](docs/CoreV1Api.md#read_namespaced_scale_scale) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**read_namespaced_secret**](docs/CoreV1Api.md#read_namespaced_secret) | **GET** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**read_namespaced_service**](docs/CoreV1Api.md#read_namespaced_service) | **GET** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**read_namespaced_service_account**](docs/CoreV1Api.md#read_namespaced_service_account) | **GET** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**read_namespaced_service_status**](docs/CoreV1Api.md#read_namespaced_service_status) | **GET** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**read_node**](docs/CoreV1Api.md#read_node) | **GET** /api/v1/nodes/{name} | 
*CoreV1Api* | [**read_node_status**](docs/CoreV1Api.md#read_node_status) | **GET** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**read_persistent_volume**](docs/CoreV1Api.md#read_persistent_volume) | **GET** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**read_persistent_volume_status**](docs/CoreV1Api.md#read_persistent_volume_status) | **GET** /api/v1/persistentvolumes/{name}/status | 
*CoreV1Api* | [**replace_namespace**](docs/CoreV1Api.md#replace_namespace) | **PUT** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**replace_namespace_finalize**](docs/CoreV1Api.md#replace_namespace_finalize) | **PUT** /api/v1/namespaces/{name}/finalize | 
*CoreV1Api* | [**replace_namespace_status**](docs/CoreV1Api.md#replace_namespace_status) | **PUT** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**replace_namespaced_config_map**](docs/CoreV1Api.md#replace_namespaced_config_map) | **PUT** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**replace_namespaced_endpoints**](docs/CoreV1Api.md#replace_namespaced_endpoints) | **PUT** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**replace_namespaced_event**](docs/CoreV1Api.md#replace_namespaced_event) | **PUT** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**replace_namespaced_limit_range**](docs/CoreV1Api.md#replace_namespaced_limit_range) | **PUT** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**replace_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#replace_namespaced_persistent_volume_claim) | **PUT** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**replace_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#replace_namespaced_persistent_volume_claim_status) | **PUT** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**replace_namespaced_pod**](docs/CoreV1Api.md#replace_namespaced_pod) | **PUT** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**replace_namespaced_pod_status**](docs/CoreV1Api.md#replace_namespaced_pod_status) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**replace_namespaced_pod_template**](docs/CoreV1Api.md#replace_namespaced_pod_template) | **PUT** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**replace_namespaced_replication_controller**](docs/CoreV1Api.md#replace_namespaced_replication_controller) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**replace_namespaced_replication_controller_status**](docs/CoreV1Api.md#replace_namespaced_replication_controller_status) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**replace_namespaced_resource_quota**](docs/CoreV1Api.md#replace_namespaced_resource_quota) | **PUT** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**replace_namespaced_resource_quota_status**](docs/CoreV1Api.md#replace_namespaced_resource_quota_status) | **PUT** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**replace_namespaced_scale_scale**](docs/CoreV1Api.md#replace_namespaced_scale_scale) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**replace_namespaced_secret**](docs/CoreV1Api.md#replace_namespaced_secret) | **PUT** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**replace_namespaced_service**](docs/CoreV1Api.md#replace_namespaced_service) | **PUT** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**replace_namespaced_service_account**](docs/CoreV1Api.md#replace_namespaced_service_account) | **PUT** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**replace_namespaced_service_status**](docs/CoreV1Api.md#replace_namespaced_service_status) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**replace_node**](docs/CoreV1Api.md#replace_node) | **PUT** /api/v1/nodes/{name} | 
*CoreV1Api* | [**replace_node_status**](docs/CoreV1Api.md#replace_node_status) | **PUT** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**replace_persistent_volume**](docs/CoreV1Api.md#replace_persistent_volume) | **PUT** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**replace_persistent_volume_status**](docs/CoreV1Api.md#replace_persistent_volume_status) | **PUT** /api/v1/persistentvolumes/{name}/status | 
*ExtensionsApi* | [**get_api_group**](docs/ExtensionsApi.md#get_api_group) | **GET** /apis/extensions/ | 
*ExtensionsV1beta1Api* | [**create_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#create_namespaced_daemon_set) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets | 
*ExtensionsV1beta1Api* | [**create_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#create_namespaced_deployment) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/deployments | 
*ExtensionsV1beta1Api* | [**create_namespaced_deployment_rollback_rollback**](docs/ExtensionsV1beta1Api.md#create_namespaced_deployment_rollback_rollback) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/rollback | 
*ExtensionsV1beta1Api* | [**create_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#create_namespaced_ingress) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses | 
*ExtensionsV1beta1Api* | [**create_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#create_namespaced_network_policy) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies | 
*ExtensionsV1beta1Api* | [**create_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#create_namespaced_replica_set) | **POST** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets | 
*ExtensionsV1beta1Api* | [**create_pod_security_policy**](docs/ExtensionsV1beta1Api.md#create_pod_security_policy) | **POST** /apis/extensions/v1beta1/podsecuritypolicies | 
*ExtensionsV1beta1Api* | [**create_third_party_resource**](docs/ExtensionsV1beta1Api.md#create_third_party_resource) | **POST** /apis/extensions/v1beta1/thirdpartyresources | 
*ExtensionsV1beta1Api* | [**delete_collection_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#delete_collection_namespaced_daemon_set) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets | 
*ExtensionsV1beta1Api* | [**delete_collection_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#delete_collection_namespaced_deployment) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/deployments | 
*ExtensionsV1beta1Api* | [**delete_collection_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#delete_collection_namespaced_ingress) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses | 
*ExtensionsV1beta1Api* | [**delete_collection_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#delete_collection_namespaced_network_policy) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies | 
*ExtensionsV1beta1Api* | [**delete_collection_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#delete_collection_namespaced_replica_set) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets | 
*ExtensionsV1beta1Api* | [**delete_collection_pod_security_policy**](docs/ExtensionsV1beta1Api.md#delete_collection_pod_security_policy) | **DELETE** /apis/extensions/v1beta1/podsecuritypolicies | 
*ExtensionsV1beta1Api* | [**delete_collection_third_party_resource**](docs/ExtensionsV1beta1Api.md#delete_collection_third_party_resource) | **DELETE** /apis/extensions/v1beta1/thirdpartyresources | 
*ExtensionsV1beta1Api* | [**delete_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#delete_namespaced_daemon_set) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name} | 
*ExtensionsV1beta1Api* | [**delete_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#delete_namespaced_deployment) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name} | 
*ExtensionsV1beta1Api* | [**delete_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#delete_namespaced_ingress) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name} | 
*ExtensionsV1beta1Api* | [**delete_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#delete_namespaced_network_policy) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name} | 
*ExtensionsV1beta1Api* | [**delete_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#delete_namespaced_replica_set) | **DELETE** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name} | 
*ExtensionsV1beta1Api* | [**delete_pod_security_policy**](docs/ExtensionsV1beta1Api.md#delete_pod_security_policy) | **DELETE** /apis/extensions/v1beta1/podsecuritypolicies/{name} | 
*ExtensionsV1beta1Api* | [**delete_third_party_resource**](docs/ExtensionsV1beta1Api.md#delete_third_party_resource) | **DELETE** /apis/extensions/v1beta1/thirdpartyresources/{name} | 
*ExtensionsV1beta1Api* | [**get_api_resources**](docs/ExtensionsV1beta1Api.md#get_api_resources) | **GET** /apis/extensions/v1beta1/ | 
*ExtensionsV1beta1Api* | [**list_daemon_set_for_all_namespaces**](docs/ExtensionsV1beta1Api.md#list_daemon_set_for_all_namespaces) | **GET** /apis/extensions/v1beta1/daemonsets | 
*ExtensionsV1beta1Api* | [**list_deployment_for_all_namespaces**](docs/ExtensionsV1beta1Api.md#list_deployment_for_all_namespaces) | **GET** /apis/extensions/v1beta1/deployments | 
*ExtensionsV1beta1Api* | [**list_ingress_for_all_namespaces**](docs/ExtensionsV1beta1Api.md#list_ingress_for_all_namespaces) | **GET** /apis/extensions/v1beta1/ingresses | 
*ExtensionsV1beta1Api* | [**list_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#list_namespaced_daemon_set) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets | 
*ExtensionsV1beta1Api* | [**list_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#list_namespaced_deployment) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/deployments | 
*ExtensionsV1beta1Api* | [**list_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#list_namespaced_ingress) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses | 
*ExtensionsV1beta1Api* | [**list_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#list_namespaced_network_policy) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies | 
*ExtensionsV1beta1Api* | [**list_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#list_namespaced_replica_set) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets | 
*ExtensionsV1beta1Api* | [**list_network_policy_for_all_namespaces**](docs/ExtensionsV1beta1Api.md#list_network_policy_for_all_namespaces) | **GET** /apis/extensions/v1beta1/networkpolicies | 
*ExtensionsV1beta1Api* | [**list_pod_security_policy**](docs/ExtensionsV1beta1Api.md#list_pod_security_policy) | **GET** /apis/extensions/v1beta1/podsecuritypolicies | 
*ExtensionsV1beta1Api* | [**list_replica_set_for_all_namespaces**](docs/ExtensionsV1beta1Api.md#list_replica_set_for_all_namespaces) | **GET** /apis/extensions/v1beta1/replicasets | 
*ExtensionsV1beta1Api* | [**list_third_party_resource**](docs/ExtensionsV1beta1Api.md#list_third_party_resource) | **GET** /apis/extensions/v1beta1/thirdpartyresources | 
*ExtensionsV1beta1Api* | [**patch_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#patch_namespaced_daemon_set) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name} | 
*ExtensionsV1beta1Api* | [**patch_namespaced_daemon_set_status**](docs/ExtensionsV1beta1Api.md#patch_namespaced_daemon_set_status) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status | 
*ExtensionsV1beta1Api* | [**patch_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#patch_namespaced_deployment) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name} | 
*ExtensionsV1beta1Api* | [**patch_namespaced_deployment_status**](docs/ExtensionsV1beta1Api.md#patch_namespaced_deployment_status) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*ExtensionsV1beta1Api* | [**patch_namespaced_deployments_scale**](docs/ExtensionsV1beta1Api.md#patch_namespaced_deployments_scale) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*ExtensionsV1beta1Api* | [**patch_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#patch_namespaced_ingress) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name} | 
*ExtensionsV1beta1Api* | [**patch_namespaced_ingress_status**](docs/ExtensionsV1beta1Api.md#patch_namespaced_ingress_status) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status | 
*ExtensionsV1beta1Api* | [**patch_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#patch_namespaced_network_policy) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name} | 
*ExtensionsV1beta1Api* | [**patch_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#patch_namespaced_replica_set) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name} | 
*ExtensionsV1beta1Api* | [**patch_namespaced_replica_set_status**](docs/ExtensionsV1beta1Api.md#patch_namespaced_replica_set_status) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status | 
*ExtensionsV1beta1Api* | [**patch_namespaced_replicasets_scale**](docs/ExtensionsV1beta1Api.md#patch_namespaced_replicasets_scale) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale | 
*ExtensionsV1beta1Api* | [**patch_namespaced_replicationcontrollers_scale**](docs/ExtensionsV1beta1Api.md#patch_namespaced_replicationcontrollers_scale) | **PATCH** /apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*ExtensionsV1beta1Api* | [**patch_pod_security_policy**](docs/ExtensionsV1beta1Api.md#patch_pod_security_policy) | **PATCH** /apis/extensions/v1beta1/podsecuritypolicies/{name} | 
*ExtensionsV1beta1Api* | [**patch_third_party_resource**](docs/ExtensionsV1beta1Api.md#patch_third_party_resource) | **PATCH** /apis/extensions/v1beta1/thirdpartyresources/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#read_namespaced_daemon_set) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_daemon_set_status**](docs/ExtensionsV1beta1Api.md#read_namespaced_daemon_set_status) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status | 
*ExtensionsV1beta1Api* | [**read_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#read_namespaced_deployment) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_deployment_status**](docs/ExtensionsV1beta1Api.md#read_namespaced_deployment_status) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*ExtensionsV1beta1Api* | [**read_namespaced_deployments_scale**](docs/ExtensionsV1beta1Api.md#read_namespaced_deployments_scale) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*ExtensionsV1beta1Api* | [**read_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#read_namespaced_ingress) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_ingress_status**](docs/ExtensionsV1beta1Api.md#read_namespaced_ingress_status) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status | 
*ExtensionsV1beta1Api* | [**read_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#read_namespaced_network_policy) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#read_namespaced_replica_set) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name} | 
*ExtensionsV1beta1Api* | [**read_namespaced_replica_set_status**](docs/ExtensionsV1beta1Api.md#read_namespaced_replica_set_status) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status | 
*ExtensionsV1beta1Api* | [**read_namespaced_replicasets_scale**](docs/ExtensionsV1beta1Api.md#read_namespaced_replicasets_scale) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale | 
*ExtensionsV1beta1Api* | [**read_namespaced_replicationcontrollers_scale**](docs/ExtensionsV1beta1Api.md#read_namespaced_replicationcontrollers_scale) | **GET** /apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*ExtensionsV1beta1Api* | [**read_pod_security_policy**](docs/ExtensionsV1beta1Api.md#read_pod_security_policy) | **GET** /apis/extensions/v1beta1/podsecuritypolicies/{name} | 
*ExtensionsV1beta1Api* | [**read_third_party_resource**](docs/ExtensionsV1beta1Api.md#read_third_party_resource) | **GET** /apis/extensions/v1beta1/thirdpartyresources/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_daemon_set**](docs/ExtensionsV1beta1Api.md#replace_namespaced_daemon_set) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_daemon_set_status**](docs/ExtensionsV1beta1Api.md#replace_namespaced_daemon_set_status) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status | 
*ExtensionsV1beta1Api* | [**replace_namespaced_deployment**](docs/ExtensionsV1beta1Api.md#replace_namespaced_deployment) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_deployment_status**](docs/ExtensionsV1beta1Api.md#replace_namespaced_deployment_status) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status | 
*ExtensionsV1beta1Api* | [**replace_namespaced_deployments_scale**](docs/ExtensionsV1beta1Api.md#replace_namespaced_deployments_scale) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale | 
*ExtensionsV1beta1Api* | [**replace_namespaced_ingress**](docs/ExtensionsV1beta1Api.md#replace_namespaced_ingress) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_ingress_status**](docs/ExtensionsV1beta1Api.md#replace_namespaced_ingress_status) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status | 
*ExtensionsV1beta1Api* | [**replace_namespaced_network_policy**](docs/ExtensionsV1beta1Api.md#replace_namespaced_network_policy) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_replica_set**](docs/ExtensionsV1beta1Api.md#replace_namespaced_replica_set) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name} | 
*ExtensionsV1beta1Api* | [**replace_namespaced_replica_set_status**](docs/ExtensionsV1beta1Api.md#replace_namespaced_replica_set_status) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status | 
*ExtensionsV1beta1Api* | [**replace_namespaced_replicasets_scale**](docs/ExtensionsV1beta1Api.md#replace_namespaced_replicasets_scale) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale | 
*ExtensionsV1beta1Api* | [**replace_namespaced_replicationcontrollers_scale**](docs/ExtensionsV1beta1Api.md#replace_namespaced_replicationcontrollers_scale) | **PUT** /apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*ExtensionsV1beta1Api* | [**replace_pod_security_policy**](docs/ExtensionsV1beta1Api.md#replace_pod_security_policy) | **PUT** /apis/extensions/v1beta1/podsecuritypolicies/{name} | 
*ExtensionsV1beta1Api* | [**replace_third_party_resource**](docs/ExtensionsV1beta1Api.md#replace_third_party_resource) | **PUT** /apis/extensions/v1beta1/thirdpartyresources/{name} | 
*LogsApi* | [**log_file_handler**](docs/LogsApi.md#log_file_handler) | **GET** /logs/{logpath} | 
*LogsApi* | [**log_file_list_handler**](docs/LogsApi.md#log_file_list_handler) | **GET** /logs/ | 
*PolicyApi* | [**get_api_group**](docs/PolicyApi.md#get_api_group) | **GET** /apis/policy/ | 
*PolicyV1beta1Api* | [**create_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#create_namespaced_pod_disruption_budget) | **POST** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**delete_collection_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#delete_collection_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**delete_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#delete_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**get_api_resources**](docs/PolicyV1beta1Api.md#get_api_resources) | **GET** /apis/policy/v1beta1/ | 
*PolicyV1beta1Api* | [**list_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#list_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**list_pod_disruption_budget_for_all_namespaces**](docs/PolicyV1beta1Api.md#list_pod_disruption_budget_for_all_namespaces) | **GET** /apis/policy/v1beta1/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**patch_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#patch_namespaced_pod_disruption_budget) | **PATCH** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**patch_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#patch_namespaced_pod_disruption_budget_status) | **PATCH** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**read_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#read_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**read_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#read_namespaced_pod_disruption_budget_status) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**replace_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#replace_namespaced_pod_disruption_budget) | **PUT** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**replace_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#replace_namespaced_pod_disruption_budget_status) | **PUT** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*RbacAuthorizationApi* | [**get_api_group**](docs/RbacAuthorizationApi.md#get_api_group) | **GET** /apis/rbac.authorization.k8s.io/ | 
*RbacAuthorizationV1alpha1Api* | [**create_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#create_cluster_role) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**create_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#create_cluster_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**create_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#create_namespaced_role) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**create_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#create_namespaced_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**get_api_resources**](docs/RbacAuthorizationV1alpha1Api.md#get_api_resources) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/ | 
*RbacAuthorizationV1alpha1Api* | [**list_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#list_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**list_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#list_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#list_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**list_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#list_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_role_binding_for_all_namespaces**](docs/RbacAuthorizationV1alpha1Api.md#list_role_binding_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_role_for_all_namespaces**](docs/RbacAuthorizationV1alpha1Api.md#list_role_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/roles | 
*RbacAuthorizationV1alpha1Api* | [**patch_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#patch_cluster_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#patch_cluster_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#patch_namespaced_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#patch_namespaced_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#read_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#read_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#read_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#read_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#replace_cluster_role) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#replace_cluster_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#replace_namespaced_role) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#replace_namespaced_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**create_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#create_cluster_role) | **POST** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles | 
*RbacAuthorizationV1beta1Api* | [**create_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#create_cluster_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings | 
*RbacAuthorizationV1beta1Api* | [**create_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#create_namespaced_role) | **POST** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1beta1Api* | [**create_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#create_namespaced_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1beta1Api* | [**delete_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#delete_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles/{name} | 
*RbacAuthorizationV1beta1Api* | [**delete_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#delete_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**delete_collection_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#delete_collection_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles | 
*RbacAuthorizationV1beta1Api* | [**delete_collection_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#delete_collection_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings | 
*RbacAuthorizationV1beta1Api* | [**delete_collection_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#delete_collection_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1beta1Api* | [**delete_collection_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#delete_collection_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1beta1Api* | [**delete_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#delete_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1beta1Api* | [**delete_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#delete_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**get_api_resources**](docs/RbacAuthorizationV1beta1Api.md#get_api_resources) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/ | 
*RbacAuthorizationV1beta1Api* | [**list_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#list_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles | 
*RbacAuthorizationV1beta1Api* | [**list_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#list_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings | 
*RbacAuthorizationV1beta1Api* | [**list_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#list_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1beta1Api* | [**list_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#list_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1beta1Api* | [**list_role_binding_for_all_namespaces**](docs/RbacAuthorizationV1beta1Api.md#list_role_binding_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/rolebindings | 
*RbacAuthorizationV1beta1Api* | [**list_role_for_all_namespaces**](docs/RbacAuthorizationV1beta1Api.md#list_role_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/roles | 
*RbacAuthorizationV1beta1Api* | [**patch_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#patch_cluster_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles/{name} | 
*RbacAuthorizationV1beta1Api* | [**patch_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#patch_cluster_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**patch_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#patch_namespaced_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1beta1Api* | [**patch_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#patch_namespaced_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**read_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#read_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles/{name} | 
*RbacAuthorizationV1beta1Api* | [**read_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#read_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**read_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#read_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1beta1Api* | [**read_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#read_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**replace_cluster_role**](docs/RbacAuthorizationV1beta1Api.md#replace_cluster_role) | **PUT** /apis/rbac.authorization.k8s.io/v1beta1/clusterroles/{name} | 
*RbacAuthorizationV1beta1Api* | [**replace_cluster_role_binding**](docs/RbacAuthorizationV1beta1Api.md#replace_cluster_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1beta1/clusterrolebindings/{name} | 
*RbacAuthorizationV1beta1Api* | [**replace_namespaced_role**](docs/RbacAuthorizationV1beta1Api.md#replace_namespaced_role) | **PUT** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1beta1Api* | [**replace_namespaced_role_binding**](docs/RbacAuthorizationV1beta1Api.md#replace_namespaced_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1beta1/namespaces/{namespace}/rolebindings/{name} | 
*SettingsApi* | [**get_api_group**](docs/SettingsApi.md#get_api_group) | **GET** /apis/settings.k8s.io/ | 
*SettingsV1alpha1Api* | [**create_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#create_namespaced_pod_preset) | **POST** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets | 
*SettingsV1alpha1Api* | [**delete_collection_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#delete_collection_namespaced_pod_preset) | **DELETE** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets | 
*SettingsV1alpha1Api* | [**delete_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#delete_namespaced_pod_preset) | **DELETE** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets/{name} | 
*SettingsV1alpha1Api* | [**get_api_resources**](docs/SettingsV1alpha1Api.md#get_api_resources) | **GET** /apis/settings.k8s.io/v1alpha1/ | 
*SettingsV1alpha1Api* | [**list_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#list_namespaced_pod_preset) | **GET** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets | 
*SettingsV1alpha1Api* | [**list_pod_preset_for_all_namespaces**](docs/SettingsV1alpha1Api.md#list_pod_preset_for_all_namespaces) | **GET** /apis/settings.k8s.io/v1alpha1/podpresets | 
*SettingsV1alpha1Api* | [**patch_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#patch_namespaced_pod_preset) | **PATCH** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets/{name} | 
*SettingsV1alpha1Api* | [**read_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#read_namespaced_pod_preset) | **GET** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets/{name} | 
*SettingsV1alpha1Api* | [**replace_namespaced_pod_preset**](docs/SettingsV1alpha1Api.md#replace_namespaced_pod_preset) | **PUT** /apis/settings.k8s.io/v1alpha1/namespaces/{namespace}/podpresets/{name} | 
*StorageApi* | [**get_api_group**](docs/StorageApi.md#get_api_group) | **GET** /apis/storage.k8s.io/ | 
*StorageV1Api* | [**create_storage_class**](docs/StorageV1Api.md#create_storage_class) | **POST** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**delete_collection_storage_class**](docs/StorageV1Api.md#delete_collection_storage_class) | **DELETE** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**delete_storage_class**](docs/StorageV1Api.md#delete_storage_class) | **DELETE** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**get_api_resources**](docs/StorageV1Api.md#get_api_resources) | **GET** /apis/storage.k8s.io/v1/ | 
*StorageV1Api* | [**list_storage_class**](docs/StorageV1Api.md#list_storage_class) | **GET** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**patch_storage_class**](docs/StorageV1Api.md#patch_storage_class) | **PATCH** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**read_storage_class**](docs/StorageV1Api.md#read_storage_class) | **GET** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**replace_storage_class**](docs/StorageV1Api.md#replace_storage_class) | **PUT** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1beta1Api* | [**create_storage_class**](docs/StorageV1beta1Api.md#create_storage_class) | **POST** /apis/storage.k8s.io/v1beta1/storageclasses | 
*StorageV1beta1Api* | [**delete_collection_storage_class**](docs/StorageV1beta1Api.md#delete_collection_storage_class) | **DELETE** /apis/storage.k8s.io/v1beta1/storageclasses | 
*StorageV1beta1Api* | [**delete_storage_class**](docs/StorageV1beta1Api.md#delete_storage_class) | **DELETE** /apis/storage.k8s.io/v1beta1/storageclasses/{name} | 
*StorageV1beta1Api* | [**get_api_resources**](docs/StorageV1beta1Api.md#get_api_resources) | **GET** /apis/storage.k8s.io/v1beta1/ | 
*StorageV1beta1Api* | [**list_storage_class**](docs/StorageV1beta1Api.md#list_storage_class) | **GET** /apis/storage.k8s.io/v1beta1/storageclasses | 
*StorageV1beta1Api* | [**patch_storage_class**](docs/StorageV1beta1Api.md#patch_storage_class) | **PATCH** /apis/storage.k8s.io/v1beta1/storageclasses/{name} | 
*StorageV1beta1Api* | [**read_storage_class**](docs/StorageV1beta1Api.md#read_storage_class) | **GET** /apis/storage.k8s.io/v1beta1/storageclasses/{name} | 
*StorageV1beta1Api* | [**replace_storage_class**](docs/StorageV1beta1Api.md#replace_storage_class) | **PUT** /apis/storage.k8s.io/v1beta1/storageclasses/{name} | 
*VersionApi* | [**get_code**](docs/VersionApi.md#get_code) | **GET** /version/ | 


## Documentation For Models

 - [AppsV1beta1Deployment](docs/AppsV1beta1Deployment.md)
 - [AppsV1beta1DeploymentCondition](docs/AppsV1beta1DeploymentCondition.md)
 - [AppsV1beta1DeploymentList](docs/AppsV1beta1DeploymentList.md)
 - [AppsV1beta1DeploymentRollback](docs/AppsV1beta1DeploymentRollback.md)
 - [AppsV1beta1DeploymentSpec](docs/AppsV1beta1DeploymentSpec.md)
 - [AppsV1beta1DeploymentStatus](docs/AppsV1beta1DeploymentStatus.md)
 - [AppsV1beta1DeploymentStrategy](docs/AppsV1beta1DeploymentStrategy.md)
 - [AppsV1beta1RollbackConfig](docs/AppsV1beta1RollbackConfig.md)
 - [AppsV1beta1RollingUpdateDeployment](docs/AppsV1beta1RollingUpdateDeployment.md)
 - [AppsV1beta1Scale](docs/AppsV1beta1Scale.md)
 - [AppsV1beta1ScaleSpec](docs/AppsV1beta1ScaleSpec.md)
 - [AppsV1beta1ScaleStatus](docs/AppsV1beta1ScaleStatus.md)
 - [ExtensionsV1beta1Deployment](docs/ExtensionsV1beta1Deployment.md)
 - [ExtensionsV1beta1DeploymentCondition](docs/ExtensionsV1beta1DeploymentCondition.md)
 - [ExtensionsV1beta1DeploymentList](docs/ExtensionsV1beta1DeploymentList.md)
 - [ExtensionsV1beta1DeploymentRollback](docs/ExtensionsV1beta1DeploymentRollback.md)
 - [ExtensionsV1beta1DeploymentSpec](docs/ExtensionsV1beta1DeploymentSpec.md)
 - [ExtensionsV1beta1DeploymentStatus](docs/ExtensionsV1beta1DeploymentStatus.md)
 - [ExtensionsV1beta1DeploymentStrategy](docs/ExtensionsV1beta1DeploymentStrategy.md)
 - [ExtensionsV1beta1RollbackConfig](docs/ExtensionsV1beta1RollbackConfig.md)
 - [ExtensionsV1beta1RollingUpdateDeployment](docs/ExtensionsV1beta1RollingUpdateDeployment.md)
 - [ExtensionsV1beta1Scale](docs/ExtensionsV1beta1Scale.md)
 - [ExtensionsV1beta1ScaleSpec](docs/ExtensionsV1beta1ScaleSpec.md)
 - [ExtensionsV1beta1ScaleStatus](docs/ExtensionsV1beta1ScaleStatus.md)
 - [RuntimeRawExtension](docs/RuntimeRawExtension.md)
 - [V1APIGroup](docs/V1APIGroup.md)
 - [V1APIGroupList](docs/V1APIGroupList.md)
 - [V1APIResource](docs/V1APIResource.md)
 - [V1APIResourceList](docs/V1APIResourceList.md)
 - [V1APIVersions](docs/V1APIVersions.md)
 - [V1AWSElasticBlockStoreVolumeSource](docs/V1AWSElasticBlockStoreVolumeSource.md)
 - [V1Affinity](docs/V1Affinity.md)
 - [V1AttachedVolume](docs/V1AttachedVolume.md)
 - [V1AzureDiskVolumeSource](docs/V1AzureDiskVolumeSource.md)
 - [V1AzureFileVolumeSource](docs/V1AzureFileVolumeSource.md)
 - [V1Binding](docs/V1Binding.md)
 - [V1Capabilities](docs/V1Capabilities.md)
 - [V1CephFSVolumeSource](docs/V1CephFSVolumeSource.md)
 - [V1CinderVolumeSource](docs/V1CinderVolumeSource.md)
 - [V1ComponentCondition](docs/V1ComponentCondition.md)
 - [V1ComponentStatus](docs/V1ComponentStatus.md)
 - [V1ComponentStatusList](docs/V1ComponentStatusList.md)
 - [V1ConfigMap](docs/V1ConfigMap.md)
 - [V1ConfigMapEnvSource](docs/V1ConfigMapEnvSource.md)
 - [V1ConfigMapKeySelector](docs/V1ConfigMapKeySelector.md)
 - [V1ConfigMapList](docs/V1ConfigMapList.md)
 - [V1ConfigMapProjection](docs/V1ConfigMapProjection.md)
 - [V1ConfigMapVolumeSource](docs/V1ConfigMapVolumeSource.md)
 - [V1Container](docs/V1Container.md)
 - [V1ContainerImage](docs/V1ContainerImage.md)
 - [V1ContainerPort](docs/V1ContainerPort.md)
 - [V1ContainerState](docs/V1ContainerState.md)
 - [V1ContainerStateRunning](docs/V1ContainerStateRunning.md)
 - [V1ContainerStateTerminated](docs/V1ContainerStateTerminated.md)
 - [V1ContainerStateWaiting](docs/V1ContainerStateWaiting.md)
 - [V1ContainerStatus](docs/V1ContainerStatus.md)
 - [V1CrossVersionObjectReference](docs/V1CrossVersionObjectReference.md)
 - [V1DaemonEndpoint](docs/V1DaemonEndpoint.md)
 - [V1DeleteOptions](docs/V1DeleteOptions.md)
 - [V1DownwardAPIProjection](docs/V1DownwardAPIProjection.md)
 - [V1DownwardAPIVolumeFile](docs/V1DownwardAPIVolumeFile.md)
 - [V1DownwardAPIVolumeSource](docs/V1DownwardAPIVolumeSource.md)
 - [V1EmptyDirVolumeSource](docs/V1EmptyDirVolumeSource.md)
 - [V1EndpointAddress](docs/V1EndpointAddress.md)
 - [V1EndpointPort](docs/V1EndpointPort.md)
 - [V1EndpointSubset](docs/V1EndpointSubset.md)
 - [V1Endpoints](docs/V1Endpoints.md)
 - [V1EndpointsList](docs/V1EndpointsList.md)
 - [V1EnvFromSource](docs/V1EnvFromSource.md)
 - [V1EnvVar](docs/V1EnvVar.md)
 - [V1EnvVarSource](docs/V1EnvVarSource.md)
 - [V1Event](docs/V1Event.md)
 - [V1EventList](docs/V1EventList.md)
 - [V1EventSource](docs/V1EventSource.md)
 - [V1ExecAction](docs/V1ExecAction.md)
 - [V1FCVolumeSource](docs/V1FCVolumeSource.md)
 - [V1FlexVolumeSource](docs/V1FlexVolumeSource.md)
 - [V1FlockerVolumeSource](docs/V1FlockerVolumeSource.md)
 - [V1GCEPersistentDiskVolumeSource](docs/V1GCEPersistentDiskVolumeSource.md)
 - [V1GitRepoVolumeSource](docs/V1GitRepoVolumeSource.md)
 - [V1GlusterfsVolumeSource](docs/V1GlusterfsVolumeSource.md)
 - [V1GroupVersionForDiscovery](docs/V1GroupVersionForDiscovery.md)
 - [V1HTTPGetAction](docs/V1HTTPGetAction.md)
 - [V1HTTPHeader](docs/V1HTTPHeader.md)
 - [V1Handler](docs/V1Handler.md)
 - [V1HorizontalPodAutoscaler](docs/V1HorizontalPodAutoscaler.md)
 - [V1HorizontalPodAutoscalerList](docs/V1HorizontalPodAutoscalerList.md)
 - [V1HorizontalPodAutoscalerSpec](docs/V1HorizontalPodAutoscalerSpec.md)
 - [V1HorizontalPodAutoscalerStatus](docs/V1HorizontalPodAutoscalerStatus.md)
 - [V1HostPathVolumeSource](docs/V1HostPathVolumeSource.md)
 - [V1ISCSIVolumeSource](docs/V1ISCSIVolumeSource.md)
 - [V1Job](docs/V1Job.md)
 - [V1JobCondition](docs/V1JobCondition.md)
 - [V1JobList](docs/V1JobList.md)
 - [V1JobSpec](docs/V1JobSpec.md)
 - [V1JobStatus](docs/V1JobStatus.md)
 - [V1KeyToPath](docs/V1KeyToPath.md)
 - [V1LabelSelector](docs/V1LabelSelector.md)
 - [V1LabelSelectorRequirement](docs/V1LabelSelectorRequirement.md)
 - [V1Lifecycle](docs/V1Lifecycle.md)
 - [V1LimitRange](docs/V1LimitRange.md)
 - [V1LimitRangeItem](docs/V1LimitRangeItem.md)
 - [V1LimitRangeList](docs/V1LimitRangeList.md)
 - [V1LimitRangeSpec](docs/V1LimitRangeSpec.md)
 - [V1ListMeta](docs/V1ListMeta.md)
 - [V1LoadBalancerIngress](docs/V1LoadBalancerIngress.md)
 - [V1LoadBalancerStatus](docs/V1LoadBalancerStatus.md)
 - [V1LocalObjectReference](docs/V1LocalObjectReference.md)
 - [V1LocalSubjectAccessReview](docs/V1LocalSubjectAccessReview.md)
 - [V1NFSVolumeSource](docs/V1NFSVolumeSource.md)
 - [V1Namespace](docs/V1Namespace.md)
 - [V1NamespaceList](docs/V1NamespaceList.md)
 - [V1NamespaceSpec](docs/V1NamespaceSpec.md)
 - [V1NamespaceStatus](docs/V1NamespaceStatus.md)
 - [V1Node](docs/V1Node.md)
 - [V1NodeAddress](docs/V1NodeAddress.md)
 - [V1NodeAffinity](docs/V1NodeAffinity.md)
 - [V1NodeCondition](docs/V1NodeCondition.md)
 - [V1NodeDaemonEndpoints](docs/V1NodeDaemonEndpoints.md)
 - [V1NodeList](docs/V1NodeList.md)
 - [V1NodeSelector](docs/V1NodeSelector.md)
 - [V1NodeSelectorRequirement](docs/V1NodeSelectorRequirement.md)
 - [V1NodeSelectorTerm](docs/V1NodeSelectorTerm.md)
 - [V1NodeSpec](docs/V1NodeSpec.md)
 - [V1NodeStatus](docs/V1NodeStatus.md)
 - [V1NodeSystemInfo](docs/V1NodeSystemInfo.md)
 - [V1NonResourceAttributes](docs/V1NonResourceAttributes.md)
 - [V1ObjectFieldSelector](docs/V1ObjectFieldSelector.md)
 - [V1ObjectMeta](docs/V1ObjectMeta.md)
 - [V1ObjectReference](docs/V1ObjectReference.md)
 - [V1OwnerReference](docs/V1OwnerReference.md)
 - [V1PersistentVolume](docs/V1PersistentVolume.md)
 - [V1PersistentVolumeClaim](docs/V1PersistentVolumeClaim.md)
 - [V1PersistentVolumeClaimList](docs/V1PersistentVolumeClaimList.md)
 - [V1PersistentVolumeClaimSpec](docs/V1PersistentVolumeClaimSpec.md)
 - [V1PersistentVolumeClaimStatus](docs/V1PersistentVolumeClaimStatus.md)
 - [V1PersistentVolumeClaimVolumeSource](docs/V1PersistentVolumeClaimVolumeSource.md)
 - [V1PersistentVolumeList](docs/V1PersistentVolumeList.md)
 - [V1PersistentVolumeSpec](docs/V1PersistentVolumeSpec.md)
 - [V1PersistentVolumeStatus](docs/V1PersistentVolumeStatus.md)
 - [V1PhotonPersistentDiskVolumeSource](docs/V1PhotonPersistentDiskVolumeSource.md)
 - [V1Pod](docs/V1Pod.md)
 - [V1PodAffinity](docs/V1PodAffinity.md)
 - [V1PodAffinityTerm](docs/V1PodAffinityTerm.md)
 - [V1PodAntiAffinity](docs/V1PodAntiAffinity.md)
 - [V1PodCondition](docs/V1PodCondition.md)
 - [V1PodList](docs/V1PodList.md)
 - [V1PodSecurityContext](docs/V1PodSecurityContext.md)
 - [V1PodSpec](docs/V1PodSpec.md)
 - [V1PodStatus](docs/V1PodStatus.md)
 - [V1PodTemplate](docs/V1PodTemplate.md)
 - [V1PodTemplateList](docs/V1PodTemplateList.md)
 - [V1PodTemplateSpec](docs/V1PodTemplateSpec.md)
 - [V1PortworxVolumeSource](docs/V1PortworxVolumeSource.md)
 - [V1Preconditions](docs/V1Preconditions.md)
 - [V1PreferredSchedulingTerm](docs/V1PreferredSchedulingTerm.md)
 - [V1Probe](docs/V1Probe.md)
 - [V1ProjectedVolumeSource](docs/V1ProjectedVolumeSource.md)
 - [V1QuobyteVolumeSource](docs/V1QuobyteVolumeSource.md)
 - [V1RBDVolumeSource](docs/V1RBDVolumeSource.md)
 - [V1ReplicationController](docs/V1ReplicationController.md)
 - [V1ReplicationControllerCondition](docs/V1ReplicationControllerCondition.md)
 - [V1ReplicationControllerList](docs/V1ReplicationControllerList.md)
 - [V1ReplicationControllerSpec](docs/V1ReplicationControllerSpec.md)
 - [V1ReplicationControllerStatus](docs/V1ReplicationControllerStatus.md)
 - [V1ResourceAttributes](docs/V1ResourceAttributes.md)
 - [V1ResourceFieldSelector](docs/V1ResourceFieldSelector.md)
 - [V1ResourceQuota](docs/V1ResourceQuota.md)
 - [V1ResourceQuotaList](docs/V1ResourceQuotaList.md)
 - [V1ResourceQuotaSpec](docs/V1ResourceQuotaSpec.md)
 - [V1ResourceQuotaStatus](docs/V1ResourceQuotaStatus.md)
 - [V1ResourceRequirements](docs/V1ResourceRequirements.md)
 - [V1SELinuxOptions](docs/V1SELinuxOptions.md)
 - [V1Scale](docs/V1Scale.md)
 - [V1ScaleIOVolumeSource](docs/V1ScaleIOVolumeSource.md)
 - [V1ScaleSpec](docs/V1ScaleSpec.md)
 - [V1ScaleStatus](docs/V1ScaleStatus.md)
 - [V1Secret](docs/V1Secret.md)
 - [V1SecretEnvSource](docs/V1SecretEnvSource.md)
 - [V1SecretKeySelector](docs/V1SecretKeySelector.md)
 - [V1SecretList](docs/V1SecretList.md)
 - [V1SecretProjection](docs/V1SecretProjection.md)
 - [V1SecretVolumeSource](docs/V1SecretVolumeSource.md)
 - [V1SecurityContext](docs/V1SecurityContext.md)
 - [V1SelfSubjectAccessReview](docs/V1SelfSubjectAccessReview.md)
 - [V1SelfSubjectAccessReviewSpec](docs/V1SelfSubjectAccessReviewSpec.md)
 - [V1ServerAddressByClientCIDR](docs/V1ServerAddressByClientCIDR.md)
 - [V1Service](docs/V1Service.md)
 - [V1ServiceAccount](docs/V1ServiceAccount.md)
 - [V1ServiceAccountList](docs/V1ServiceAccountList.md)
 - [V1ServiceList](docs/V1ServiceList.md)
 - [V1ServicePort](docs/V1ServicePort.md)
 - [V1ServiceSpec](docs/V1ServiceSpec.md)
 - [V1ServiceStatus](docs/V1ServiceStatus.md)
 - [V1Status](docs/V1Status.md)
 - [V1StatusCause](docs/V1StatusCause.md)
 - [V1StatusDetails](docs/V1StatusDetails.md)
 - [V1StorageClass](docs/V1StorageClass.md)
 - [V1StorageClassList](docs/V1StorageClassList.md)
 - [V1SubjectAccessReview](docs/V1SubjectAccessReview.md)
 - [V1SubjectAccessReviewSpec](docs/V1SubjectAccessReviewSpec.md)
 - [V1SubjectAccessReviewStatus](docs/V1SubjectAccessReviewStatus.md)
 - [V1TCPSocketAction](docs/V1TCPSocketAction.md)
 - [V1Taint](docs/V1Taint.md)
 - [V1TokenReview](docs/V1TokenReview.md)
 - [V1TokenReviewSpec](docs/V1TokenReviewSpec.md)
 - [V1TokenReviewStatus](docs/V1TokenReviewStatus.md)
 - [V1Toleration](docs/V1Toleration.md)
 - [V1UserInfo](docs/V1UserInfo.md)
 - [V1Volume](docs/V1Volume.md)
 - [V1VolumeMount](docs/V1VolumeMount.md)
 - [V1VolumeProjection](docs/V1VolumeProjection.md)
 - [V1VsphereVirtualDiskVolumeSource](docs/V1VsphereVirtualDiskVolumeSource.md)
 - [V1WatchEvent](docs/V1WatchEvent.md)
 - [V1WeightedPodAffinityTerm](docs/V1WeightedPodAffinityTerm.md)
 - [V1alpha1ClusterRole](docs/V1alpha1ClusterRole.md)
 - [V1alpha1ClusterRoleBinding](docs/V1alpha1ClusterRoleBinding.md)
 - [V1alpha1ClusterRoleBindingList](docs/V1alpha1ClusterRoleBindingList.md)
 - [V1alpha1ClusterRoleList](docs/V1alpha1ClusterRoleList.md)
 - [V1alpha1PodPreset](docs/V1alpha1PodPreset.md)
 - [V1alpha1PodPresetList](docs/V1alpha1PodPresetList.md)
 - [V1alpha1PodPresetSpec](docs/V1alpha1PodPresetSpec.md)
 - [V1alpha1PolicyRule](docs/V1alpha1PolicyRule.md)
 - [V1alpha1Role](docs/V1alpha1Role.md)
 - [V1alpha1RoleBinding](docs/V1alpha1RoleBinding.md)
 - [V1alpha1RoleBindingList](docs/V1alpha1RoleBindingList.md)
 - [V1alpha1RoleList](docs/V1alpha1RoleList.md)
 - [V1alpha1RoleRef](docs/V1alpha1RoleRef.md)
 - [V1alpha1Subject](docs/V1alpha1Subject.md)
 - [V1beta1APIVersion](docs/V1beta1APIVersion.md)
 - [V1beta1CertificateSigningRequest](docs/V1beta1CertificateSigningRequest.md)
 - [V1beta1CertificateSigningRequestCondition](docs/V1beta1CertificateSigningRequestCondition.md)
 - [V1beta1CertificateSigningRequestList](docs/V1beta1CertificateSigningRequestList.md)
 - [V1beta1CertificateSigningRequestSpec](docs/V1beta1CertificateSigningRequestSpec.md)
 - [V1beta1CertificateSigningRequestStatus](docs/V1beta1CertificateSigningRequestStatus.md)
 - [V1beta1ClusterRole](docs/V1beta1ClusterRole.md)
 - [V1beta1ClusterRoleBinding](docs/V1beta1ClusterRoleBinding.md)
 - [V1beta1ClusterRoleBindingList](docs/V1beta1ClusterRoleBindingList.md)
 - [V1beta1ClusterRoleList](docs/V1beta1ClusterRoleList.md)
 - [V1beta1DaemonSet](docs/V1beta1DaemonSet.md)
 - [V1beta1DaemonSetList](docs/V1beta1DaemonSetList.md)
 - [V1beta1DaemonSetSpec](docs/V1beta1DaemonSetSpec.md)
 - [V1beta1DaemonSetStatus](docs/V1beta1DaemonSetStatus.md)
 - [V1beta1DaemonSetUpdateStrategy](docs/V1beta1DaemonSetUpdateStrategy.md)
 - [V1beta1Eviction](docs/V1beta1Eviction.md)
 - [V1beta1FSGroupStrategyOptions](docs/V1beta1FSGroupStrategyOptions.md)
 - [V1beta1HTTPIngressPath](docs/V1beta1HTTPIngressPath.md)
 - [V1beta1HTTPIngressRuleValue](docs/V1beta1HTTPIngressRuleValue.md)
 - [V1beta1HostPortRange](docs/V1beta1HostPortRange.md)
 - [V1beta1IDRange](docs/V1beta1IDRange.md)
 - [V1beta1Ingress](docs/V1beta1Ingress.md)
 - [V1beta1IngressBackend](docs/V1beta1IngressBackend.md)
 - [V1beta1IngressList](docs/V1beta1IngressList.md)
 - [V1beta1IngressRule](docs/V1beta1IngressRule.md)
 - [V1beta1IngressSpec](docs/V1beta1IngressSpec.md)
 - [V1beta1IngressStatus](docs/V1beta1IngressStatus.md)
 - [V1beta1IngressTLS](docs/V1beta1IngressTLS.md)
 - [V1beta1LocalSubjectAccessReview](docs/V1beta1LocalSubjectAccessReview.md)
 - [V1beta1NetworkPolicy](docs/V1beta1NetworkPolicy.md)
 - [V1beta1NetworkPolicyIngressRule](docs/V1beta1NetworkPolicyIngressRule.md)
 - [V1beta1NetworkPolicyList](docs/V1beta1NetworkPolicyList.md)
 - [V1beta1NetworkPolicyPeer](docs/V1beta1NetworkPolicyPeer.md)
 - [V1beta1NetworkPolicyPort](docs/V1beta1NetworkPolicyPort.md)
 - [V1beta1NetworkPolicySpec](docs/V1beta1NetworkPolicySpec.md)
 - [V1beta1NonResourceAttributes](docs/V1beta1NonResourceAttributes.md)
 - [V1beta1PodDisruptionBudget](docs/V1beta1PodDisruptionBudget.md)
 - [V1beta1PodDisruptionBudgetList](docs/V1beta1PodDisruptionBudgetList.md)
 - [V1beta1PodDisruptionBudgetSpec](docs/V1beta1PodDisruptionBudgetSpec.md)
 - [V1beta1PodDisruptionBudgetStatus](docs/V1beta1PodDisruptionBudgetStatus.md)
 - [V1beta1PodSecurityPolicy](docs/V1beta1PodSecurityPolicy.md)
 - [V1beta1PodSecurityPolicyList](docs/V1beta1PodSecurityPolicyList.md)
 - [V1beta1PodSecurityPolicySpec](docs/V1beta1PodSecurityPolicySpec.md)
 - [V1beta1PolicyRule](docs/V1beta1PolicyRule.md)
 - [V1beta1ReplicaSet](docs/V1beta1ReplicaSet.md)
 - [V1beta1ReplicaSetCondition](docs/V1beta1ReplicaSetCondition.md)
 - [V1beta1ReplicaSetList](docs/V1beta1ReplicaSetList.md)
 - [V1beta1ReplicaSetSpec](docs/V1beta1ReplicaSetSpec.md)
 - [V1beta1ReplicaSetStatus](docs/V1beta1ReplicaSetStatus.md)
 - [V1beta1ResourceAttributes](docs/V1beta1ResourceAttributes.md)
 - [V1beta1Role](docs/V1beta1Role.md)
 - [V1beta1RoleBinding](docs/V1beta1RoleBinding.md)
 - [V1beta1RoleBindingList](docs/V1beta1RoleBindingList.md)
 - [V1beta1RoleList](docs/V1beta1RoleList.md)
 - [V1beta1RoleRef](docs/V1beta1RoleRef.md)
 - [V1beta1RollingUpdateDaemonSet](docs/V1beta1RollingUpdateDaemonSet.md)
 - [V1beta1RunAsUserStrategyOptions](docs/V1beta1RunAsUserStrategyOptions.md)
 - [V1beta1SELinuxStrategyOptions](docs/V1beta1SELinuxStrategyOptions.md)
 - [V1beta1SelfSubjectAccessReview](docs/V1beta1SelfSubjectAccessReview.md)
 - [V1beta1SelfSubjectAccessReviewSpec](docs/V1beta1SelfSubjectAccessReviewSpec.md)
 - [V1beta1StatefulSet](docs/V1beta1StatefulSet.md)
 - [V1beta1StatefulSetList](docs/V1beta1StatefulSetList.md)
 - [V1beta1StatefulSetSpec](docs/V1beta1StatefulSetSpec.md)
 - [V1beta1StatefulSetStatus](docs/V1beta1StatefulSetStatus.md)
 - [V1beta1StorageClass](docs/V1beta1StorageClass.md)
 - [V1beta1StorageClassList](docs/V1beta1StorageClassList.md)
 - [V1beta1Subject](docs/V1beta1Subject.md)
 - [V1beta1SubjectAccessReview](docs/V1beta1SubjectAccessReview.md)
 - [V1beta1SubjectAccessReviewSpec](docs/V1beta1SubjectAccessReviewSpec.md)
 - [V1beta1SubjectAccessReviewStatus](docs/V1beta1SubjectAccessReviewStatus.md)
 - [V1beta1SupplementalGroupsStrategyOptions](docs/V1beta1SupplementalGroupsStrategyOptions.md)
 - [V1beta1ThirdPartyResource](docs/V1beta1ThirdPartyResource.md)
 - [V1beta1ThirdPartyResourceList](docs/V1beta1ThirdPartyResourceList.md)
 - [V1beta1TokenReview](docs/V1beta1TokenReview.md)
 - [V1beta1TokenReviewSpec](docs/V1beta1TokenReviewSpec.md)
 - [V1beta1TokenReviewStatus](docs/V1beta1TokenReviewStatus.md)
 - [V1beta1UserInfo](docs/V1beta1UserInfo.md)
 - [V2alpha1CronJob](docs/V2alpha1CronJob.md)
 - [V2alpha1CronJobList](docs/V2alpha1CronJobList.md)
 - [V2alpha1CronJobSpec](docs/V2alpha1CronJobSpec.md)
 - [V2alpha1CronJobStatus](docs/V2alpha1CronJobStatus.md)
 - [V2alpha1CrossVersionObjectReference](docs/V2alpha1CrossVersionObjectReference.md)
 - [V2alpha1HorizontalPodAutoscaler](docs/V2alpha1HorizontalPodAutoscaler.md)
 - [V2alpha1HorizontalPodAutoscalerList](docs/V2alpha1HorizontalPodAutoscalerList.md)
 - [V2alpha1HorizontalPodAutoscalerSpec](docs/V2alpha1HorizontalPodAutoscalerSpec.md)
 - [V2alpha1HorizontalPodAutoscalerStatus](docs/V2alpha1HorizontalPodAutoscalerStatus.md)
 - [V2alpha1JobTemplateSpec](docs/V2alpha1JobTemplateSpec.md)
 - [V2alpha1MetricSpec](docs/V2alpha1MetricSpec.md)
 - [V2alpha1MetricStatus](docs/V2alpha1MetricStatus.md)
 - [V2alpha1ObjectMetricSource](docs/V2alpha1ObjectMetricSource.md)
 - [V2alpha1ObjectMetricStatus](docs/V2alpha1ObjectMetricStatus.md)
 - [V2alpha1PodsMetricSource](docs/V2alpha1PodsMetricSource.md)
 - [V2alpha1PodsMetricStatus](docs/V2alpha1PodsMetricStatus.md)
 - [V2alpha1ResourceMetricSource](docs/V2alpha1ResourceMetricSource.md)
 - [V2alpha1ResourceMetricStatus](docs/V2alpha1ResourceMetricStatus.md)
 - [VersionInfo](docs/VersionInfo.md)


## Documentation For Authorization


## BearerToken

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header


## Author



