      SUBROUTINE LEAVE
C
C  THIS ROUTINE
C
C    1) DE-ALLOCATES ALL SCRATCH SPACE ALLOCATED SINCE THE LAST ENTER,
C       INCLUDING THE LAST ENTER-BLOCK.
C    2) RESTORES THE RECOVERY LEVEL TO ITS VALUE
C       AT THE TIME OF THE LAST CALL TO ENTER.
C
C  ERROR STATES -
C
C    1 - CANNOT LEAVE BEYOND THE FIRST ENTER.
C    2 - ISTACK(INOW) HAS BEEN OVERWRITTEN.
C    3 - TOO MANY ISTKRLS OR ISTACK(1 AND/OR INOW) CLOBBERED.
C    4 - ISTACK(INOW+1) HAS BEEN OVERWRITTEN.
C    5 - ISTACK(INOW+2) HAS BEEN OVERWRITTEN.
C
      COMMON /CSTAK/DSTACK
      DOUBLE PRECISION DSTACK(500)
      INTEGER ISTACK(1000)
      EQUIVALENCE (DSTACK(1),ISTACK(1))
      EQUIVALENCE (ISTACK(1),LOUT)
C
C  GET THE POINTER TO THE CURRENT ENTER-BLOCK.
C
      INOW=I8TSEL(-1)
C
C/6S
C     IF (INOW.EQ.0)
C    1  CALL SETERR(43HLEAVE - CANNOT LEAVE BEYOND THE FIRST ENTER,43,
C    2              1,2)
C     IF (ISTACK(INOW).LT.1)
C    1  CALL SETERR(41HLEAVE - ISTACK(INOW) HAS BEEN OVERWRITTEN,41,2,2)
C     IF (LOUT.LT.ISTACK(INOW)) CALL SETERR(
C    1  59HLEAVE - TOO MANY ISTKRLS OR ISTACK(1 AND/OR INOW) CLOBBERED,
C    2  59,3,2)
C     IF (ISTACK(INOW+1).LT.1 .OR. ISTACK(INOW+1).GT.2)
C    1  CALL SETERR(43HLEAVE - ISTACK(INOW+1) HAS BEEN OVERWRITTEN,
C    2              43,4,2)
C     IF (ISTACK(INOW+2).GT.INOW-3 .OR. ISTACK(INOW+2).LT.0)
C    1  CALL SETERR(43HLEAVE - ISTACK(INOW+2) HAS BEEN OVERWRITTEN,
C    2              43,5,2)
C/7S
      IF (INOW.EQ.0)
     1  CALL SETERR('LEAVE - CANNOT LEAVE BEYOND THE FIRST ENTER',43,
     2              1,2)
      IF (ISTACK(INOW).LT.1)
     1  CALL SETERR('LEAVE - ISTACK(INOW) HAS BEEN OVERWRITTEN',41,2,2)
      IF (LOUT.LT.ISTACK(INOW)) CALL SETERR(
     1  'LEAVE - TOO MANY ISTKRLS OR ISTACK(1 AND/OR INOW) CLOBBERED',
     2  59,3,2)
      IF (ISTACK(INOW+1).LT.1 .OR. ISTACK(INOW+1).GT.2)
     1  CALL SETERR('LEAVE - ISTACK(INOW+1) HAS BEEN OVERWRITTEN',
     2              43,4,2)
      IF (ISTACK(INOW+2).GT.INOW-3 .OR. ISTACK(INOW+2).LT.0)
     1  CALL SETERR('LEAVE - ISTACK(INOW+2) HAS BEEN OVERWRITTEN',
     2              43,5,2)
C/
C
C  DE-ALLOCATE THE SCRATCH SPACE.
C
      CALL ISTKRL(LOUT-ISTACK(INOW)+1)
C
C  RESTORE THE RECOVERY LEVEL.
C
      CALL RETSRC(ISTACK(INOW+1))
C
C  LOWER THE BACK-POINTER.
C
      ITEMP=I8TSEL(ISTACK(INOW+2))
C
      RETURN
C
      END
