//
// SecureServerSocket.h
//
// $Id: //poco/1.3/NetSSL_OpenSSL/include/Poco/Net/SecureServerSocket.h#4 $
//
// Library: NetSSL_OpenSSL
// Package: SSLSockets
// Module:  SecureServerSocket
//
// Definition of the SecureServerSocket class.
//
// Copyright (c) 2006-2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef NetSSL_SecureServerSocket_INCLUDED
#define NetSSL_SecureServerSocket_INCLUDED


#include "Poco/Net/NetSSL.h"
#include "Poco/Net/ServerSocket.h"
#include "Poco/Net/Context.h"


namespace Poco {
namespace Net {


class NetSSL_API SecureServerSocket: public ServerSocket
	/// A server socket for secure SSL connections.
{
public:
	SecureServerSocket();
		/// Creates a SSL server socket using the
		/// default SSL server context.
		///
		/// The server socket must be bound to
		/// an address and put into listening state.

	explicit SecureServerSocket(Context::Ptr pContext);
		/// Creates a SSL server socket, using the
		/// given SSL context object.
		///
		/// The server socket must be bound to
		/// an address and put into listening state.

	SecureServerSocket(const Socket& socket);
		/// Creates the SecureServerSocket with the SocketImpl
		/// from another socket. The SocketImpl must be
		/// a SecureServerSocketImpl, otherwise an InvalidArgumentException
		/// will be thrown.

	SecureServerSocket(const SocketAddress& address, int backlog = 64);
		/// Creates a server socket using the default server SSL context,
		/// binds it to the given address and puts it in listening
		/// state.
		///
		/// After successful construction, the server socket
		/// is ready to accept connections.

	SecureServerSocket(const SocketAddress& address, int backlog, Context::Ptr pContext);
		/// Creates a server socket using the given SSL context, binds it
		/// to the given address and puts it in listening
		/// state.
		///
		/// After successful construction, the server socket
		/// is ready to accept connections.

	SecureServerSocket(Poco::UInt16 port, int backlog = 64);
		/// Creates a server socket using the default server SSL context,
		/// binds it to the given port and puts it in listening
		/// state.
		///
		/// After successful construction, the server socket
		/// is ready to accept connections.

	SecureServerSocket(Poco::UInt16 port, int backlog, Context::Ptr pContext);
		/// Creates a server socket using the given SSL context, binds it
		/// to the given port and puts it in listening
		/// state.
		///
		/// After successful construction, the server socket
		/// is ready to accept connections.

	virtual ~SecureServerSocket();
		/// Destroys the StreamSocket.

	SecureServerSocket& operator = (const Socket& socket);
		/// Assignment operator.
		///
		/// Releases the socket's SocketImpl and
		/// attaches the SocketImpl from the other socket and
		/// increments the reference count of the SocketImpl.	

	StreamSocket acceptConnection(SocketAddress& clientAddr);
		/// Get the next completed connection from the
		/// socket's completed connection queue.
		///
		/// If the queue is empty, waits until a connection
		/// request completes.
		///
		/// Returns a new SSL socket for the connection
		/// with the client.
		///
		/// The client socket's address is returned in clientAddr.
		///
		/// No SSL handshake is performed on the new connection.
		/// The SSL handshake will be performed the first time
		/// sendBytes(), receiveBytes() or completeHandshake()
		/// is called on the returned SecureStreamSocket.

	StreamSocket acceptConnection();
		/// Get the next completed connection from the
		/// socket's completed connection queue.
		///
		/// If the queue is empty, waits until a connection
		/// request completes.
		///
		/// Returns a new SSL socket for the connection
		/// with the client.
		///
		/// No SSL handshake is performed on the new connection.
		/// The SSL handshake will be performed the first time
		/// sendBytes(), receiveBytes() or completeHandshake()
		/// is called on the returned SecureStreamSocket.

	Context::Ptr context() const;
		/// Returns the SSL context used by this socket.
};


} } // namespace Poco::Net


#endif // NetSSL_SecureServerSocket_INCLUDED
