//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
#ifndef vtk_m_ClipTables_h
#define vtk_m_ClipTables_h

#include <vtkm/CellShape.h>
#include <vtkm/Types.h>

#include <vtkm/cont/ArrayHandle.h>
#include <vtkm/cont/ExecutionObjectBase.h>

namespace vtkm
{
namespace worklet
{
namespace internal
{
// clang-format off
// table format:
// ncells, {{celltype, nverts, {edge/verts(>=100), ...}}, ...}, \n
// values < 100 represent edges where the corresponding vertex lies
// values >= 100 reresent existing vertices of the input cell (vertex = value - 100)
VTKM_STATIC_CONSTEXPR_ARRAY vtkm::UInt8 ClipTablesData[] = {
// Vtx
1, // Case : 0
1, 1, 100,
0, // Case : 1
// Lin
1, // Case : 0
3, 2, 100, 101,
1, // Case : 1
3, 2, 0, 101,
1, // Case : 2
3, 2, 0, 100,
0, // Case : 3
// Tri
1, // Case : 0
5, 3, 100, 101, 102,
1, // Case : 1
9, 4, 101, 102, 2, 0,
1, // Case : 2
9, 4, 102, 100, 0, 1,
1, // Case : 3
5, 3, 2, 1, 102,
1, // Case : 4
9, 4, 100, 101, 1, 2,
1, // Case : 5
5, 3, 1, 0, 101,
1, // Case : 6
5, 3, 0, 2, 100,
0, // Case : 7
// Qua
1, // Case : 0
9, 4, 100, 101, 102, 103,
2, // Case : 1
9, 4, 3, 0, 101, 103,
5, 3, 103, 101, 102,
2, // Case : 2
9, 4, 0, 1, 102, 100,
5, 3, 100, 102, 103,
1, // Case : 3
9, 4, 3, 1, 102, 103,
2, // Case : 4
9, 4, 1, 2, 103, 101,
5, 3, 101, 103, 100,
2, // Case : 5
5, 3, 3, 2, 103,
5, 3, 1, 0, 101,
1, // Case : 6
9, 4, 0, 2, 103, 100,
1, // Case : 7
5, 3, 3, 2, 103,
2, // Case : 8
9, 4, 2, 3, 100, 102,
5, 3, 102, 100, 101,
1, // Case : 9
9, 4, 2, 0, 101, 102,
2, // Case : 10
5, 3, 0, 3, 100,
5, 3, 2, 1, 102,
1, // Case : 11
5, 3, 2, 1, 102,
1, // Case : 12
9, 4, 1, 3, 100, 101,
1, // Case : 13
5, 3, 1, 0, 101,
1, // Case : 14
5, 3, 0, 3, 100,
0, // Case : 15
// Tet
1, // Case : 0
10, 4, 100, 101, 102, 103,
1, // Case : 1
13, 6, 0, 3, 2, 101, 103, 102,
1, // Case : 2
13, 6, 100, 103, 102, 0, 4, 1,
1, // Case : 3
13, 6, 103, 3, 4, 102, 2, 1,
1, // Case : 4
13, 6, 2, 5, 1, 100, 103, 101,
1, // Case : 5
13, 6, 101, 0, 1, 103, 3, 5,
1, // Case : 6
13, 6, 103, 4, 5, 100, 0, 2,
1, // Case : 7
10, 4, 3, 4, 5, 103,
1, // Case : 8
13, 6, 100, 102, 101, 3, 5, 4,
1, // Case : 9
13, 6, 102, 2, 5, 101, 0, 4,
1, // Case : 10
13, 6, 100, 0, 3, 102, 1, 5,
1, // Case : 11
10, 4, 2, 5, 1, 102,
1, // Case : 12
13, 6, 101, 1, 4, 100, 2, 3,
1, // Case : 13
10, 4, 0, 1, 4, 101,
1, // Case : 14
10, 4, 0, 3, 2, 100,
0, // Case : 15
// Hex
1, // Case : 0
12, 8, 100, 101, 102, 103, 104, 105, 106, 107,
9, // Case : 1
0, 7, 101, 102, 103, 104, 105, 106, 107,
13, 6, 101, 103, 104, 0, 3, 8,
10, 4, 101, 103, 104, 255,
10, 4, 101, 102, 103, 255,
14, 5, 106, 107, 103, 102, 255,
14, 5, 105, 106, 102, 101, 255,
14, 5, 104, 107, 106, 105, 255,
10, 4, 103, 107, 104, 255,
10, 4, 104, 105, 101, 255,
9, // Case : 2
0, 7, 105, 104, 100, 102, 106, 107, 103,
13, 6, 9, 0, 1, 105, 100, 102,
10, 4, 105, 102, 100, 255,
10, 4, 105, 100, 104, 255,
14, 5, 107, 104, 100, 103, 255,
14, 5, 106, 105, 104, 107, 255,
14, 5, 102, 106, 107, 103, 255,
10, 4, 100, 102, 103, 255,
10, 4, 102, 105, 106, 255,
2, // Case : 3
12, 8, 1, 102, 103, 3, 9, 105, 104, 8,
13, 6, 102, 106, 105, 103, 107, 104,
9, // Case : 4
0, 7, 106, 105, 101, 103, 107, 104, 100,
13, 6, 11, 1, 2, 106, 101, 103,
10, 4, 106, 103, 101, 255,
10, 4, 106, 101, 105, 255,
14, 5, 104, 105, 101, 100, 255,
14, 5, 107, 106, 105, 104, 255,
14, 5, 103, 107, 104, 100, 255,
10, 4, 101, 103, 100, 255,
10, 4, 103, 106, 107, 255,
12, // Case : 5
0, 2, 8, 11,
14, 5, 104, 107, 106, 105, 255,
10, 4, 105, 106, 101, 255,
10, 4, 104, 105, 101, 255,
10, 4, 103, 107, 104, 255,
10, 4, 106, 107, 103, 255,
14, 5, 106, 103, 2, 11, 255,
14, 5, 101, 106, 11, 1, 255,
10, 4, 101, 1, 0, 255,
14, 5, 104, 101, 0, 8, 255,
14, 5, 104, 8, 3, 103, 255,
10, 4, 103, 3, 2, 255,
2, // Case : 6
12, 8, 2, 103, 100, 0, 11, 106, 105, 9,
13, 6, 103, 107, 106, 100, 104, 105,
9, // Case : 7
0, 5, 8, 9, 3, 2, 11,
14, 5, 104, 107, 106, 105, 255,
10, 4, 106, 103, 255, 107,
14, 5, 105, 106, 11, 9, 255,
14, 5, 8, 104, 105, 9, 255,
10, 4, 103, 107, 104, 255,
14, 5, 103, 104, 8, 3, 255,
10, 4, 103, 3, 2, 255,
14, 5, 11, 106, 103, 2, 255,
9, // Case : 8
0, 7, 102, 101, 100, 107, 106, 105, 104,
13, 6, 2, 3, 10, 102, 100, 107,
10, 4, 102, 107, 100, 255,
10, 4, 102, 100, 101, 255,
14, 5, 105, 101, 100, 104, 255,
14, 5, 106, 102, 101, 105, 255,
14, 5, 107, 106, 105, 104, 255,
10, 4, 100, 107, 104, 255,
10, 4, 107, 102, 106, 255,
2, // Case : 9
12, 8, 10, 107, 104, 8, 2, 102, 101, 0,
13, 6, 107, 106, 102, 104, 105, 101,
12, // Case : 10
0, 2, 10, 9,
14, 5, 107, 106, 105, 104, 255,
10, 4, 106, 102, 105, 255,
10, 4, 107, 102, 106, 255,
10, 4, 100, 107, 104, 255,
10, 4, 105, 100, 104, 255,
14, 5, 105, 9, 0, 100, 255,
14, 5, 102, 1, 9, 105, 255,
10, 4, 102, 2, 1, 255,
14, 5, 107, 10, 2, 102, 255,
14, 5, 107, 100, 3, 10, 255,
10, 4, 100, 0, 3, 255,
9, // Case : 11
0, 5, 9, 8, 1, 2, 10,
14, 5, 105, 104, 107, 106, 255,
10, 4, 107, 255, 102, 106,
14, 5, 104, 8, 10, 107, 255,
14, 5, 9, 8, 104, 105, 255,
10, 4, 102, 105, 106, 255,
14, 5, 102, 1, 9, 105, 255,
10, 4, 102, 2, 1, 255,
14, 5, 10, 2, 102, 107, 255,
2, // Case : 12
12, 8, 11, 106, 107, 10, 1, 101, 100, 3,
13, 6, 100, 104, 107, 101, 105, 106,
9, // Case : 13
0, 5, 8, 10, 0, 1, 11,
14, 5, 104, 107, 106, 105, 255,
10, 4, 106, 255, 101, 105,
14, 5, 107, 10, 11, 106, 255,
14, 5, 8, 10, 107, 104, 255,
10, 4, 101, 104, 105, 255,
14, 5, 101, 0, 8, 104, 255,
10, 4, 101, 1, 0, 255,
14, 5, 11, 1, 101, 106, 255,
9, // Case : 14
0, 5, 10, 11, 3, 0, 9,
14, 5, 107, 106, 105, 104, 255,
10, 4, 105, 255, 100, 104,
14, 5, 106, 11, 9, 105, 255,
14, 5, 10, 11, 106, 107, 255,
10, 4, 100, 107, 104, 255,
14, 5, 100, 3, 10, 107, 255,
10, 4, 100, 0, 3, 255,
14, 5, 9, 0, 100, 105, 255,
1, // Case : 15
12, 8, 8, 9, 11, 10, 104, 105, 106, 107,
9, // Case : 16
0, 7, 105, 101, 100, 107, 106, 102, 103,
13, 6, 105, 100, 107, 4, 8, 7,
10, 4, 105, 100, 107, 255,
10, 4, 105, 101, 100, 255,
14, 5, 102, 103, 100, 101, 255,
14, 5, 106, 102, 101, 105, 255,
14, 5, 107, 103, 102, 106, 255,
10, 4, 100, 103, 107, 255,
10, 4, 107, 106, 105, 255,
2, // Case : 17
12, 8, 4, 105, 101, 0, 7, 107, 103, 3,
13, 6, 103, 102, 101, 107, 106, 105,
12, // Case : 18
0, 2, 7, 1,
14, 5, 107, 103, 102, 106, 255,
10, 4, 106, 102, 105, 255,
10, 4, 107, 106, 105, 255,
10, 4, 100, 103, 107, 255,
10, 4, 102, 103, 100, 255,
14, 5, 102, 100, 0, 1, 255,
14, 5, 105, 102, 1, 9, 255,
10, 4, 105, 9, 4, 255,
14, 5, 107, 105, 4, 7, 255,
14, 5, 107, 7, 8, 100, 255,
10, 4, 100, 8, 0, 255,
9, // Case : 19
0, 5, 1, 3, 9, 4, 7,
14, 5, 102, 106, 107, 103, 255,
10, 4, 107, 105, 255, 106,
14, 5, 103, 107, 7, 3, 255,
14, 5, 1, 102, 103, 3, 255,
10, 4, 105, 106, 102, 255,
14, 5, 105, 102, 1, 9, 255,
10, 4, 105, 9, 4, 255,
14, 5, 7, 107, 105, 4, 255,
6, // Case : 20
13, 6, 1, 2, 11, 101, 103, 106,
13, 6, 100, 107, 105, 8, 7, 4,
10, 4, 103, 101, 106, 107,
10, 4, 105, 107, 106, 101,
10, 4, 100, 105, 101, 107,
10, 4, 103, 107, 100, 101,
11, // Case : 21
0, 4, 4, 7, 11, 11,
14, 5, 106, 103, 2, 11, 255,
10, 4, 2, 103, 3, 255,
14, 5, 107, 7, 3, 103, 255,
10, 4, 106, 107, 103, 255,
10, 4, 101, 1, 0, 255,
10, 4, 105, 106, 101, 255,
14, 5, 101, 106, 11, 1, 255,
10, 4, 105, 107, 106, 255,
14, 5, 105, 4, 7, 107, 255,
14, 5, 105, 101, 0, 4, 255,
11, // Case : 22
0, 4, 11, 2, 7, 7,
14, 5, 107, 7, 8, 100, 255,
10, 4, 8, 0, 100, 255,
14, 5, 103, 100, 0, 2, 255,
10, 4, 107, 100, 103, 255,
10, 4, 105, 9, 4, 255,
10, 4, 106, 105, 107, 255,
14, 5, 105, 4, 7, 107, 255,
10, 4, 106, 107, 103, 255,
14, 5, 106, 103, 2, 11, 255,
14, 5, 106, 11, 9, 105, 255,
9, // Case : 23
0, 6, 3, 2, 11, 9, 4, 7,
10, 4, 106, 105, 107, 255,
14, 5, 106, 11, 9, 105, 255,
10, 4, 103, 106, 107, 255,
14, 5, 103, 2, 11, 106, 255,
10, 4, 3, 2, 103, 255,
14, 5, 103, 107, 7, 3, 255,
14, 5, 7, 107, 105, 4, 255,
10, 4, 105, 9, 4, 255,
12, // Case : 24
0, 2, 2, 4,
14, 5, 102, 101, 105, 106, 255,
10, 4, 106, 105, 107, 255,
10, 4, 102, 106, 107, 255,
10, 4, 100, 101, 102, 255,
10, 4, 105, 101, 100, 255,
14, 5, 105, 100, 8, 4, 255,
14, 5, 107, 105, 4, 7, 255,
10, 4, 107, 7, 10, 255,
14, 5, 102, 107, 10, 2, 255,
14, 5, 102, 2, 3, 100, 255,
10, 4, 100, 3, 8, 255,
9, // Case : 25
0, 5, 4, 0, 7, 10, 2,
14, 5, 105, 106, 102, 101, 255,
10, 4, 102, 107, 255, 106,
14, 5, 101, 102, 2, 0, 255,
14, 5, 4, 105, 101, 0, 255,
10, 4, 107, 106, 105, 255,
14, 5, 107, 105, 4, 7, 255,
10, 4, 107, 7, 10, 255,
14, 5, 2, 102, 107, 10, 255,
6, // Case : 26
10, 4, 100, 0, 3, 8,
10, 4, 105, 107, 106, 102,
14, 5, 2, 102, 107, 10, 7,
14, 5, 1, 9, 105, 102, 4,
14, 5, 107, 105, 4, 7, 102,
14, 5, 7, 4, 1, 2, 102,
5, // Case : 27
10, 4, 105, 107, 106, 102,
14, 5, 2, 102, 107, 10, 7,
14, 5, 1, 9, 105, 102, 4,
14, 5, 107, 105, 4, 7, 102,
14, 5, 7, 4, 1, 2, 102,
11, // Case : 28
0, 4, 11, 1, 4, 4,
14, 5, 105, 100, 8, 4, 255,
10, 4, 8, 100, 3, 255,
14, 5, 101, 1, 3, 100, 255,
10, 4, 105, 101, 100, 255,
10, 4, 107, 7, 10, 255,
10, 4, 106, 105, 107, 255,
14, 5, 107, 105, 4, 7, 255,
10, 4, 106, 101, 105, 255,
14, 5, 106, 11, 1, 101, 255,
14, 5, 106, 107, 10, 11, 255,
9, // Case : 29
0, 6, 0, 1, 11, 10, 7, 4,
10, 4, 106, 105, 107, 255,
14, 5, 106, 107, 10, 11, 255,
10, 4, 101, 105, 106, 255,
14, 5, 101, 106, 11, 1, 255,
10, 4, 0, 101, 1, 255,
14, 5, 101, 0, 4, 105, 255,
14, 5, 4, 7, 107, 105, 255,
10, 4, 107, 7, 10, 255,
8, // Case : 30
0, 5, 11, 9, 10, 7, 4,
10, 4, 100, 0, 3, 8,
14, 5, 105, 106, 11, 9, 255,
14, 5, 106, 107, 10, 11, 255,
10, 4, 107, 7, 10, 255,
10, 4, 106, 105, 107, 255,
14, 5, 107, 105, 4, 7, 255,
10, 4, 105, 9, 4, 255,
7, // Case : 31
0, 5, 9, 11, 10, 4, 7,
14, 5, 106, 107, 10, 11, 255,
10, 4, 107, 7, 10, 255,
14, 5, 105, 106, 11, 9, 255,
10, 4, 4, 105, 9, 255,
14, 5, 7, 107, 105, 4, 255,
10, 4, 107, 106, 105, 255,
9, // Case : 32
0, 7, 106, 102, 101, 104, 107, 103, 100,
13, 6, 106, 101, 104, 5, 9, 4,
10, 4, 106, 101, 104, 255,
10, 4, 106, 102, 101, 255,
14, 5, 103, 100, 101, 102, 255,
14, 5, 107, 103, 102, 106, 255,
14, 5, 104, 100, 103, 107, 255,
10, 4, 101, 100, 104, 255,
10, 4, 104, 107, 106, 255,
12, // Case : 33
0, 2, 3, 5,
14, 5, 103, 102, 106, 107, 255,
10, 4, 102, 101, 106, 255,
10, 4, 103, 101, 102, 255,
10, 4, 104, 103, 107, 255,
10, 4, 106, 104, 107, 255,
14, 5, 106, 5, 4, 104, 255,
14, 5, 101, 9, 5, 106, 255,
10, 4, 101, 0, 9, 255,
14, 5, 103, 3, 0, 101, 255,
14, 5, 103, 104, 8, 3, 255,
10, 4, 104, 4, 8, 255,
2, // Case : 34
12, 8, 5, 106, 102, 1, 4, 104, 100, 0,
13, 6, 100, 103, 102, 104, 107, 106,
9, // Case : 35
0, 5, 3, 1, 8, 4, 5,
14, 5, 103, 102, 106, 107, 255,
10, 4, 106, 255, 104, 107,
14, 5, 102, 1, 5, 106, 255,
14, 5, 3, 1, 102, 103, 255,
10, 4, 104, 103, 107, 255,
14, 5, 104, 8, 3, 103, 255,
10, 4, 104, 4, 8, 255,
14, 5, 5, 4, 104, 106, 255,
12, // Case : 36
0, 2, 2, 4,
14, 5, 103, 107, 104, 100, 255,
10, 4, 107, 106, 104, 255,
10, 4, 103, 106, 107, 255,
10, 4, 101, 103, 100, 255,
10, 4, 104, 101, 100, 255,
14, 5, 104, 4, 9, 101, 255,
14, 5, 106, 5, 4, 104, 255,
10, 4, 106, 11, 5, 255,
14, 5, 103, 2, 11, 106, 255,
14, 5, 103, 101, 1, 2, 255,
10, 4, 101, 9, 1, 255,
6, // Case : 37
10, 4, 101, 0, 9, 1,
10, 4, 106, 107, 103, 104,
14, 5, 8, 3, 103, 104, 2,
14, 5, 4, 104, 106, 5, 11,
14, 5, 103, 2, 11, 106, 104,
14, 5, 2, 8, 4, 11, 104,
9, // Case : 38
0, 5, 4, 0, 5, 11, 2,
14, 5, 104, 100, 103, 107, 255,
10, 4, 103, 255, 106, 107,
14, 5, 100, 0, 2, 103, 255,
14, 5, 4, 0, 100, 104, 255,
10, 4, 106, 104, 107, 255,
14, 5, 106, 5, 4, 104, 255,
10, 4, 106, 11, 5, 255,
14, 5, 2, 11, 106, 103, 255,
5, // Case : 39
10, 4, 106, 107, 103, 104,
14, 5, 8, 3, 103, 104, 2,
14, 5, 4, 104, 106, 5, 11,
14, 5, 103, 2, 11, 106, 104,
14, 5, 2, 8, 4, 11, 104,
6, // Case : 40
13, 6, 101, 104, 106, 9, 4, 5,
13, 6, 3, 10, 2, 100, 107, 102,
10, 4, 104, 106, 101, 107,
10, 4, 102, 106, 107, 101,
10, 4, 100, 101, 102, 107,
10, 4, 104, 100, 107, 101,
11, // Case : 41
0, 4, 2, 10, 5, 5,
14, 5, 106, 5, 4, 104, 255,
10, 4, 4, 8, 104, 255,
14, 5, 107, 104, 8, 10, 255,
10, 4, 106, 104, 107, 255,
10, 4, 101, 0, 9, 255,
10, 4, 102, 101, 106, 255,
14, 5, 101, 9, 5, 106, 255,
10, 4, 102, 106, 107, 255,
14, 5, 102, 107, 10, 2, 255,
14, 5, 102, 2, 0, 101, 255,
11, // Case : 42
0, 4, 5, 4, 10, 10,
14, 5, 107, 100, 3, 10, 255,
10, 4, 3, 100, 0, 255,
14, 5, 104, 4, 0, 100, 255,
10, 4, 107, 104, 100, 255,
10, 4, 102, 2, 1, 255,
10, 4, 106, 107, 102, 255,
14, 5, 102, 107, 10, 2, 255,
10, 4, 106, 104, 107, 255,
14, 5, 106, 5, 4, 104, 255,
14, 5, 106, 102, 1, 5, 255,
9, // Case : 43
0, 6, 8, 4, 5, 1, 2, 10,
10, 4, 106, 107, 102, 255,
14, 5, 106, 102, 1, 5, 255,
10, 4, 104, 107, 106, 255,
14, 5, 104, 106, 5, 4, 255,
10, 4, 8, 104, 4, 255,
14, 5, 104, 8, 10, 107, 255,
14, 5, 10, 2, 102, 107, 255,
10, 4, 102, 2, 1, 255,
11, // Case : 44
0, 4, 10, 3, 4, 4,
14, 5, 104, 4, 9, 101, 255,
10, 4, 9, 1, 101, 255,
14, 5, 100, 101, 1, 3, 255,
10, 4, 104, 101, 100, 255,
10, 4, 106, 11, 5, 255,
10, 4, 107, 106, 104, 255,
14, 5, 106, 5, 4, 104, 255,
10, 4, 107, 104, 100, 255,
14, 5, 107, 100, 3, 10, 255,
14, 5, 107, 10, 11, 106, 255,
8, // Case : 45
0, 5, 10, 11, 8, 4, 5,
10, 4, 101, 1, 0, 9,
14, 5, 106, 107, 10, 11, 255,
14, 5, 107, 104, 8, 10, 255,
10, 4, 104, 4, 8, 255,
10, 4, 107, 106, 104, 255,
14, 5, 104, 106, 5, 4, 255,
10, 4, 106, 11, 5, 255,
9, // Case : 46
0, 6, 0, 3, 10, 11, 5, 4,
10, 4, 107, 106, 104, 255,
14, 5, 107, 10, 11, 106, 255,
10, 4, 100, 107, 104, 255,
14, 5, 100, 3, 10, 107, 255,
10, 4, 0, 3, 100, 255,
14, 5, 100, 104, 4, 0, 255,
14, 5, 4, 104, 106, 5, 255,
10, 4, 106, 11, 5, 255,
7, // Case : 47
0, 5, 11, 10, 8, 5, 4,
14, 5, 107, 104, 8, 10, 255,
10, 4, 104, 4, 8, 255,
14, 5, 106, 107, 10, 11, 255,
10, 4, 5, 106, 11, 255,
14, 5, 4, 104, 106, 5, 255,
10, 4, 104, 107, 106, 255,
2, // Case : 48
12, 8, 9, 101, 100, 8, 5, 106, 107, 7,
13, 6, 101, 102, 106, 100, 103, 107,
9, // Case : 49
0, 5, 3, 7, 0, 9, 5,
14, 5, 103, 102, 106, 107, 255,
10, 4, 106, 101, 255, 102,
14, 5, 107, 106, 5, 7, 255,
14, 5, 3, 103, 107, 7, 255,
10, 4, 101, 102, 103, 255,
14, 5, 101, 103, 3, 0, 255,
10, 4, 101, 0, 9, 255,
14, 5, 5, 106, 101, 9, 255,
9, // Case : 50
0, 5, 7, 5, 8, 0, 1,
14, 5, 107, 103, 102, 106, 255,
10, 4, 102, 100, 255, 103,
14, 5, 106, 102, 1, 5, 255,
14, 5, 7, 107, 106, 5, 255,
10, 4, 100, 103, 107, 255,
14, 5, 100, 107, 7, 8, 255,
10, 4, 100, 8, 0, 255,
14, 5, 1, 102, 100, 0, 255,
1, // Case : 51
12, 8, 103, 102, 106, 107, 3, 1, 5, 7,
11, // Case : 52
0, 4, 7, 8, 2, 2,
14, 5, 103, 101, 1, 2, 255,
10, 4, 1, 101, 9, 255,
14, 5, 100, 8, 9, 101, 255,
10, 4, 103, 100, 101, 255,
10, 4, 106, 11, 5, 255,
10, 4, 107, 103, 106, 255,
14, 5, 106, 103, 2, 11, 255,
10, 4, 107, 100, 103, 255,
14, 5, 107, 7, 8, 100, 255,
14, 5, 107, 106, 5, 7, 255,
8, // Case : 53
0, 5, 7, 5, 3, 2, 11,
10, 4, 101, 0, 9, 1,
14, 5, 106, 5, 7, 107, 255,
14, 5, 107, 7, 3, 103, 255,
10, 4, 103, 3, 2, 255,
10, 4, 107, 103, 106, 255,
14, 5, 103, 2, 11, 106, 255,
10, 4, 106, 11, 5, 255,
9, // Case : 54
0, 6, 0, 8, 7, 5, 11, 2,
10, 4, 107, 103, 106, 255,
14, 5, 107, 106, 5, 7, 255,
10, 4, 100, 103, 107, 255,
14, 5, 100, 107, 7, 8, 255,
10, 4, 0, 100, 8, 255,
14, 5, 100, 0, 2, 103, 255,
14, 5, 2, 11, 106, 103, 255,
10, 4, 106, 11, 5, 255,
7, // Case : 55
0, 5, 5, 7, 3, 11, 2,
14, 5, 107, 7, 3, 103, 255,
10, 4, 103, 3, 2, 255,
14, 5, 106, 5, 7, 107, 255,
10, 4, 11, 5, 106, 255,
14, 5, 2, 11, 106, 103, 255,
10, 4, 103, 106, 107, 255,
11, // Case : 56
0, 4, 5, 9, 2, 2,
14, 5, 102, 2, 3, 100, 255,
10, 4, 3, 8, 100, 255,
14, 5, 101, 100, 8, 9, 255,
10, 4, 102, 100, 101, 255,
10, 4, 107, 7, 10, 255,
10, 4, 106, 107, 102, 255,
14, 5, 107, 10, 2, 102, 255,
10, 4, 106, 102, 101, 255,
14, 5, 106, 101, 9, 5, 255,
14, 5, 106, 5, 7, 107, 255,
9, // Case : 57
0, 6, 0, 9, 5, 7, 10, 2,
10, 4, 106, 107, 102, 255,
14, 5, 106, 5, 7, 107, 255,
10, 4, 101, 106, 102, 255,
14, 5, 101, 9, 5, 106, 255,
10, 4, 0, 9, 101, 255,
14, 5, 101, 102, 2, 0, 255,
14, 5, 2, 102, 107, 10, 255,
10, 4, 107, 7, 10, 255,
8, // Case : 58
0, 5, 5, 1, 7, 10, 2,
10, 4, 100, 8, 0, 3,
14, 5, 102, 1, 5, 106, 255,
14, 5, 106, 5, 7, 107, 255,
10, 4, 107, 7, 10, 255,
10, 4, 106, 107, 102, 255,
14, 5, 107, 10, 2, 102, 255,
10, 4, 102, 2, 1, 255,
7, // Case : 59
0, 5, 1, 5, 7, 2, 10,
14, 5, 106, 5, 7, 107, 255,
10, 4, 107, 7, 10, 255,
14, 5, 102, 1, 5, 106, 255,
10, 4, 2, 1, 102, 255,
14, 5, 10, 2, 102, 107, 255,
10, 4, 107, 102, 106, 255,
2, // Case : 60
13, 6, 101, 1, 9, 100, 3, 8,
13, 6, 106, 5, 11, 107, 7, 10,
2, // Case : 61
13, 6, 7, 107, 10, 5, 106, 11,
10, 4, 0, 101, 1, 9,
2, // Case : 62
13, 6, 7, 107, 10, 5, 106, 11,
10, 4, 0, 3, 100, 8,
1, // Case : 63
13, 6, 107, 10, 7, 106, 11, 5,
9, // Case : 64
0, 7, 107, 104, 105, 102, 103, 100, 101,
13, 6, 6, 5, 11, 107, 105, 102,
10, 4, 107, 102, 105, 255,
10, 4, 107, 105, 104, 255,
14, 5, 100, 104, 105, 101, 255,
14, 5, 103, 107, 104, 100, 255,
14, 5, 102, 103, 100, 101, 255,
10, 4, 105, 102, 101, 255,
10, 4, 102, 107, 103, 255,
6, // Case : 65
13, 6, 105, 107, 102, 5, 6, 11,
13, 6, 8, 3, 0, 104, 103, 101,
10, 4, 107, 102, 105, 103,
10, 4, 101, 102, 103, 105,
10, 4, 104, 105, 101, 103,
10, 4, 107, 104, 103, 105,
12, // Case : 66
0, 2, 0, 6,
14, 5, 100, 103, 107, 104, 255,
10, 4, 104, 107, 105, 255,
10, 4, 100, 104, 105, 255,
10, 4, 102, 103, 100, 255,
10, 4, 107, 103, 102, 255,
14, 5, 107, 102, 11, 6, 255,
14, 5, 105, 107, 6, 5, 255,
10, 4, 105, 5, 9, 255,
14, 5, 100, 105, 9, 0, 255,
14, 5, 100, 0, 1, 102, 255,
10, 4, 102, 1, 11, 255,
11, // Case : 67
0, 4, 8, 3, 6, 6,
14, 5, 107, 102, 11, 6, 255,
10, 4, 11, 102, 1, 255,
14, 5, 103, 3, 1, 102, 255,
10, 4, 107, 103, 102, 255,
10, 4, 105, 5, 9, 255,
10, 4, 104, 107, 105, 255,
14, 5, 105, 107, 6, 5, 255,
10, 4, 104, 103, 107, 255,
14, 5, 104, 8, 3, 103, 255,
14, 5, 104, 105, 9, 8, 255,
2, // Case : 68
12, 8, 6, 107, 103, 2, 5, 105, 101, 1,
13, 6, 101, 100, 103, 105, 104, 107,
11, // Case : 69
0, 4, 6, 5, 8, 8,
14, 5, 104, 101, 0, 8, 255,
10, 4, 0, 101, 1, 255,
14, 5, 105, 5, 1, 101, 255,
10, 4, 104, 105, 101, 255,
10, 4, 103, 3, 2, 255,
10, 4, 107, 104, 103, 255,
14, 5, 103, 104, 8, 3, 255,
10, 4, 107, 105, 104, 255,
14, 5, 107, 6, 5, 105, 255,
14, 5, 107, 103, 2, 6, 255,
9, // Case : 70
0, 5, 0, 2, 9, 5, 6,
14, 5, 100, 103, 107, 104, 255,
10, 4, 107, 255, 105, 104,
14, 5, 103, 2, 6, 107, 255,
14, 5, 0, 2, 103, 100, 255,
10, 4, 105, 100, 104, 255,
14, 5, 105, 9, 0, 100, 255,
10, 4, 105, 5, 9, 255,
14, 5, 6, 5, 105, 107, 255,
9, // Case : 71
0, 6, 9, 5, 6, 2, 3, 8,
10, 4, 107, 104, 103, 255,
14, 5, 107, 103, 2, 6, 255,
10, 4, 105, 104, 107, 255,
14, 5, 105, 107, 6, 5, 255,
10, 4, 9, 105, 5, 255,
14, 5, 105, 9, 8, 104, 255,
14, 5, 8, 3, 103, 104, 255,
10, 4, 103, 3, 2, 255,
12, // Case : 72
0, 2, 3, 5,
14, 5, 100, 104, 105, 101, 255,
10, 4, 101, 105, 102, 255,
10, 4, 100, 101, 102, 255,
10, 4, 107, 104, 100, 255,
10, 4, 105, 104, 107, 255,
14, 5, 105, 107, 6, 5, 255,
14, 5, 102, 105, 5, 11, 255,
10, 4, 102, 11, 2, 255,
14, 5, 100, 102, 2, 3, 255,
14, 5, 100, 3, 10, 107, 255,
10, 4, 107, 10, 6, 255,
11, // Case : 73
0, 4, 0, 8, 5, 5,
14, 5, 105, 107, 6, 5, 255,
10, 4, 6, 107, 10, 255,
14, 5, 104, 8, 10, 107, 255,
10, 4, 105, 104, 107, 255,
10, 4, 102, 11, 2, 255,
10, 4, 101, 105, 102, 255,
14, 5, 102, 105, 5, 11, 255,
10, 4, 101, 104, 105, 255,
14, 5, 101, 0, 8, 104, 255,
14, 5, 101, 102, 2, 0, 255,
6, // Case : 74
10, 4, 102, 1, 11, 2,
10, 4, 107, 104, 100, 105,
14, 5, 9, 0, 100, 105, 3,
14, 5, 5, 105, 107, 6, 10,
14, 5, 100, 3, 10, 107, 105,
14, 5, 3, 9, 5, 10, 105,
8, // Case : 75
0, 5, 8, 10, 9, 5, 6,
10, 4, 102, 2, 1, 11,
14, 5, 107, 104, 8, 10, 255,
14, 5, 104, 105, 9, 8, 255,
10, 4, 105, 5, 9, 255,
10, 4, 104, 107, 105, 255,
14, 5, 105, 107, 6, 5, 255,
10, 4, 107, 10, 6, 255,
9, // Case : 76
0, 5, 3, 1, 10, 6, 5,
14, 5, 100, 104, 105, 101, 255,
10, 4, 105, 107, 255, 104,
14, 5, 101, 105, 5, 1, 255,
14, 5, 3, 100, 101, 1, 255,
10, 4, 107, 104, 100, 255,
14, 5, 107, 100, 3, 10, 255,
10, 4, 107, 10, 6, 255,
14, 5, 5, 105, 107, 6, 255,
9, // Case : 77
0, 6, 10, 6, 5, 1, 0, 8,
10, 4, 105, 101, 104, 255,
14, 5, 105, 5, 1, 101, 255,
10, 4, 107, 105, 104, 255,
14, 5, 107, 6, 5, 105, 255,
10, 4, 10, 6, 107, 255,
14, 5, 107, 104, 8, 10, 255,
14, 5, 8, 104, 101, 0, 255,
10, 4, 101, 1, 0, 255,
5, // Case : 78
10, 4, 107, 104, 100, 105,
14, 5, 9, 0, 100, 105, 3,
14, 5, 5, 105, 107, 6, 10,
14, 5, 100, 3, 10, 107, 105,
14, 5, 3, 9, 5, 10, 105,
7, // Case : 79
0, 5, 10, 8, 9, 6, 5,
14, 5, 104, 105, 9, 8, 255,
10, 4, 105, 5, 9, 255,
14, 5, 107, 104, 8, 10, 255,
10, 4, 6, 107, 10, 255,
14, 5, 5, 105, 107, 6, 255,
10, 4, 105, 104, 107, 255,
12, // Case : 80
0, 2, 8, 11,
14, 5, 100, 101, 102, 103, 255,
10, 4, 101, 105, 102, 255,
10, 4, 100, 105, 101, 255,
10, 4, 107, 100, 103, 255,
10, 4, 102, 107, 103, 255,
14, 5, 102, 11, 6, 107, 255,
14, 5, 105, 5, 11, 102, 255,
10, 4, 105, 4, 5, 255,
14, 5, 100, 8, 4, 105, 255,
14, 5, 100, 107, 7, 8, 255,
10, 4, 107, 6, 7, 255,
11, // Case : 81
0, 4, 0, 3, 11, 11,
14, 5, 102, 11, 6, 107, 255,
10, 4, 6, 7, 107, 255,
14, 5, 103, 107, 7, 3, 255,
10, 4, 102, 107, 103, 255,
10, 4, 105, 4, 5, 255,
10, 4, 101, 105, 102, 255,
14, 5, 105, 5, 11, 102, 255,
10, 4, 101, 102, 103, 255,
14, 5, 101, 103, 3, 0, 255,
14, 5, 101, 0, 4, 105, 255,
6, // Case : 82
10, 4, 105, 5, 9, 4,
10, 4, 107, 100, 103, 102,
14, 5, 1, 102, 100, 0, 8,
14, 5, 11, 6, 107, 102, 7,
14, 5, 100, 107, 7, 8, 102,
14, 5, 8, 7, 11, 1, 102,
8, // Case : 83
0, 5, 3, 7, 1, 11, 6,
10, 4, 105, 9, 4, 5,
14, 5, 107, 7, 3, 103, 255,
14, 5, 103, 3, 1, 102, 255,
10, 4, 102, 1, 11, 255,
10, 4, 103, 102, 107, 255,
14, 5, 102, 11, 6, 107, 255,
10, 4, 107, 6, 7, 255,
11, // Case : 84
0, 4, 2, 1, 8, 8,
14, 5, 100, 8, 4, 105, 255,
10, 4, 4, 5, 105, 255,
14, 5, 101, 105, 5, 1, 255,
10, 4, 100, 105, 101, 255,
10, 4, 107, 6, 7, 255,
10, 4, 103, 107, 100, 255,
14, 5, 107, 7, 8, 100, 255,
10, 4, 103, 100, 101, 255,
14, 5, 103, 101, 1, 2, 255,
14, 5, 103, 2, 6, 107, 255,
2, // Case : 85
13, 6, 107, 7, 6, 103, 3, 2,
13, 6, 105, 5, 4, 101, 1, 0,
8, // Case : 86
0, 5, 2, 6, 0, 8, 7,
10, 4, 105, 5, 9, 4,
14, 5, 107, 103, 2, 6, 255,
14, 5, 103, 100, 0, 2, 255,
10, 4, 100, 8, 0, 255,
10, 4, 103, 107, 100, 255,
14, 5, 100, 107, 7, 8, 255,
10, 4, 107, 6, 7, 255,
2, // Case : 87
13, 6, 6, 107, 7, 2, 103, 3,
10, 4, 9, 4, 105, 5,
6, // Case : 88
10, 4, 107, 6, 7, 10,
10, 4, 102, 100, 101, 105,
14, 5, 4, 105, 100, 8, 3,
14, 5, 5, 11, 102, 105, 2,
14, 5, 100, 102, 2, 3, 105,
14, 5, 3, 2, 5, 4, 105,
8, // Case : 89
0, 5, 0, 2, 4, 5, 11,
10, 4, 107, 7, 10, 6,
14, 5, 102, 2, 0, 101, 255,
14, 5, 101, 0, 4, 105, 255,
10, 4, 105, 4, 5, 255,
10, 4, 101, 105, 102, 255,
14, 5, 105, 5, 11, 102, 255,
10, 4, 102, 11, 2, 255,
4, // Case : 90
10, 4, 7, 6, 10, 107,
10, 4, 8, 3, 0, 100,
10, 4, 4, 9, 5, 105,
10, 4, 1, 2, 11, 102,
3, // Case : 91
10, 4, 4, 9, 5, 105,
10, 4, 7, 10, 107, 6,
10, 4, 1, 102, 2, 11,
8, // Case : 92
0, 5, 1, 5, 3, 8, 4,
10, 4, 107, 10, 6, 7,
14, 5, 105, 5, 1, 101, 255,
14, 5, 101, 1, 3, 100, 255,
10, 4, 100, 3, 8, 255,
10, 4, 101, 100, 105, 255,
14, 5, 100, 8, 4, 105, 255,
10, 4, 105, 4, 5, 255,
2, // Case : 93
13, 6, 1, 101, 0, 5, 105, 4,
10, 4, 10, 107, 7, 6,
3, // Case : 94
10, 4, 10, 7, 6, 107,
10, 4, 3, 100, 0, 8,
10, 4, 5, 9, 105, 4,
2, // Case : 95
10, 4, 6, 10, 7, 107,
10, 4, 5, 4, 9, 105,
2, // Case : 96
12, 8, 11, 102, 101, 9, 6, 107, 104, 4,
13, 6, 102, 103, 107, 101, 100, 104,
11, // Case : 97
0, 4, 6, 11, 3, 3,
14, 5, 103, 3, 0, 101, 255,
10, 4, 0, 9, 101, 255,
14, 5, 102, 101, 9, 11, 255,
10, 4, 103, 101, 102, 255,
10, 4, 104, 4, 8, 255,
10, 4, 107, 104, 103, 255,
14, 5, 104, 8, 3, 103, 255,
10, 4, 107, 103, 102, 255,
14, 5, 107, 102, 11, 6, 255,
14, 5, 107, 6, 4, 104, 255,
9, // Case : 98
0, 5, 0, 4, 1, 11, 6,
14, 5, 100, 103, 107, 104, 255,
10, 4, 107, 102, 255, 103,
14, 5, 104, 107, 6, 4, 255,
14, 5, 0, 100, 104, 4, 255,
10, 4, 102, 103, 100, 255,
14, 5, 102, 100, 0, 1, 255,
10, 4, 102, 1, 11, 255,
14, 5, 6, 107, 102, 11, 255,
9, // Case : 99
0, 6, 1, 11, 6, 4, 8, 3,
10, 4, 107, 104, 103, 255,
14, 5, 107, 6, 4, 104, 255,
10, 4, 102, 107, 103, 255,
14, 5, 102, 11, 6, 107, 255,
10, 4, 1, 11, 102, 255,
14, 5, 102, 103, 3, 1, 255,
14, 5, 3, 103, 104, 8, 255,
10, 4, 104, 4, 8, 255,
9, // Case : 100
0, 5, 2, 6, 1, 9, 4,
14, 5, 103, 107, 104, 100, 255,
10, 4, 104, 255, 101, 100,
14, 5, 107, 6, 4, 104, 255,
14, 5, 2, 6, 107, 103, 255,
10, 4, 101, 103, 100, 255,
14, 5, 101, 1, 2, 103, 255,
10, 4, 101, 9, 1, 255,
14, 5, 4, 9, 101, 104, 255,
8, // Case : 101
0, 5, 6, 4, 2, 3, 8,
10, 4, 101, 9, 1, 0,
14, 5, 104, 107, 6, 4, 255,
14, 5, 107, 103, 2, 6, 255,
10, 4, 103, 3, 2, 255,
10, 4, 107, 104, 103, 255,
14, 5, 103, 104, 8, 3, 255,
10, 4, 104, 4, 8, 255,
1, // Case : 102
12, 8, 0, 4, 6, 2, 100, 104, 107, 103,
7, // Case : 103
0, 5, 4, 6, 2, 8, 3,
14, 5, 107, 103, 2, 6, 255,
10, 4, 103, 3, 2, 255,
14, 5, 104, 107, 6, 4, 255,
10, 4, 8, 104, 4, 255,
14, 5, 3, 103, 104, 8, 255,
10, 4, 103, 107, 104, 255,
11, // Case : 104
0, 4, 4, 9, 3, 3,
14, 5, 100, 102, 2, 3, 255,
10, 4, 2, 102, 11, 255,
14, 5, 101, 9, 11, 102, 255,
10, 4, 100, 101, 102, 255,
10, 4, 107, 10, 6, 255,
10, 4, 104, 100, 107, 255,
14, 5, 107, 100, 3, 10, 255,
10, 4, 104, 101, 100, 255,
14, 5, 104, 4, 9, 101, 255,
14, 5, 104, 107, 6, 4, 255,
2, // Case : 105
13, 6, 104, 8, 4, 107, 10, 6,
13, 6, 101, 9, 0, 102, 11, 2,
8, // Case : 106
0, 5, 4, 6, 0, 3, 10,
10, 4, 102, 1, 11, 2,
14, 5, 107, 6, 4, 104, 255,
14, 5, 104, 4, 0, 100, 255,
10, 4, 100, 0, 3, 255,
10, 4, 104, 100, 107, 255,
14, 5, 100, 3, 10, 107, 255,
10, 4, 107, 10, 6, 255,
2, // Case : 107
13, 6, 4, 104, 8, 6, 107, 10,
10, 4, 1, 102, 2, 11,
9, // Case : 108
0, 6, 1, 9, 4, 6, 10, 3,
10, 4, 104, 100, 107, 255,
14, 5, 104, 107, 6, 4, 255,
10, 4, 101, 100, 104, 255,
14, 5, 101, 104, 4, 9, 255,
10, 4, 1, 101, 9, 255,
14, 5, 101, 1, 3, 100, 255,
14, 5, 3, 10, 107, 100, 255,
10, 4, 107, 10, 6, 255,
2, // Case : 109
13, 6, 4, 104, 8, 6, 107, 10,
10, 4, 1, 0, 101, 9,
7, // Case : 110
0, 5, 6, 4, 0, 10, 3,
14, 5, 104, 4, 0, 100, 255,
10, 4, 100, 0, 3, 255,
14, 5, 107, 6, 4, 104, 255,
10, 4, 10, 6, 107, 255,
14, 5, 3, 10, 107, 100, 255,
10, 4, 100, 107, 104, 255,
1, // Case : 111
13, 6, 104, 8, 4, 107, 10, 6,
9, // Case : 112
0, 5, 8, 9, 7, 6, 11,
14, 5, 100, 101, 102, 103, 255,
10, 4, 102, 255, 107, 103,
14, 5, 101, 9, 11, 102, 255,
14, 5, 8, 9, 101, 100, 255,
10, 4, 107, 100, 103, 255,
14, 5, 107, 7, 8, 100, 255,
10, 4, 107, 6, 7, 255,
14, 5, 11, 6, 107, 102, 255,
9, // Case : 113
0, 6, 7, 6, 11, 9, 0, 3,
10, 4, 102, 103, 101, 255,
14, 5, 102, 101, 9, 11, 255,
10, 4, 107, 103, 102, 255,
14, 5, 107, 102, 11, 6, 255,
10, 4, 7, 107, 6, 255,
14, 5, 107, 7, 3, 103, 255,
14, 5, 3, 0, 101, 103, 255,
10, 4, 101, 0, 9, 255,
5, // Case : 114
10, 4, 107, 100, 103, 102,
14, 5, 1, 102, 100, 0, 8,
14, 5, 11, 6, 107, 102, 7,
14, 5, 100, 107, 7, 8, 102,
14, 5, 8, 7, 11, 1, 102,
7, // Case : 115
0, 5, 7, 3, 1, 6, 11,
14, 5, 103, 3, 1, 102, 255,
10, 4, 102, 1, 11, 255,
14, 5, 107, 7, 3, 103, 255,
10, 4, 6, 7, 107, 255,
14, 5, 11, 6, 107, 102, 255,
10, 4, 102, 107, 103, 255,
9, // Case : 116
0, 6, 9, 1, 2, 6, 7, 8,
10, 4, 103, 107, 100, 255,
14, 5, 103, 2, 6, 107, 255,
10, 4, 101, 103, 100, 255,
14, 5, 101, 1, 2, 103, 255,
10, 4, 9, 1, 101, 255,
14, 5, 101, 100, 8, 9, 255,
14, 5, 8, 100, 107, 7, 255,
10, 4, 107, 6, 7, 255,
2, // Case : 117
13, 6, 6, 107, 7, 2, 103, 3,
10, 4, 9, 101, 0, 1,
7, // Case : 118
0, 5, 6, 2, 0, 7, 8,
14, 5, 103, 100, 0, 2, 255,
10, 4, 100, 8, 0, 255,
14, 5, 107, 103, 2, 6, 255,
10, 4, 7, 107, 6, 255,
14, 5, 8, 100, 107, 7, 255,
10, 4, 100, 103, 107, 255,
1, // Case : 119
13, 6, 107, 7, 6, 103, 3, 2,
8, // Case : 120
0, 5, 9, 11, 8, 3, 2,
10, 4, 107, 6, 7, 10,
14, 5, 102, 101, 9, 11, 255,
14, 5, 101, 100, 8, 9, 255,
10, 4, 100, 3, 8, 255,
10, 4, 101, 102, 100, 255,
14, 5, 100, 102, 2, 3, 255,
10, 4, 102, 11, 2, 255,
2, // Case : 121
13, 6, 11, 102, 2, 9, 101, 0,
10, 4, 7, 10, 107, 6,
3, // Case : 122
10, 4, 7, 6, 10, 107,
10, 4, 8, 0, 100, 3,
10, 4, 11, 102, 1, 2,
2, // Case : 123
10, 4, 6, 10, 7, 107,
10, 4, 11, 1, 2, 102,
2, // Case : 124
13, 6, 3, 100, 8, 1, 101, 9,
10, 4, 6, 7, 107, 10,
2, // Case : 125
10, 4, 6, 10, 7, 107,
10, 4, 9, 0, 1, 101,
2, // Case : 126
10, 4, 8, 3, 0, 100,
10, 4, 7, 6, 10, 107,
1, // Case : 127
10, 4, 7, 6, 10, 107,
9, // Case : 128
0, 7, 106, 105, 104, 103, 102, 101, 100,
13, 6, 106, 104, 103, 6, 7, 10,
10, 4, 106, 104, 103, 255,
10, 4, 106, 105, 104, 255,
14, 5, 101, 100, 104, 105, 255,
14, 5, 102, 101, 105, 106, 255,
14, 5, 103, 100, 101, 102, 255,
10, 4, 104, 100, 103, 255,
10, 4, 103, 102, 106, 255,
12, // Case : 129
0, 2, 0, 6,
14, 5, 101, 105, 106, 102, 255,
10, 4, 105, 104, 106, 255,
10, 4, 101, 104, 105, 255,
10, 4, 103, 101, 102, 255,
10, 4, 106, 103, 102, 255,
14, 5, 106, 6, 10, 103, 255,
14, 5, 104, 7, 6, 106, 255,
10, 4, 104, 8, 7, 255,
14, 5, 101, 0, 8, 104, 255,
14, 5, 101, 103, 3, 0, 255,
10, 4, 103, 10, 3, 255,
6, // Case : 130
13, 6, 104, 103, 106, 7, 10, 6,
13, 6, 0, 1, 9, 100, 102, 105,
10, 4, 103, 106, 104, 102,
10, 4, 105, 106, 102, 104,
10, 4, 100, 104, 105, 102,
10, 4, 103, 100, 102, 104,
11, // Case : 131
0, 4, 9, 1, 6, 6,
14, 5, 106, 6, 10, 103, 255,
10, 4, 10, 3, 103, 255,
14, 5, 102, 103, 3, 1, 255,
10, 4, 106, 103, 102, 255,
10, 4, 104, 8, 7, 255,
10, 4, 105, 104, 106, 255,
14, 5, 104, 7, 6, 106, 255,
10, 4, 105, 106, 102, 255,
14, 5, 105, 102, 1, 9, 255,
14, 5, 105, 9, 8, 104, 255,
12, // Case : 132
0, 2, 7, 1,
14, 5, 104, 105, 101, 100, 255,
10, 4, 105, 106, 101, 255,
10, 4, 104, 106, 105, 255,
10, 4, 103, 104, 100, 255,
10, 4, 101, 103, 100, 255,
14, 5, 101, 1, 2, 103, 255,
14, 5, 106, 11, 1, 101, 255,
10, 4, 106, 6, 11, 255,
14, 5, 104, 7, 6, 106, 255,
14, 5, 104, 103, 10, 7, 255,
10, 4, 103, 2, 10, 255,
6, // Case : 133
10, 4, 103, 3, 2, 10,
10, 4, 106, 105, 104, 101,
14, 5, 0, 8, 104, 101, 7,
14, 5, 1, 101, 106, 11, 6,
14, 5, 104, 7, 6, 106, 101,
14, 5, 7, 0, 1, 6, 101,
11, // Case : 134
0, 4, 9, 0, 7, 7,
14, 5, 104, 103, 10, 7, 255,
10, 4, 10, 103, 2, 255,
14, 5, 100, 0, 2, 103, 255,
10, 4, 104, 100, 103, 255,
10, 4, 106, 6, 11, 255,
10, 4, 105, 104, 106, 255,
14, 5, 106, 104, 7, 6, 255,
10, 4, 105, 100, 104, 255,
14, 5, 105, 9, 0, 100, 255,
14, 5, 105, 106, 11, 9, 255,
8, // Case : 135
0, 5, 9, 11, 8, 7, 6,
10, 4, 103, 3, 2, 10,
14, 5, 106, 11, 9, 105, 255,
14, 5, 105, 9, 8, 104, 255,
10, 4, 104, 8, 7, 255,
10, 4, 105, 104, 106, 255,
14, 5, 104, 7, 6, 106, 255,
10, 4, 106, 6, 11, 255,
2, // Case : 136
12, 8, 7, 104, 100, 3, 6, 106, 102, 2,
13, 6, 104, 105, 106, 100, 101, 102,
9, // Case : 137
0, 5, 0, 2, 8, 7, 6,
14, 5, 101, 105, 106, 102, 255,
10, 4, 106, 104, 255, 105,
14, 5, 102, 106, 6, 2, 255,
14, 5, 0, 101, 102, 2, 255,
10, 4, 104, 105, 101, 255,
14, 5, 104, 101, 0, 8, 255,
10, 4, 104, 8, 7, 255,
14, 5, 6, 106, 104, 7, 255,
11, // Case : 138
0, 4, 6, 7, 9, 9,
14, 5, 105, 9, 0, 100, 255,
10, 4, 0, 3, 100, 255,
14, 5, 104, 100, 3, 7, 255,
10, 4, 105, 100, 104, 255,
10, 4, 102, 2, 1, 255,
10, 4, 106, 102, 105, 255,
14, 5, 102, 1, 9, 105, 255,
10, 4, 106, 105, 104, 255,
14, 5, 106, 104, 7, 6, 255,
14, 5, 106, 6, 2, 102, 255,
9, // Case : 139
0, 6, 8, 7, 6, 2, 1, 9,
10, 4, 106, 102, 105, 255,
14, 5, 106, 6, 2, 102, 255,
10, 4, 104, 106, 105, 255,
14, 5, 104, 7, 6, 106, 255,
10, 4, 8, 7, 104, 255,
14, 5, 104, 105, 9, 8, 255,
14, 5, 9, 105, 102, 1, 255,
10, 4, 102, 2, 1, 255,
9, // Case : 140
0, 5, 1, 3, 11, 6, 7,
14, 5, 101, 100, 104, 105, 255,
10, 4, 104, 255, 106, 105,
14, 5, 100, 3, 7, 104, 255,
14, 5, 1, 3, 100, 101, 255,
10, 4, 106, 101, 105, 255,
14, 5, 106, 11, 1, 101, 255,
10, 4, 106, 6, 11, 255,
14, 5, 7, 6, 106, 104, 255,
5, // Case : 141
10, 4, 106, 105, 104, 101,
14, 5, 0, 8, 104, 101, 7,
14, 5, 1, 101, 106, 11, 6,
14, 5, 104, 7, 6, 106, 101,
14, 5, 7, 0, 1, 6, 101,
9, // Case : 142
0, 6, 3, 0, 9, 11, 6, 7,
10, 4, 105, 104, 106, 255,
14, 5, 105, 106, 11, 9, 255,
10, 4, 100, 104, 105, 255,
14, 5, 100, 105, 9, 0, 255,
10, 4, 3, 100, 0, 255,
14, 5, 100, 3, 7, 104, 255,
14, 5, 7, 6, 106, 104, 255,
10, 4, 106, 6, 11, 255,
7, // Case : 143
0, 5, 11, 9, 8, 6, 7,
14, 5, 105, 9, 8, 104, 255,
10, 4, 104, 8, 7, 255,
14, 5, 106, 11, 9, 105, 255,
10, 4, 6, 11, 106, 255,
14, 5, 7, 6, 106, 104, 255,
10, 4, 104, 106, 105, 255,
2, // Case : 144
12, 8, 6, 106, 105, 4, 10, 103, 100, 8,
13, 6, 100, 101, 105, 103, 102, 106,
9, // Case : 145
0, 5, 0, 4, 3, 10, 6,
14, 5, 101, 105, 106, 102, 255,
10, 4, 106, 255, 103, 102,
14, 5, 105, 4, 6, 106, 255,
14, 5, 0, 4, 105, 101, 255,
10, 4, 103, 101, 102, 255,
14, 5, 103, 3, 0, 101, 255,
10, 4, 103, 10, 3, 255,
14, 5, 6, 10, 103, 106, 255,
11, // Case : 146
0, 4, 6, 10, 1, 1,
14, 5, 102, 100, 0, 1, 255,
10, 4, 0, 100, 8, 255,
14, 5, 103, 10, 8, 100, 255,
10, 4, 102, 103, 100, 255,
10, 4, 105, 9, 4, 255,
10, 4, 106, 102, 105, 255,
14, 5, 105, 102, 1, 9, 255,
10, 4, 106, 103, 102, 255,
14, 5, 106, 6, 10, 103, 255,
14, 5, 106, 105, 4, 6, 255,
9, // Case : 147
0, 6, 3, 10, 6, 4, 9, 1,
10, 4, 106, 102, 105, 255,
14, 5, 106, 105, 4, 6, 255,
10, 4, 103, 102, 106, 255,
14, 5, 103, 106, 6, 10, 255,
10, 4, 3, 103, 10, 255,
14, 5, 103, 3, 1, 102, 255,
14, 5, 1, 9, 105, 102, 255,
10, 4, 105, 9, 4, 255,
11, // Case : 148
0, 4, 4, 8, 1, 1,
14, 5, 101, 1, 2, 103, 255,
10, 4, 2, 10, 103, 255,
14, 5, 100, 103, 10, 8, 255,
10, 4, 101, 103, 100, 255,
10, 4, 106, 6, 11, 255,
10, 4, 105, 106, 101, 255,
14, 5, 106, 11, 1, 101, 255,
10, 4, 105, 101, 100, 255,
14, 5, 105, 100, 8, 4, 255,
14, 5, 105, 4, 6, 106, 255,
8, // Case : 149
0, 5, 4, 6, 0, 1, 11,
10, 4, 103, 10, 3, 2,
14, 5, 106, 105, 4, 6, 255,
14, 5, 105, 101, 0, 4, 255,
10, 4, 101, 1, 0, 255,
10, 4, 105, 106, 101, 255,
14, 5, 101, 106, 11, 1, 255,
10, 4, 106, 6, 11, 255,
2, // Case : 150
13, 6, 103, 10, 2, 100, 8, 0,
13, 6, 106, 11, 6, 105, 9, 4,
2, // Case : 151
13, 6, 9, 105, 4, 11, 106, 6,
10, 4, 3, 103, 10, 2,
9, // Case : 152
0, 5, 2, 6, 3, 8, 4,
14, 5, 102, 101, 105, 106, 255,
10, 4, 105, 100, 255, 101,
14, 5, 106, 105, 4, 6, 255,
14, 5, 2, 102, 106, 6, 255,
10, 4, 100, 101, 102, 255,
14, 5, 100, 102, 2, 3, 255,
10, 4, 100, 3, 8, 255,
14, 5, 4, 105, 100, 8, 255,
1, // Case : 153
12, 8, 101, 105, 106, 102, 0, 4, 6, 2,
8, // Case : 154
0, 5, 6, 4, 2, 1, 9,
10, 4, 100, 3, 8, 0,
14, 5, 105, 4, 6, 106, 255,
14, 5, 106, 6, 2, 102, 255,
10, 4, 102, 2, 1, 255,
10, 4, 106, 102, 105, 255,
14, 5, 102, 1, 9, 105, 255,
10, 4, 105, 9, 4, 255,
7, // Case : 155
0, 5, 4, 6, 2, 9, 1,
14, 5, 106, 6, 2, 102, 255,
10, 4, 102, 2, 1, 255,
14, 5, 105, 4, 6, 106, 255,
10, 4, 9, 4, 105, 255,
14, 5, 1, 9, 105, 102, 255,
10, 4, 102, 105, 106, 255,
9, // Case : 156
0, 6, 3, 8, 4, 6, 11, 1,
10, 4, 105, 106, 101, 255,
14, 5, 105, 4, 6, 106, 255,
10, 4, 100, 105, 101, 255,
14, 5, 100, 8, 4, 105, 255,
10, 4, 3, 8, 100, 255,
14, 5, 100, 101, 1, 3, 255,
14, 5, 1, 101, 106, 11, 255,
10, 4, 106, 6, 11, 255,
7, // Case : 157
0, 5, 6, 4, 0, 11, 1,
14, 5, 105, 101, 0, 4, 255,
10, 4, 101, 1, 0, 255,
14, 5, 106, 105, 4, 6, 255,
10, 4, 11, 106, 6, 255,
14, 5, 1, 101, 106, 11, 255,
10, 4, 101, 105, 106, 255,
2, // Case : 158
13, 6, 9, 105, 4, 11, 106, 6,
10, 4, 3, 8, 100, 0,
1, // Case : 159
13, 6, 105, 4, 9, 106, 6, 11,
12, // Case : 160
0, 2, 10, 9,
14, 5, 103, 100, 101, 102, 255,
10, 4, 102, 101, 106, 255,
10, 4, 103, 102, 106, 255,
10, 4, 104, 100, 103, 255,
10, 4, 101, 100, 104, 255,
14, 5, 101, 104, 4, 9, 255,
14, 5, 106, 101, 9, 5, 255,
10, 4, 106, 5, 6, 255,
14, 5, 103, 106, 6, 10, 255,
14, 5, 103, 10, 7, 104, 255,
10, 4, 104, 7, 4, 255,
6, // Case : 161
10, 4, 104, 4, 8, 7,
10, 4, 106, 103, 102, 101,
14, 5, 0, 101, 103, 3, 10,
14, 5, 9, 5, 106, 101, 6,
14, 5, 103, 106, 6, 10, 101,
14, 5, 10, 6, 9, 0, 101,
11, // Case : 162
0, 4, 1, 0, 10, 10,
14, 5, 103, 10, 7, 104, 255,
10, 4, 7, 4, 104, 255,
14, 5, 100, 104, 4, 0, 255,
10, 4, 103, 104, 100, 255,
10, 4, 106, 5, 6, 255,
10, 4, 102, 106, 103, 255,
14, 5, 106, 6, 10, 103, 255,
10, 4, 102, 103, 100, 255,
14, 5, 102, 100, 0, 1, 255,
14, 5, 102, 1, 5, 106, 255,
8, // Case : 163
0, 5, 1, 5, 3, 10, 6,
10, 4, 104, 4, 8, 7,
14, 5, 106, 102, 1, 5, 255,
14, 5, 102, 103, 3, 1, 255,
10, 4, 103, 10, 3, 255,
10, 4, 102, 106, 103, 255,
14, 5, 103, 106, 6, 10, 255,
10, 4, 106, 5, 6, 255,
6, // Case : 164
10, 4, 106, 5, 6, 11,
10, 4, 103, 100, 101, 104,
14, 5, 4, 9, 101, 104, 1,
14, 5, 7, 104, 103, 10, 2,
14, 5, 101, 1, 2, 103, 104,
14, 5, 1, 4, 7, 2, 104,
4, // Case : 165
10, 4, 7, 8, 4, 104,
10, 4, 10, 2, 3, 103,
10, 4, 6, 5, 11, 106,
10, 4, 1, 9, 0, 101,
8, // Case : 166
0, 5, 0, 2, 4, 7, 10,
10, 4, 106, 11, 5, 6,
14, 5, 103, 100, 0, 2, 255,
14, 5, 100, 104, 4, 0, 255,
10, 4, 104, 7, 4, 255,
10, 4, 100, 103, 104, 255,
14, 5, 104, 103, 10, 7, 255,
10, 4, 103, 2, 10, 255,
3, // Case : 167
10, 4, 11, 6, 5, 106,
10, 4, 2, 103, 3, 10,
10, 4, 4, 8, 104, 7,
11, // Case : 168
0, 4, 2, 3, 9, 9,
14, 5, 101, 104, 4, 9, 255,
10, 4, 4, 104, 7, 255,
14, 5, 100, 3, 7, 104, 255,
10, 4, 101, 100, 104, 255,
10, 4, 106, 5, 6, 255,
10, 4, 102, 101, 106, 255,
14, 5, 106, 101, 9, 5, 255,
10, 4, 102, 100, 101, 255,
14, 5, 102, 2, 3, 100, 255,
14, 5, 102, 106, 6, 2, 255,
8, // Case : 169
0, 5, 2, 6, 0, 9, 5,
10, 4, 104, 8, 7, 4,
14, 5, 106, 6, 2, 102, 255,
14, 5, 102, 2, 0, 101, 255,
10, 4, 101, 0, 9, 255,
10, 4, 102, 101, 106, 255,
14, 5, 101, 9, 5, 106, 255,
10, 4, 106, 5, 6, 255,
2, // Case : 170
13, 6, 100, 3, 0, 104, 7, 4,
13, 6, 102, 1, 2, 106, 5, 6,
2, // Case : 171
13, 6, 5, 106, 6, 1, 102, 2,
10, 4, 8, 7, 104, 4,
8, // Case : 172
0, 5, 3, 7, 1, 9, 4,
10, 4, 106, 6, 11, 5,
14, 5, 104, 100, 3, 7, 255,
14, 5, 100, 101, 1, 3, 255,
10, 4, 101, 9, 1, 255,
10, 4, 100, 104, 101, 255,
14, 5, 101, 104, 4, 9, 255,
10, 4, 104, 7, 4, 255,
3, // Case : 173
10, 4, 6, 5, 11, 106,
10, 4, 7, 104, 8, 4,
10, 4, 1, 0, 101, 9,
2, // Case : 174
13, 6, 7, 104, 4, 3, 100, 0,
10, 4, 11, 5, 106, 6,
2, // Case : 175
10, 4, 4, 7, 8, 104,
10, 4, 5, 11, 6, 106,
9, // Case : 176
0, 5, 9, 8, 5, 6, 10,
14, 5, 101, 102, 103, 100, 255,
10, 4, 103, 106, 255, 102,
14, 5, 100, 103, 10, 8, 255,
14, 5, 9, 101, 100, 8, 255,
10, 4, 106, 102, 101, 255,
14, 5, 106, 101, 9, 5, 255,
10, 4, 106, 5, 6, 255,
14, 5, 10, 103, 106, 6, 255,
5, // Case : 177
10, 4, 106, 103, 102, 101,
14, 5, 0, 101, 103, 3, 10,
14, 5, 9, 5, 106, 101, 6,
14, 5, 103, 106, 6, 10, 101,
14, 5, 10, 6, 9, 0, 101,
9, // Case : 178
0, 6, 8, 0, 1, 5, 6, 10,
10, 4, 102, 106, 103, 255,
14, 5, 102, 1, 5, 106, 255,
10, 4, 100, 102, 103, 255,
14, 5, 100, 0, 1, 102, 255,
10, 4, 8, 0, 100, 255,
14, 5, 100, 103, 10, 8, 255,
14, 5, 10, 103, 106, 6, 255,
10, 4, 106, 5, 6, 255,
7, // Case : 179
0, 5, 5, 1, 3, 6, 10,
14, 5, 102, 103, 3, 1, 255,
10, 4, 103, 10, 3, 255,
14, 5, 106, 102, 1, 5, 255,
10, 4, 6, 106, 5, 255,
14, 5, 10, 103, 106, 6, 255,
10, 4, 103, 102, 106, 255,
8, // Case : 180
0, 5, 8, 10, 9, 1, 2,
10, 4, 106, 5, 6, 11,
14, 5, 103, 10, 8, 100, 255,
14, 5, 100, 8, 9, 101, 255,
10, 4, 101, 9, 1, 255,
10, 4, 100, 101, 103, 255,
14, 5, 101, 1, 2, 103, 255,
10, 4, 103, 2, 10, 255,
3, // Case : 181
10, 4, 6, 5, 11, 106,
10, 4, 10, 3, 103, 2,
10, 4, 9, 101, 0, 1,
2, // Case : 182
13, 6, 8, 100, 0, 10, 103, 2,
10, 4, 5, 106, 11, 6,
2, // Case : 183
10, 4, 2, 3, 10, 103,
10, 4, 11, 6, 5, 106,
9, // Case : 184
0, 6, 8, 3, 2, 6, 5, 9,
10, 4, 102, 101, 106, 255,
14, 5, 102, 106, 6, 2, 255,
10, 4, 100, 101, 102, 255,
14, 5, 100, 102, 2, 3, 255,
10, 4, 8, 100, 3, 255,
14, 5, 100, 8, 9, 101, 255,
14, 5, 9, 5, 106, 101, 255,
10, 4, 106, 5, 6, 255,
7, // Case : 185
0, 5, 6, 2, 0, 5, 9,
14, 5, 102, 2, 0, 101, 255,
10, 4, 101, 0, 9, 255,
14, 5, 106, 6, 2, 102, 255,
10, 4, 5, 6, 106, 255,
14, 5, 9, 5, 106, 101, 255,
10, 4, 101, 106, 102, 255,
2, // Case : 186
13, 6, 5, 106, 6, 1, 102, 2,
10, 4, 8, 100, 3, 0,
1, // Case : 187
13, 6, 106, 6, 5, 102, 2, 1,
2, // Case : 188
13, 6, 3, 100, 8, 1, 101, 9,
10, 4, 6, 106, 5, 11,
2, // Case : 189
10, 4, 9, 0, 1, 101,
10, 4, 5, 11, 6, 106,
2, // Case : 190
10, 4, 0, 8, 3, 100,
10, 4, 11, 6, 5, 106,
1, // Case : 191
10, 4, 5, 11, 6, 106,
2, // Case : 192
12, 8, 5, 105, 104, 7, 11, 102, 103, 10,
13, 6, 105, 101, 102, 104, 100, 103,
11, // Case : 193
0, 4, 11, 5, 0, 0,
14, 5, 101, 0, 8, 104, 255,
10, 4, 8, 7, 104, 255,
14, 5, 105, 104, 7, 5, 255,
10, 4, 101, 104, 105, 255,
10, 4, 103, 10, 3, 255,
10, 4, 102, 103, 101, 255,
14, 5, 103, 3, 0, 101, 255,
10, 4, 102, 101, 105, 255,
14, 5, 102, 105, 5, 11, 255,
14, 5, 102, 11, 10, 103, 255,
11, // Case : 194
0, 4, 10, 7, 0, 0,
14, 5, 100, 105, 9, 0, 255,
10, 4, 9, 105, 5, 255,
14, 5, 104, 7, 5, 105, 255,
10, 4, 100, 104, 105, 255,
10, 4, 102, 1, 11, 255,
10, 4, 103, 100, 102, 255,
14, 5, 102, 100, 0, 1, 255,
10, 4, 103, 104, 100, 255,
14, 5, 103, 10, 7, 104, 255,
14, 5, 103, 102, 11, 10, 255,
2, // Case : 195
13, 6, 103, 3, 10, 102, 1, 11,
13, 6, 104, 7, 8, 105, 5, 9,
9, // Case : 196
0, 5, 7, 5, 10, 2, 1,
14, 5, 104, 105, 101, 100, 255,
10, 4, 101, 255, 103, 100,
14, 5, 105, 5, 1, 101, 255,
14, 5, 7, 5, 105, 104, 255,
10, 4, 103, 104, 100, 255,
14, 5, 103, 10, 7, 104, 255,
10, 4, 103, 2, 10, 255,
14, 5, 1, 2, 103, 101, 255,
8, // Case : 197
0, 5, 5, 1, 7, 8, 0,
10, 4, 103, 2, 10, 3,
14, 5, 101, 105, 5, 1, 255,
14, 5, 105, 104, 7, 5, 255,
10, 4, 104, 8, 7, 255,
10, 4, 105, 101, 104, 255,
14, 5, 104, 101, 0, 8, 255,
10, 4, 101, 1, 0, 255,
9, // Case : 198
0, 6, 2, 10, 7, 5, 9, 0,
10, 4, 104, 105, 100, 255,
14, 5, 104, 7, 5, 105, 255,
10, 4, 103, 104, 100, 255,
14, 5, 103, 10, 7, 104, 255,
10, 4, 2, 10, 103, 255,
14, 5, 103, 100, 0, 2, 255,
14, 5, 0, 100, 105, 9, 255,
10, 4, 105, 5, 9, 255,
2, // Case : 199
13, 6, 5, 105, 9, 7, 104, 8,
10, 4, 2, 103, 3, 10,
9, // Case : 200
0, 5, 3, 7, 2, 11, 5,
14, 5, 100, 104, 105, 101, 255,
10, 4, 105, 255, 102, 101,
14, 5, 104, 7, 5, 105, 255,
14, 5, 3, 7, 104, 100, 255,
10, 4, 102, 100, 101, 255,
14, 5, 102, 2, 3, 100, 255,
10, 4, 102, 11, 2, 255,
14, 5, 5, 11, 102, 105, 255,
9, // Case : 201
0, 6, 2, 11, 5, 7, 8, 0,
10, 4, 105, 101, 104, 255,
14, 5, 105, 104, 7, 5, 255,
10, 4, 102, 101, 105, 255,
14, 5, 102, 105, 5, 11, 255,
10, 4, 2, 102, 11, 255,
14, 5, 102, 2, 0, 101, 255,
14, 5, 0, 8, 104, 101, 255,
10, 4, 104, 8, 7, 255,
8, // Case : 202
0, 5, 7, 5, 3, 0, 9,
10, 4, 102, 11, 2, 1,
14, 5, 105, 104, 7, 5, 255,
14, 5, 104, 100, 3, 7, 255,
10, 4, 100, 0, 3, 255,
10, 4, 104, 105, 100, 255,
14, 5, 100, 105, 9, 0, 255,
10, 4, 105, 5, 9, 255,
2, // Case : 203
13, 6, 5, 105, 9, 7, 104, 8,
10, 4, 2, 1, 102, 11,
1, // Case : 204
12, 8, 3, 1, 5, 7, 100, 101, 105, 104,
7, // Case : 205
0, 5, 1, 5, 7, 0, 8,
14, 5, 105, 104, 7, 5, 255,
10, 4, 104, 8, 7, 255,
14, 5, 101, 105, 5, 1, 255,
10, 4, 0, 101, 1, 255,
14, 5, 8, 104, 101, 0, 255,
10, 4, 104, 105, 101, 255,
7, // Case : 206
0, 5, 5, 7, 3, 9, 0,
14, 5, 104, 100, 3, 7, 255,
10, 4, 100, 0, 3, 255,
14, 5, 105, 104, 7, 5, 255,
10, 4, 9, 105, 5, 255,
14, 5, 0, 100, 105, 9, 255,
10, 4, 100, 104, 105, 255,
1, // Case : 207
13, 6, 105, 9, 5, 104, 8, 7,
9, // Case : 208
0, 5, 8, 10, 4, 5, 11,
14, 5, 100, 101, 102, 103, 255,
10, 4, 102, 105, 255, 101,
14, 5, 103, 102, 11, 10, 255,
14, 5, 8, 100, 103, 10, 255,
10, 4, 105, 101, 100, 255,
14, 5, 105, 100, 8, 4, 255,
10, 4, 105, 4, 5, 255,
14, 5, 11, 102, 105, 5, 255,
9, // Case : 209
0, 6, 4, 5, 11, 10, 3, 0,
10, 4, 102, 103, 101, 255,
14, 5, 102, 11, 10, 103, 255,
10, 4, 105, 102, 101, 255,
14, 5, 105, 5, 11, 102, 255,
10, 4, 4, 5, 105, 255,
14, 5, 105, 101, 0, 4, 255,
14, 5, 0, 101, 103, 3, 255,
10, 4, 103, 10, 3, 255,
8, // Case : 210
0, 5, 10, 11, 8, 0, 1,
10, 4, 105, 4, 5, 9,
14, 5, 102, 11, 10, 103, 255,
14, 5, 103, 10, 8, 100, 255,
10, 4, 100, 8, 0, 255,
10, 4, 103, 100, 102, 255,
14, 5, 100, 0, 1, 102, 255,
10, 4, 102, 1, 11, 255,
2, // Case : 211
13, 6, 10, 103, 3, 11, 102, 1,
10, 4, 4, 105, 9, 5,
9, // Case : 212
0, 6, 10, 2, 1, 5, 4, 8,
10, 4, 101, 100, 105, 255,
14, 5, 101, 105, 5, 1, 255,
10, 4, 103, 100, 101, 255,
14, 5, 103, 101, 1, 2, 255,
10, 4, 10, 103, 2, 255,
14, 5, 103, 10, 8, 100, 255,
14, 5, 8, 4, 105, 100, 255,
10, 4, 105, 4, 5, 255,
2, // Case : 213
13, 6, 1, 101, 0, 5, 105, 4,
10, 4, 10, 3, 103, 2,
2, // Case : 214
13, 6, 8, 100, 0, 10, 103, 2,
10, 4, 5, 9, 105, 4,
2, // Case : 215
10, 4, 5, 4, 9, 105,
10, 4, 2, 3, 10, 103,
5, // Case : 216
10, 4, 102, 100, 101, 105,
14, 5, 4, 105, 100, 8, 3,
14, 5, 5, 11, 102, 105, 2,
14, 5, 100, 102, 2, 3, 105,
14, 5, 3, 2, 5, 4, 105,
7, // Case : 217
0, 5, 2, 0, 4, 11, 5,
14, 5, 101, 0, 4, 105, 255,
10, 4, 105, 4, 5, 255,
14, 5, 102, 2, 0, 101, 255,
10, 4, 11, 2, 102, 255,
14, 5, 5, 11, 102, 105, 255,
10, 4, 105, 102, 101, 255,
3, // Case : 218
10, 4, 2, 11, 1, 102,
10, 4, 3, 8, 100, 0,
10, 4, 5, 105, 4, 9,
2, // Case : 219
10, 4, 11, 1, 2, 102,
10, 4, 5, 4, 9, 105,
7, // Case : 220
0, 5, 5, 1, 3, 4, 8,
14, 5, 101, 1, 3, 100, 255,
10, 4, 100, 3, 8, 255,
14, 5, 105, 5, 1, 101, 255,
10, 4, 4, 5, 105, 255,
14, 5, 8, 4, 105, 100, 255,
10, 4, 100, 105, 101, 255,
1, // Case : 221
13, 6, 101, 0, 1, 105, 4, 5,
2, // Case : 222
10, 4, 0, 8, 3, 100,
10, 4, 9, 5, 4, 105,
1, // Case : 223
10, 4, 9, 5, 4, 105,
9, // Case : 224
0, 5, 10, 11, 7, 4, 9,
14, 5, 103, 100, 101, 102, 255,
10, 4, 101, 104, 255, 100,
14, 5, 102, 101, 9, 11, 255,
14, 5, 10, 103, 102, 11, 255,
10, 4, 104, 100, 103, 255,
14, 5, 104, 103, 10, 7, 255,
10, 4, 104, 7, 4, 255,
14, 5, 9, 101, 104, 4, 255,
8, // Case : 225
0, 5, 11, 9, 10, 3, 0,
10, 4, 104, 7, 4, 8,
14, 5, 101, 9, 11, 102, 255,
14, 5, 102, 11, 10, 103, 255,
10, 4, 103, 10, 3, 255,
10, 4, 102, 103, 101, 255,
14, 5, 103, 3, 0, 101, 255,
10, 4, 101, 0, 9, 255,
9, // Case : 226
0, 6, 4, 7, 10, 11, 1, 0,
10, 4, 103, 100, 102, 255,
14, 5, 103, 102, 11, 10, 255,
10, 4, 104, 100, 103, 255,
14, 5, 104, 103, 10, 7, 255,
10, 4, 4, 104, 7, 255,
14, 5, 104, 4, 0, 100, 255,
14, 5, 0, 1, 102, 100, 255,
10, 4, 102, 1, 11, 255,
2, // Case : 227
13, 6, 10, 103, 3, 11, 102, 1,
10, 4, 4, 8, 104, 7,
5, // Case : 228
10, 4, 103, 100, 101, 104,
14, 5, 4, 9, 101, 104, 1,
14, 5, 7, 104, 103, 10, 2,
14, 5, 101, 1, 2, 103, 104,
14, 5, 1, 4, 7, 2, 104,
3, // Case : 229
10, 4, 2, 3, 10, 103,
10, 4, 1, 101, 9, 0,
10, 4, 7, 4, 104, 8,
7, // Case : 230
0, 5, 2, 0, 4, 10, 7,
14, 5, 100, 104, 4, 0, 255,
10, 4, 104, 7, 4, 255,
14, 5, 103, 100, 0, 2, 255,
10, 4, 10, 103, 2, 255,
14, 5, 7, 104, 103, 10, 255,
10, 4, 104, 100, 103, 255,
2, // Case : 231
10, 4, 10, 2, 3, 103,
10, 4, 7, 8, 4, 104,
9, // Case : 232
0, 6, 7, 4, 9, 11, 2, 3,
10, 4, 101, 102, 100, 255,
14, 5, 101, 9, 11, 102, 255,
10, 4, 104, 101, 100, 255,
14, 5, 104, 4, 9, 101, 255,
10, 4, 7, 4, 104, 255,
14, 5, 104, 100, 3, 7, 255,
14, 5, 3, 100, 102, 2, 255,
10, 4, 102, 11, 2, 255,
2, // Case : 233
13, 6, 11, 102, 2, 9, 101, 0,
10, 4, 7, 104, 8, 4,
2, // Case : 234
13, 6, 7, 104, 4, 3, 100, 0,
10, 4, 11, 102, 1, 2,
2, // Case : 235
10, 4, 11, 1, 2, 102,
10, 4, 4, 7, 8, 104,
7, // Case : 236
0, 5, 7, 3, 1, 4, 9,
14, 5, 100, 101, 1, 3, 255,
10, 4, 101, 9, 1, 255,
14, 5, 104, 100, 3, 7, 255,
10, 4, 4, 104, 7, 255,
14, 5, 9, 101, 104, 4, 255,
10, 4, 101, 100, 104, 255,
2, // Case : 237
10, 4, 4, 7, 8, 104,
10, 4, 9, 0, 1, 101,
1, // Case : 238
13, 6, 104, 4, 7, 100, 0, 3,
1, // Case : 239
10, 4, 7, 8, 4, 104,
1, // Case : 240
12, 8, 100, 101, 102, 103, 8, 9, 11, 10,
7, // Case : 241
0, 5, 9, 11, 10, 0, 3,
14, 5, 102, 11, 10, 103, 255,
10, 4, 103, 10, 3, 255,
14, 5, 101, 9, 11, 102, 255,
10, 4, 0, 9, 101, 255,
14, 5, 3, 0, 101, 103, 255,
10, 4, 103, 101, 102, 255,
7, // Case : 242
0, 5, 11, 10, 8, 1, 0,
14, 5, 103, 10, 8, 100, 255,
10, 4, 100, 8, 0, 255,
14, 5, 102, 11, 10, 103, 255,
10, 4, 1, 11, 102, 255,
14, 5, 0, 1, 102, 100, 255,
10, 4, 100, 102, 103, 255,
1, // Case : 243
13, 6, 103, 3, 10, 102, 1, 11,
7, // Case : 244
0, 5, 10, 8, 9, 2, 1,
14, 5, 100, 8, 9, 101, 255,
10, 4, 101, 9, 1, 255,
14, 5, 103, 10, 8, 100, 255,
10, 4, 2, 10, 103, 255,
14, 5, 1, 2, 103, 101, 255,
10, 4, 101, 103, 100, 255,
2, // Case : 245
10, 4, 2, 3, 10, 103,
10, 4, 1, 9, 0, 101,
1, // Case : 246
13, 6, 100, 0, 8, 103, 2, 10,
1, // Case : 247
10, 4, 10, 2, 3, 103,
7, // Case : 248
0, 5, 11, 9, 8, 2, 3,
14, 5, 101, 100, 8, 9, 255,
10, 4, 100, 3, 8, 255,
14, 5, 102, 101, 9, 11, 255,
10, 4, 2, 102, 11, 255,
14, 5, 3, 100, 102, 2, 255,
10, 4, 100, 101, 102, 255,
1, // Case : 249
13, 6, 102, 2, 11, 101, 0, 9,
2, // Case : 250
10, 4, 0, 8, 3, 100,
10, 4, 1, 2, 11, 102,
1, // Case : 251
10, 4, 1, 2, 11, 102,
1, // Case : 252
13, 6, 100, 8, 3, 101, 9, 1,
1, // Case : 253
10, 4, 1, 9, 0, 101,
1, // Case : 254
10, 4, 3, 0, 8, 100,
0, // Case : 255
// Wdg
1, // Case : 0
13, 6, 100, 101, 102, 103, 104, 105,
2, // Case : 1
13, 6, 0, 2, 6, 101, 102, 103,
14, 5, 101, 102, 105, 104, 103,
2, // Case : 2
13, 6, 1, 0, 7, 102, 100, 104,
14, 5, 102, 100, 103, 105, 104,
8, // Case : 3
0, 7, 102, 103, 104, 1, 2, 6, 7,
10, 4, 104, 105, 103, 102,
10, 4, 102, 103, 104, 255,
14, 5, 6, 7, 104, 103, 255,
14, 5, 1, 7, 6, 2, 255,
10, 4, 102, 1, 2, 255,
14, 5, 102, 2, 6, 103, 255,
14, 5, 7, 1, 102, 104, 255,
2, // Case : 4
13, 6, 2, 1, 8, 100, 101, 105,
14, 5, 100, 101, 104, 103, 105,
8, // Case : 5
0, 7, 101, 105, 103, 0, 1, 8, 6,
10, 4, 103, 104, 105, 101,
10, 4, 101, 105, 103, 255,
14, 5, 8, 6, 103, 105, 255,
14, 5, 0, 6, 8, 1, 255,
10, 4, 101, 0, 1, 255,
14, 5, 101, 1, 8, 105, 255,
14, 5, 6, 0, 101, 103, 255,
8, // Case : 6
0, 7, 100, 104, 105, 2, 0, 7, 8,
10, 4, 105, 103, 104, 100,
10, 4, 100, 104, 105, 255,
14, 5, 7, 8, 105, 104, 255,
14, 5, 2, 8, 7, 0, 255,
10, 4, 100, 2, 0, 255,
14, 5, 100, 0, 7, 104, 255,
14, 5, 8, 2, 100, 105, 255,
1, // Case : 7
13, 6, 6, 7, 8, 103, 104, 105,
2, // Case : 8
13, 6, 104, 105, 100, 3, 5, 6,
14, 5, 104, 101, 102, 105, 100,
1, // Case : 9
12, 8, 101, 102, 105, 104, 0, 2, 5, 3,
9, // Case : 10
0, 6, 0, 1, 7, 3, 5, 6,
14, 5, 105, 100, 6, 5, 255,
10, 4, 100, 0, 6, 255,
14, 5, 100, 102, 1, 0, 255,
10, 4, 105, 102, 100, 255,
14, 5, 104, 7, 1, 102, 255,
10, 4, 105, 104, 102, 255,
14, 5, 5, 3, 104, 105, 255,
10, 4, 3, 7, 104, 255,
7, // Case : 11
0, 5, 1, 2, 5, 3, 7,
14, 5, 104, 105, 5, 3, 255,
10, 4, 3, 7, 104, 255,
14, 5, 2, 5, 105, 102, 255,
14, 5, 1, 102, 104, 7, 255,
10, 4, 104, 102, 105, 255,
10, 4, 102, 1, 2, 255,
9, // Case : 12
0, 6, 5, 3, 6, 2, 1, 8,
14, 5, 101, 1, 8, 105, 255,
10, 4, 105, 8, 5, 255,
14, 5, 105, 5, 3, 104, 255,
10, 4, 101, 105, 104, 255,
14, 5, 100, 104, 3, 6, 255,
10, 4, 101, 104, 100, 255,
14, 5, 1, 101, 100, 2, 255,
10, 4, 2, 100, 6, 255,
7, // Case : 13
0, 5, 1, 0, 3, 5, 8,
14, 5, 105, 5, 3, 104, 255,
10, 4, 5, 105, 8, 255,
14, 5, 0, 101, 104, 3, 255,
14, 5, 1, 8, 105, 101, 255,
10, 4, 105, 104, 101, 255,
10, 4, 101, 0, 1, 255,
2, // Case : 14
10, 4, 100, 2, 0, 6,
13, 6, 5, 8, 105, 3, 7, 104,
1, // Case : 15
13, 6, 3, 104, 7, 5, 105, 8,
2, // Case : 16
13, 6, 105, 103, 101, 4, 3, 7,
14, 5, 105, 102, 100, 103, 101,
9, // Case : 17
0, 6, 3, 4, 7, 0, 2, 6,
14, 5, 102, 2, 6, 103, 255,
10, 4, 103, 6, 3, 255,
14, 5, 103, 3, 4, 105, 255,
10, 4, 102, 103, 105, 255,
14, 5, 101, 105, 4, 7, 255,
10, 4, 102, 105, 101, 255,
14, 5, 2, 102, 101, 0, 255,
10, 4, 0, 101, 7, 255,
1, // Case : 18
12, 8, 102, 100, 103, 105, 1, 0, 3, 4,
7, // Case : 19
0, 5, 2, 1, 4, 3, 6,
14, 5, 103, 3, 4, 105, 255,
10, 4, 3, 103, 6, 255,
14, 5, 1, 102, 105, 4, 255,
14, 5, 2, 6, 103, 102, 255,
10, 4, 103, 105, 102, 255,
10, 4, 102, 1, 2, 255,
9, // Case : 20
0, 6, 1, 2, 8, 4, 3, 7,
14, 5, 103, 101, 7, 3, 255,
10, 4, 101, 1, 7, 255,
14, 5, 101, 100, 2, 1, 255,
10, 4, 103, 100, 101, 255,
14, 5, 105, 8, 2, 100, 255,
10, 4, 103, 105, 100, 255,
14, 5, 3, 4, 105, 103, 255,
10, 4, 4, 8, 105, 255,
2, // Case : 21
10, 4, 101, 0, 1, 7,
13, 6, 3, 6, 103, 4, 8, 105,
7, // Case : 22
0, 5, 2, 0, 3, 4, 8,
14, 5, 105, 103, 3, 4, 255,
10, 4, 4, 8, 105, 255,
14, 5, 0, 3, 103, 100, 255,
14, 5, 2, 100, 105, 8, 255,
10, 4, 105, 100, 103, 255,
10, 4, 100, 2, 0, 255,
1, // Case : 23
13, 6, 4, 105, 8, 3, 103, 6,
8, // Case : 24
0, 7, 105, 100, 101, 4, 5, 6, 7,
10, 4, 101, 100, 102, 105,
10, 4, 105, 101, 100, 255,
14, 5, 6, 100, 101, 7, 255,
14, 5, 4, 5, 6, 7, 255,
10, 4, 105, 5, 4, 255,
14, 5, 105, 100, 6, 5, 255,
14, 5, 7, 101, 105, 4, 255,
7, // Case : 25
0, 5, 4, 5, 2, 0, 7,
14, 5, 101, 0, 2, 102, 255,
10, 4, 0, 101, 7, 255,
14, 5, 5, 105, 102, 2, 255,
14, 5, 4, 7, 101, 105, 255,
10, 4, 101, 102, 105, 255,
10, 4, 105, 5, 4, 255,
7, // Case : 26
0, 5, 5, 4, 1, 0, 6,
14, 5, 100, 102, 1, 0, 255,
10, 4, 0, 6, 100, 255,
14, 5, 4, 1, 102, 105, 255,
14, 5, 5, 105, 100, 6, 255,
10, 4, 100, 105, 102, 255,
10, 4, 105, 5, 4, 255,
1, // Case : 27
13, 6, 5, 105, 4, 2, 102, 1,
2, // Case : 28
10, 4, 105, 5, 4, 8,
13, 6, 2, 6, 100, 1, 7, 101,
2, // Case : 29
10, 4, 101, 0, 1, 7,
10, 4, 5, 4, 105, 8,
2, // Case : 30
10, 4, 105, 5, 4, 8,
10, 4, 0, 100, 2, 6,
1, // Case : 31
10, 4, 5, 8, 4, 105,
2, // Case : 32
13, 6, 103, 104, 102, 5, 4, 8,
14, 5, 103, 100, 101, 104, 102,
9, // Case : 33
0, 6, 2, 0, 6, 5, 4, 8,
14, 5, 104, 102, 8, 4, 255,
10, 4, 102, 2, 8, 255,
14, 5, 102, 101, 0, 2, 255,
10, 4, 104, 101, 102, 255,
14, 5, 103, 6, 0, 101, 255,
10, 4, 104, 103, 101, 255,
14, 5, 4, 5, 103, 104, 255,
10, 4, 5, 6, 103, 255,
9, // Case : 34
0, 6, 4, 5, 8, 1, 0, 7,
14, 5, 100, 0, 7, 104, 255,
10, 4, 104, 7, 4, 255,
14, 5, 104, 4, 5, 103, 255,
10, 4, 100, 104, 103, 255,
14, 5, 102, 103, 5, 8, 255,
10, 4, 100, 103, 102, 255,
14, 5, 0, 100, 102, 1, 255,
10, 4, 1, 102, 8, 255,
2, // Case : 35
10, 4, 102, 1, 2, 8,
13, 6, 4, 7, 104, 5, 6, 103,
1, // Case : 36
12, 8, 100, 101, 104, 103, 2, 1, 4, 5,
7, // Case : 37
0, 5, 0, 1, 4, 5, 6,
14, 5, 103, 104, 4, 5, 255,
10, 4, 5, 6, 103, 255,
14, 5, 1, 4, 104, 101, 255,
14, 5, 0, 101, 103, 6, 255,
10, 4, 103, 101, 104, 255,
10, 4, 101, 0, 1, 255,
7, // Case : 38
0, 5, 0, 2, 5, 4, 7,
14, 5, 104, 4, 5, 103, 255,
10, 4, 4, 104, 7, 255,
14, 5, 2, 100, 103, 5, 255,
14, 5, 0, 7, 104, 100, 255,
10, 4, 104, 103, 100, 255,
10, 4, 100, 2, 0, 255,
1, // Case : 39
13, 6, 5, 103, 6, 4, 104, 7,
8, // Case : 40
0, 7, 104, 102, 100, 3, 4, 8, 6,
10, 4, 100, 102, 101, 104,
10, 4, 104, 100, 102, 255,
14, 5, 8, 102, 100, 6, 255,
14, 5, 3, 4, 8, 6, 255,
10, 4, 104, 4, 3, 255,
14, 5, 104, 102, 8, 4, 255,
14, 5, 6, 100, 104, 3, 255,
7, // Case : 41
0, 5, 4, 3, 0, 2, 8,
14, 5, 102, 101, 0, 2, 255,
10, 4, 2, 8, 102, 255,
14, 5, 3, 0, 101, 104, 255,
14, 5, 4, 104, 102, 8, 255,
10, 4, 102, 104, 101, 255,
10, 4, 104, 4, 3, 255,
2, // Case : 42
10, 4, 104, 4, 3, 7,
13, 6, 1, 8, 102, 0, 6, 100,
2, // Case : 43
10, 4, 104, 4, 3, 7,
10, 4, 2, 102, 1, 8,
7, // Case : 44
0, 5, 3, 4, 1, 2, 6,
14, 5, 100, 2, 1, 101, 255,
10, 4, 2, 100, 6, 255,
14, 5, 4, 104, 101, 1, 255,
14, 5, 3, 6, 100, 104, 255,
10, 4, 100, 101, 104, 255,
10, 4, 104, 4, 3, 255,
1, // Case : 45
13, 6, 4, 104, 3, 1, 101, 0,
2, // Case : 46
10, 4, 100, 2, 0, 6,
10, 4, 4, 3, 104, 7,
1, // Case : 47
10, 4, 4, 7, 3, 104,
8, // Case : 48
0, 7, 103, 101, 102, 5, 3, 7, 8,
10, 4, 102, 101, 100, 103,
10, 4, 103, 102, 101, 255,
14, 5, 7, 101, 102, 8, 255,
14, 5, 5, 3, 7, 8, 255,
10, 4, 103, 3, 5, 255,
14, 5, 103, 101, 7, 3, 255,
14, 5, 8, 102, 103, 5, 255,
2, // Case : 49
10, 4, 103, 3, 5, 6,
13, 6, 0, 7, 101, 2, 8, 102,
7, // Case : 50
0, 5, 5, 3, 0, 1, 8,
14, 5, 102, 1, 0, 100, 255,
10, 4, 1, 102, 8, 255,
14, 5, 3, 103, 100, 0, 255,
14, 5, 5, 8, 102, 103, 255,
10, 4, 102, 100, 103, 255,
10, 4, 103, 3, 5, 255,
2, // Case : 51
10, 4, 102, 1, 2, 8,
10, 4, 3, 5, 103, 6,
7, // Case : 52
0, 5, 3, 5, 2, 1, 7,
14, 5, 101, 100, 2, 1, 255,
10, 4, 1, 7, 101, 255,
14, 5, 5, 2, 100, 103, 255,
14, 5, 3, 103, 101, 7, 255,
10, 4, 101, 103, 100, 255,
10, 4, 103, 3, 5, 255,
2, // Case : 53
10, 4, 103, 3, 5, 6,
10, 4, 1, 101, 0, 7,
1, // Case : 54
13, 6, 3, 103, 5, 0, 100, 2,
1, // Case : 55
10, 4, 3, 6, 5, 103,
1, // Case : 56
13, 6, 100, 101, 102, 6, 7, 8,
1, // Case : 57
13, 6, 2, 102, 8, 0, 101, 7,
1, // Case : 58
13, 6, 0, 100, 6, 1, 102, 8,
1, // Case : 59
10, 4, 2, 1, 8, 102,
1, // Case : 60
13, 6, 1, 101, 7, 2, 100, 6,
1, // Case : 61
10, 4, 1, 0, 7, 101,
1, // Case : 62
10, 4, 0, 2, 6, 100,
0, // Case : 63
// Pyr
1, // Case : 0
14, 5, 100, 101, 102, 103, 104,
2, // Case : 1
13, 6, 0, 4, 3, 101, 104, 103,
10, 4, 101, 102, 103, 104,
2, // Case : 2
13, 6, 1, 5, 0, 102, 104, 100,
10, 4, 102, 103, 100, 104,
7, // Case : 3
0, 7, 104, 5, 4, 1, 3, 102, 103,
10, 4, 4, 104, 5, 255,
14, 5, 1, 3, 4, 5, 255,
14, 5, 1, 5, 104, 102, 255,
10, 4, 102, 104, 103, 255,
14, 5, 103, 104, 4, 3, 255,
14, 5, 102, 103, 3, 1, 255,
2, // Case : 4
13, 6, 2, 6, 1, 103, 104, 101,
10, 4, 103, 100, 101, 104,
2, // Case : 5
13, 6, 4, 104, 6, 0, 101, 1,
13, 6, 104, 4, 6, 103, 3, 2,
7, // Case : 6
0, 7, 104, 6, 5, 2, 0, 103, 100,
10, 4, 5, 104, 6, 255,
14, 5, 2, 0, 5, 6, 255,
14, 5, 2, 6, 104, 103, 255,
10, 4, 103, 104, 100, 255,
14, 5, 100, 104, 5, 0, 255,
14, 5, 103, 100, 0, 2, 255,
2, // Case : 7
10, 4, 4, 5, 6, 104,
13, 6, 2, 3, 103, 6, 4, 104,
2, // Case : 8
13, 6, 3, 7, 2, 100, 104, 102,
10, 4, 100, 101, 102, 104,
7, // Case : 9
0, 7, 104, 4, 7, 0, 2, 101, 102,
10, 4, 7, 104, 4, 255,
14, 5, 0, 2, 7, 4, 255,
14, 5, 0, 4, 104, 101, 255,
10, 4, 101, 104, 102, 255,
14, 5, 102, 104, 7, 2, 255,
14, 5, 101, 102, 2, 0, 255,
2, // Case : 10
13, 6, 7, 104, 5, 3, 100, 0,
13, 6, 104, 7, 5, 102, 2, 1,
2, // Case : 11
10, 4, 7, 4, 5, 104,
13, 6, 1, 2, 102, 5, 7, 104,
7, // Case : 12
0, 7, 104, 7, 6, 3, 1, 100, 101,
10, 4, 6, 104, 7, 255,
14, 5, 3, 1, 6, 7, 255,
14, 5, 3, 7, 104, 100, 255,
10, 4, 100, 104, 101, 255,
14, 5, 101, 104, 6, 1, 255,
14, 5, 100, 101, 1, 3, 255,
2, // Case : 13
10, 4, 6, 7, 4, 104,
13, 6, 0, 1, 101, 4, 6, 104,
2, // Case : 14
10, 4, 5, 6, 7, 104,
13, 6, 3, 0, 100, 7, 5, 104,
1, // Case : 15
14, 5, 4, 5, 6, 7, 104,
1, // Case : 16
12, 8, 100, 101, 102, 103, 4, 5, 6, 7,
2, // Case : 17
13, 6, 3, 7, 103, 0, 5, 101,
13, 6, 5, 6, 7, 101, 102, 103,
2, // Case : 18
13, 6, 0, 4, 100, 1, 6, 102,
13, 6, 6, 7, 4, 102, 103, 100,
1, // Case : 19
13, 6, 3, 7, 103, 1, 6, 102,
2, // Case : 20
13, 6, 1, 5, 101, 2, 7, 103,
13, 6, 7, 4, 5, 103, 100, 101,
2, // Case : 21
10, 4, 0, 101, 1, 5,
10, 4, 103, 3, 2, 7,
1, // Case : 22
13, 6, 0, 4, 100, 2, 7, 103,
1, // Case : 23
10, 4, 103, 3, 2, 7,
2, // Case : 24
13, 6, 2, 6, 102, 3, 4, 100,
13, 6, 4, 5, 6, 100, 101, 102,
1, // Case : 25
13, 6, 2, 6, 102, 0, 5, 101,
2, // Case : 26
10, 4, 3, 100, 0, 4,
10, 4, 102, 2, 1, 6,
1, // Case : 27
10, 4, 102, 2, 1, 6,
1, // Case : 28
13, 6, 1, 5, 101, 3, 4, 100,
1, // Case : 29
10, 4, 101, 1, 0, 5,
1, // Case : 30
10, 4, 100, 0, 3, 4,
0, // Case : 31
};

// Index into ClipTablesData for each shape and configuration
VTKM_STATIC_CONSTEXPR_ARRAY vtkm::UInt16 ClipTablesIndices[] = {
//Vtx
0, 4,  //cases 0 - 1
//Lin
5, 10, 15, 20,  //cases 0 - 3
//Tri
21, 27, 34, 41, 47, 54, 60, 66,  //cases 0 - 7
//Qua
67, 74, 86, 98, 105, 117, 128, 135,  //cases 0 - 7
141, 153, 160, 171, 177, 184, 190, 196,  //cases 8 - 15
//Tet
197, 204, 213, 222, 231, 240, 249, 258,  //cases 0 - 7
265, 274, 283, 292, 299, 308, 315, 322,  //cases 8 - 15
//Hex
323, 334, 397, 460, 479, 542, 618, 637,  //cases 0 - 7
698, 761, 780, 856, 917, 936, 997, 1058,  //cases 8 - 15
1069, 1132, 1151, 1227, 1288, 1329, 1401, 1473,  //cases 16 - 23
1534, 1610, 1671, 1712, 1747, 1819, 1880, 1933,  //cases 24 - 31
1980, 2043, 2119, 2138, 2199, 2275, 2316, 2377,  //cases 32 - 39
2412, 2453, 2525, 2597, 2658, 2730, 2783, 2844,  //cases 40 - 47
2891, 2910, 2971, 3032, 3043, 3115, 3168, 3229,  //cases 48 - 55
3276, 3348, 3409, 3462, 3509, 3526, 3541, 3556,  //cases 56 - 63
3565, 3628, 3669, 3745, 3817, 3836, 3908, 3969,  //cases 64 - 71
4030, 4106, 4178, 4219, 4272, 4333, 4394, 4429,  //cases 72 - 79
4476, 4552, 4624, 4665, 4718, 4790, 4807, 4860,  //cases 80 - 87
4875, 4916, 4969, 4994, 5013, 5066, 5081, 5100,  //cases 88 - 95
5113, 5132, 5204, 5265, 5326, 5387, 5440, 5451,  //cases 96 - 103
5498, 5570, 5587, 5640, 5655, 5716, 5731, 5778,  //cases 104 - 111
5787, 5848, 5909, 5944, 5991, 6052, 6067, 6114,  //cases 112 - 119
6123, 6176, 6191, 6210, 6223, 6238, 6251, 6264,  //cases 120 - 127
6271, 6334, 6410, 6451, 6523, 6599, 6640, 6712,  //cases 128 - 135
6765, 6784, 6845, 6917, 6978, 7039, 7074, 7135,  //cases 136 - 143
7182, 7201, 7262, 7334, 7395, 7467, 7520, 7537,  //cases 144 - 151
7552, 7613, 7624, 7677, 7724, 7785, 7832, 7847,  //cases 152 - 159
7856, 7932, 7973, 8045, 8098, 8139, 8164, 8217,  //cases 160 - 167
8236, 8308, 8361, 8378, 8393, 8446, 8465, 8480,  //cases 168 - 175
8493, 8554, 8589, 8650, 8697, 8750, 8769, 8784,  //cases 176 - 183
8797, 8858, 8905, 8920, 8929, 8944, 8957, 8970,  //cases 184 - 191
8977, 8996, 9068, 9140, 9157, 9218, 9271, 9332,  //cases 192 - 199
9347, 9408, 9469, 9522, 9537, 9548, 9595, 9642,  //cases 200 - 207
9651, 9712, 9773, 9826, 9841, 9902, 9917, 9932,  //cases 208 - 215
9945, 9980, 10027, 10046, 10059, 10106, 10115, 10128,  //cases 216 - 223
10135, 10196, 10249, 10310, 10325, 10360, 10379, 10426,  //cases 224 - 231
10439, 10500, 10515, 10530, 10543, 10590, 10603, 10612,  //cases 232 - 239
10619, 10630, 10677, 10724, 10733, 10780, 10793, 10802,  //cases 240 - 247
10809, 10856, 10865, 10878, 10885, 10894, 10901, 10908,  //cases 248 - 255
//Wdg
10909, 10918, 10934, 10950, 11006, 11022, 11078, 11134,  //cases 0 - 7
11143, 11159, 11170, 11231, 11278, 11339, 11386, 11401,  //cases 8 - 15
11410, 11426, 11487, 11498, 11545, 11606, 11621, 11668,  //cases 16 - 23
11677, 11733, 11780, 11827, 11836, 11851, 11864, 11877,  //cases 24 - 31
11884, 11900, 11961, 12022, 12037, 12048, 12095, 12142,  //cases 32 - 39
12151, 12207, 12254, 12269, 12282, 12329, 12338, 12351,  //cases 40 - 47
12358, 12414, 12429, 12476, 12489, 12536, 12549, 12558,  //cases 48 - 55
12565, 12574, 12583, 12592, 12599, 12608, 12615, 12622,  //cases 56 - 63
//Pyr
12623, 12631, 12646, 12661, 12711, 12726, 12743, 12793,  //cases 0 - 7
12808, 12823, 12873, 12890, 12905, 12955, 12970, 12985,  //cases 8 - 15
12993, 13004, 13021, 13038, 13047, 13064, 13077, 13086,  //cases 16 - 23
13093, 13110, 13119, 13132, 13139, 13148, 13155, 13162,  //cases 24 - 31
};

enum
{
  CLIP_TABLES_DATA_SIZE = sizeof(ClipTablesData) / sizeof(ClipTablesData[0]),
  CLIP_TABLES_INDICES_SIZE = sizeof(ClipTablesIndices) / sizeof(ClipTablesIndices[0]),
  MAX_CELL_EDGES = 12, // Hexahedron
  CELL_EDGES_SIZE = vtkm::NUMBER_OF_CELL_SHAPES * MAX_CELL_EDGES * 2
};

#define X 255
VTKM_STATIC_CONSTEXPR_ARRAY vtkm::UInt8 CellEdges[CELL_EDGES_SIZE] = {
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_EMPTY_CELL
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_VERTEX
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLY_VERTEX
  0, 1, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_LINE
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLY_LINE
  0, 1, 1, 2, 2, 0, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TRIANGLE
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TRIANGLE_STRIP
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLYGON
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_PIXEL
  0, 1, 1, 2, 3, 2, 0, 3, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_QUAD
  0, 1, 1, 2, 2, 0, 0, 3, 1, 3, 2, 3,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TETRA
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_VOXEL
  0, 1, 1, 2, 3, 2, 0, 3, 4, 5, 5, 6,
  7, 6, 4, 7, 0, 4, 1, 5, 3, 7, 2, 6, // vtkm::CELL_SHAPE_HEXAHEDRON
  0, 1, 1, 2, 2, 0, 3, 4, 4, 5, 5, 3,
  0, 3, 1, 4, 2, 5, X, X, X, X, X, X, // vtkm::CELL_SHAPE_WEDGE
  0, 1, 1, 2, 2, 3, 3, 0, 0, 4, 1, 4,
  2, 4, 3, 4, X, X, X, X, X, X, X, X // vtkm::CELL_SHAPE_PYRAMID
};
#undef X
// clang-format on

class ClipTables : public vtkm::cont::ExecutionObjectBase
{
public:
  using EdgeVec = vtkm::IdComponent2;

  template <typename DeviceAdapter>
  class DevicePortal
  {
  public:
    VTKM_EXEC
    vtkm::Id GetCaseIndex(vtkm::Id shape, vtkm::Id caseId) const
    {
      // index into ClipTablesIndices for each shape
      VTKM_STATIC_CONSTEXPR_ARRAY vtkm::Int32 CellIndexLookup[vtkm::NUMBER_OF_CELL_SHAPES] = {
        -1,  //  0 = vtkm::CELL_SHAPE_EMPTY_CELL
        0,   //  1 = vtkm::CELL_SHAPE_VERTEX
        -1,  //  2 = vtkm::CELL_SHAPE_POLY_VERTEX
        2,   //  3 = vtkm::CELL_SHAPE_LINE
        -1,  //  4 = vtkm::CELL_SHAPE_POLY_LINE
        6,   //  5 = vtkm::CELL_SHAPE_TRIANGLE
        -1,  //  6 = vtkm::CELL_SHAPE_TRIANGLE_STRIP
        -1,  //  7 = vtkm::CELL_SHAPE_POLYGON
        -1,  //  8 = vtkm::CELL_SHAPE_PIXEL
        14,  //  9 = vtkm::CELL_SHAPE_QUAD
        30,  // 10 = vtkm::CELL_SHAPE_TETRA
        -1,  // 11 = vtkm::CELL_SHAPE_VOXEL
        46,  // 12 = vtkm::CELL_SHAPE_HEXAHEDRON
        302, // 13 = vtkm::CELL_SHAPE_WEDGE
        366  // 14 = vtkm::CELL_SHAPE_PYRAMID
      };

      vtkm::Id index = CellIndexLookup[shape];
      return this->ClipTablesIndicesPortal.Get(index + caseId);
    }

    VTKM_EXEC
    vtkm::UInt8 ValueAt(vtkm::Id idx) const { return this->ClipTablesDataPortal.Get(idx); }

    VTKM_EXEC
    EdgeVec GetEdge(vtkm::Id shape, vtkm::Id edgeId) const
    {
      vtkm::Id index = ((shape * MAX_CELL_EDGES) + edgeId) * 2;
      vtkm::IdComponent v1 = this->CellEdgesPortal.Get(index);
      vtkm::IdComponent v2 = this->CellEdgesPortal.Get(index + 1);
      return EdgeVec(v1, v2);
    }

  private:
    typename vtkm::cont::ArrayHandle<vtkm::UInt8>::ExecutionTypes<DeviceAdapter>::PortalConst
      ClipTablesDataPortal;
    typename vtkm::cont::ArrayHandle<vtkm::UInt16>::ExecutionTypes<DeviceAdapter>::PortalConst
      ClipTablesIndicesPortal;
    typename vtkm::cont::ArrayHandle<vtkm::UInt8>::ExecutionTypes<DeviceAdapter>::PortalConst
      CellEdgesPortal;

    friend class ClipTables;
  };

  ClipTables()
    : ClipTablesDataArray(vtkm::cont::make_ArrayHandle(ClipTablesData, CLIP_TABLES_DATA_SIZE))
    , ClipTablesIndicesArray(
        vtkm::cont::make_ArrayHandle(ClipTablesIndices, CLIP_TABLES_INDICES_SIZE))
    , CellEdgesArray(vtkm::cont::make_ArrayHandle(CellEdges, CELL_EDGES_SIZE))
  {
  }

  template <typename DeviceAdapter>
  DevicePortal<DeviceAdapter> PrepareForExecution(DeviceAdapter)
  {
    DevicePortal<DeviceAdapter> portal;
    portal.ClipTablesDataPortal = this->ClipTablesDataArray.PrepareForInput(DeviceAdapter());
    portal.ClipTablesIndicesPortal = this->ClipTablesIndicesArray.PrepareForInput(DeviceAdapter());
    portal.CellEdgesPortal = this->CellEdgesArray.PrepareForInput(DeviceAdapter());
    return portal;
  }

private:
  vtkm::cont::ArrayHandle<vtkm::UInt8> ClipTablesDataArray;
  vtkm::cont::ArrayHandle<vtkm::UInt16> ClipTablesIndicesArray;
  vtkm::cont::ArrayHandle<vtkm::UInt8> CellEdgesArray;
};
}
}
} // namespace vtkm::worklet::internal

#endif // vtk_m_ClipTables_h
