/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SILMatrixAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Init utility for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILMatrixAttributes::Init()
{
    role1 = 0;
    role2 = 0;

    SILMatrixAttributes::SelectAll();
}

// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Copy utility for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILMatrixAttributes::Copy(const SILMatrixAttributes &obj)
{
    set1 = obj.set1;
    category1 = obj.category1;
    role1 = obj.role1;
    set2 = obj.set2;
    category2 = obj.category2;
    role2 = obj.role2;

    SILMatrixAttributes::SelectAll();
}

// Type map format string
const char *SILMatrixAttributes::TypeMapFormatString = SILMATRIXATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SILMatrixAttributes::TmfsStruct = {SILMATRIXATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Default constructor for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes::SILMatrixAttributes() : 
    AttributeSubject(SILMatrixAttributes::TypeMapFormatString)
{
    SILMatrixAttributes::Init();
}

// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Constructor for the derived classes of SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes::SILMatrixAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILMatrixAttributes::Init();
}

// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Copy constructor for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes::SILMatrixAttributes(const SILMatrixAttributes &obj) : 
    AttributeSubject(SILMatrixAttributes::TypeMapFormatString)
{
    SILMatrixAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILMatrixAttributes::SILMatrixAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes::SILMatrixAttributes(const SILMatrixAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILMatrixAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILMatrixAttributes::~SILMatrixAttributes
//
// Purpose: 
//   Destructor for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes::~SILMatrixAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SILMatrixAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes& 
SILMatrixAttributes::operator = (const SILMatrixAttributes &obj)
{
    if (this == &obj) return *this;

    SILMatrixAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SILMatrixAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILMatrixAttributes::operator == (const SILMatrixAttributes &obj) const
{
    // Create the return value
    return ((set1 == obj.set1) &&
            (category1 == obj.category1) &&
            (role1 == obj.role1) &&
            (set2 == obj.set2) &&
            (category2 == obj.category2) &&
            (role2 == obj.role2));
}

// ****************************************************************************
// Method: SILMatrixAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILMatrixAttributes::operator != (const SILMatrixAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SILMatrixAttributes::TypeName
//
// Purpose: 
//   Type name method for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SILMatrixAttributes::TypeName() const
{
    return "SILMatrixAttributes";
}

// ****************************************************************************
// Method: SILMatrixAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILMatrixAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SILMatrixAttributes *tmp = (const SILMatrixAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SILMatrixAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILMatrixAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SILMatrixAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SILMatrixAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SILMatrixAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILMatrixAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SILMatrixAttributes(*this);
    else
        retval = new SILMatrixAttributes;

    return retval;
}

// ****************************************************************************
// Method: SILMatrixAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILMatrixAttributes::SelectAll()
{
    Select(ID_set1,      (void *)&set1);
    Select(ID_category1, (void *)&category1);
    Select(ID_role1,     (void *)&role1);
    Select(ID_set2,      (void *)&set2);
    Select(ID_category2, (void *)&category2);
    Select(ID_role2,     (void *)&role2);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILMatrixAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILMatrixAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SILMatrixAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SILMatrixAttributes.
    DataNode *node = new DataNode("SILMatrixAttributes");

    if(completeSave || !FieldsEqual(ID_set1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("set1", set1));
    }

    if(completeSave || !FieldsEqual(ID_category1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category1", category1));
    }

    if(completeSave || !FieldsEqual(ID_role1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("role1", role1));
    }

    if(completeSave || !FieldsEqual(ID_set2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("set2", set2));
    }

    if(completeSave || !FieldsEqual(ID_category2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category2", category2));
    }

    if(completeSave || !FieldsEqual(ID_role2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("role2", role2));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SILMatrixAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILMatrixAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SILMatrixAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("set1")) != 0)
        SetSet1(node->AsIntVector());
    if((node = searchNode->GetNode("category1")) != 0)
        SetCategory1(node->AsString());
    if((node = searchNode->GetNode("role1")) != 0)
        SetRole1(node->AsInt());
    if((node = searchNode->GetNode("set2")) != 0)
        SetSet2(node->AsIntVector());
    if((node = searchNode->GetNode("category2")) != 0)
        SetCategory2(node->AsString());
    if((node = searchNode->GetNode("role2")) != 0)
        SetRole2(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SILMatrixAttributes::SetSet1(const intVector &set1_)
{
    set1 = set1_;
    Select(ID_set1, (void *)&set1);
}

void
SILMatrixAttributes::SetCategory1(const std::string &category1_)
{
    category1 = category1_;
    Select(ID_category1, (void *)&category1);
}

void
SILMatrixAttributes::SetRole1(int role1_)
{
    role1 = role1_;
    Select(ID_role1, (void *)&role1);
}

void
SILMatrixAttributes::SetSet2(const intVector &set2_)
{
    set2 = set2_;
    Select(ID_set2, (void *)&set2);
}

void
SILMatrixAttributes::SetCategory2(const std::string &category2_)
{
    category2 = category2_;
    Select(ID_category2, (void *)&category2);
}

void
SILMatrixAttributes::SetRole2(int role2_)
{
    role2 = role2_;
    Select(ID_role2, (void *)&role2);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
SILMatrixAttributes::GetSet1() const
{
    return set1;
}

intVector &
SILMatrixAttributes::GetSet1()
{
    return set1;
}

const std::string &
SILMatrixAttributes::GetCategory1() const
{
    return category1;
}

std::string &
SILMatrixAttributes::GetCategory1()
{
    return category1;
}

int
SILMatrixAttributes::GetRole1() const
{
    return role1;
}

const intVector &
SILMatrixAttributes::GetSet2() const
{
    return set2;
}

intVector &
SILMatrixAttributes::GetSet2()
{
    return set2;
}

const std::string &
SILMatrixAttributes::GetCategory2() const
{
    return category2;
}

std::string &
SILMatrixAttributes::GetCategory2()
{
    return category2;
}

int
SILMatrixAttributes::GetRole2() const
{
    return role2;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SILMatrixAttributes::SelectSet1()
{
    Select(ID_set1, (void *)&set1);
}

void
SILMatrixAttributes::SelectCategory1()
{
    Select(ID_category1, (void *)&category1);
}

void
SILMatrixAttributes::SelectSet2()
{
    Select(ID_set2, (void *)&set2);
}

void
SILMatrixAttributes::SelectCategory2()
{
    Select(ID_category2, (void *)&category2);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILMatrixAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILMatrixAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_set1:      return "set1";
    case ID_category1: return "category1";
    case ID_role1:     return "role1";
    case ID_set2:      return "set2";
    case ID_category2: return "category2";
    case ID_role2:     return "role2";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILMatrixAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SILMatrixAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_set1:      return FieldType_intVector;
    case ID_category1: return FieldType_string;
    case ID_role1:     return FieldType_int;
    case ID_set2:      return FieldType_intVector;
    case ID_category2: return FieldType_string;
    case ID_role2:     return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SILMatrixAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILMatrixAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_set1:      return "intVector";
    case ID_category1: return "string";
    case ID_role1:     return "int";
    case ID_set2:      return "intVector";
    case ID_category2: return "string";
    case ID_role2:     return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILMatrixAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILMatrixAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SILMatrixAttributes &obj = *((const SILMatrixAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_set1:
        {  // new scope
        retval = (set1 == obj.set1);
        }
        break;
    case ID_category1:
        {  // new scope
        retval = (category1 == obj.category1);
        }
        break;
    case ID_role1:
        {  // new scope
        retval = (role1 == obj.role1);
        }
        break;
    case ID_set2:
        {  // new scope
        retval = (set2 == obj.set2);
        }
        break;
    case ID_category2:
        {  // new scope
        retval = (category2 == obj.category2);
        }
        break;
    case ID_role2:
        {  // new scope
        retval = (role2 == obj.role2);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

