//=======================================================================
// filestab.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "filestab.h"
#include "filestreeview.h"
#include "pkg.h"
#include <gtkmm/buttonbox.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/separator.h>

using sigc::mem_fun;
using Glib::ustring;
using namespace Gpaco;


FilesTab::FilesTab(Pkg& pkg)
:
	Gtk::VBox(),
	mPkg(pkg),
	mLabel("", 0.02, 0.5),
	mProgressBar(),
	mpTreeView(new FilesTreeView(pkg)),
	mButtonInst("View _installed", true),
	mButtonMiss("View _missing", true)
{
	mButtonMiss.set_active(mPkg.listFilesMiss());
	mButtonMiss.signal_toggled().connect(mem_fun(*this, &FilesTab::onSwitchMissing));
	mButtonMiss.set_tooltip_text("List the missing files (those files installed by "
		"the package but removed afterwards)");

	mButtonInst.set_active(mPkg.listFilesInst());
	mButtonInst.signal_toggled().connect(mem_fun(*this, &FilesTab::onSwitchInstalled));

	mButtonInst.set_tooltip_text("List the currently installed files");

	Gtk::HButtonBox* pHButtonBox(Gtk::manage(new Gtk::HButtonBox(Gtk::BUTTONBOX_START, 8)));
	pHButtonBox->set_border_width(2);
	pHButtonBox->pack_start(mButtonInst);
	pHButtonBox->pack_start(mButtonMiss);

	Gtk::ScrolledWindow* pScrolledWindow(Gtk::manage(new Gtk::ScrolledWindow()));
	pScrolledWindow->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	pScrolledWindow->add(*mpTreeView);

	Gtk::HBox* pHBox(Gtk::manage(new Gtk::HBox())); 
	pHBox->pack_start(mLabel, Gtk::PACK_SHRINK, 8);
	pHBox->pack_end(mProgressBar, Gtk::PACK_SHRINK);

	mProgressBar.set_size_request(-1, 0);

	pack_start(*pHButtonBox, Gtk::PACK_SHRINK);
	pack_start(*pScrolledWindow);
	pack_start(*(Gtk::manage(new Gtk::HSeparator)), Gtk::PACK_SHRINK, 1);
	pack_start(*pHBox, Gtk::PACK_SHRINK);

	show_all();
	mProgressBar.hide();
}


FilesTab::~FilesTab()
{
	delete mpTreeView;
}


void FilesTab::setLabelText(ustring const& text)
{
	mLabel.set_text(text);
}


//---------//
// private //
//---------//


void FilesTab::onSwitchInstalled()
{
	mPkg.switchListFilesInst();
	if (mPkg.filesInst())
		mpTreeView->resetModel();
}


void FilesTab::onSwitchMissing()
{
	mPkg.switchListFilesMiss();
	if (mPkg.filesMiss())
		mpTreeView->resetModel();
}

