///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/**
 * \file PolygonVertex.h
 * \brief Contains definition of Core::PolygonVertex class.
 */

#ifndef __OVITO_POLYGON_VERTEX_H
#define __OVITO_POLYGON_VERTEX_H

#include <core/Core.h>

namespace Core {

/**
 * \brief A polygon vertex is part of a BezierPolygon.
 *
 * \author Alexander Stukowski
 * \sa BezierPolygon
 */
class CORE_DLLEXPORT PolygonVertex
{
public:

	/**
	 * \brief The types of vertices that can be used in a BezierPolygon.
	 */
	enum VertexType {
	    BezierVertex,
	    InterpolationVertex,
	};

	/// \brief Default constructor.
	PolygonVertex() {}

	/// \brief Initializes the vertex with the given values.
	PolygonVertex(VertexType vertexType, const Point3& pos) : _vertexType(vertexType), _pos(pos) {}

	/// \brief Copy constructor.
	PolygonVertex(const PolygonVertex& vertex) :
		_vertexType(vertex._vertexType), _pos(vertex._pos) {}

	/// \brief Returns the type of this vertex.
	VertexType vertexType() const { return _vertexType; }

	/// \brief Returns the position of this vertex.
	const Point3& pos() const { return _pos; }

private:

	VertexType _vertexType;
	Point3 _pos;

	friend class BezierPolygon;
};


};	// End of namespace Core

#endif // __OVITO_POLYGON_VERTEX_H
