# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1182-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57406);
 script_cve_id("CVE-2006-4790");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1182-1 (gnutls11)";
 script_name(name);

 desc = "The remote host is missing an update to gnutls11
announced via advisory DSA 1182-1.

Daniel Bleichenbacher discovered a flaw in GNU TLS cryptographic package
that could allow an attacker to generate a forged signature that GNU TLS
will accept as valid.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.16-13.2sarge2.

The unstable distribution (sid) does no longer contain gnutls11, for
gnutls13 this problem has been fixed in version 1.4.4-1.

We recommend that you upgrade your GNU TLS package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201182-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1182-1 (gnutls11)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnutls-bin", ver:"1.0.16-13.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11", ver:"1.0.16-13.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11-dbg", ver:"1.0.16-13.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11-dev", ver:"1.0.16-13.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
