/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Filter;
import org.chefproject.core.NewsChannel;
import org.chefproject.core.NewsItem;
import org.chefproject.exception.NewsConnectionException;
import org.chefproject.exception.NewsFormatException;
import org.chefproject.service.generic.GenericNewsService;
import org.chefproject.util.Cache;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BasicNewsService
extends TurbineBaseService
implements GenericNewsService {
    protected static int DEFAULT_EXPIRATION = 600;
    protected Cache m_storage = null;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        Log.info("chef", this + ".init()");
        super.init();
        this.m_storage = new Cache();
    }

    public void shutdown() {
        this.m_storage.clear();
        this.m_storage = null;
        super.shutdown();
        Log.info("chef", this + ".shutdown()");
    }

    protected void updateChannel(String source) throws NewsConnectionException, NewsFormatException {
        if (!this.m_storage.containsKey(source)) {
            this.m_storage.put(source, new BasicNewsChannel(source), DEFAULT_EXPIRATION);
        }
    }

    public List getNewsitems(String source) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        Object obj = this.m_storage.get(source);
        NewsChannel ch = (NewsChannel)obj;
        List items = ch.getNewsitems();
        return items;
    }

    public List getNewsitems(String source, Filter filter) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        List items = ((NewsChannel)this.m_storage.get(source)).getNewsitems(filter);
        return items;
    }

    public boolean isUpdateAvailable(String source) {
        return true;
    }

    public List getChannels() {
        return this.m_storage.getKeys();
    }

    public NewsChannel getChannel(String source) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        return (NewsChannel)this.m_storage.get(source);
    }

    public void removeChannel(String source) {
        this.m_storage.remove(source);
    }

    public class BasicNewsChannel
    implements NewsChannel {
        protected String m_source = null;
        protected String m_link = null;
        protected String m_title = null;
        protected String m_description = null;
        protected String m_language = null;
        protected String m_copyright = null;
        protected String m_pubdate = null;
        protected String m_lastbuilddate = null;
        protected List m_items = null;

        public BasicNewsChannel(String source) throws NewsConnectionException, NewsFormatException {
            if (this.m_items == null) {
                this.m_items = new Vector();
            }
            this.initChannel(source);
        }

        private Node getNode(Node start, String name) {
            NodeList list = start.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeName().equals(name)) {
                    return node;
                }
                ++i;
            }
            return null;
        }

        private String getNodeValue(Node start, String nodename, String defval) {
            Node thenode = this.getNode(start, nodename);
            String rv = defval;
            if (thenode != null) {
                rv = thenode.getFirstChild().getNodeValue();
            }
            return rv;
        }

        private void initChannel(String source) throws NewsConnectionException, NewsFormatException {
            Document document = null;
            try {
                URL url = new URL(source);
                DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
                docfactory.setValidating(false);
                DocumentBuilder parser = docfactory.newDocumentBuilder();
                InputSource insource = new InputSource(url.toExternalForm());
                insource.setEncoding("UTF-8");
                document = parser.parse(insource);
            }
            catch (MalformedURLException e) {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".initChannel(" + source + ") bad url: " + e.getMessage());
                }
                throw new NewsFormatException("\"" + source + "\" is not a complete and valid URL.");
            }
            catch (IOException e) {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".initChannel(" + source + ") constructor: couldn't connect: " + e.getMessage());
                }
                throw new NewsConnectionException("Unable to obtain news feed from " + source);
            }
            catch (Exception e) {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".initChannel(" + source + ") constructor: couldn't parse: " + e.getMessage());
                }
                throw new NewsConnectionException("Unable to interpret news feed from " + source);
            }
            if (document.equals(null)) {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".initChannel(" + source + ") constructor: null document");
                }
                throw new NewsFormatException("File received from \"" + source + "\" is not in RSS format");
            }
            Node channel = null;
            NodeList list = document.getElementsByTagName("channel");
            if (list.getLength() != 1) {
                throw new NewsFormatException("File received from " + source + " is not in RSS format");
            }
            channel = list.item(0);
            Node titlenode = this.getNode(channel, "title");
            if (titlenode == null) {
                throw new NewsFormatException("File received from " + source + " is not in RSS format");
            }
            this.m_title = titlenode.getFirstChild().getNodeValue();
            this.m_source = source;
            this.m_description = this.getNodeValue(channel, "description", null);
            this.m_lastbuilddate = this.getNodeValue(channel, "lastBuildDate", null);
            this.m_pubdate = this.getNodeValue(channel, "pubDate", null);
            this.m_copyright = this.getNodeValue(channel, "copyright", null);
            this.m_language = this.getNodeValue(channel, "language", null);
            this.m_link = this.getNodeValue(channel, "link", null);
            this.m_items = new Vector();
            NodeList items = document.getElementsByTagName("item");
            int i = 0;
            while (i < items.getLength()) {
                String iTitle = this.getNodeValue(items.item(i), "title", "");
                String iDescription = this.getNodeValue(items.item(i), "description", "");
                String iLink = this.getNodeValue(items.item(i), "link", null);
                String iPubDate = this.getNodeValue(items.item(i), "pubDate", null);
                this.m_items.add(new BasicNewsItem(iTitle, iDescription, iLink, iPubDate));
                ++i;
            }
        }

        public List getNewsitems() {
            Vector rv = new Vector();
            rv.addAll(this.m_items);
            return rv;
        }

        public List getNewsitems(Filter filter) {
            Vector items = new Vector(this.m_items);
            if (filter != null) {
                Vector<NewsItem> accepted = new Vector<NewsItem>();
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    NewsItem item = (NewsItem)it.next();
                    if (!filter.accept(item)) continue;
                    accepted.add(item);
                }
                items = accepted;
            }
            return items;
        }

        public String getSource() {
            return this.m_source;
        }

        public String getLink() {
            return this.m_link;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getLanguage() {
            return this.m_language;
        }

        public String getCopyright() {
            return this.m_copyright;
        }

        public String getPubdate() {
            return this.m_pubdate;
        }

        public String getLastbuilddate() {
            return this.m_lastbuilddate;
        }

        public void setNewsitems(List items) {
            this.m_items = new Vector(items);
        }

        public void addNewsitem(NewsItem item) {
            this.m_items.add(item);
        }

        public void setSource(String source) throws NewsConnectionException, NewsFormatException {
            this.m_source = source;
            this.initChannel(source);
        }

        public void setLink(String link) {
            this.m_link = link;
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public void setLanguage(String language) {
            this.m_language = language;
        }

        public void setCopyright(String copyright) {
            this.m_copyright = copyright;
        }

        public void setPubdate(String pubdate) {
            this.m_pubdate = pubdate;
        }

        public void setLastbuilddate(String builddate) {
            this.m_lastbuilddate = builddate;
        }

        public boolean isUpdateAvailable() {
            return true;
        }

        public int compareTo(Object obj) throws ClassCastException {
            int rv = 0;
            if (this.m_source == null) {
                if (obj != null) {
                    rv = -1;
                }
            } else if (obj == null) {
                rv = 1;
            } else if (obj instanceof String) {
                rv = this.m_source.compareTo((String)obj);
            } else {
                NewsChannel other = (NewsChannel)obj;
                rv = this.m_source.compareTo(other.getLink());
            }
            return rv;
        }

        public boolean equals(Object obj) throws ClassCastException {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            String hval = "";
            if (this.m_source != null) {
                hval = this.m_source;
            }
            return hval.hashCode();
        }
    }

    public class BasicNewsItem
    implements NewsItem {
        protected String m_title = null;
        protected String m_link = null;
        protected String m_pubdate = null;
        protected String m_description = null;

        public BasicNewsItem(String title, String description, String link, String pubdate) {
            this.m_title = title;
            this.m_description = description;
            this.m_link = link;
            this.m_pubdate = pubdate;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getPubdate() {
            return this.m_pubdate;
        }

        public String getLink() {
            return this.m_link;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        public void setPubdate(String pubdate) {
            this.m_pubdate = pubdate;
        }

        public void setLink(String link) {
            this.m_link = link;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }
    }
}

