/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.Edit;
import org.chefproject.core.Resource;
import org.chefproject.core.StorageUser;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseXmlFileStorage {
    protected String m_fileStoragePath = null;
    protected String m_rootTagName = null;
    protected String m_containerTagName = null;
    protected String m_entryTagName = null;
    protected Hashtable m_store = null;
    protected Hashtable m_locks = null;
    protected StorageUser m_user = null;

    public BaseXmlFileStorage(String path, String root, String container, String entry, StorageUser user) {
        this.m_fileStoragePath = path;
        this.m_rootTagName = root;
        this.m_containerTagName = container;
        this.m_entryTagName = entry;
        this.m_user = user;
    }

    protected void finalize() {
        this.m_user = null;
    }

    protected Document load() {
        return Xml.readDocument(this.m_fileStoragePath);
    }

    public void open() {
        this.m_store = new Hashtable();
        Container top = null;
        if (this.m_containerTagName == null) {
            top = new Container(null);
            this.m_store.put("", top);
        }
        this.m_locks = new Hashtable();
        try {
            Document doc = this.load();
            if (doc == null) {
                Log.warn("chef", this + "missing user xml file: " + this.m_fileStoragePath);
                return;
            }
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals(this.m_rootTagName)) {
                Log.warn("chef", this + ".open(): root tag not: " + this.m_rootTagName + " found: " + root.getTagName());
                return;
            }
            NodeList rootNodes = root.getChildNodes();
            int rootNodesLength = rootNodes.getLength();
            int i = 0;
            while (i < rootNodesLength) {
                Node rootNode = rootNodes.item(i);
                if (rootNode.getNodeType() == 1) {
                    Element rootElement = (Element)rootNode;
                    if (this.m_containerTagName == null && rootElement.getTagName().equals(this.m_entryTagName)) {
                        Resource entry = this.m_user.newResource(top.container, rootElement);
                        top.contained.put(entry.getId(), entry);
                    } else if (this.m_containerTagName != null && rootElement.getTagName().equals(this.m_containerTagName)) {
                        Resource containerResource = this.m_user.newContainer(rootElement);
                        Container container = new Container(containerResource);
                        this.m_store.put(containerResource.getReference(), container);
                        NodeList containerNodes = rootElement.getChildNodes();
                        int containerNodesLength = containerNodes.getLength();
                        int j = 0;
                        while (j < containerNodesLength) {
                            Element containerElement;
                            Node containerNode = containerNodes.item(j);
                            if (containerNode.getNodeType() == 1 && (containerElement = (Element)containerNode).getTagName().equals(this.m_entryTagName)) {
                                Resource entry = this.m_user.newResource(container.container, containerElement);
                                container.contained.put(entry.getId(), entry);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.warn("chef", this + ".open(): ", (Throwable)e);
        }
    }

    protected Document createDocument() {
        Document doc = Xml.createDocument();
        Stack<Element> stack = new Stack<Element>();
        Element root = doc.createElement(this.m_rootTagName);
        doc.appendChild(root);
        stack.push(root);
        if (this.m_containerTagName == null) {
            Enumeration enumeration = ((Container)this.m_store.get((Object)"")).contained.elements();
            while (enumeration.hasMoreElements()) {
                Resource entry = (Resource)enumeration.nextElement();
                entry.toXml(doc, stack);
            }
        } else {
            Enumeration enumeration = this.m_store.elements();
            while (enumeration.hasMoreElements()) {
                Container c = (Container)enumeration.nextElement();
                if (c.container == null) continue;
                Element containerElement = c.container.toXml(doc, stack);
                stack.push(containerElement);
                Enumeration elementEnum = c.contained.elements();
                while (elementEnum.hasMoreElements()) {
                    Resource entry = (Resource)elementEnum.nextElement();
                    entry.toXml(doc, stack);
                }
                stack.pop();
            }
        }
        stack.pop();
        return doc;
    }

    protected void flush() {
        Document doc = this.createDocument();
        Xml.writeDocument(doc, this.m_fileStoragePath);
    }

    public void close() {
        this.flush();
        this.m_locks.clear();
        this.m_locks = null;
        this.m_store.clear();
        this.m_store = null;
    }

    public boolean checkContainer(String ref) {
        Container c = (Container)this.m_store.get(ref);
        return c != null;
    }

    public Resource getContainer(String ref) {
        if (ref == null) {
            return null;
        }
        Container c = (Container)this.m_store.get(ref);
        if (c == null) {
            return null;
        }
        return c.container;
    }

    public List getAllContainers() {
        Vector<Resource> rv = new Vector<Resource>();
        if (this.m_containerTagName == null) {
            return rv;
        }
        if (this.m_store.size() == 0) {
            return rv;
        }
        Enumeration enumeration = this.m_store.elements();
        while (enumeration.hasMoreElements()) {
            Container c = (Container)enumeration.nextElement();
            rv.add(c.container);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit putContainer(String ref) {
        Container c = (Container)this.m_store.get(ref);
        if (c != null) {
            return null;
        }
        Edit edit = this.m_user.newContainerEdit(ref);
        Hashtable hashtable = this.m_locks;
        synchronized (hashtable) {
            block5: {
                if (this.m_locks.get(edit.getReference()) == null) break block5;
                Edit edit2 = null;
                return edit2;
            }
            this.m_locks.put(edit.getReference(), edit);
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit editContainer(String ref) {
        Container c = (Container)this.m_store.get(ref);
        if (c == null) {
            return null;
        }
        Hashtable hashtable = this.m_locks;
        synchronized (hashtable) {
            block5: {
                if (this.m_locks.get(c.container.getReference()) == null) break block5;
                Edit edit = null;
                return edit;
            }
            Edit edit = this.m_user.newContainerEdit(c.container);
            this.m_locks.put(edit.getReference(), edit);
            Edit edit2 = edit;
            return edit2;
        }
    }

    public void commitContainer(Edit edit) {
        Resource updatedContainer = this.m_user.newContainer(edit);
        Container c = (Container)this.m_store.get(updatedContainer.getReference());
        if (c != null) {
            c.container = updatedContainer;
        } else {
            c = new Container(updatedContainer);
            this.m_store.put(updatedContainer.getReference(), c);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void cancelContainer(Edit edit) {
        this.m_locks.remove(edit.getReference());
    }

    public void removeContainer(Edit edit) {
        Container c = (Container)this.m_store.get(edit.getReference());
        if (c != null) {
            this.m_store.remove(c);
        }
        this.m_locks.remove(edit.getReference());
    }

    public boolean checkResource(String container, String id) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) == null) {
            return false;
        }
        return c.contained.get(id) != null;
    }

    public Resource getResource(String container, String id) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) == null) {
            return null;
        }
        return (Resource)c.contained.get(id);
    }

    public List getAllResources(String container) {
        Container c;
        Vector rv = new Vector();
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) == null) {
            return rv;
        }
        if (c.contained.size() == 0) {
            return rv;
        }
        rv.addAll(c.contained.values());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit putResource(String container, String id, Object[] others) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) == null) {
            return null;
        }
        if (c.contained.get(id) != null) {
            return null;
        }
        Edit edit = this.m_user.newResourceEdit(c.container, id, others);
        Hashtable hashtable = this.m_locks;
        synchronized (hashtable) {
            block7: {
                if (this.m_locks.get(edit.getReference()) == null) break block7;
                Edit edit2 = null;
                return edit2;
            }
            this.m_locks.put(edit.getReference(), edit);
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit editResource(String container, String id) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) == null) {
            return null;
        }
        Resource entry = (Resource)c.contained.get(id);
        if (entry == null) {
            return null;
        }
        Hashtable hashtable = this.m_locks;
        synchronized (hashtable) {
            block7: {
                if (this.m_locks.get(entry.getReference()) == null) break block7;
                Edit edit = null;
                return edit;
            }
            Edit edit = this.m_user.newResourceEdit(c.container, entry);
            this.m_locks.put(entry.getReference(), edit);
            Edit edit2 = edit;
            return edit2;
        }
    }

    public void commitResource(String container, Edit edit) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) != null) {
            Resource updatedEntry = this.m_user.newResource(c.container, edit);
            c.contained.put(updatedEntry.getId(), updatedEntry);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void cancelResource(String container, Edit edit) {
        this.m_locks.remove(edit.getReference());
    }

    public void removeResource(String container, Edit edit) {
        Container c;
        if (container == null) {
            container = "";
        }
        if ((c = (Container)this.m_store.get(container)) != null) {
            c.contained.remove(edit.getId());
        }
        this.m_locks.remove(edit.getReference());
    }

    protected class Container {
        public Resource container;
        public Hashtable contained;

        public Container(Resource c) {
            this.container = c;
            this.contained = new Hashtable();
        }
    }
}

