import test from 'ava';
import m from './';

test('camelCase', t => {
	t.is(m('foo'), 'foo');
	t.is(m('foo-bar'), 'fooBar');
	t.is(m('foo-bar-baz'), 'fooBarBaz');
	t.is(m('foo--bar'), 'fooBar');
	t.is(m('--foo-bar'), 'fooBar');
	t.is(m('--foo--bar'), 'fooBar');
	t.is(m('FOO-BAR'), 'fooBar');
	t.is(m('FOÈ-BAR'), 'foèBar');
	t.is(m('-foo-bar-'), 'fooBar');
	t.is(m('--foo--bar--'), 'fooBar');
	t.is(m('foo.bar'), 'fooBar');
	t.is(m('foo..bar'), 'fooBar');
	t.is(m('..foo..bar..'), 'fooBar');
	t.is(m('foo_bar'), 'fooBar');
	t.is(m('__foo__bar__'), 'fooBar');
	t.is(m('__foo__bar__'), 'fooBar');
	t.is(m('foo bar'), 'fooBar');
	t.is(m('  foo  bar  '), 'fooBar');
	t.is(m('-'), '-');
	t.is(m(' - '), '-');
	t.is(m('fooBar'), 'fooBar');
	t.is(m('fooBar-baz'), 'fooBarBaz');
	t.is(m('foìBar-baz'), 'foìBarBaz');
	t.is(m('fooBarBaz-bazzy'), 'fooBarBazBazzy');
	t.is(m('FBBazzy'), 'fbBazzy');
	t.is(m('F'), 'f');
	t.is(m('FooBar'), 'fooBar');
	t.is(m('Foo'), 'foo');
	t.is(m('FOO'), 'foo');
	t.is(m('foo', 'bar'), 'fooBar');
	t.is(m('foo', '-bar'), 'fooBar');
	t.is(m('foo', '-bar', 'baz'), 'fooBarBaz');
	t.is(m('', ''), '');
	t.is(m('--'), '');
	t.is(m(''), '');
	t.is(m('--__--_--_'), '');
	t.is(m('---_', '--', '', '-_- '), '');
	t.is(m('foo bar?'), 'fooBar?');
	t.is(m('foo bar!'), 'fooBar!');
	t.is(m('foo bar$'), 'fooBar$');
	t.is(m('foo-bar#'), 'fooBar#');
	t.is(m('XMLHttpRequest'), 'xmlHttpRequest');
	t.is(m('AjaxXMLHttpRequest'), 'ajaxXmlHttpRequest');
	t.is(m('Ajax-XMLHttpRequest'), 'ajaxXmlHttpRequest');
});
