#ifndef ICONS_NERDFONT
#define ICONS_NERDFONT

// You can find hex codes for nerd fonts here
// https://www.nerdfonts.com/cheat-sheet

// Arrows
#define MD_ARROW_UPWARD    "\uf55c"
#define MD_ARROW_FORWARD   "\uf553"
#define MD_ARROW_DOWNWARD  "\uf544"

// Generics
#define ICON_DIRECTORY     "\ue5ff"
#define ICON_FILE          "\uf713"
#define ICON_EXEC          "\uf144"
#define ICON_MANUAL        "\uf5bd"

// Top level and common icons
#define ICON_ARCHIVE       "\uf53b"
#define ICON_BRIEFCASE     "\uf5d5"
#define ICON_C             "\ue61e"
#define ICON_CHANGELOG     "\uf7d9"
#define ICON_CHESS         "\uf639"
#define ICON_CLOJURE       "\ue76a"
#define ICON_CONFIGURE     "\uf423"
#define ICON_CPLUSPLUS     "\ue61d"
#define ICON_DATABASE      "\uf6b7"
#define ICON_DESKTOP       "\ufcbe"
#define ICON_DOCUMENT      "\uf718"
#define ICON_DOWNLOADS     "\uf5d7"
#define ICON_FSHARP        "\ue7a7"
#define ICON_GIT           "\ue5fb"
#define ICON_HASKELL       "\ue777"
#define ICON_HTML          "\uf72d"
#define ICON_JAVA          "\ue738"
#define ICON_JAVASCRIPT    "\uf81d"
#define ICON_LICENSE       "\uf718"
#define ICON_LINUX         "\uf83c"
#define ICON_MAKEFILE      "\uf68c"
#define ICON_MUSIC         "\uf832"
#define ICON_MUSICFILE     "\uf886"
#define ICON_OPTICALDISK   "\ue271"
#define ICON_PICTUREFILE   "\uf71e"
#define ICON_PICTURES      "\uf753"
#define ICON_PLAYLIST      "\uf910"
#define ICON_PUBLIC        "\ue5ff"
#define ICON_PYTHON        "\ue235"
#define ICON_REACT         "\ue625"
#define ICON_RUBY          "\ue23e"
#define ICON_SCRIPT        "\ue795"
#define ICON_TEMPLATES     "\ufac6"
#define ICON_TEX           "\ufb68"
#define ICON_VIDEOFILE     "\uf72a"
#define ICON_VIDEOS        "\uf72f"
#define ICON_WORDDOC       "\uf72b"


/* Numbers */
#define ICON_EXT_1         ICON_MANUAL
#define ICON_EXT_7Z        ICON_ARCHIVE

/* A */
#define ICON_EXT_A         ICON_MANUAL
#define ICON_EXT_APK       ICON_ARCHIVE
#define ICON_EXT_ASM       ICON_FILE
#define ICON_EXT_AUP       ICON_MUSICFILE
#define ICON_EXT_AVI       ICON_VIDEOFILE

/* B */
#define ICON_EXT_BAT       ICON_SCRIPT
#define ICON_EXT_BIB       ICON_TEX
#define ICON_EXT_BIN       "\uf471"
#define ICON_EXT_BMP       ICON_PICTUREFILE
#define ICON_EXT_BZ2       ICON_ARCHIVE

/* C */
#define ICON_EXT_C         ICON_C
#define ICON_EXT_CPLUSPLUS ICON_CPLUSPLUS
#define ICON_EXT_CAB       ICON_ARCHIVE
#define ICON_EXT_CABAL     ICON_HASKELL
#define ICON_EXT_CBR       ICON_ARCHIVE
#define ICON_EXT_CBZ       ICON_ARCHIVE
#define ICON_EXT_CC        ICON_CPLUSPLUS
#define ICON_EXT_CLASS     ICON_JAVA
#define ICON_EXT_CLJ       ICON_CLOJURE
#define ICON_EXT_CLJC      ICON_CLOJURE
#define ICON_EXT_CLJS      ICON_CLOJURE
#define ICON_EXT_CLS       ICON_TEX
#define ICON_EXT_CMAKE     ICON_MAKEFILE
#define ICON_EXT_COFFEE    "\ue751"
#define ICON_EXT_CONF      ICON_CONFIGURE
#define ICON_EXT_CPIO      ICON_ARCHIVE
#define ICON_EXT_CPP       ICON_CPLUSPLUS
#define ICON_EXT_CSS       "\ue749"
#define ICON_EXT_CUE       ICON_PLAYLIST
#define ICON_EXT_CVS       ICON_CONFIGURE
#define ICON_EXT_CXX       ICON_CPLUSPLUS

/* D */
#define ICON_EXT_DB        ICON_DATABASE
#define ICON_EXT_DEB       "\ue77d"
#define ICON_EXT_DIFF      "\uf440"
#define ICON_EXT_DLL       ICON_SCRIPT
#define ICON_EXT_DOC       ICON_WORDDOC
#define ICON_EXT_DOCX      ICON_WORDDOC

/* E */
#define ICON_EXT_EJS       ICON_JAVASCRIPT
#define ICON_EXT_ELF       ICON_LINUX
#define ICON_EXT_EPUB      ICON_MANUAL
#define ICON_EXT_EXE       ICON_EXEC

/* F */
#define ICON_EXT_FEN       ICON_CHESS
#define ICON_EXT_FSHARP    ICON_FSHARP
#define ICON_EXT_FLAC      ICON_MUSICFILE
#define ICON_EXT_FLV       ICON_VIDEOFILE
#define ICON_EXT_FS        ICON_FSHARP
#define ICON_EXT_FSI       ICON_FSHARP
#define ICON_EXT_FSSCRIPT  ICON_FSHARP
#define ICON_EXT_FSX       ICON_FSHARP

/* G */
#define ICON_EXT_GEM       ICON_RUBY
#define ICON_EXT_GIF       ICON_PICTUREFILE
#define ICON_EXT_GO        "\ufcd1"
#define ICON_EXT_GZ        ICON_ARCHIVE
#define ICON_EXT_GZIP      ICON_ARCHIVE

/* H */
#define ICON_EXT_H         ICON_C
#define ICON_EXT_HH        ICON_CPLUSPLUS
#define ICON_EXT_HPP       ICON_CPLUSPLUS
#define ICON_EXT_HS        ICON_HASKELL
#define ICON_EXT_HTACCESS  ICON_CONFIGURE
#define ICON_EXT_HTPASSWD  ICON_CONFIGURE
#define ICON_EXT_HTM       ICON_HTML
#define ICON_EXT_HTML      ICON_HTML
#define ICON_EXT_HXX       ICON_CPLUSPLUS

/* I */
#define ICON_EXT_ICO       ICON_PICTUREFILE
#define ICON_EXT_IMG       ICON_OPTICALDISK
#define ICON_EXT_INI       ICON_CONFIGURE
#define ICON_EXT_ISO       ICON_OPTICALDISK

/* J */
#define ICON_EXT_JAR       ICON_JAVA
#define ICON_EXT_JAVA      ICON_JAVA
#define ICON_EXT_JL        ICON_CONFIGURE
#define ICON_EXT_JPEG      ICON_PICTUREFILE
#define ICON_EXT_JPG       ICON_PICTUREFILE
#define ICON_EXT_JS        ICON_JAVASCRIPT
#define ICON_EXT_JSON      "\ufb25"
#define ICON_EXT_JSX       ICON_REACT

/* K */

/* L */
#define ICON_EXT_LHA       ICON_ARCHIVE
#define ICON_EXT_LHS       ICON_HASKELL
#define ICON_EXT_LOG       ICON_DOCUMENT
#define ICON_EXT_LUA       "\ue620"
#define ICON_EXT_LZH       ICON_ARCHIVE
#define ICON_EXT_LZMA      ICON_ARCHIVE

/* M */
#define ICON_EXT_M4A       ICON_MUSICFILE
#define ICON_EXT_M4V       ICON_VIDEOFILE
#define ICON_EXT_M         "\ufd1c"
#define ICON_EXT_MAT       "\uf0ce"
#define ICON_EXT_MD        "\ue609"
#define ICON_EXT_MK        ICON_MAKEFILE
#define ICON_EXT_MKV       ICON_VIDEOFILE
#define ICON_EXT_MOV       ICON_VIDEOFILE
#define ICON_EXT_MP3       ICON_MUSICFILE
#define ICON_EXT_MP4       ICON_VIDEOFILE
#define ICON_EXT_MPEG      ICON_VIDEOFILE
#define ICON_EXT_MPG       ICON_VIDEOFILE
#define ICON_EXT_MSI       "\uf871"

/* N */
#define ICON_EXT_NIX       "\uf313"

/* O */
#define ICON_EXT_O         ICON_MANUAL
#define ICON_EXT_OGG       ICON_MUSICFILE
#define ICON_EXT_ODOWNLOAD ICON_DOWNLOADS
#define ICON_EXT_OUT       ICON_LINUX

/* P */
#define ICON_EXT_PART      ICON_DOWNLOADS
#define ICON_EXT_PATCH     "\uf440"
#define ICON_EXT_PDF       "\uf724"
#define ICON_EXT_PGN       ICON_CHESS
#define ICON_EXT_PHP       "\ue73d"
#define ICON_EXT_PNG       ICON_PICTUREFILE
#define ICON_EXT_PPT       "\uf726"
#define ICON_EXT_PPTX      "\uf726"
#define ICON_EXT_PSB       "\ue7b8"
#define ICON_EXT_PSD       "\ue7b8"
#define ICON_EXT_PY        ICON_PYTHON
#define ICON_EXT_PYC       ICON_PYTHON
#define ICON_EXT_PYD       ICON_PYTHON
#define ICON_EXT_PYO       ICON_PYTHON

/* Q */

/* R */
#define ICON_EXT_RAR       ICON_ARCHIVE
#define ICON_EXT_RC        ICON_CONFIGURE
#define ICON_EXT_ROM       "\uf795"
#define ICON_EXT_RPM       ICON_ARCHIVE
#define ICON_EXT_RSS       "\uf96b"
#define ICON_EXT_RTF       "\uf724"
#define ICON_EXT_RB        ICON_RUBY

/* S */
#define ICON_EXT_SASS      "\ue603"
#define ICON_EXT_SCSS      "\ue603"
#define ICON_EXT_SO        ICON_MANUAL
#define ICON_EXT_SCALA     "\ue737"
#define ICON_EXT_SH        ICON_SCRIPT
#define ICON_EXT_SLIM      ICON_SCRIPT
#define ICON_EXT_SLN       "\ue70c"
#define ICON_EXT_SQL       ICON_DATABASE
#define ICON_EXT_SRT       "\uf679"
#define ICON_EXT_STY       ICON_TEX
#define ICON_EXT_SUB       "\uf679"
#define ICON_EXT_SVG       ICON_PICTUREFILE

/* T */
#define ICON_EXT_TAR       ICON_ARCHIVE
#define ICON_EXT_TEX       ICON_TEX
#define ICON_EXT_TGZ       ICON_ARCHIVE
#define ICON_EXT_TS        "\ue628"
#define ICON_EXT_TSX       ICON_REACT
#define ICON_EXT_TXT       ICON_DOCUMENT
#define ICON_EXT_TXZ       ICON_ARCHIVE

/* U */

/* V */
#define ICON_EXT_VID       ICON_VIDEOFILE
#define ICON_EXT_VIM       "\ue62b"
#define ICON_EXT_VIMRC     "\ue62b"

/* W */
#define ICON_EXT_WAV       ICON_MUSICFILE
#define ICON_EXT_WEBM      ICON_VIDEOFILE
#define ICON_EXT_WMA       ICON_VIDEOFILE
#define ICON_EXT_WMV       ICON_VIDEOFILE

/* X */
#define ICON_EXT_XBPS      ICON_ARCHIVE
#define ICON_EXT_XCF       ICON_PICTUREFILE
#define ICON_EXT_XHTML     ICON_HTML
#define ICON_EXT_XLS       "\uf71a"
#define ICON_EXT_XLSX      "\uf71a"
#define ICON_EXT_XML       ICON_HTML
#define ICON_EXT_XZ        ICON_ARCHIVE

/* Y */
#define ICON_EXT_YAML      ICON_CONFIGURE
#define ICON_EXT_YML       ICON_CONFIGURE

/* Z */
#define ICON_EXT_ZIP       ICON_ARCHIVE
#define ICON_EXT_ZSH       ICON_SCRIPT
#define ICON_EXT_ZST       ICON_ARCHIVE

#endif // ICONS_NERDFONT
