package Locales::DB::Language::fo;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::fo::VERSION = '0.09';

$Locales::DB::Language::fo::cldr_version = '2.0';

%Locales::DB::Language::fo::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ og\ \{1\}",
            'end'    => "\{0\}\ og\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '’',
        'quotation_end'             => '”',
        'quotation_start'           => '”'
    },
    'fallback' => [
        'is',
        'da',
        'sv',
        'en'
    ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr' => {
            'content' => "nei\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "já\:j",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::fo::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'abkhaziskt',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'afríska',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'amhariskt',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'arabiskt',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'assamesiskt',
    'asa'    => "asu\ \(Tanzania\)",
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'aymara',
    'az'     => 'azerbaijaniskt',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'belarussiskt',
    'bej'    => 'Beja',
    'bem'    => 'bemba',
    'ber'    => 'Berber',
    'bez'    => "bena\ \(Tanzania\)",
    'bg'     => 'bulgarskum',
    'bh'     => 'bihariskt',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengaliskt',
    'bnt'    => 'Bantu',
    'bo'     => 'tibetanskt',
    'br'     => 'bretonskt',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'bosniskt',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'katalanskt',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'kekkiskt',
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'valisiskt',
    'da'     => 'danskt',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'týskt',
    'de_at'  => "Austrian\ German",
    'de_ch'  => "Swiss\ High\ German",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'dzongkha',
    'ebu'    => 'kiembu',
    'ee'     => 'Ewe',
    'efi'    => 'efik',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'grikskt',
    'elx'    => 'Elamite',
    'en'     => 'enskt',
    'en_au'  => "Australian\ English",
    'en_ca'  => "Canadian\ English",
    'en_gb'  => "British\ English",
    'en_us'  => "U\.S\.\ English",
    'enm'    => "Middle\ English",
    'eo'     => 'esperanto',
    'es'     => 'spanskt',
    'es_419' => "Latin\ American\ Spanish",
    'es_es'  => "Iberian\ Spanish",
    'et'     => 'estlendskt',
    'eu'     => 'baskiskt',
    'ewo'    => 'Ewondo',
    'fa'     => 'persiskt',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'finskt',
    'fil'    => 'filipiniskt',
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'fidjianskt',
    'fo'     => 'føroyskt',
    'fon'    => 'Fon',
    'fr'     => 'franskt',
    'fr_ca'  => "Canadian\ French",
    'fr_ch'  => "Swiss\ French",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => 'vestfrisikt',
    'ga'     => 'írskt',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "skotskt\ gæliskt",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'galliskt',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'guarani',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Swiss\ German",
    'gu'     => 'gujariti',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'haussa',
    'hai'    => 'Haida',
    'haw'    => 'hawaiianskt',
    'he'     => 'hebraiskt',
    'hi'     => 'hindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'kroatiskum',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'haitiskt',
    'hu'     => 'ungarskt',
    'hup'    => 'Hupa',
    'hy'     => 'armenskum',
    'hz'     => 'Herero',
    'ia'     => 'interlingua',
    'iba'    => 'Iban',
    'id'     => 'indonesiskum',
    'ie'     => 'interlingue',
    'ig'     => 'igbo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'íslendskt',
    'it'     => 'italskt',
    'iu'     => 'Inuktitut',
    'ja'     => 'japanskt',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'javanesiskt',
    'ka'     => 'georgiskt',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kapverdiskt',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'kazakiskt',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'kambodjanskt',
    'kmb'    => 'Kimbundu',
    'kn'     => 'kannada',
    'ko'     => 'koreanskt',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'kashmiriskt',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdiskt',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'kyrgyz',
    'la'     => 'latín',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'luxemburgiskt',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'lingala',
    'lo'     => 'laotiskt',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'litavskt',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'olulujia',
    'lv'     => 'latviskt',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malagasiskt',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'maoriskt',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'makedonskt',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'malayalam',
    'mn'     => 'mongoliskt',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'marathiskt',
    'ms'     => 'malajiskt',
    'mt'     => 'maltesiskt',
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'burmesiskt',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "norskt\ bokmál",
    'nd'     => "North\ Ndebele",
    'nds'    => "Low\ German",
    'ne'     => 'nepalskt',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'hollendskt',
    'nl_be'  => 'Flemish',
    'nmg'    => 'Kwasio',
    'nn'     => 'nýnorskt',
    'no'     => 'norskt',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Northern\ Sotho",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'occitan',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'oriya',
    'os'     => 'ossetiskt',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'punjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'polskt',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'pashto',
    'pt'     => 'portugisiskt',
    'pt_br'  => "Brazilian\ Portuguese",
    'pt_pt'  => "Iberian\ Portuguese",
    'qu'     => 'quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'rumansh',
    'rn'     => 'rundi',
    'ro'     => 'romanskt',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'russiskt',
    'rup'    => 'Aromanian',
    'rw'     => 'ruanda',
    'rwk'    => 'Rwa',
    'sa'     => 'sanskrit',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'sindhi',
    'se'     => "Northern\ Sami",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => 'serbokroatiskt',
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'sinhalesiskt',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'slovakiskum',
    'sl'     => 'slovenskum',
    'sla'    => "Slavic\ Language",
    'sm'     => 'samoiskt',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'shona',
    'snk'    => 'Soninke',
    'so'     => 'somaliskt',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'albanskt',
    'sr'     => 'serbiskum',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'swatiskt',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => 'sesotho',
    'su'     => 'sundanesiskt',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'svenskt',
    'sw'     => 'swahili',
    'swb'    => 'shimaorískt',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'tamilskt',
    'tai'    => "Tai\ Language",
    'te'     => 'telugu',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'tetum',
    'tg'     => 'tajikiskt',
    'th'     => 'thailendskt',
    'ti'     => 'tigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'turkmenskt',
    'tkl'    => 'Tokelau',
    'tl'     => 'tagalog',
    'tlh'    => 'klingonskt',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'tswana',
    'to'     => 'tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "tok\ pisin",
    'tr'     => 'turkiskt',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tatar',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'tahitiskt',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'uighur',
    'uga'    => 'Ugaritic',
    'uk'     => 'ukrainskt',
    'umb'    => 'Umbundu',
    'und'    => "Unknown\ Language",
    'ur'     => 'urdu',
    'uz'     => 'uzbekiskt',
    'vai'    => 'Vai',
    've'     => 'venda',
    'vi'     => 'vietnamesiskt',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'jiddiskt',
    'yo'     => 'yoruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'kantonesískt',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => 'kinesískt',
    'znd'    => 'Zande',
    'zu'     => 'sulu',
    'zun'    => 'Zuni',
    'zxx'    => "No\ linguistic\ content",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::fo::name_to_code = (
    'abkhaziskt'                    => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'afríska'                      => 'af',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albanskt'                      => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amhariskt'                     => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'arabiskt'                      => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armenskum'                     => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'assamesiskt'                   => 'as',
    'asturian'                      => 'ast',
    'asutanzania'                   => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azerbaijaniskt'                => 'az',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'baskiskt'                      => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'belarussiskt'                  => 'be',
    'bemba'                         => 'bem',
    'benatanzania'                  => 'bez',
    'bengaliskt'                    => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihariskt'                     => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'bosniskt'                      => 'bs',
    'braj'                          => 'bra',
    'brazilianportuguese'           => 'pt_br',
    'bretonskt'                     => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgarskum'                    => 'bg',
    'buriat'                        => 'bua',
    'burmesiskt'                    => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'danskt'                        => 'da',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'enskt'                         => 'en',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'estlendskt'                    => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fidjianskt'                    => 'fj',
    'filipiniskt'                   => 'fil',
    'finnougrianlanguage'           => 'fiu',
    'finskt'                        => 'fi',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'franskt'                       => 'fr',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'føroyskt'                     => 'fo',
    'ga'                            => 'gaa',
    'galliskt'                      => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'georgiskt'                     => 'ka',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'grikskt'                       => 'el',
    'guarani'                       => 'gn',
    'gujariti'                      => 'gu',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitiskt'                      => 'ht',
    'haussa'                        => 'ha',
    'hawaiianskt'                   => 'haw',
    'hebraiskt'                     => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hollendskt'                    => 'nl',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indonesiskum'                  => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'italskt'                       => 'it',
    'japanskt'                      => 'ja',
    'javanesiskt'                   => 'jv',
    'jiddiskt'                      => 'yi',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kambodjanskt'                  => 'km',
    'kannada'                       => 'kn',
    'kantonesískt'                 => 'yue',
    'kanuri'                        => 'kr',
    'kapverdiskt'                   => 'kea',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiriskt'                   => 'ks',
    'kashubian'                     => 'csb',
    'katalanskt'                    => 'ca',
    'kawi'                          => 'kaw',
    'kazakiskt'                     => 'kk',
    'kekkiskt'                      => 'cs',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kiembu'                        => 'ebu',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinesískt'                    => 'zh',
    'klingonskt'                    => 'tlh',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koreanskt'                     => 'ko',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kroatiskum'                    => 'hr',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdiskt'                      => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'kyrgyz'                        => 'ky',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'laotiskt'                      => 'lo',
    'latinamericanspanish'          => 'es_419',
    'latviskt'                      => 'lv',
    'latín'                        => 'la',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'litavskt'                      => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxemburgiskt'                 => 'lb',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makedonskt'                    => 'mk',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasiskt'                   => 'mg',
    'malajiskt'                     => 'ms',
    'malayalam'                     => 'ml',
    'maltesiskt'                    => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maoriskt'                      => 'mi',
    'marathiskt'                    => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongoliskt'                    => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepalskt'                      => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'norskt'                        => 'no',
    'norsktbokmál'                 => 'nb',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'nýnorskt'                     => 'nn',
    'occitan'                       => 'oc',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'olulujia'                      => 'luy',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetiskt'                     => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pashto'                        => 'ps',
    'persiskt'                      => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'polskt'                        => 'pl',
    'portugisiskt'                  => 'pt',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'punjabi'                       => 'pa',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romanskt'                      => 'ro',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'ruanda'                        => 'rw',
    'rumansh'                       => 'rm',
    'rundi'                         => 'rn',
    'russiskt'                      => 'ru',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoiskt'                      => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serbiskum'                     => 'sr',
    'serbokroatiskt'                => 'sh',
    'serer'                         => 'srr',
    'sesotho'                       => 'st',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shimaorískt'                  => 'swb',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhalesiskt'                  => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'skotsktgæliskt'               => 'gd',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slovakiskum'                   => 'sk',
    'slovenskum'                    => 'sl',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somaliskt'                     => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'spanskt'                       => 'es',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sulu'                          => 'zu',
    'sumerian'                      => 'sux',
    'sundanesiskt'                  => 'su',
    'susu'                          => 'sus',
    'svenskt'                       => 'sv',
    'swahili'                       => 'sw',
    'swatiskt'                      => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitiskt'                     => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajikiskt'                     => 'tg',
    'tamashek'                      => 'tmh',
    'tamilskt'                      => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'thailendskt'                   => 'th',
    'tibetanskt'                    => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkiskt'                      => 'tr',
    'turkmenskt'                    => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'týskt'                        => 'de',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'uighur'                        => 'ug',
    'ukrainskt'                     => 'uk',
    'umbundu'                       => 'umb',
    'ungarskt'                      => 'hu',
    'unknownlanguage'               => 'und',
    'uppersorbian'                  => 'hsb',
    'urdu'                          => 'ur',
    'uzbekiskt'                     => 'uz',
    'vai'                           => 'vai',
    'valisiskt'                     => 'cy',
    'venda'                         => 've',
    'vestfrisikt'                   => 'fy',
    'vietnamesiskt'                 => 'vi',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
    'írskt'                        => 'ga',
    'íslendskt'                    => 'is',
);

1;
