/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "predefined-action.h"

using namespace Ubuntu::HUD;

PredefinedAction::PredefinedAction(QObject *parent)
    : Action(parent)
{
    d = 0; // not using private class for now
}


void
PredefinedAction::setIdentifier(const QString &identifier)
{
    qWarning("Trying to set identifier (%s) on predefined action.", qPrintable(identifier));
    return;
}

void
PredefinedAction::setLabel(const QString &label)
{
    qWarning("Trying to set label (%s) on predefined action.", qPrintable(label));
    return;
}

void
PredefinedAction::setDescription(const QString &description)
{
    qWarning("Trying to set description (%s) on predefined action.", qPrintable(description));
    return;
}


void
PredefinedAction::setKeywords(QString keywords)
{
    qWarning("Trying to set keywords (%s) on predefined action.", qPrintable(keywords));
    return;
}

void
PredefinedAction::setIsBackgroundAction(bool value)
{
    Q_UNUSED(value)
    qWarning("Trying to set isBackgroundAction on predefined action.");
    return;
}

void
PredefinedAction::setEnabled(bool value)
{
    Q_UNUSED(value)
    qWarning("Trying to set enabled on predefined action.");
    return;
}

void
PredefinedAction::setCommitLabel(const QString &label)
{
    qWarning("Trying to set commitLabel (%s) on predefined action.", qPrintable(label));
    return;
}

void
PredefinedAction::setHasLivePreview(bool value)
{
    Q_UNUSED(value)
    qWarning("Trying to set hasLivePreview on predefined action.");
    return;
}

void
PredefinedAction::setHasNoPreview(bool value)
{
    Q_UNUSED(value)
    qWarning("Trying to set hasNoPreview on predefined action.");
    return;
}

void
PredefinedAction::setRequiresPreview(bool value)
{
    Q_UNUSED(value)
    qWarning("Trying to set requiresPreview on predefined action.");
    return;
}

void
PredefinedAction::addParameter(Parameter *parameter)
{
    Q_UNUSED(parameter)
    qWarning("Trying to add parameter on predefined action.");
    return;
}

void
PredefinedAction::removeParameter(Parameter *parameter)
{
    Q_UNUSED(parameter)
    qWarning("Trying to remove parameter on predefined action.");
    return;
}
