; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare { i64, i1 } @llvm.ssub.with.overflow.i64(i64, i64)
declare { i8, i1 } @llvm.ssub.with.overflow.i8(i8, i8)

declare void @use(i1)

define i1 @test_generic(i64 %a, i64 %b) {
; CHECK-LABEL: @test_generic(
; CHECK-NEXT:    [[RES:%.*]] = tail call { i64, i1 } @llvm.ssub.with.overflow.i64(i64 [[A:%.*]], i64 [[B:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i64, i1 } [[RES]], 1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i64, i1 } @llvm.ssub.with.overflow.i64(i64 %a, i64 %b)
  %overflow = extractvalue { i64, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant0(i8 %a) {
; CHECK-LABEL: @test_constant0(
; CHECK-NEXT:    ret i1 false
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 0)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant1(i8 %a) {
; CHECK-LABEL: @test_constant1(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp eq i8 [[A:%.*]], -128
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 1)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant2(i8 %a) {
; CHECK-LABEL: @test_constant2(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp slt i8 [[A:%.*]], -126
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 2)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant3(i8 %a) {
; CHECK-LABEL: @test_constant3(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp slt i8 [[A:%.*]], -125
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 3)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant4(i8 %a) {
; CHECK-LABEL: @test_constant4(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp slt i8 [[A:%.*]], -124
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 4)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}


define i1 @test_constant127(i8 %a) {
; CHECK-LABEL: @test_constant127(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp slt i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 127)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant128(i8 %a) {
; CHECK-LABEL: @test_constant128(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp sgt i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 128)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant255(i8 %a) {
; CHECK-LABEL: @test_constant255(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp eq i8 [[A:%.*]], 127
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %a, i8 255)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @sub_eq0(i8 %x, i8 %y, i1 %b) {
; CHECK-LABEL: @sub_eq0(
; CHECK-NEXT:    [[SS:%.*]] = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[OV:%.*]] = extractvalue { i8, i1 } [[SS]], 1
; CHECK-NEXT:    call void @use(i1 [[OV]])
; CHECK-NEXT:    [[EQ0:%.*]] = icmp eq i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[EQ0]]
;
  %ss = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %x, i8 %y)
  %ov = extractvalue { i8, i1 } %ss, 1
  call void @use(i1 %ov)
  %sub = extractvalue { i8, i1 } %ss, 0
  %eq0 = icmp eq i8 %sub, 0
  ret i1 %eq0
}

define i1 @sub_ne0(i8 %x, i8 %y, i1 %b) {
; CHECK-LABEL: @sub_ne0(
; CHECK-NEXT:    [[SS:%.*]] = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[OV:%.*]] = extractvalue { i8, i1 } [[SS]], 1
; CHECK-NEXT:    call void @use(i1 [[OV]])
; CHECK-NEXT:    [[NE0:%.*]] = icmp ne i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[NE0]]
;
  %ss = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %x, i8 %y)
  %ov = extractvalue { i8, i1 } %ss, 1
  call void @use(i1 %ov)
  %sub = extractvalue { i8, i1 } %ss, 0
  %ne0 = icmp ne i8 %sub, 0
  ret i1 %ne0
}

; negative test - need zero

define i1 @sub_eq1(i8 %x, i8 %y, i1 %b) {
; CHECK-LABEL: @sub_eq1(
; CHECK-NEXT:    [[SS:%.*]] = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[OV:%.*]] = extractvalue { i8, i1 } [[SS]], 1
; CHECK-NEXT:    call void @use(i1 [[OV]])
; CHECK-NEXT:    [[SUB:%.*]] = extractvalue { i8, i1 } [[SS]], 0
; CHECK-NEXT:    [[EQ1:%.*]] = icmp eq i8 [[SUB]], 1
; CHECK-NEXT:    ret i1 [[EQ1]]
;
  %ss = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %x, i8 %y)
  %ov = extractvalue { i8, i1 } %ss, 1
  call void @use(i1 %ov)
  %sub = extractvalue { i8, i1 } %ss, 0
  %eq1 = icmp eq i8 %sub, 1
  ret i1 %eq1
}

; negative test - need equality pred

define i1 @sub_sgt0(i8 %x, i8 %y, i1 %b) {
; CHECK-LABEL: @sub_sgt0(
; CHECK-NEXT:    [[SS:%.*]] = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[OV:%.*]] = extractvalue { i8, i1 } [[SS]], 1
; CHECK-NEXT:    call void @use(i1 [[OV]])
; CHECK-NEXT:    [[SUB:%.*]] = extractvalue { i8, i1 } [[SS]], 0
; CHECK-NEXT:    [[SGT0:%.*]] = icmp sgt i8 [[SUB]], 0
; CHECK-NEXT:    ret i1 [[SGT0]]
;
  %ss = call { i8, i1 } @llvm.ssub.with.overflow.i8(i8 %x, i8 %y)
  %ov = extractvalue { i8, i1 } %ss, 1
  call void @use(i1 %ov)
  %sub = extractvalue { i8, i1 } %ss, 0
  %sgt0 = icmp sgt i8 %sub, 0
  ret i1 %sgt0
}
