/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.lisaac.ldt.LisaacPlugin;

public class LisaacAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        this.editDocumentCommand(d, c);
    }

    protected void editDocumentCommand(IDocument document, DocumentCommand command) {
        String textCommand = command.text;
        if (textCommand != null) {
            boolean enableIndent = LisaacPlugin.getDefault().getPreferenceStore().getBoolean("lisaac_indent");
            if (!enableIndent) {
                return;
            }
            String[] lineDelimiters = document.getLegalLineDelimiters();
            int endOfLineIndex = TextUtilities.endsWith((String[])lineDelimiters, (String)textCommand);
            if (endOfLineIndex > -1) {
                this.indentOnNewLine(document, command);
            } else if (textCommand.equals("\t")) {
                this.indentOnTab(document, command);
            } else {
                this.indentOnSpecificChar(document, command);
            }
        }
    }

    private static void doIndentLine(int indentLine, IDocument document, DocumentCommand command) {
        try {
            String instr;
            int lastIndent = LisaacAutoEditStrategy.getIndentWithPreviousLine(indentLine, document);
            IRegion currentLineInfo = document.getLineInformation(indentLine);
            int lineStart = currentLineInfo.getOffset();
            int lineEnd = currentLineInfo.getOffset() + currentLineInfo.getLength();
            IRegion originalBlankRegion = LisaacAutoEditStrategy.getBlankAfterOffset(document, lineStart);
            int currentIndent = originalBlankRegion.getLength();
            if (lineEnd - originalBlankRegion.getOffset() + currentIndent > 8 && (instr = document.get(originalBlankRegion.getOffset() + currentIndent, 8)).startsWith("Section ")) {
                lastIndent = 2;
                if (command != null) {
                    command.text = "";
                    command.offset = lineStart;
                    command.length = currentIndent;
                } else {
                    document.replace(lineStart, currentIndent, "");
                }
                return;
            }
            int i = lineEnd - 1;
            int indent2 = 0;
            while (i >= lineStart) {
                char c = document.getChar(i);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        if (indent2 == 0) break;
                        indent2 -= 2;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        indent2 += 2;
                        break;
                    }
                    case '\"': {
                        do {
                            if (--i < lineStart) continue;
                            c = document.getChar(i);
                        } while (i >= lineStart && c != '\"');
                        break;
                    }
                    case '\'': {
                        do {
                            if (--i < lineStart) continue;
                            c = document.getChar(i);
                        } while (i >= lineStart && c != '\'');
                    }
                }
                --i;
            }
            lastIndent -= indent2;
            if (command != null) {
                command.text = LisaacAutoEditStrategy.createString(lastIndent);
                command.offset = lineStart;
                command.length = currentIndent;
            } else {
                document.replace(lineStart, currentIndent, LisaacAutoEditStrategy.createString(lastIndent));
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static int getIndentWithPreviousLine(int line, IDocument document) {
        int result = 0;
        try {
            while (line > 0) {
                String instr;
                IRegion lineRegion = document.getLineInformation(--line);
                int lineStart = lineRegion.getOffset();
                int lineEnd = lineRegion.getOffset() + lineRegion.getLength();
                IRegion originalBlankRegion = LisaacAutoEditStrategy.getBlankAfterOffset(document, document.getLineOffset(line));
                result = originalBlankRegion.getLength();
                if (lineEnd - originalBlankRegion.getOffset() + result > 8 && (instr = document.get(originalBlankRegion.getOffset() + result, 8)).startsWith("Section ")) {
                    result = 2;
                } else {
                    int i = lineStart;
                    int deltaIndent = 0;
                    while (i < lineEnd) {
                        char c = document.getChar(i);
                        switch (c) {
                            case '(': 
                            case '[': 
                            case '{': {
                                deltaIndent += 2;
                                break;
                            }
                            case ')': 
                            case ']': 
                            case '}': {
                                if (deltaIndent == 0) break;
                                deltaIndent -= 2;
                                break;
                            }
                            case '\"': {
                                do {
                                    if (++i >= lineEnd) continue;
                                    c = document.getChar(i);
                                } while (i < lineEnd && c != '\"');
                                break;
                            }
                            case '\'': {
                                do {
                                    if (++i >= lineEnd) continue;
                                    c = document.getChar(i);
                                } while (i < lineEnd && c != '\'');
                            }
                        }
                        ++i;
                    }
                    result += deltaIndent;
                    if (LisaacAutoEditStrategy.getBlankEnd(document, lineStart) == lineEnd) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    private static int getBlankEnd(IDocument document, int offset) throws BadLocationException {
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        int blankEnd = offset;
        int maxBlankEnd = lineRegion.getOffset() + lineRegion.getLength();
        while (blankEnd < maxBlankEnd) {
            char c = document.getChar(blankEnd);
            if (c != ' ' && c != '\t') break;
            ++blankEnd;
        }
        return blankEnd;
    }

    protected void indentOnNewLine(IDocument document, DocumentCommand command) {
        try {
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            LisaacAutoEditStrategy.doIndentLine(line, document, command);
            int indent = LisaacAutoEditStrategy.getIndentWithPreviousLine(line + 1, document);
            command.addCommand(p, 0, "\n" + LisaacAutoEditStrategy.createString(indent), null);
            command.shiftsCaret = true;
            command.caretOffset = p;
        }
        catch (BadLocationException badLocationException) {}
    }

    private static IRegion getBlankAfterOffset(IDocument document, int offset) throws BadLocationException {
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        int blankEnd = offset;
        int maxBlankEnd = lineRegion.getOffset() + lineRegion.getLength();
        while (blankEnd < maxBlankEnd) {
            char c = document.getChar(blankEnd);
            if (c != ' ' && c != '\t') break;
            ++blankEnd;
        }
        return new Region(offset, blankEnd - offset);
    }

    public static String createString(int length) {
        StringBuffer buffer = new StringBuffer(length);
        int index = 0;
        while (index < length) {
            buffer.append(' ');
            ++index;
        }
        return buffer.toString();
    }

    protected void indentOnTab(IDocument document, DocumentCommand command) {
        try {
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            LisaacAutoEditStrategy.doIndentLine(line, document, command);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void indentOnSpecificChar(IDocument document, DocumentCommand command) {
    }

    public static void fullIndentDocument(IDocument document) {
        int line = 0;
        int maxLine = document.getNumberOfLines();
        while (line < maxLine) {
            LisaacAutoEditStrategy.doIndentLine(line, document, null);
            ++line;
        }
    }

    public static void indentLine(int line, IDocument document) {
        LisaacAutoEditStrategy.doIndentLine(line, document, null);
    }
}

