/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "dns_resolver.h"

DnsResolver::DnsResolver()
{
        labelDomain = new QLabel(tr("&Domain :"), this);
        labelIp = new QLabel(tr("&Ip :"), this);
        lineDomain = new QLineEdit(this);
        lineIp = new QLineEdit(this);
        closeButton = new QPushButton(tr("Close"), this);
        labelDomain->setBuddy(lineDomain);
        labelIp->setBuddy(lineIp);
        buttonIp = new QPushButton(tr("Resolve IP"),this);
        buttonDomain = new QPushButton(tr("Resolve Domain"),this);
        setWindowTitle(tr("Domain Name System resolver"));
        setWindowIcon(QIcon(":/images/kontrolpack.png"));
        QHBoxLayout* Layout = new QHBoxLayout();
        Layout->addWidget(labelDomain);
        Layout->addWidget(lineDomain);
        Layout->addWidget(labelIp);
        Layout->addWidget(lineIp);
        Layout->addWidget(buttonDomain);
        Layout->addWidget(buttonIp);
        Layout->addWidget(closeButton);
        setLayout(Layout);

        connect(this->buttonIp, SIGNAL(clicked(bool)), this, SLOT(resolveIp(bool)));
        connect(this->buttonDomain, SIGNAL(clicked(bool)), this, SLOT(resolveDomain(bool)));
        connect(closeButton, SIGNAL(clicked()), this, SLOT(reject()));
}

void DnsResolver::resolveDomain(bool valid)
{
    QHostInfo infoAdresse = QHostInfo::fromName(lineDomain->text());
    QList<QHostAddress> result_adresses = infoAdresse.addresses();
    QString Ip;
    for(int i=0; i < result_adresses.size(); i++)
    {
        Ip = Ip + result_adresses.at(i).toString() +"; ";
    }
    lineIp->setText(Ip);
}

void DnsResolver::resolveIp(bool valid)
{
    QHostInfo::lookupHost(lineIp->text(),this, SLOT(resolveIpFinish(QHostInfo)));
}

void DnsResolver::resolveIpFinish(const QHostInfo& infoAdresse)
{
    lineDomain->setText(infoAdresse.hostName());
}

void DnsResolver::closeEvent(QCloseEvent *event)
{
    hide();
    event->ignore();
}

