/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.wrapper.cli.AbstractCommandLineConverter;
import org.apache.maven.wrapper.cli.CommandLineArgumentException;
import org.apache.maven.wrapper.cli.CommandLineOption;
import org.apache.maven.wrapper.cli.CommandLineParser;
import org.apache.maven.wrapper.cli.ParsedCommandLine;

public abstract class AbstractPropertiesCommandLineConverter
extends AbstractCommandLineConverter<Map<String, String>> {
    protected abstract String getPropertyOption();

    protected abstract String getPropertyOptionDetailed();

    protected abstract String getPropertyOptionDescription();

    @Override
    public void configure(CommandLineParser parser) {
        CommandLineOption option = parser.option(this.getPropertyOption(), this.getPropertyOptionDetailed());
        option = option.hasArguments();
        option.hasDescription(this.getPropertyOptionDescription());
    }

    @Override
    protected Map<String, String> newInstance() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> convert(ParsedCommandLine options, Map<String, String> properties) throws CommandLineArgumentException {
        for (String keyValueExpression : options.option(this.getPropertyOption()).getValues()) {
            int pos = keyValueExpression.indexOf("=");
            if (pos < 0) {
                properties.put(keyValueExpression, "");
                continue;
            }
            properties.put(keyValueExpression.substring(0, pos), keyValueExpression.substring(pos + 1));
        }
        return properties;
    }
}

